/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.artifact;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;

public abstract class DelegatingArtifact
extends AbstractArtifact {
    private final Artifact delegate;

    protected DelegatingArtifact(Artifact delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate artifact cannot be null");
    }

    protected abstract DelegatingArtifact newInstance(Artifact var1);

    @Override
    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public Artifact setVersion(String version) {
        Artifact artifact = this.delegate.setVersion(version);
        if (artifact != this.delegate) {
            return this.newInstance(artifact);
        }
        return this;
    }

    @Override
    public String getBaseVersion() {
        return this.delegate.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.delegate.isSnapshot();
    }

    @Override
    public String getClassifier() {
        return this.delegate.getClassifier();
    }

    @Override
    public String getExtension() {
        return this.delegate.getExtension();
    }

    @Override
    public File getFile() {
        return this.delegate.getFile();
    }

    @Override
    public Artifact setFile(File file) {
        Artifact artifact = this.delegate.setFile(file);
        if (artifact != this.delegate) {
            return this.newInstance(artifact);
        }
        return this;
    }

    @Override
    public String getProperty(String key2, String defaultValue) {
        return this.delegate.getProperty(key2, defaultValue);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public Artifact setProperties(Map<String, String> properties2) {
        Artifact artifact = this.delegate.setProperties(properties2);
        if (artifact != this.delegate) {
            return this.newInstance(artifact);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (obj2 instanceof DelegatingArtifact) {
            return this.delegate.equals(((DelegatingArtifact)obj2).delegate);
        }
        return this.delegate.equals(obj2);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

