/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ift;

import com.intellij.jupyter.py.ift.DsIftUtilsKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.lesson.LessonManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/py/ift/LearningModuleFileListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isWorkspaceProject", "", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.jupyter.py.ift"})
@SourceDebugExtension(value={"SMAP\nLearningModuleFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearningModuleFileListener.kt\ncom/intellij/jupyter/py/ift/LearningModuleFileListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n11483#2,9:38\n13409#2:47\n13410#2:50\n11492#2:51\n1#3:48\n1#3:49\n*S KotlinDebug\n*F\n+ 1 LearningModuleFileListener.kt\ncom/intellij/jupyter/py/ift/LearningModuleFileListener\n*L\n25#1:38,9\n25#1:47\n25#1:50\n25#1:51\n25#1:49\n*E\n"})
final class LearningModuleFileListener
implements FileEditorManagerListener {
    private final boolean isWorkspaceProject;

    public LearningModuleFileListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.isWorkspaceProject = Intrinsics.areEqual((Object)project.getName(), (Object)"workspace");
    }

    /*
     * WARNING - void declaration
     */
    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        void $this$mapNotNullTo$iv$iv;
        Module[] modules;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isWorkspaceProject) {
            return;
        }
        if (LessonManager.Companion.getInstance().lessonIsRunning()) {
            return;
        }
        LangSupport langSupport = LangManager.Companion.getInstance().getLangSupport();
        if (langSupport == null) {
            return;
        }
        LangSupport languageSupport = langSupport;
        Path learningModulePath = DsIftUtilsKt.getLearningModulePath(languageSupport);
        Project project = source.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Module[] $this$mapNotNull$iv = modules = ModuleManager.Companion.getInstance(project2).getModules();
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void module = element$iv$iv;
            boolean bl2 = false;
            if (ProjectUtil.guessModuleDir((Module)module) != null) {
                VirtualFile virtualFile;
                VirtualFile it = virtualFile;
                boolean bl3 = false;
                object = Intrinsics.areEqual((Object)it.getFileSystem().getNioPath(it), (Object)learningModulePath) ? virtualFile : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            VirtualFile it$iv$iv = object;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (virtualFile == null) {
            return;
        }
        VirtualFile dir = virtualFile;
        boolean inLearningModule = VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)false);
        if (inLearningModule) {
            for (FileEditor fileEditor : source.getAllEditors(file)) {
                Intrinsics.checkNotNull((Object)fileEditor);
                DsIftUtilsKt.setEditorWithLearningFileAsRO(fileEditor);
            }
        }
    }
}

