/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.djangoDbConfig;

import com.intellij.database.Dbms;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.python.djangoDbConfig.PyDataSourceConfiguration;
import com.intellij.util.text.UniqueNameGenerator;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DjangoDataSourceDetector
extends DataSourceDetector {
    public void collectDataSources(@NotNull Project project, @NotNull DataSourceDetector.Builder builder) {
        if (project == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(1);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            DjangoDataSourceDetector.collectDataSourcesInner(module, builder, true);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        if (module == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(3);
        }
        DjangoDataSourceDetector.collectDataSourcesInner(module, builder, false);
    }

    private static void collectDataSourcesInner(Module module, DataSourceDetector.Builder result2, boolean uniqueNames) {
        PyExpression value2;
        PyFile settingsFile = DjangoSettingsPy.getSettingsFile(module);
        if (settingsFile == null) {
            return;
        }
        PyTargetExpression attribute = PyPsiUtils.getAttribute((PyFile)settingsFile, (String)"DATABASES");
        Set existingDataSourceNames = DbUtil.getExistingDataSourceNames((Project)module.getProject());
        if (attribute != null && (value2 = attribute.findAssignedValue()) instanceof PyDictLiteralExpression) {
            PyKeyValueExpression[] elements;
            for (PyKeyValueExpression element : elements = ((PyDictLiteralExpression)value2).getElements()) {
                String name = "Django " + PyPsiUtils.strValue((PyExpression)element.getKey());
                String dsName = uniqueNames ? UniqueNameGenerator.generateUniqueName((String)name, (Collection)existingDataSourceNames) : name;
                DjangoDataSourceDetector.createDataSource(dsName, element.getValue(), result2);
            }
        }
    }

    private static void createDataSource(String name, PyExpression value2, DataSourceDetector.Builder builder) {
        if (!(value2 instanceof PyDictLiteralExpression)) {
            return;
        }
        final Map map2 = PyUtil.dictValue((PyDictLiteralExpression)((PyDictLiteralExpression)value2));
        String engineName = PyPsiUtils.strValue((PyExpression)((PyExpression)map2.get("ENGINE")));
        Dbms dbms = DjangoDataSourceDetector.guessDbms(engineName);
        if (dbms == Dbms.UNKNOWN) {
            return;
        }
        PsiDirectory root = DjangoUtil.getProjectRoot((PsiElement)value2);
        PyDataSourceConfiguration configuration = new PyDataSourceConfiguration(root){

            @Override
            public String getOption(String name) {
                return PyPathEvaluator.evaluatePath((PyExpression)((PyExpression)map2.get(name)));
            }
        };
        DataSourceConfigUtil.buildDataSource((Dbms)dbms, (String)name, (String)"Django", (PsiElement)value2, (DataSourceConfiguration)configuration, (DataSourceDetector.Builder)builder);
    }

    @NotNull
    private static Dbms guessDbms(String engineName) {
        if (engineName == null) {
            Dbms dbms = Dbms.UNKNOWN;
            if (dbms == null) {
                DjangoDataSourceDetector.$$$reportNull$$$0(4);
            }
            return dbms;
        }
        engineName = StringUtil.trimStart((String)engineName, (String)"django.db.backends.");
        Dbms dbms = Dbms.fromString((String)engineName);
        if (dbms == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(5);
        }
        return dbms;
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            DjangoDataSourceDetector.$$$reportNull$$$0(6);
        }
        PyPsiUtils.assertValid((PsiElement)file);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            return Comparing.equal((Object)file.getVirtualFile(), (Object)DjangoUtil.getSettingsFile((Module)module));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/djangoDbConfig/DjangoDataSourceDetector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/djangoDbConfig/DjangoDataSourceDetector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDataSources";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

