/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.cells;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.PyCellUtil;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import com.jetbrains.python.console.PythonConsoleView;
import org.jetbrains.annotations.NotNull;

public final class PyCellLineMarkerProvider
implements LineMarkerProvider,
DumbAware {
    public static final String CELL_ACTION_ID = "PyExecuteCellAction";
    private final EditorColorsManager colorsManager = EditorColorsManager.getInstance();
    private final AnAction action = ActionManager.getInstance().getAction("PyExecuteCellAction");

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        PsiFile file;
        VirtualFile virtualFile;
        if (element == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (Boolean.TRUE.equals((virtualFile = (file = element.getContainingFile()).getVirtualFile()).getUserData(PythonConsoleView.CONSOLE_KEY))) {
            return null;
        }
        boolean plainPython = file.getViewProvider().getBaseLanguage().equals(PythonLanguage.getInstance());
        boolean isInjected = InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(file);
        if (plainPython && !isInjected && (PyCellUtil.isBlockCell((PsiElement)element) || PyCellLineMarkerProvider.isBeginningOfFile(element, file) && PyCellLineMarkerProvider.addIconToTheBeginning(element))) {
            return this.createBlockCellLineMarker(element, this.colorsManager);
        }
        return null;
    }

    private static boolean hasCustomToolbar(@NotNull PsiElement element) {
        PsiFile psiFile;
        if (element == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if ((psiFile = element.getContainingFile()) == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return PyExecuteConsoleCustomizer.Companion.getInstance().isCustomDescriptorSupported(virtualFile);
    }

    private static boolean addIconToTheBeginning(@NotNull PsiElement element) {
        if (element == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return Registry.is((String)"python.scientific.always_use_sci_view") && !PyCellLineMarkerProvider.hasCustomToolbar(element) || PyCellUtil.hasCells((PsiFile)element.getContainingFile());
    }

    private static boolean isBeginningOfFile(@NotNull PsiElement element, @NotNull PsiFile file) {
        if (element == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return element == PsiTreeUtil.getDeepestFirst((PsiElement)file);
    }

    private static boolean hasMarkdownSuffix(@NotNull PsiElement element) {
        String text2;
        if (element == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return (text2 = element.getText()).endsWith("md") || text2.endsWith("markdown");
    }

    @NotNull
    private LineMarkerInfo<PsiElement> createBlockCellLineMarker(final @NotNull PsiElement element, @NotNull EditorColorsManager colorsManager) {
        if (element == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (colorsManager == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(7);
        }
        Function tooltipProvider = psiElement -> this.action.getTemplateText();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new LineMarkerActionWrapper(element, this.action));
        LineMarkerInfo<PsiElement> info = new LineMarkerInfo<PsiElement>(PsiTreeUtil.getDeepestFirst((PsiElement)element), element.getTextRange(), AllIcons.RunConfigurations.TestState.Run, tooltipProvider, null, GutterIconRenderer.Alignment.CENTER){

            public GutterIconRenderer createGutterRenderer() {
                if (PyCellLineMarkerProvider.hasMarkdownSuffix(element)) {
                    return null;
                }
                return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                    public AnAction getClickAction() {
                        return new AnAction(){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                Editor editor;
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (!PyExecuteInConsole.checkIfAvailableAndShowHint((Editor)(editor = (Editor)e.getData(CommonDataKeys.EDITOR)))) {
                                    return;
                                }
                                if (editor != null) {
                                    CaretModel caretModel = editor.getCaretModel();
                                    int initOffset = caretModel.getOffset();
                                    caretModel.moveToOffset(element.getTextOffset());
                                    PyCellLineMarkerProvider.this.action.actionPerformed(e);
                                    caretModel.moveToOffset(initOffset);
                                } else {
                                    PyCellLineMarkerProvider.this.action.actionPerformed(e);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/python/scientific/cells/PyCellLineMarkerProvider$1$1$1", "actionPerformed"));
                            }
                        };
                    }

                    public boolean isNavigateAction() {
                        return true;
                    }

                    public ActionGroup getPopupMenuActions() {
                        return null;
                    }
                };
            }
        };
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        LineMarkerInfo<PsiElement> lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            PyCellLineMarkerProvider.$$$reportNull$$$0(8);
        }
        return lineMarkerInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/scientific/cells/PyCellLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/scientific/cells/PyCellLineMarkerProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockCellLineMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomToolbar";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIconToTheBeginning";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isBeginningOfFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasMarkdownSuffix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCellLineMarker";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

