/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.panel.datawrangler;

import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.scientific.py.tables.panel.datawrangler.AbstractSummaryDialog;
import com.intellij.scientific.py.tables.panel.datawrangler.DSSummaryCreationSettings;
import com.intellij.scientific.py.tables.panel.datawrangler.DataWranglerMainPanel;
import com.intellij.scientific.tables.DSTableBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/scientific/py/tables/panel/datawrangler/EditSummaryDialog;", "Lcom/intellij/scientific/py/tables/panel/datawrangler/AbstractSummaryDialog;", "oldName", "", "settings", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DSSummaryCreationSettings;", "dataWrangler", "Lcom/intellij/scientific/py/tables/panel/datawrangler/DataWranglerMainPanel;", "<init>", "(Ljava/lang/String;Lcom/intellij/scientific/py/tables/panel/datawrangler/DSSummaryCreationSettings;Lcom/intellij/scientific/py/tables/panel/datawrangler/DataWranglerMainPanel;)V", "doOKAction", "", "validateName", "Lcom/intellij/openapi/ui/ValidationInfo;", "summaryName", "intellij.scientific.py.tables"})
public final class EditSummaryDialog
extends AbstractSummaryDialog {
    @NotNull
    private final String oldName;

    public EditSummaryDialog(@NotNull String oldName, @NotNull DSSummaryCreationSettings settings, @NotNull DataWranglerMainPanel dataWrangler) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)dataWrangler, (String)"dataWrangler");
        super(settings, dataWrangler);
        this.oldName = oldName;
        this.setTitle(DSTableBundle.message((String)"ds.DataWrangler.summary.edit.title", (Object[])new Object[0]));
        this.getComponentWithTree().replaceWithOneTreeSummaryAndRepaint(settings);
        this.init();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.getDataWrangler().deleteSummary(this.oldName);
        this.getDataWrangler().addNewSummary(this.getSettings());
        this.getSettings().saveSettingsFileInScriptsDir();
    }

    @Override
    @Nullable
    protected ValidationInfo validateName(@NotNull String summaryName) {
        Intrinsics.checkNotNullParameter((Object)summaryName, (String)"summaryName");
        return ((CharSequence)summaryName).length() == 0 ? new ValidationInfo(DSTableBundle.message((String)"ds.DataWrangler.summary.new.summary.name.empty", (Object[])new Object[0])) : (Intrinsics.areEqual((Object)summaryName, (Object)this.oldName) ? null : (this.getDataWrangler().getSummaryNames().contains(summaryName) ? new ValidationInfo(DSTableBundle.message((String)"ds.DataWrangler.summary.new.summary.name.duplication", (Object[])new Object[0])) : null));
    }
}

