/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.django.model.applications.DjangoAppConfigClassUtil;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.blockEvaluator.PyBlockEvaluator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoSettingsPy {
    private static final DjangoSettingsCache NO_SETTINGS = new DjangoSettingsCache(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, null, null, Collections.emptyList(), null);
    private static final Key<CachedValue<DjangoSettingsCache>> DJANGO_SETTINGS_CACHE_KEY = Key.create((String)"DjangoSettingsPy.DjangoSettingsCache");

    private DjangoSettingsPy() {
    }

    public static Collection<PyCustomMember> getSettingsMembers(Project project) {
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length != 1) {
            return Collections.emptyList();
        }
        PyFile settingsFile = DjangoSettingsPy.getSettingsFile(modules[0]);
        if (settingsFile == null) {
            return Collections.emptyList();
        }
        ArrayList<PyCustomMember> members = new ArrayList<PyCustomMember>();
        DjangoSettingsPy.collectAllMembers(settingsFile, members, new HashSet<PyFile>());
        return members;
    }

    @Nullable
    @RequiresBackgroundThread(generateAssertion=false)
    @RequiresReadLock
    public static PyFile getSettingsFile(@Nullable Module module) {
        Module module2;
        ThreadingAssertions.softAssertReadAccess();
        if (module2 == null) {
            return null;
        }
        VirtualFile settingsFile = DjangoCoreUtil.getSettingsFile(module2);
        if (settingsFile != null) {
            return DjangoSettingsPy.asPyFile(module2.getProject(), settingsFile);
        }
        return DjangoSettingsPy.findSettingsFile(module2);
    }

    @Nullable
    @RequiresBackgroundThread(generateAssertion=false)
    public static PyFile findSettingsFile(@Nullable Module module) {
        VirtualFile[] contentRoots;
        if (module == null) {
            return null;
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        String settings = ((DjangoFacetConfiguration)facet.getConfiguration()).getSettingsFilePath();
        VirtualFile projectRootFolderFile = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
        if (projectRootFolderFile == null) {
            return null;
        }
        VirtualFile settingsVFile = projectRootFolderFile.findChild(settings);
        if (settingsVFile != null) {
            return DjangoSettingsPy.asPyFile(module.getProject(), settingsVFile);
        }
        for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            settingsVFile = contentRoot.findFileByRelativePath(settings);
            if (settingsVFile == null) continue;
            return DjangoSettingsPy.asPyFile(module.getProject(), settingsVFile);
        }
        return null;
    }

    public static void insertAppToInstalledApps(@NotNull String appName, @NotNull Module module) {
        if (appName == null) {
            DjangoSettingsPy.$$$reportNull$$$0(0);
        }
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(1);
        }
        WriteCommandAction.writeCommandAction((Project)module.getProject()).run(() -> {
            PyFile settingsFile = DjangoSettingsPy.getSettingsFile(module);
            if (settingsFile == null) {
                DjangoSettingsPy.notifyInsertAppFailed(null, DjangoBundle.message("notification.manage.install.app.failed.settings", new Object[0]), appName, module);
                return;
            }
            PyTargetExpression installedAppsTargetExpression = settingsFile.findTopLevelAttribute("INSTALLED_APPS");
            if (installedAppsTargetExpression == null) {
                DjangoSettingsPy.notifyInsertAppFailed(settingsFile, DjangoBundle.message("notification.manage.install.app.failed.installed.apps", new Object[0]), appName, module);
                return;
            }
            PyExpression assignedValue = installedAppsTargetExpression.findAssignedValue();
            if (assignedValue == null) {
                DjangoSettingsPy.notifyInsertAppFailed(settingsFile, DjangoBundle.message("notification.manage.install.app.failed.installed.apps.value", new Object[0]), appName, module);
                return;
            }
            if (!(assignedValue instanceof PyListLiteralExpression)) {
                DjangoSettingsPy.notifyInsertAppFailed(settingsFile, DjangoBundle.message("notification.manage.install.app.failed.installed.apps.not.list", new Object[0]), appName, module);
                return;
            }
            PyListLiteralExpression pyListLiteralExpression = (PyListLiteralExpression)assignedValue;
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance((Project)module.getProject());
            String appNameLowercase = StringUtil.toLowerCase((String)appName);
            String appConfigName = StringUtil.replace((String)StringUtil.capitalizeWords((String)appNameLowercase, (String)"_", (boolean)true, (boolean)true), (String)"_", (String)"");
            String pathToAppConfig = appName + ".apps." + appConfigName + "Config";
            PyExpression[] elements = pyListLiteralExpression.getElements();
            boolean preferDoubleQuotes = false;
            if (elements.length > 0) {
                preferDoubleQuotes = elements[0].getText().startsWith("\"");
            }
            PsiElement addedElement = pyListLiteralExpression.add((PsiElement)pyElementGenerator.createStringLiteralFromString(pathToAppConfig, preferDoubleQuotes));
            PsiElement newLine = (PsiElement)pyElementGenerator.createFromText(LanguageLevel.getDefault(), PsiWhiteSpace.class, "\n");
            PyUtil.addListNode((PsiElement)addedElement.getParent(), (PsiElement)newLine, (ASTNode)addedElement.getNode(), (boolean)true, (boolean)true, (boolean)false);
            if (addedElement instanceof Navigatable) {
                ((Navigatable)addedElement).navigate(true);
            }
        });
    }

    private static void notifyInsertAppFailed(@Nullable PyFile settingsFile, @NlsContexts.NotificationContent @NotNull String text2, @NotNull String appName, @NotNull Module module) {
        if (text2 == null) {
            DjangoSettingsPy.$$$reportNull$$$0(2);
        }
        if (appName == null) {
            DjangoSettingsPy.$$$reportNull$$$0(3);
        }
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(4);
        }
        Notification notification = new Notification("Django Notifications", DjangoBundle.message("notification.manage.install.app.failed.title", appName), text2, NotificationType.WARNING);
        if (settingsFile != null) {
            notification.addAction((AnAction)NotificationAction.createSimple((String)DjangoBundle.message("notification.manage.install.app.failed.open.settings.file.button", new Object[0]), () -> settingsFile.navigate(true)));
        }
        notification.notify(module.getProject());
    }

    @Nullable
    @RequiresReadLock
    private static PyFile asPyFile(@NotNull Project project, @NotNull VirtualFile settingsVFile) {
        PsiFile settingsFile;
        if (project == null) {
            DjangoSettingsPy.$$$reportNull$$$0(5);
        }
        if (settingsVFile == null) {
            DjangoSettingsPy.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!settingsVFile.isValid()) {
            return null;
        }
        if (settingsVFile.isDirectory()) {
            VirtualFile initFile = settingsVFile.findChild("__init__.py");
            if (initFile == null || !initFile.isValid()) {
                return null;
            }
            PsiFile settingsFile2 = PsiManager.getInstance((Project)project).findFile(initFile);
            if (settingsFile2 instanceof PyFile) {
                return (PyFile)settingsFile2;
            }
        }
        if ((settingsFile = PsiManager.getInstance((Project)project).findFile(settingsVFile)) instanceof PyFile) {
            return (PyFile)settingsFile;
        }
        return null;
    }

    @Nullable
    public static PsiElement resolveSettingsMember(@NotNull PsiElement element, @NotNull String name, @NotNull PyResolveContext resolveContext) {
        if (element == null) {
            DjangoSettingsPy.$$$reportNull$$$0(7);
        }
        if (name == null) {
            DjangoSettingsPy.$$$reportNull$$$0(8);
        }
        if (resolveContext == null) {
            DjangoSettingsPy.$$$reportNull$$$0(9);
        }
        Project project = element.getProject();
        Collection<PyCustomMember> settings = DjangoSettingsPy.getSettingsMembers(project);
        for (PyCustomMember setting : settings) {
            if (!setting.getName().equals(name)) continue;
            return setting.resolve(element, resolveContext);
        }
        return null;
    }

    @NotNull
    public static List<DjangoAppConfig> getInstalledApps(@NotNull Module module) {
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(10);
        }
        ArrayList<DjangoAppConfig> result2 = new ArrayList<DjangoAppConfig>();
        for (String app : DjangoSettingsPy.getCachedData((Module)module).myInstalledApps) {
            if (app == null) continue;
            DjangoAppConfig djangoAppConfig = DjangoAppConfigClassUtil.getApplicationInfo(module, app);
            result2.add(djangoAppConfig);
        }
        ArrayList<DjangoAppConfig> arrayList = result2;
        if (arrayList == null) {
            DjangoSettingsPy.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static List<String> getMiddleware(@Nullable Module module) {
        List<String> list2 = DjangoSettingsPy.getCachedData((Module)module).myMiddleware;
        if (list2 == null) {
            DjangoSettingsPy.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private static DjangoSettingsCache getCachedData(@Nullable Module module) {
        PyFile file = DjangoSettingsPy.getSettingsFile(module);
        if (file == null) {
            return NO_SETTINGS;
        }
        CachedValue<DjangoSettingsCache> data = (CachedValue<DjangoSettingsCache>)file.getUserData(DJANGO_SETTINGS_CACHE_KEY);
        if (data == null) {
            data = DjangoSettingsPy.buildCachedData(file);
            file.putUserData(DJANGO_SETTINGS_CACHE_KEY, data);
        }
        return (DjangoSettingsCache)data.getValue();
    }

    @NotNull
    public static List<String> getOldTemplateDirs(@NotNull PyFile settingsPy) {
        if (settingsPy == null) {
            DjangoSettingsPy.$$$reportNull$$$0(13);
        }
        PyBlockEvaluator evaluator = new PyBlockEvaluator();
        evaluator.trackDeclarations("TEMPLATE_DIRS");
        evaluator.evaluate((PyElement)settingsPy);
        List<String> result2 = evaluator.getValueAsList("TEMPLATE_DIRS");
        List<String> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            DjangoSettingsPy.$$$reportNull$$$0(14);
        }
        return list2;
    }

    private static CachedValue<DjangoSettingsCache> buildCachedData(PyFile settingsFile) {
        return CachedValuesManager.getManager((Project)settingsFile.getProject()).createCachedValue(() -> {
            PyBlockEvaluator evaluator = new PyBlockEvaluator();
            evaluator.trackDeclarations("STATICFILES_DIRS");
            evaluator.trackDeclarations("TEMPLATES");
            evaluator.evaluate((PyElement)settingsFile);
            ArrayList<String> oldTemplateDirs = new ArrayList<String>(DjangoSettingsPy.getOldTemplateDirs(settingsFile));
            List declarations = ContainerUtil.filterIsInstance((Collection)evaluator.getDeclarations("TEMPLATES"), PyDictLiteralExpression.class);
            PsiQuery newSyntaxTemplateLoaders = new PsiQuery((PsiElement)settingsFile).descendants(PyKeyValueExpression.class).filter(o -> "loaders".equals(PyEvaluator.evaluate((PyExpression)o.getKey(), String.class))).descendants(PySequenceExpression.class);
            PsiQuery loadersQuery = PsiQuery.createFromQueries(Arrays.asList(newSyntaxTemplateLoaders));
            PsiQuery innerLoadersQuery = loadersQuery.descendants(new PsiQuery.PsiFilter(PyStringLiteralExpression.class));
            Set templateLoaders = loadersQuery.addElements(innerLoadersQuery).asStream().map(o -> (String)PyEvaluator.evaluate((PyExpression)o, String.class)).collect(Collectors.toSet());
            DjangoSettingsCache cache = new DjangoSettingsCache(evaluator.getValueAsStringList("INSTALLED_APPS"), new ArrayList<String>(templateLoaders), oldTemplateDirs, evaluator.getDeclarations("STATICFILES_DIRS"), evaluator.getValueAsStringList("MIDDLEWARE"), evaluator.getValueAsString("ROOT_URLCONF"), evaluator.getValueAsString("MEDIA_URL"), evaluator.getValueAsString("TEST_RUNNER"), evaluator.getValueAsString("STATIC_ROOT"), declarations, evaluator.getValueAsString("MEDIA_ROOT"));
            return new CachedValueProvider.Result((Object)cache, evaluator.getVisitedFiles().toArray());
        }, false);
    }

    @NotNull
    public static List<PyExpression> getStaticfilesDirs(@NotNull Module module) {
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(15);
        }
        List<PyExpression> dirs2 = DjangoSettingsPy.getCachedData((Module)module).myStaticfilesDirs;
        PyUtil.verboseOnly(() -> dirs2.forEach(PyPsiUtils::assertValid));
        List<PyExpression> list2 = dirs2;
        if (list2 == null) {
            DjangoSettingsPy.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public static List<String> getOldTemplateDirs(@NotNull Module module) {
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(17);
        }
        List<String> list2 = DjangoSettingsPy.getCachedData((Module)module).myOldTemplateDirs;
        if (list2 == null) {
            DjangoSettingsPy.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public static List<String> getTemplateLoaders(Module module) {
        List<String> list2 = DjangoSettingsPy.getCachedData((Module)module).myTemplateLoaders;
        if (list2 == null) {
            DjangoSettingsPy.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public static Collection<PyDictLiteralExpression> getTemplateDicts(@NotNull Module module) {
        if (module == null) {
            DjangoSettingsPy.$$$reportNull$$$0(20);
        }
        Collection<PyDictLiteralExpression> collection = DjangoSettingsPy.getCachedData((Module)module).myTemplateDicts;
        if (collection == null) {
            DjangoSettingsPy.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @Nullable
    public static String getRootUrlconf(Module module) {
        return DjangoSettingsPy.getCachedData((Module)module).myRootUrlconf;
    }

    @Nullable
    public static String getMediaUrl(Module module) {
        return DjangoSettingsPy.getCachedData((Module)module).myMediaUrl;
    }

    @Nullable
    public static String getTestRunner(Module module) {
        return DjangoSettingsPy.getCachedData((Module)module).myTestRunner;
    }

    @Nullable
    public static String getStaticRoot(Module module) {
        return DjangoSettingsPy.getCachedData((Module)module).myStaticRoot;
    }

    @Nullable
    public static String getMediaRoot(Module module) {
        return DjangoSettingsPy.getCachedData((Module)module).myMediaRoot;
    }

    private static void collectAllMembers(PyFile settingsFile, List<PyCustomMember> result2, Set<PyFile> processedFiles) {
        if (processedFiles.contains(settingsFile)) {
            return;
        }
        processedFiles.add(settingsFile);
        for (PyTargetExpression expression : settingsFile.getTopLevelAttributes()) {
            String name = expression.getName();
            if (name == null) continue;
            result2.add(new PyCustomMember(name, (PsiElement)expression));
        }
        List imports = settingsFile.getFromImports();
        for (PyFromImportStatement element : imports) {
            PsiElement resolved;
            PyReferenceExpression expression = element.getImportSource();
            if (expression == null || !((resolved = expression.getReference().resolve()) instanceof PyFile)) continue;
            DjangoSettingsPy.collectAllMembers((PyFile)resolved, result2, processedFiles);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 14, 16, 18, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 1: 
            case 4: 
            case 10: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsVFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/codeInsight/DjangoSettingsPy";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsPy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/codeInsight/DjangoSettingsPy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledApps";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMiddleware";
                break;
            }
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldTemplateDirs";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticfilesDirs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateLoaders";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "insertAppToInstalledApps";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifyInsertAppFailed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asPyFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveSettingsMember";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledApps";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 13: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOldTemplateDirs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStaticfilesDirs";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateDicts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 14, 16, 18, 19, 21 -> new IllegalStateException(string);
        };
    }

    private static final class DjangoSettingsCache {
        private final List<String> myInstalledApps;
        private final List<String> myMiddleware;
        private final List<String> myTemplateLoaders;
        private final List<String> myOldTemplateDirs;
        private final Collection<PyDictLiteralExpression> myTemplateDicts;
        private final List<PyExpression> myStaticfilesDirs;
        private final String myRootUrlconf;
        private final String myMediaUrl;
        private final String myTestRunner;
        private final String myStaticRoot;
        private final String myMediaRoot;

        private DjangoSettingsCache(List<String> apps, List<String> templateLoaders, List<String> oldTemplateDirs, List<PyExpression> staticfilesDirs, List<String> middleware, String rootUrlconf, String mediaUrl, String testRunner, String staticRoot, Collection<PyDictLiteralExpression> templateDicts, String mediaRoot) {
            this.myInstalledApps = apps;
            this.myTemplateDicts = templateDicts;
            this.myTemplateLoaders = templateLoaders;
            this.myOldTemplateDirs = oldTemplateDirs;
            this.myStaticfilesDirs = staticfilesDirs;
            this.myMiddleware = middleware;
            this.myRootUrlconf = rootUrlconf;
            this.myMediaUrl = mediaUrl;
            this.myTestRunner = testRunner;
            this.myStaticRoot = staticRoot;
            this.myMediaRoot = mediaRoot;
        }
    }
}

