/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.modelApi;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoField;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.modelApi.DjangoUrlModel;
import com.jetbrains.django.model.modelApi.NoSuchApplicationException;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoader;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoTemplateLoaderStrategy;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.Result;
import com.jetbrains.python.extensions.ModuleExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoModelApi {
    public static final String PACKAGE_NAME = "Django";
    @NotNull
    private final PsiDirectory myWebSiteDirectory;
    @NotNull
    private final Module myDjangoModule;
    @NotNull
    private final VirtualFile mySettingsFile;
    @NotNull
    private final VirtualFile myDjangoProjectRoot;

    private DjangoModelApi(@NotNull PsiDirectory webSiteDirectory, @NotNull Module djangoModule, @NotNull VirtualFile djangoProjectRoot, @NotNull VirtualFile settingsFile) {
        if (webSiteDirectory == null) {
            DjangoModelApi.$$$reportNull$$$0(0);
        }
        if (djangoModule == null) {
            DjangoModelApi.$$$reportNull$$$0(1);
        }
        if (djangoProjectRoot == null) {
            DjangoModelApi.$$$reportNull$$$0(2);
        }
        if (settingsFile == null) {
            DjangoModelApi.$$$reportNull$$$0(3);
        }
        this.myWebSiteDirectory = webSiteDirectory;
        this.myDjangoModule = djangoModule;
        this.myDjangoProjectRoot = djangoProjectRoot;
        this.mySettingsFile = settingsFile;
    }

    @NotNull
    @RequiresReadLock
    public static @NotNull Result<DjangoModelApi, @NonNls String> create(@NotNull Module djangoModule) {
        if (djangoModule == null) {
            DjangoModelApi.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.softAssertReadAccess();
        DjangoFacet facet = DjangoFacet.getInstance(djangoModule);
        if (facet == null) {
            return new Result.Failure((Object)("Facet not found in module " + djangoModule));
        }
        VirtualFile djangoProjectRoot = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile();
        if (djangoProjectRoot == null) {
            return new Result.Failure((Object)("Root not found in module " + djangoModule));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)djangoModule.getProject());
        VirtualFile settingsFile = DjangoCoreUtil.getSettingsFile(facet);
        if (settingsFile == null) {
            return new Result.Failure((Object)("Settings file not found in module " + djangoModule));
        }
        VirtualFile webSiteFolder = settingsFile.getParent();
        if (webSiteFolder == null) {
            return new Result.Failure((Object)("WebSite virtual folder not found in module " + djangoModule));
        }
        PsiDirectory webSiteDirectory = psiManager.findDirectory(webSiteFolder);
        if (webSiteDirectory == null) {
            return new Result.Failure((Object)("WebSite directory not found in module " + djangoModule));
        }
        return new Result.Success((Object)new DjangoModelApi(webSiteDirectory, djangoModule, djangoProjectRoot, settingsFile));
    }

    @NotNull
    @RequiresReadLock
    public static @NotNull Result<DjangoModelApi, @NonNls String> create(@NotNull PyElement djangoElement) {
        if (djangoElement == null) {
            DjangoModelApi.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.softAssertReadAccess();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)djangoElement);
        if (module == null) {
            return new Result.Failure((Object)("No module found for element " + djangoElement));
        }
        return DjangoModelApi.create(module);
    }

    public boolean isDjangoPackageMatches(@NotNull PyRequirement requirement, boolean defaultValue) {
        Boolean result2;
        if (requirement == null) {
            DjangoModelApi.$$$reportNull$$$0(6);
        }
        return (result2 = this.isDjangoPackageMatches(requirement)) != null ? result2 : defaultValue;
    }

    @Nullable
    public Boolean isDjangoPackageMatches(@NotNull PyRequirement requirement) {
        PyPackage aPackage;
        if (requirement == null) {
            DjangoModelApi.$$$reportNull$$$0(7);
        }
        if ((aPackage = this.getDjangoPackage()) == null) {
            return null;
        }
        return aPackage.matches(requirement);
    }

    @NotNull
    public List<DjangoUrlModel> getRootUrls() {
        PyFile mainUrlsPy = this.getURLConfFile();
        if (mainUrlsPy == null) {
            List<DjangoUrlModel> list2 = Collections.emptyList();
            if (list2 == null) {
                DjangoModelApi.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<DjangoUrlModel> list3 = DjangoUrlModel.getUrlsByFile(mainUrlsPy);
        if (list3 == null) {
            DjangoModelApi.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @NotNull
    public List<DjangoModelClass> getModelClasses(@NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoModelApi.$$$reportNull$$$0(10);
        }
        ArrayList<DjangoModelClass> result2 = new ArrayList<DjangoModelClass>();
        for (DjangoApplicationModel applicationModel : this.getApplications()) {
            result2.addAll(applicationModel.getModelClasses(context));
        }
        ArrayList<DjangoModelClass> arrayList = result2;
        if (arrayList == null) {
            DjangoModelApi.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    @RequiresReadLock
    public List<DjangoApplicationModel> getApplications() {
        ThreadingAssertions.softAssertReadAccess();
        ArrayList<DjangoApplicationModel> result2 = new ArrayList<DjangoApplicationModel>();
        for (DjangoAppConfig appInfo : DjangoSettingsPy.getInstalledApps(this.myDjangoModule)) {
            try {
                result2.add(new DjangoApplicationModel(appInfo, this.myDjangoModule, this.myDjangoProjectRoot));
            }
            catch (NoSuchApplicationException noSuchApplicationException) {}
        }
        ArrayList<DjangoApplicationModel> arrayList = result2;
        if (arrayList == null) {
            DjangoModelApi.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<VirtualFile, Class<?>>> getTemplateFolders() {
        ArrayList result2 = new ArrayList();
        for (DjangoTemplateLoader loader : DjangoTemplateLoaderStrategy.getLoaders(this)) {
            for (VirtualFile templateFolder : loader.getTemplateFolders(this)) {
                result2.add(Pair.create((Object)templateFolder, loader.getClass()));
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            DjangoModelApi.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public Module getDjangoModule() {
        Module module = this.myDjangoModule;
        if (module == null) {
            DjangoModelApi.$$$reportNull$$$0(14);
        }
        return module;
    }

    @Nullable
    public List<String> getDjangoVersionParts() {
        PyPackage aPackage = this.getDjangoPackage();
        if (aPackage == null) {
            return null;
        }
        return DjangoCoreUtil.getDjangoVersionParts(aPackage);
    }

    @Nullable
    public PyPackage getDjangoPackage() {
        Sdk sdk = ModuleExtKt.getSdk((Module)this.myDjangoModule);
        if (sdk == null) {
            return null;
        }
        List packages = PyPackageManager.getInstance((Sdk)sdk).getPackages();
        if (packages == null) {
            return null;
        }
        return PyPsiPackageUtil.findPackage((List)packages, (String)PACKAGE_NAME);
    }

    @NotNull
    public VirtualFile getSettingsFile() {
        VirtualFile virtualFile = this.mySettingsFile;
        if (virtualFile == null) {
            DjangoModelApi.$$$reportNull$$$0(15);
        }
        return virtualFile;
    }

    @Nullable
    public PyFile getURLConfFile() {
        PsiFile result2 = null;
        String urlconf = DjangoSettingsPy.getRootUrlconf(this.myDjangoModule);
        if (urlconf != null) {
            result2 = DjangoPsiUtil.findFileInRoots(urlconf, (PsiElement)this.myWebSiteDirectory);
        }
        if (result2 == null) {
            result2 = this.myWebSiteDirectory.findFile("urls.py");
        }
        return (PyFile)PyUtil.as((Object)result2, PyFile.class);
    }

    public static boolean notDjangoModule(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            DjangoModelApi.$$$reportNull$$$0(16);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && !DjangoFacet.isPresent(module);
    }

    public void collectAllUrlsFromCache(@NotNull Set<? super PyFile> files) {
        if (files == null) {
            DjangoModelApi.$$$reportNull$$$0(17);
        }
        Project project = this.myDjangoModule.getProject();
        Collection urlPatternVars = StubIndex.getElements((StubIndexKey)PyVariableNameIndex.KEY, (Object)"urlpatterns", (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project), PyTargetExpression.class);
        for (PyTargetExpression urlPatternVar : urlPatternVars) {
            PsiFile file = urlPatternVar.getContainingFile();
            if (!(file instanceof PyFile)) continue;
            files.add((PyFile)((PyFile)file));
        }
    }

    @NotNull
    public VirtualFile getDjangoProjectRoot() {
        VirtualFile virtualFile = this.myDjangoProjectRoot;
        if (virtualFile == null) {
            DjangoModelApi.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    @NotNull
    public static List<DjangoField> getFieldsWithTypes(@NotNull TypeEvalContext context, @NotNull PyClass clazz, @NotNull Function<? super PyTargetExpression, ? extends PyType> typeProvider, @NotNull DjangoFQNamesProvider fieldParent) {
        if (context == null) {
            DjangoModelApi.$$$reportNull$$$0(19);
        }
        if (clazz == null) {
            DjangoModelApi.$$$reportNull$$$0(20);
        }
        if (typeProvider == null) {
            DjangoModelApi.$$$reportNull$$$0(21);
        }
        if (fieldParent == null) {
            DjangoModelApi.$$$reportNull$$$0(22);
        }
        ArrayList<DjangoField> result2 = new ArrayList<DjangoField>();
        for (PyTargetExpression targetExpression : clazz.getClassAttributesInherited(context)) {
            PyExpression assignedValue;
            String name = targetExpression.getName();
            if (name == null || (assignedValue = targetExpression.findAssignedValue()) == null) continue;
            PyClassType fieldClassType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)assignedValue), PyClassType.class);
            PyType fieldType = typeProvider.apply((PyTargetExpression)targetExpression);
            if (fieldType != null && fieldClassType != null) {
                result2.add(new DjangoField(targetExpression, fieldType, name, fieldClassType));
                continue;
            }
            if (fieldClassType == null || !NameResolverTools.isSubclass((PyClass)fieldClassType.getPyClass(), (FQNamesProvider)fieldParent, (TypeEvalContext)context)) continue;
            result2.add(new DjangoField(targetExpression, null, name, fieldClassType));
        }
        ArrayList<DjangoField> arrayList = result2;
        if (arrayList == null) {
            DjangoModelApi.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 11, 12, 13, 14, 15, 18, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webSiteDirectory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoProjectRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/modelApi/DjangoModelApi";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProvider";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/modelApi/DjangoModelApi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootUrls";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplications";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFolders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDjangoModule";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDjangoProjectRoot";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsWithTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoPackageMatches";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 23: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModelClasses";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notDjangoModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectAllUrlsFromCache";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsWithTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 11, 12, 13, 14, 15, 18, 23 -> new IllegalStateException(string);
        };
    }
}

