/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.batik.mapping.svg;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.batik.mapping.svg.Utils;
import org.jetbrains.letsPlot.commons.event.Event;
import org.jetbrains.letsPlot.commons.event.MouseEvent;
import org.jetbrains.letsPlot.commons.registration.CompositeRegistration;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.datamodel.mapping.svg.shared.TargetPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimElements;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimNode;
import org.jetbrains.letsPlot.datamodel.svg.event.SvgEventSpec;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMCircleElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMGElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMLineElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMPathElement;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMRectElement;
import org.jetbrains.relocated.apache.batik.dom.AbstractDocument;
import org.jetbrains.relocated.apache.batik.dom.events.DOMMouseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J&\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/batik/mapping/svg/BatikTargetPeer;", "Lorg/jetbrains/letsPlot/datamodel/mapping/svg/shared/TargetPeer;", "Lorg/w3c/dom/Node;", "doc", "Lorg/jetbrains/relocated/apache/batik/dom/AbstractDocument;", "(Lorg/apache/batik/dom/AbstractDocument;)V", "addMouseHandler", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "source", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "target", "Lorg/w3c/dom/events/EventTarget;", "spec", "Lorg/jetbrains/letsPlot/datamodel/svg/event/SvgEventSpec;", "eventType", "", "appendChild", "", "child", "hookEventHandlers", "eventSpecs", "", "newSvgElement", "newSvgSlimNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimNode;", "newSvgTextNode", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextNode;", "removeAllChildren", "setAttribute", "name", "value", "platf-batik"})
public final class BatikTargetPeer
implements TargetPeer<Node> {
    @NotNull
    private final AbstractDocument doc;

    public BatikTargetPeer(@NotNull AbstractDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.doc = doc;
    }

    @Override
    public void appendChild(@NotNull Node target, @NotNull Node child) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        target.appendChild(child);
    }

    @Override
    public void removeAllChildren(@NotNull Node target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target.hasChildNodes()) {
            Node child = target.getFirstChild();
            while (child != null) {
                Node nextSibling = child.getNextSibling();
                target.removeChild(child);
                child = nextSibling;
            }
        }
    }

    @Override
    @NotNull
    public Node newSvgElement(@NotNull SvgElement source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return Utils.INSTANCE.newBatikElement(source, this.doc);
    }

    @Override
    @NotNull
    public Node newSvgTextNode(@NotNull SvgTextNode source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Text textNode = Utils.INSTANCE.newBatikText(source, this.doc);
        textNode.setNodeValue((String)source.textContent().get());
        return textNode;
    }

    @Override
    @NotNull
    public Node newSvgSlimNode(@NotNull SvgSlimNode source) {
        Node node;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String string = source.getElementName();
        if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getGROUP())) {
            node = new SVGOMGElement(null, this.doc);
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getLINE())) {
            node = new SVGOMLineElement(null, this.doc);
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getCIRCLE())) {
            node = new SVGOMCircleElement(null, this.doc);
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getRECT())) {
            node = new SVGOMRectElement(null, this.doc);
        } else if (Intrinsics.areEqual((Object)string, (Object)SvgSlimElements.INSTANCE.getPATH())) {
            node = new SVGOMPathElement(null, this.doc);
        } else {
            throw new IllegalStateException("Unsupported slim node " + Reflection.getOrCreateKotlinClass(source.getClass()).getSimpleName() + " '" + source.getElementName() + '\'');
        }
        return node;
    }

    @Override
    public void setAttribute(@NotNull Node target, @NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ((Element)target).setAttribute(name, value2);
    }

    @Override
    @NotNull
    public Registration hookEventHandlers(@NotNull SvgElement source, @NotNull Node target, @NotNull Set<? extends SvgEventSpec> eventSpecs) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(eventSpecs, (String)"eventSpecs");
        CompositeRegistration regs = new CompositeRegistration(new Registration[0]);
        EventTarget cfr_ignored_0 = (EventTarget)((Object)target);
        for (SvgEventSpec svgEventSpec : eventSpecs) {
            Registration registration2;
            switch (WhenMappings.$EnumSwitchMapping$0[svgEventSpec.ordinal()]) {
                case 1: {
                    registration2 = this.addMouseHandler(source, (EventTarget)((Object)target), svgEventSpec, "click");
                    break;
                }
                case 2: {
                    registration2 = this.addMouseHandler(source, (EventTarget)((Object)target), svgEventSpec, "mousedown");
                    break;
                }
                case 3: {
                    registration2 = this.addMouseHandler(source, (EventTarget)((Object)target), svgEventSpec, "mouseup");
                    break;
                }
                case 4: {
                    registration2 = this.addMouseHandler(source, (EventTarget)((Object)target), svgEventSpec, "mouseover");
                    break;
                }
                case 5: {
                    registration2 = this.addMouseHandler(source, (EventTarget)((Object)target), svgEventSpec, "mousemove");
                    break;
                }
                case 6: {
                    registration2 = this.addMouseHandler(source, (EventTarget)((Object)target), svgEventSpec, "mouseout");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected event spec " + (Object)((Object)svgEventSpec));
                }
            }
            Registration handlerReg = registration2;
            regs.add(handlerReg);
        }
        return regs;
    }

    private final Registration addMouseHandler(SvgElement source, EventTarget target, SvgEventSpec spec, String eventType) {
        EventListener listener2 = arg_0 -> BatikTargetPeer.addMouseHandler$lambda$0(source, spec, arg_0);
        target.addEventListener(eventType, listener2, false);
        return new Registration(target, eventType, listener2){
            final /* synthetic */ EventTarget $target;
            final /* synthetic */ String $eventType;
            final /* synthetic */ EventListener $listener;
            {
                this.$target = $target;
                this.$eventType = $eventType;
                this.$listener = $listener;
            }

            protected void doRemove() {
                this.$target.removeEventListener(this.$eventType, this.$listener, false);
            }
        };
    }

    private static final void addMouseHandler$lambda$0(SvgElement $source, SvgEventSpec $spec, org.w3c.dom.events.Event evt) {
        Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
        Intrinsics.checkNotNullParameter((Object)((Object)$spec), (String)"$spec");
        evt.stopPropagation();
        Intrinsics.checkNotNull((Object)evt, (String)"null cannot be cast to non-null type org.apache.batik.dom.events.DOMMouseEvent");
        DOMMouseEvent e = (DOMMouseEvent)evt;
        $source.dispatch($spec, (Event)new MouseEvent(e.getClientX(), e.getClientY(), Utils.INSTANCE.getButton(e), Utils.INSTANCE.getModifiers(e)));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SvgEventSpec.values().length];
            try {
                nArray[SvgEventSpec.MOUSE_CLICKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SvgEventSpec.MOUSE_PRESSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SvgEventSpec.MOUSE_RELEASED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SvgEventSpec.MOUSE_OVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SvgEventSpec.MOUSE_MOVE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SvgEventSpec.MOUSE_OUT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

