/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.Transform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00062\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0004J\u0012\u0010\u001f\u001a\u00020\u001d2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010 \u001a\u00020\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0014\u0010!\u001a\u00020\u00002\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "domainValues", "", "", "domainLimits", "", "(Ljava/util/Collection;Ljava/util/List;)V", "effectiveDomain", "getEffectiveDomain", "()Ljava/util/List;", "effectiveDomainTransformed", "", "getEffectiveDomainTransformed", "indexByDomainValue", "", "", "initialDomain", "getInitialDomain", "apply", "l", "applyInverse", "v", "(Ljava/lang/Double;)Ljava/lang/Object;", "asNumber", "input", "(Ljava/lang/Object;)Ljava/lang/Double;", "fromNumber", "hasDomainLimits", "", "indexOf", "isInDomain", "withDomain", "withMoreLimits", "limits", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDiscreteTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscreteTransform.kt\norg/jetbrains/letsPlot/core/plot/base/DiscreteTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1559#2:99\n1590#2,4:100\n1549#2:104\n1620#2,3:105\n1549#2:108\n1620#2,3:109\n*S KotlinDebug\n*F\n+ 1 DiscreteTransform.kt\norg/jetbrains/letsPlot/core/plot/base/DiscreteTransform\n*L\n28#1:99\n28#1:100,4\n29#1:104\n29#1:105,3\n45#1:108\n45#1:109,3\n*E\n"})
public final class DiscreteTransform
implements Transform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Object> domainLimits;
    @NotNull
    private final Map<Object, Integer> indexByDomainValue;
    @NotNull
    private final List<Object> initialDomain;
    @NotNull
    private final List<Object> effectiveDomain;
    @NotNull
    private final List<Double> effectiveDomainTransformed;

    /*
     * WARNING - void declaration
     */
    public DiscreteTransform(@NotNull Collection<? extends Object> domainValues, @NotNull List<? extends Object> domainLimits) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        Intrinsics.checkNotNullParameter(domainLimits, (String)"domainLimits");
        this.domainLimits = domainLimits;
        this.initialDomain = CollectionsKt.distinct((Iterable)domainValues);
        this.effectiveDomain = this.domainLimits.isEmpty() ? this.initialDomain : CollectionsKt.distinct((Iterable)this.domainLimits);
        Iterable iterable = this.effectiveDomain;
        DiscreteTransform discreteTransform = this;
        boolean $i$f$mapIndexed = false;
        void var5_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void value2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)value2, (Object)((int)index)));
        }
        discreteTransform.indexByDomainValue = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        $this$mapIndexed$iv = this.effectiveDomain;
        discreteTransform = this;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object item$iv$iv2;
            item$iv$iv2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Double.valueOf(((Number)MapsKt.getValue(this.indexByDomainValue, (Object)it)).intValue()));
        }
        discreteTransform.effectiveDomainTransformed = (List)destination$iv$iv;
    }

    @NotNull
    public final List<Object> getInitialDomain() {
        return this.initialDomain;
    }

    @NotNull
    public final List<Object> getEffectiveDomain() {
        return this.effectiveDomain;
    }

    @NotNull
    public final List<Double> getEffectiveDomainTransformed() {
        return this.effectiveDomainTransformed;
    }

    @Override
    public boolean hasDomainLimits() {
        return !((Collection)this.domainLimits).isEmpty();
    }

    @Override
    public boolean isInDomain(@Nullable Object v) {
        return this.indexByDomainValue.containsKey(v);
    }

    public final int indexOf(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return ((Number)MapsKt.getValue(this.indexByDomainValue, (Object)v)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Double> apply(@NotNull List<?> l) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Iterable $this$map$iv = l;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.asNumber(it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object applyInverse(@Nullable Double v) {
        return this.fromNumber(v);
    }

    private final Double asNumber(Object input) {
        if (input == null) {
            return null;
        }
        if (this.indexByDomainValue.containsKey(input)) {
            return ((Number)MapsKt.getValue(this.indexByDomainValue, (Object)input)).intValue();
        }
        throw new IllegalStateException("value " + input + " is not in the domain: " + this.effectiveDomain);
    }

    private final Object fromNumber(Double v) {
        double d;
        if (v == null || !(!Double.isInfinite(d = v.doubleValue()) && !Double.isNaN(d))) {
            return null;
        }
        int i = MathKt.roundToInt((double)v);
        return i >= 0 && i < this.effectiveDomain.size() ? this.effectiveDomain.get(i) : null;
    }

    @NotNull
    public final DiscreteTransform withMoreLimits(@NotNull Collection<? extends Object> limits) {
        Intrinsics.checkNotNullParameter(limits, (String)"limits");
        List expandedLimits = CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)this.domainLimits, (Iterable)limits));
        return new DiscreteTransform((Collection<? extends Object>)this.initialDomain, expandedLimits);
    }

    @NotNull
    public final DiscreteTransform withDomain(@NotNull Collection<? extends Object> domainValues) {
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        return new DiscreteTransform(domainValues, this.domainLimits);
    }

    @Override
    @NotNull
    public List<Object> applyInverse(@NotNull List<Double> l) {
        return Transform.DefaultImpls.applyInverse(this, l);
    }

    @Override
    @NotNull
    public Transform unwrap() {
        return Transform.DefaultImpls.unwrap(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform$Companion;", "", "()V", "join", "Lorg/jetbrains/letsPlot/core/plot/base/DiscreteTransform;", "l", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DiscreteTransform join(@NotNull List<DiscreteTransform> l) {
            Intrinsics.checkNotNullParameter(l, (String)"l");
            LinkedHashSet domainValues = new LinkedHashSet();
            LinkedHashSet domainLimits = new LinkedHashSet();
            for (DiscreteTransform transform2 : l) {
                domainValues.addAll(transform2.getInitialDomain());
                domainLimits.addAll(transform2.domainLimits);
            }
            return new DiscreteTransform(domainValues, CollectionsKt.toList((Iterable)domainLimits));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

