/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.geom.TextGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001aH\u0016J0\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LabelGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom;", "()V", "alphaStroke", "", "getAlphaStroke", "()Z", "setAlphaStroke", "(Z)V", "borderWidth", "", "getBorderWidth", "()D", "setBorderWidth", "(D)V", "paddingFactor", "getPaddingFactor", "setPaddingFactor", "radiusFactor", "getRadiusFactor", "setRadiusFactor", "buildTextComponent", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "text", "", "sizeUnitRatio", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "boundsCenter", "rectangleForText", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "textSize", "padding", "hAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "vAnchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "Companion", "plot-base"})
public final class LabelGeom
extends TextGeom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double paddingFactor = 0.25;
    private double radiusFactor = 0.15;
    private double borderWidth = 1.0;
    private boolean alphaStroke;

    public final double getPaddingFactor() {
        return this.paddingFactor;
    }

    public final void setPaddingFactor(double d) {
        this.paddingFactor = d;
    }

    public final double getRadiusFactor() {
        return this.radiusFactor;
    }

    public final void setRadiusFactor(double d) {
        this.radiusFactor = d;
    }

    public final double getBorderWidth() {
        return this.borderWidth;
    }

    public final void setBorderWidth(double d) {
        this.borderWidth = d;
    }

    public final boolean getAlphaStroke() {
        return this.alphaStroke;
    }

    public final void setAlphaStroke(boolean bl) {
        this.alphaStroke = bl;
    }

    @Override
    @NotNull
    public SvgGElement buildTextComponent(@NotNull DataPointAesthetics p, @NotNull DoubleVector location2, @NotNull String text2, double sizeUnitRatio, @NotNull GeomContext ctx2, @Nullable DoubleVector boundsCenter) {
        double d;
        SvgPathElement svgPathElement;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        DoubleVector textSize = TextUtil.INSTANCE.measure(text2, p, ctx2, sizeUnitRatio);
        Text.HorizontalAnchor hAnchor = TextUtil.INSTANCE.hAnchor(p, location2, boundsCenter);
        Text.VerticalAnchor vAnchor = TextUtil.INSTANCE.vAnchor(p, location2, boundsCenter);
        double fontSize = TextUtil.INSTANCE.fontSize(p, sizeUnitRatio);
        double padding = fontSize * this.paddingFactor;
        DoubleRectangle rectangle = this.rectangleForText(location2, textSize, padding, hAnchor, vAnchor);
        SvgPathElement $this$buildTextComponent_u24lambda_u240 = svgPathElement = new SvgPathElement();
        boolean bl = false;
        $this$buildTextComponent_u24lambda_u240.d().set(LabelGeom.Companion.roundedRectangle(rectangle, this.radiusFactor * rectangle.getHeight()).build());
        SvgPathElement backgroundRect = svgPathElement;
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, backgroundRect, p, this.alphaStroke, null, false, 24, null);
        backgroundRect.strokeWidth().set(this.borderWidth);
        MultilineLabel label2 = new MultilineLabel(text2);
        TextUtil.INSTANCE.decorate(label2, p, sizeUnitRatio, this.alphaStroke);
        switch (WhenMappings.$EnumSwitchMapping$0[hAnchor.ordinal()]) {
            case 1: {
                d = location2.getX() + padding;
                break;
            }
            case 2: {
                d = location2.getX() - padding;
                break;
            }
            case 3: {
                d = location2.getX();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double xPosition = d;
        DoubleVector textPosition = new DoubleVector(xPosition, rectangle.getOrigin().getY() + padding + fontSize * 0.8);
        label2.setHorizontalAnchor(hAnchor);
        label2.moveTo(textPosition);
        SvgGElement g = new SvgGElement();
        g.children().add(backgroundRect);
        g.children().add(label2.getRootGroup());
        SvgUtils.INSTANCE.transformRotate(g, TextUtil.INSTANCE.angle(p), location2.getX(), location2.getY());
        return g;
    }

    private final DoubleRectangle rectangleForText(DoubleVector location2, DoubleVector textSize, double padding, Text.HorizontalAnchor hAnchor, Text.VerticalAnchor vAnchor) {
        double d;
        double d2;
        double width2 = textSize.getX() + padding * (double)2;
        double height = textSize.getY() + padding * (double)2;
        switch (WhenMappings.$EnumSwitchMapping$0[hAnchor.ordinal()]) {
            case 1: {
                d2 = location2.getX();
                break;
            }
            case 2: {
                d2 = location2.getX() - width2;
                break;
            }
            case 3: {
                d2 = location2.getX() - width2 / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double originX2 = d2;
        switch (WhenMappings.$EnumSwitchMapping$1[vAnchor.ordinal()]) {
            case 1: {
                d = location2.getY();
                break;
            }
            case 2: {
                d = location2.getY() - height;
                break;
            }
            case 3: {
                d = location2.getY() - height / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double originY2 = d;
        return new DoubleRectangle(originX2, originY2, width2, height);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LabelGeom$Companion;", "", "()V", "roundedRectangle", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder;", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "radius", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgPathDataBuilder roundedRectangle(DoubleRectangle rect2, double radius) {
            SvgPathDataBuilder svgPathDataBuilder;
            SvgPathDataBuilder $this$roundedRectangle_u24lambda_u241 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            boolean bl = false;
            DoubleRectangle $this$roundedRectangle_u24lambda_u241_u24lambda_u240 = rect2;
            boolean bl2 = false;
            double r = Math.min(radius, Math.min($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getWidth() / (double)2, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getHeight() / (double)2));
            SvgPathDataBuilder.moveTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight() - r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight() - r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom() - r, false, 64, null);
            SvgPathDataBuilder.lineTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop() + r, false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop() + r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight() - r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), false, 64, null);
            SvgPathDataBuilder.lineTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft() + r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft() + r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop() + r, false, 64, null);
            SvgPathDataBuilder.lineTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom() - r, false, 4, null);
            SvgPathDataBuilder.curveTo$default($this$roundedRectangle_u24lambda_u241, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom() - r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft() + r, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), false, 64, null);
            $this$roundedRectangle_u24lambda_u241.closePath();
            return svgPathDataBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Text.HorizontalAnchor.values().length];
            try {
                nArray[Text.HorizontalAnchor.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

