/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.layout;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "", "x", "", "y", "(DD)V", "getX", "()D", "getY", "Companion", "plot-base"})
public final class TextJustification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;

    public TextJustification(double x2, double y2) {
        this.x = x2;
        this.y = y2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification$Companion;", "", "()V", "applyJustification", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "boundRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "textSize", "lineHeight", "", "justification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "rotation", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification$Companion$TextRotation;", "xPosition", "hjust", "yPosition", "vjust", "TextRotation", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<DoubleVector, Text.HorizontalAnchor> applyJustification(@NotNull DoubleRectangle boundRect, @NotNull DoubleVector textSize, double lineHeight, @NotNull TextJustification justification, @Nullable TextRotation rotation) {
            DoubleVector doubleVector;
            Intrinsics.checkNotNullParameter((Object)boundRect, (String)"boundRect");
            Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
            Intrinsics.checkNotNullParameter((Object)justification, (String)"justification");
            DoubleRectangle rect2 = rotation != null ? boundRect.flip() : boundRect;
            Pair<Double, Text.HorizontalAnchor> pair2 = this.xPosition(rect2, justification.getX());
            double x2 = ((Number)pair2.component1()).doubleValue();
            Text.HorizontalAnchor hAnchor = (Text.HorizontalAnchor)((Object)pair2.component2());
            double y2 = this.yPosition(rect2, textSize, lineHeight, justification.getY());
            TextRotation textRotation = rotation;
            switch (textRotation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[textRotation.ordinal()]) {
                case -1: {
                    doubleVector = new DoubleVector(x2, y2);
                    break;
                }
                case 1: {
                    doubleVector = new DoubleVector(rect2.getTop() + rect2.getBottom() - y2, x2);
                    break;
                }
                case 2: {
                    doubleVector = new DoubleVector(y2, rect2.getLeft() + rect2.getRight() - x2);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DoubleVector position = doubleVector;
            return TuplesKt.to((Object)position, (Object)((Object)hAnchor));
        }

        public static /* synthetic */ Pair applyJustification$default(Companion companion, DoubleRectangle doubleRectangle, DoubleVector doubleVector, double d, TextJustification textJustification, TextRotation textRotation, int n, Object object) {
            if ((n & 0x10) != 0) {
                textRotation = null;
            }
            return companion.applyJustification(doubleRectangle, doubleVector, d, textJustification, textRotation);
        }

        private final Pair<Double, Text.HorizontalAnchor> xPosition(DoubleRectangle boundRect, double hjust) {
            double textWidth = 0.0;
            Text.HorizontalAnchor anchor = hjust < 0.5 ? Text.HorizontalAnchor.LEFT : (hjust == 0.5 ? Text.HorizontalAnchor.MIDDLE : Text.HorizontalAnchor.RIGHT);
            double x2 = boundRect.getLeft() + (boundRect.getWidth() - textWidth) * hjust;
            return TuplesKt.to((Object)x2, (Object)((Object)anchor));
        }

        private final double yPosition(DoubleRectangle boundRect, DoubleVector textSize, double lineHeight, double vjust) {
            double y2 = boundRect.getBottom() - (boundRect.getHeight() - textSize.getY()) * vjust;
            return y2 - textSize.getY() + lineHeight * 0.8;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification$Companion$TextRotation;", "", "angle", "", "(Ljava/lang/String;ID)V", "getAngle", "()D", "CLOCKWISE", "ANTICLOCKWISE", "plot-base"})
        public static final class TextRotation
        extends Enum<TextRotation> {
            private final double angle;
            public static final /* enum */ TextRotation CLOCKWISE = new TextRotation(90.0);
            public static final /* enum */ TextRotation ANTICLOCKWISE = new TextRotation(-90.0);
            private static final /* synthetic */ TextRotation[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private TextRotation(double angle) {
                this.angle = angle;
            }

            public final double getAngle() {
                return this.angle;
            }

            public static TextRotation[] values() {
                return (TextRotation[])$VALUES.clone();
            }

            public static TextRotation valueOf(String value2) {
                return Enum.valueOf(TextRotation.class, value2);
            }

            @NotNull
            public static EnumEntries<TextRotation> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = textRotationArray = new TextRotation[]{TextRotation.CLOCKWISE, TextRotation.ANTICLOCKWISE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TextRotation.values().length];
                try {
                    nArray[TextRotation.CLOCKWISE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TextRotation.ANTICLOCKWISE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

