/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.svg.RichText;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001e\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0007J\u0015\u0010$\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0007J\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0,J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0007H\u0002J\b\u0010/\u001a\u00020\u0013H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "text", "", "(Ljava/lang/String;)V", "myFontFamily", "myFontSize", "", "myFontStyle", "myFontWeight", "myLineHeight", "myLines", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextElement;", "myTextColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getText", "()Ljava/lang/String;", "addClassName", "", "className", "buildComponent", "linesCount", "", "setFontFamily", "fontFamily", "setFontSize", "px", "setFontStyle", "cssName", "setFontWeight", "setHorizontalAnchor", "anchor", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "setLineHeight", "v", "setTextOpacity", "value", "(Ljava/lang/Double;)V", "setX", "x", "setY", "y", "textColor", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/WritableProperty;", "updatePositions", "yStart", "updateStyleAttribute", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nMultilineLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n1855#2,2:129\n1855#2,2:131\n1855#2,2:133\n1855#2,2:135\n1855#2,2:137\n1855#2,2:139\n1864#2,3:141\n*S KotlinDebug\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel\n*L\n17#1:125\n17#1:126,3\n26#1:129,2\n33#1:131,2\n50#1:133,2\n85#1:135,2\n96#1:137,2\n100#1:139,2\n114#1:141,3\n*E\n"})
public final class MultilineLabel
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final List<SvgTextElement> myLines;
    @Nullable
    private Color myTextColor;
    private double myFontSize;
    @Nullable
    private String myFontWeight;
    @Nullable
    private String myFontFamily;
    @Nullable
    private String myFontStyle;
    private double myLineHeight;

    /*
     * WARNING - void declaration
     */
    public MultilineLabel(@NotNull String text2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        Iterable iterable = Companion.splitLines(this.text);
        Object object = RichText.INSTANCE;
        MultilineLabel multilineLabel = this;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((RichText)object).toSvg((String)p0));
        }
        multilineLabel.myLines = (List)destination$iv$iv;
        $this$map$iv = this.myLines;
        object = this.getRootGroup().children();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgNode p0 = (SvgNode)element$iv;
            boolean bl = false;
            object.add(p0);
        }
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Override
    protected void buildComponent() {
    }

    @Override
    public void addClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.addClass(className);
        }
    }

    @NotNull
    public final WritableProperty<Color> textColor() {
        return new WritableProperty<Color>(this){
            final /* synthetic */ MultilineLabel this$0;
            {
                this.this$0 = $receiver;
            }

            public void set(@Nullable Color value2) {
                Iterable $this$forEach$iv = MultilineLabel.access$getMyLines$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    SvgTextElement p0 = (SvgTextElement)element$iv;
                    boolean bl = false;
                    p0.fillColor();
                }
                MultilineLabel.access$setMyTextColor$p(this.this$0, value2);
                MultilineLabel.access$updateStyleAttribute(this.this$0);
            }
        };
    }

    public final void setHorizontalAnchor(@NotNull Text.HorizontalAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)((Object)anchor), (String)"anchor");
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.setAttribute("text-anchor", Text.INSTANCE.toTextAnchor$plot_base(anchor));
        }
    }

    public final void setFontSize(double px) {
        this.myFontSize = px;
        this.updateStyleAttribute();
    }

    public final void setFontWeight(@Nullable String cssName) {
        this.myFontWeight = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontStyle(@Nullable String cssName) {
        this.myFontStyle = cssName;
        this.updateStyleAttribute();
    }

    public final void setFontFamily(@Nullable String fontFamily) {
        this.myFontFamily = fontFamily;
        this.updateStyleAttribute();
    }

    public final void setTextOpacity(@Nullable Double value2) {
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.fillOpacity().set(value2);
        }
    }

    private final void updateStyleAttribute() {
        String styleAttr = Text.INSTANCE.buildStyle$plot_base(this.myTextColor, this.myFontSize, this.myFontWeight, this.myFontFamily, this.myFontStyle);
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.setAttribute("style", styleAttr);
        }
    }

    public final void setX(double x2) {
        Iterable $this$forEach$iv = this.myLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgTextElement it = (SvgTextElement)element$iv;
            boolean bl = false;
            it.x().set(x2);
        }
    }

    public final void setY(double y2) {
        this.updatePositions(y2);
    }

    public final void setLineHeight(double v) {
        this.myLineHeight = v;
        Object object = (SvgTextElement)CollectionsKt.firstOrNull(this.myLines);
        double yStart = object != null && (object = ((SvgTextElement)object).y()) != null && (object = (Double)object.get()) != null ? (Double)object : 0.0;
        this.updatePositions(yStart);
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePositions(double yStart) {
        Iterable $this$forEachIndexed$iv = this.myLines;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void elem;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SvgTextElement svgTextElement = (SvgTextElement)item$iv;
            int index = n;
            boolean bl = false;
            elem.y().set(yStart + this.myLineHeight * (double)index);
        }
    }

    public final int linesCount() {
        return this.myLines.size();
    }

    public static final /* synthetic */ List access$getMyLines$p(MultilineLabel $this) {
        return $this.myLines;
    }

    public static final /* synthetic */ void access$setMyTextColor$p(MultilineLabel $this, Color color) {
        $this.myTextColor = color;
    }

    public static final /* synthetic */ void access$updateStyleAttribute(MultilineLabel $this) {
        $this.updateStyleAttribute();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel$Companion;", "", "()V", "splitLines", "", "", "text", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nMultilineLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1549#2:125\n1620#2,3:126\n*S KotlinDebug\n*F\n+ 1 MultilineLabel.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel$Companion\n*L\n122#1:125\n122#1:126,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> splitLines(@NotNull String text2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            char[] cArray = new char[]{'\n'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)p0))).toString());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

