/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.css.engine.value.svg;

import org.jetbrains.relocated.apache.batik.css.engine.CSSEngine;
import org.jetbrains.relocated.apache.batik.css.engine.CSSStylableElement;
import org.jetbrains.relocated.apache.batik.css.engine.StyleMap;
import org.jetbrains.relocated.apache.batik.css.engine.value.ListValue;
import org.jetbrains.relocated.apache.batik.css.engine.value.URIValue;
import org.jetbrains.relocated.apache.batik.css.engine.value.Value;
import org.jetbrains.relocated.apache.batik.css.engine.value.svg.SVGColorManager;
import org.jetbrains.relocated.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGPaintManager
extends SVGColorManager {
    public SVGPaintManager(String prop) {
        super(prop);
    }

    public SVGPaintManager(String prop, Value v) {
        super(prop, v);
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 7;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine2) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                if (lu.getStringValue().equalsIgnoreCase("none")) {
                    return SVGValueConstants.NONE_VALUE;
                }
            }
            default: {
                return super.createValue(lu, engine2);
            }
            case 24: 
        }
        String value2 = lu.getStringValue();
        String uri = SVGPaintManager.resolveURI(engine2.getCSSBaseURI(), value2);
        lu = lu.getNextLexicalUnit();
        if (lu == null) {
            return new URIValue(value2, uri);
        }
        ListValue result2 = new ListValue(' ');
        result2.append(new URIValue(value2, uri));
        if (lu.getLexicalUnitType() == 35 && lu.getStringValue().equalsIgnoreCase("none")) {
            result2.append(SVGValueConstants.NONE_VALUE);
            return result2;
        }
        Value v = super.createValue(lu, engine2);
        if (v.getCssValueType() == 3) {
            ListValue lv = (ListValue)v;
            for (int i = 0; i < lv.getLength(); ++i) {
                result2.append(lv.item(i));
            }
        } else {
            result2.append(v);
        }
        return result2;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine2, int idx, StyleMap sm, Value value2) {
        ListValue lv;
        Value v;
        if (value2 == SVGValueConstants.NONE_VALUE) {
            return value2;
        }
        if (value2.getCssValueType() == 2 && (v = (lv = (ListValue)value2).item(0)).getPrimitiveType() == 20) {
            v = lv.item(1);
            if (v == SVGValueConstants.NONE_VALUE) {
                return value2;
            }
            Value t = super.computeValue(elt, pseudo, engine2, idx, sm, v);
            if (t != v) {
                ListValue result2 = new ListValue(' ');
                result2.append(lv.item(0));
                result2.append(t);
                if (lv.getLength() == 3) {
                    result2.append(lv.item(1));
                }
                return result2;
            }
            return value2;
        }
        return super.computeValue(elt, pseudo, engine2, idx, sm, value2);
    }
}

