/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.ext.awt.image;

import java.awt.Color;
import org.jetbrains.relocated.apache.batik.ext.awt.image.Light;

public abstract class AbstractLight
implements Light {
    private double[] color;

    public static final double sRGBToLsRGB(double value2) {
        if (value2 <= 0.003928) {
            return value2 / 12.92;
        }
        return Math.pow((value2 + 0.055) / 1.055, 2.4);
    }

    @Override
    public double[] getColor(boolean linear2) {
        double[] ret = new double[3];
        if (linear2) {
            ret[0] = AbstractLight.sRGBToLsRGB(this.color[0]);
            ret[1] = AbstractLight.sRGBToLsRGB(this.color[1]);
            ret[2] = AbstractLight.sRGBToLsRGB(this.color[2]);
        } else {
            ret[0] = this.color[0];
            ret[1] = this.color[1];
            ret[2] = this.color[2];
        }
        return ret;
    }

    public AbstractLight(Color color) {
        this.setColor(color);
    }

    @Override
    public void setColor(Color newColor) {
        this.color = new double[3];
        this.color[0] = (double)newColor.getRed() / 255.0;
        this.color[1] = (double)newColor.getGreen() / 255.0;
        this.color[2] = (double)newColor.getBlue() / 255.0;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public double[][][] getLightMap(double x2, double y2, double dx, double dy, int width2, int height, double[][][] z) {
        double[][][] L = new double[height][][];
        for (int i = 0; i < height; ++i) {
            L[i] = this.getLightRow(x2, y2, dx, width2, z[i], null);
            y2 += dy;
        }
        return L;
    }

    @Override
    public double[][] getLightRow(double x2, double y2, double dx, int width2, double[][] z, double[][] lightRow) {
        double[][] ret = lightRow;
        if (ret == null) {
            ret = new double[width2][3];
        }
        for (int i = 0; i < width2; ++i) {
            this.getLight(x2, y2, z[i][3], ret[i]);
            x2 += dx;
        }
        return ret;
    }
}

