/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java;

import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.concurrency.ThreadContext;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramScopeManager;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.uml.core.actions.UmlShowDependencies;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.JavaUmlEdge;
import com.intellij.uml.java.JavaUmlElementManager;
import com.intellij.uml.java.JavaUmlNode;
import com.intellij.uml.java.JavaUmlNodeItems;
import com.intellij.uml.java.JavaUmlRelationshipManager;
import com.intellij.uml.java.JavaUmlRelationships;
import com.intellij.uml.java.dependency.RelationshipAnalysisSimpleResult;
import com.intellij.uml.java.dependency.UastClassDependencyAnalyzer;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.java.utils.UmlJavaUtils;
import com.intellij.uml.java.utils.UmlKotlinUtils;
import com.intellij.uml.java.utils.UmlPsiUtil;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.uml.utils.DiagramContainerUtil;
import com.intellij.uml.utils.DiagramProgressUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ThreadSafe
public final class JavaUmlDataModel
extends DiagramDataModel<PsiElement> {
    private static final int READ_ACTION_BATCH_SIZE = 30;
    @NotNull
    private static final ProgressPart SEARCHING_FOR_NODE_ITEMS_PART = new ProgressPart(0.0, 0.4);
    @NotNull
    private static final ProgressPart COMPUTING_NODE_ITEMS_PRESENTATION_PART = new ProgressPart(0.4, 0.35);
    @NotNull
    private static final ProgressPart INFERRING_RELATIONSHIP_PART = new ProgressPart(0.75, 0.25);
    @Nullable
    private volatile SmartPsiElementPointer<PsiElement> myInitialElement;
    private volatile boolean myHasAlreadyDroppedParents;
    private volatile boolean myUseInnerClasses;
    private volatile boolean myIsReinitializing;
    private volatile boolean myContainsKotlinClassesOnly;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiClass>> myClasses;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiClass>> myClassesRemovedByUser;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiPackage>> myPackages;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<String, SmartPsiElementPointer<PsiPackage>> myPackagesRemovedByUser;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<SmartPsiElementPointer<PsiElement>, JavaUmlNodeItems> myNodesItems;
    @GuardedBy(value="myLock")
    @NotNull
    private final Set<DiagramNode<PsiElement>> myNodes;
    @GuardedBy(value="myLock")
    @NotNull
    private final Set<DiagramEdge<PsiElement>> myEdges;
    @GuardedBy(value="myLock")
    @NotNull
    private final Set<DiagramEdge<PsiElement>> myDependencyEdges;
    @GuardedBy(value="myLock")
    @NotNull
    private final Set<DiagramEdgeIdentity<PsiElement>> myEdgesRemovedByUser;
    @NotNull
    private final Object myLock;
    @Nullable
    private final VirtualFile myEditorFile;
    @NotNull
    private final SmartPointerManager mySpManager;

    public JavaUmlDataModel(@NotNull Project project, @Nullable PsiElement psiElement, @Nullable VirtualFile file, @NotNull DiagramPresentationModel ignoredPresentationModel) {
        if (project == null) {
            JavaUmlDataModel.$$$reportNull$$$0(0);
        }
        if (ignoredPresentationModel == null) {
            JavaUmlDataModel.$$$reportNull$$$0(1);
        }
        super(project, Objects.requireNonNull(DiagramProvider.findByID("JAVA")));
        this.myClasses = new HashMap<String, SmartPsiElementPointer<PsiClass>>();
        this.myClassesRemovedByUser = new HashMap<String, SmartPsiElementPointer<PsiClass>>();
        this.myPackages = new HashMap<String, SmartPsiElementPointer<PsiPackage>>();
        this.myPackagesRemovedByUser = new HashMap<String, SmartPsiElementPointer<PsiPackage>>();
        this.myNodesItems = new HashMap<SmartPsiElementPointer<PsiElement>, JavaUmlNodeItems>();
        this.myNodes = new HashSet<DiagramNode<PsiElement>>();
        this.myEdges = new HashSet<DiagramEdge<PsiElement>>();
        this.myDependencyEdges = new HashSet<DiagramEdge<PsiElement>>();
        this.myEdgesRemovedByUser = new HashSet<DiagramEdgeIdentity<PsiElement>>();
        this.myLock = new Object();
        this.myEditorFile = file;
        this.mySpManager = SmartPointerManager.getInstance((Project)this.getProject());
        this.init(psiElement);
    }

    private void init(@Nullable PsiElement psiElement) {
        this.myIsReinitializing = true;
        this.myInitialElement = psiElement == null ? null : this.mySpManager.createSmartPsiElementPointer(psiElement);
        this.myHasAlreadyDroppedParents = false;
        this.myUseInnerClasses = Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(JavaUmlCategoryManager.INNER_CLASSES);
        if (psiElement != null) {
            this.addElement(psiElement);
        }
        this.myIsReinitializing = false;
    }

    @Override
    @Nullable
    public DiagramNode<PsiElement> addElement(@Nullable PsiElement element) {
        return (DiagramNode)ContainerUtil.getFirstItem(this.addMultiNodeElement(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<DiagramNode<PsiElement>> addMultiNodeElement(@Nullable PsiElement element) {
        if (element == null) {
            List<DiagramNode<PsiElement>> list = List.of();
            if (list != null) return list;
            JavaUmlDataModel.$$$reportNull$$$0(2);
            return list;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.findNode(element) != null) {
            List<DiagramNode<PsiElement>> list = List.of();
            // MONITOREXIT : object
            if (list != null) return list;
            JavaUmlDataModel.$$$reportNull$$$0(3);
            return list;
        }
        PsiPackage aPackage = JavaUmlElementManager.tryInterpretAsPackage(element);
        Stream<DiagramNode<PsiElement>> nodes = aPackage != null ? this.addPackage(aPackage) : (element instanceof PsiClass ? this.addClasses(!this.isModelInitializationFinished() && this.myIsReinitializing, (PsiClass)element) : (element instanceof PsiClassOwner ? this.addFile((PsiClassOwner)element) : (element instanceof PsiDirectory ? this.addDirectory((PsiDirectory)element) : Stream.of((DiagramNode)null))));
        List<DiagramNode<PsiElement>> list = nodes.collect(Collectors.toList());
        // MONITOREXIT : object
        if (list != null) return list;
        JavaUmlDataModel.$$$reportNull$$$0(4);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addClasses(boolean addParents, PsiClass ... classes) {
        PsiElement initialElement;
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(5);
        }
        List<Object> classesList = new ArrayList<PsiClass>(Arrays.asList(classes));
        if (!this.isModelInitializationFinished() || this.myIsReinitializing) {
            void var6_9;
            classesList = new ArrayList(ContainerUtil.filter(classesList, it -> it.getQualifiedName() != null && !this.isInsidePackages((PsiClass)it)));
            PsiClass[] psiClassArray = classes;
            int n = psiClassArray.length;
            boolean bl = false;
            while (var6_9 < n) {
                PsiClass psiClass = psiClassArray[var6_9];
                this.setupScopeManager(psiClass, true);
                if (!this.myUseInnerClasses && PsiUtil.isInnerClass((PsiClass)psiClass)) {
                    this.myUseInnerClasses = true;
                    Objects.requireNonNull(this.getNodeContentManager()).setCategoryEnabled(JavaUmlCategoryManager.INNER_CLASSES, true);
                }
                ++var6_9;
            }
        }
        for (PsiClass psiClass : classesList) {
            this.myClassesRemovedByUser.remove(UmlPsiUtil.getClassQualifiedName(psiClass));
        }
        if (!(this.myHasAlreadyDroppedParents || this.isModelInitializationFinished() || this.myIsReinitializing || !((initialElement = JavaUmlDataModel.dereference(this.myInitialElement)) instanceof PsiClass) || this.myClasses.isEmpty())) {
            this.clearAllNodesAndEdges();
            this.clearAllData();
            this.myHasAlreadyDroppedParents = true;
            classesList.add((PsiClass)initialElement);
        }
        if (addParents) {
            classesList = classesList.stream().flatMap(JavaUmlDataModel::findAllParentsForClass).collect(Collectors.toList());
        }
        if (this.myUseInnerClasses) {
            classesList.addAll(ContainerUtil.flatMap(classesList, it -> new ArrayList<PsiClass>(UmlPsiUtil.getAllInnerClasses(it))));
        }
        HashSet<Object> classesSet = new HashSet<Object>(classesList);
        for (PsiClass psiClass : classesSet) {
            String className = UmlPsiUtil.getClassQualifiedName(psiClass);
            if (className == null) continue;
            this.myClasses.put(className, (SmartPsiElementPointer<PsiClass>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiClass));
        }
        Stream<DiagramNode<PsiElement>> stream = classesSet.stream().map(this::createJavaNode);
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addPackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(7);
        }
        if (!this.isModelInitializationFinished() || this.myIsReinitializing) {
            PsiPackage[] packages;
            Stream<DiagramNode<PsiElement>> classesStream = this.addClasses(false, psiPackage.getClasses());
            for (PsiPackage aPackage : packages = psiPackage.getSubPackages()) {
                this.myPackages.put(aPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)aPackage));
            }
            Stream<DiagramNode<PsiElement>> stream = Stream.concat(Arrays.stream(packages).map(this::createJavaNode), classesStream);
            if (stream == null) {
                JavaUmlDataModel.$$$reportNull$$$0(8);
            }
            return stream;
        }
        String fqn = psiPackage.getQualifiedName();
        if (fqn.isEmpty() || ContainerUtil.exists(this.myPackages.keySet(), packageFqn -> fqn.startsWith(packageFqn + "."))) {
            Stream<DiagramNode<PsiElement>> stream = Stream.empty();
            if (stream == null) {
                JavaUmlDataModel.$$$reportNull$$$0(9);
            }
            return stream;
        }
        this.myPackages.put(fqn, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.myPackagesRemovedByUser.remove(fqn);
        Stream<DiagramNode<PsiElement>> stream = Stream.of(this.createJavaNode((PsiElement)psiPackage));
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addFile(@NotNull PsiClassOwner psiFile) {
        if (psiFile == null) {
            JavaUmlDataModel.$$$reportNull$$$0(11);
        }
        return this.addClasses(false, psiFile.getClasses());
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Stream<DiagramNode<PsiElement>> addDirectory(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            JavaUmlDataModel.$$$reportNull$$$0(12);
        }
        Project project = this.getProject();
        List<PsiFile> allFilesInDir = JavaUmlElementManager.getAllPsiFilesRecursively(project, psiDirectory);
        PsiPackage aPackage = JavaUmlElementManager.getDirectoryPackage(psiDirectory);
        Stream<DiagramNode<PsiElement>> stream = JavaUmlElementManager.getAllPackagesOrClassOwnersRecursively(project, psiDirectory, aPackage, allFilesInDir).flatMap(it -> {
            if (it instanceof PsiPackage) {
                return this.addPackage((PsiPackage)it);
            }
            if (it instanceof PsiClassOwner) {
                return this.addFile((PsiClassOwner)it);
            }
            assert (false) : "Incorrect element type " + it.getClass().getName();
            return Stream.empty();
        }).toList().stream();
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    private JavaUmlNode createJavaNode(@NotNull PsiElement it) {
        if (it == null) {
            JavaUmlDataModel.$$$reportNull$$$0(14);
        }
        if (this.getUserData(DiagramDataKeys.GRAPH_BUILDER) != null) {
            JavaUmlNode node = new JavaUmlNode(it, this.getBuilder());
            node.getPresentableTitle();
            node.getIcon();
            JavaUmlNode javaUmlNode = node;
            if (javaUmlNode == null) {
                JavaUmlDataModel.$$$reportNull$$$0(15);
            }
            return javaUmlNode;
        }
        return new JavaUmlNode(it, this.getProvider());
    }

    @NotNull
    private static <V> Set<V> copy(@NotNull Set<V> set) {
        if (set == null) {
            JavaUmlDataModel.$$$reportNull$$$0(16);
        }
        return new HashSet<V>(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<DiagramNode<PsiElement>> getNodes() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        // MONITORENTER : object
        Set<DiagramNode<PsiElement>> set = JavaUmlDataModel.copy(this.myNodes);
        // MONITOREXIT : object
        if (set != null) return set;
        JavaUmlDataModel.$$$reportNull$$$0(17);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<DiagramEdge<PsiElement>> getEdges() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myDependencyEdges.isEmpty()) {
            Set<DiagramEdge<PsiElement>> set = JavaUmlDataModel.copy(this.myEdges);
            // MONITOREXIT : object
            if (set != null) return set;
            JavaUmlDataModel.$$$reportNull$$$0(18);
            return set;
        }
        Set<DiagramEdge<PsiElement>> allEdges = JavaUmlDataModel.copy(this.myEdges);
        allEdges.addAll(this.myDependencyEdges);
        Set<DiagramEdge<PsiElement>> set = allEdges;
        // MONITOREXIT : object
        if (set != null) return set;
        JavaUmlDataModel.$$$reportNull$$$0(19);
        return set;
    }

    @GuardedBy(value="myLock")
    private void collapseToPackage(@NotNull DiagramNode<? extends PsiElement> umlNode) {
        PsiElement element;
        PsiPackage psiPackage;
        if (umlNode == null) {
            JavaUmlDataModel.$$$reportNull$$$0(20);
        }
        PsiPackage psiPackage2 = psiPackage = (element = umlNode.getIdentifyingElement()) instanceof PsiPackage ? ((PsiPackage)element).getParentPackage() : UmlJavaUtils.getPackage(element);
        if (psiPackage == null || psiPackage.getQualifiedName().isEmpty()) {
            return;
        }
        String fqnStart = psiPackage.getQualifiedName() + ".";
        ContainerUtil.filter(this.myPackages.keySet(), fqn -> fqn.startsWith(fqnStart)).forEach(fqn -> this.myPackages.remove(fqn));
        ContainerUtil.filter(this.myClasses.keySet(), fqn -> fqn.startsWith(fqnStart)).forEach(fqn -> this.myClasses.remove(fqn));
        this.myPackages.put(psiPackage.getQualifiedName(), (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.myPackagesRemovedByUser.remove(psiPackage.getQualifiedName());
    }

    @Override
    @NotNull
    @NonNls
    public String getNodeName(@NotNull DiagramNode<PsiElement> node) {
        PsiElement element;
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(21);
        }
        if ((element = node.getIdentifyingElement()) instanceof PsiClass) {
            String string = "Class " + UmlPsiUtil.getClassQualifiedName((PsiClass)element);
            if (string == null) {
                JavaUmlDataModel.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (element instanceof PsiPackage) {
            String string = "Package " + ((PsiPackage)element).getQualifiedName();
            if (string == null) {
                JavaUmlDataModel.$$$reportNull$$$0(23);
            }
            return string;
        }
        return "";
    }

    @Override
    @Nullable
    public DiagramEdge<PsiElement> createEdge(@NotNull DiagramNode<PsiElement> from, @NotNull DiagramNode<PsiElement> to) {
        if (from == null) {
            JavaUmlDataModel.$$$reportNull$$$0(24);
        }
        if (to == null) {
            JavaUmlDataModel.$$$reportNull$$$0(25);
        }
        Ref errorHolder = Ref.create();
        PsiClass source = (PsiClass)from.getIdentifyingElement();
        PsiClass target = (PsiClass)to.getIdentifyingElement();
        String srcName = JavaUmlDataModel.getNameForClass(source);
        String dstName = JavaUmlDataModel.getNameForClass(target);
        DiagramRelationshipInfo relationship = JavaUmlDataModel.inferRelationshipInfo(source, target);
        String commandName = JavaUmlDataModel.getEdgeCreationCommandName(relationship, srcName, dstName);
        Callable<JavaUmlEdge> callable = () -> {
            try {
                errorHolder.set((Object)(target.isAnnotationType() ? UmlPsiUtil.annotateClass(source, target) : UmlPsiUtil.createInheritanceBetween(source, target)));
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (errorHolder.get() != null) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new Exception((String)errorHolder.get());
                }
                Messages.showErrorDialog((Project)((PsiElement)from.getIdentifyingElement()).getProject(), (String)((String)errorHolder.get()), (String)DiagramBundle.message("error.cant.create.edge", new Object[0]));
                return null;
            }
            JavaUmlEdge edge = new JavaUmlEdge(from, to, relationship, new PsiElement[0]);
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Object object = this.myLock;
            synchronized (object) {
                this.myEdges.add(edge);
            }
            DiagramBuilder builder = this.getBuilder();
            builder.queryUpdate().withDataReload().withPresentationUpdate().run();
            if (!UmlPsiUtil.isAbstract(source) && !OverrideImplementExploreUtil.getMethodSignaturesToImplement((PsiClass)source).isEmpty()) {
                int code;
                Project project = builder.getProject();
                int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((Project)project, (String)DiagramBundle.message("class.must.be.abstract.or.implement.methods", source.getName()), (String)DiagramBundle.message("class.must.be.abstract.title", new Object[0]), (String)DiagramBundle.message("generate.methods", new Object[0]), (String)DiagramBundle.message("make.abstract", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (code == 0) {
                    VirtualFile file;
                    PsiFile psiFile = source.getContainingFile();
                    VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
                    if (psiFile == null) {
                        return null;
                    }
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), false);
                    OverrideImplementUtil.chooseAndImplementMethods((Project)project, (Editor)editor, (PsiClass)source);
                    if (!ApplicationManager.getApplication().isUnitTestMode() && this.myEditorFile != null) {
                        FileEditorManager.getInstance((Project)project).openFile(this.myEditorFile, true);
                    }
                } else {
                    UmlPsiUtil.makeClassAbstract(source);
                }
            }
            return edge;
        };
        return DiagramAction.performCommand(this.getBuilder(), callable, commandName, null, new PsiElement[]{from.getIdentifyingElement().getContainingFile()});
    }

    @NotNull
    @Nls
    private static String getNameForClass(@NotNull PsiClass source) {
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(26);
        }
        String string = StringUtil.notNullize((String)source.getName(), (String)("<" + DiagramJavaBundle.message("unknown.node.tooltip", new Object[0]) + ">"));
        if (string == null) {
            JavaUmlDataModel.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static DiagramRelationshipInfo inferRelationshipInfo(@NotNull PsiClass src, @NotNull PsiClass dst) {
        if (src == null) {
            JavaUmlDataModel.$$$reportNull$$$0(28);
        }
        if (dst == null) {
            JavaUmlDataModel.$$$reportNull$$$0(29);
        }
        if (dst.isInterface()) {
            if (dst.isAnnotationType()) {
                DiagramRelationshipInfo diagramRelationshipInfo = JavaUmlRelationships.ANNOTATION;
                if (diagramRelationshipInfo == null) {
                    JavaUmlDataModel.$$$reportNull$$$0(30);
                }
                return diagramRelationshipInfo;
            }
            DiagramRelationshipInfo diagramRelationshipInfo = src.isInterface() ? JavaUmlRelationships.INTERFACE_GENERALIZATION : JavaUmlRelationships.REALIZATION;
            if (diagramRelationshipInfo == null) {
                JavaUmlDataModel.$$$reportNull$$$0(31);
            }
            return diagramRelationshipInfo;
        }
        if (src.isEquivalentTo((PsiElement)dst)) {
            DiagramRelationshipInfo diagramRelationshipInfo = JavaUmlRelationships.DEPENDENCY;
            if (diagramRelationshipInfo == null) {
                JavaUmlDataModel.$$$reportNull$$$0(32);
            }
            return diagramRelationshipInfo;
        }
        DiagramRelationshipInfo diagramRelationshipInfo = JavaUmlRelationships.GENERALIZATION;
        if (diagramRelationshipInfo == null) {
            JavaUmlDataModel.$$$reportNull$$$0(33);
        }
        return diagramRelationshipInfo;
    }

    @Nullable
    @Nls
    private static String getEdgeCreationCommandName(@NotNull DiagramRelationshipInfo relationship, @NotNull String srcName, @NotNull String dstName) {
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(34);
        }
        if (srcName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(35);
        }
        if (dstName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(36);
        }
        String messageKey = null;
        if (relationship == JavaUmlRelationships.ANNOTATION) {
            messageKey = "create.edge.command.name.annotation";
        } else if (relationship == JavaUmlRelationships.GENERALIZATION || relationship == JavaUmlRelationships.INTERFACE_GENERALIZATION) {
            messageKey = "create.edge.command.name.extends";
        } else if (relationship == JavaUmlRelationships.REALIZATION) {
            messageKey = "create.edge.command.name.implements";
        }
        return messageKey != null ? DiagramJavaBundle.message(messageKey, srcName, dstName) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(@NotNull DiagramNode<PsiElement> node) {
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            this.removeElement(node.getIdentifyingElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEdge(@NotNull DiagramEdge<PsiElement> edge) {
        if (edge == null) {
            JavaUmlDataModel.$$$reportNull$$$0(38);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            this.myEdges.remove(edge);
            this.myDependencyEdges.remove(edge);
            this.myEdgesRemovedByUser.add(DiagramEdgeIdentity.of(edge));
        }
    }

    @Deprecated
    private void removeEdgeFromCode(@NotNull DiagramEdge<PsiElement> edge) {
        if (edge == null) {
            JavaUmlDataModel.$$$reportNull$$$0(39);
        }
        PsiElement source = edge.getSource().getIdentifyingElement();
        PsiElement target = edge.getTarget().getIdentifyingElement();
        DiagramRelationshipInfo relationship = edge.getRelationship();
        if (source instanceof PsiClass) {
            PsiClass srcCls = (PsiClass)source;
            if (target instanceof PsiClass) {
                PsiClass trgCls = (PsiClass)target;
                if (relationship != DiagramRelationshipInfo.NO_RELATIONSHIP) {
                    int exitCode;
                    int n = exitCode = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)srcCls.getProject(), (String)JavaUmlDataModel.getMessageForEdgeRemoval(JavaUmlDataModel.getNameForClass(srcCls), JavaUmlDataModel.getNameForClass(trgCls), relationship), (String)DiagramBundle.message("remove.relationship.link", new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (exitCode == 0) {
                        String commandName = DiagramJavaBundle.message("create.edge.command.name.remove.link", srcCls.getName(), trgCls.getName());
                        Runnable runnable = () -> {
                            if (UmlJavaUtils.prepareClassForWrite(srcCls)) {
                                try {
                                    PsiModifierList list;
                                    PsiReferenceList extendsList = Objects.requireNonNull(srcCls.getExtendsList(), "Diagram has not been updated");
                                    PsiReferenceList implementsList = Objects.requireNonNull(srcCls.getImplementsList(), "Diagram has not been updated");
                                    if (relationship == JavaUmlRelationships.GENERALIZATION || relationship == JavaUmlRelationships.INTERFACE_GENERALIZATION) {
                                        RefactoringUtil.removeFromReferenceList((PsiReferenceList)extendsList, (PsiClass)trgCls);
                                    } else if (relationship == JavaUmlRelationships.REALIZATION) {
                                        RefactoringUtil.removeFromReferenceList((PsiReferenceList)(srcCls.isInterface() ? extendsList : implementsList), (PsiClass)trgCls);
                                    } else if (relationship == JavaUmlRelationships.ANNOTATION && (list = srcCls.getModifierList()) != null) {
                                        for (PsiAnnotation annotation : list.getAnnotations()) {
                                            if (!annotation.isPhysical() || !annotation.isValid() || !Objects.equals(annotation.getQualifiedName(), trgCls.getQualifiedName())) continue;
                                            annotation.delete();
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        DiagramAction.performCommand(this.getBuilder(), runnable, commandName, null, new PsiElement[]{source.getContainingFile()});
                    }
                }
            }
        }
    }

    @NotNull
    @Nls
    private static String getMessageForEdgeRemoval(@NotNull @Nls String sourceName, @NotNull @Nls String targetName, @NotNull DiagramRelationshipInfo relationship) {
        if (sourceName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(40);
        }
        if (targetName == null) {
            JavaUmlDataModel.$$$reportNull$$$0(41);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(42);
        }
        String string = relationship == JavaUmlRelationships.ANNOTATION ? DiagramBundle.message("remove.annotation.from.class", targetName, sourceName) : DiagramBundle.message("this.will.remove.relationship.link.between.classes", sourceName);
        if (string == null) {
            JavaUmlDataModel.$$$reportNull$$$0(43);
        }
        return string;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@Nullable ProgressIndicator indicator) {
        return this.refreshDataModel(indicator);
    }

    @Override
    public void refreshDataModel() {
        this.refreshDataModel(null);
    }

    @NotNull
    private CompletableFuture<Void> refreshDataModel(@Nullable ProgressIndicator indicator) {
        Callable<CompletableFuture> refreshInLock = () -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Object object = this.myLock;
            synchronized (object) {
                this.clearAllNodesAndEdges();
                this.myUseInnerClasses = ContainerUtil.exists((Object[])this.getNodeContentManager().getEnabledCategories(), it -> it == JavaUmlCategoryManager.INNER_CLASSES);
                this.myContainsKotlinClassesOnly = true;
                return this.updateDataModel(indicator).thenRunAsync(() -> this.getProvider().getExtras().getToolbarActionsProvider().updateAllDiagramEditorToolbars(this.getProject()), Futures.inEdt());
            }
        };
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            CompletableFuture completableFuture;
            try {
                completableFuture = refreshInLock.call();
            }
            catch (Exception e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            if (completableFuture == null) {
                JavaUmlDataModel.$$$reportNull$$$0(44);
            }
            return completableFuture;
        }
        CompletionStage completionStage = Promises.asCompletableFuture((Promise)this.wrapInNonBlockingRA(refreshInLock, indicator).submit((Executor)AppExecutorUtil.getAppExecutorService())).thenComposeAsync(ThreadContext.captureThreadContext(Function.identity()));
        if (completionStage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(45);
        }
        return completionStage;
    }

    @NotNull
    private <T> NonBlockingReadAction<T> wrapInNonBlockingRA(Callable<T> refreshInLock, @Nullable ProgressIndicator indicator) {
        NonBlockingReadAction action = ReadAction.nonBlocking(refreshInLock).expireWith((Disposable)this).inSmartMode(this.getProject()).withDocumentsCommitted(this.getProject());
        if (indicator != null) {
            action = action.wrapProgress(indicator);
        }
        NonBlockingReadAction nonBlockingReadAction = action;
        if (nonBlockingReadAction == null) {
            JavaUmlDataModel.$$$reportNull$$$0(46);
        }
        return nonBlockingReadAction;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        Object object = Registry.is((String)"diagrams.uml.java.use.psi.modification.tracker") ? PsiManager.getInstance((Project)this.getProject()).getModificationTracker() : ModificationTracker.NEVER_CHANGED;
        if (object == null) {
            JavaUmlDataModel.$$$reportNull$$$0(47);
        }
        return object;
    }

    @GuardedBy(value="myLock")
    private void clearAllNodesAndEdges() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.myDependencyEdges.clear();
        this.myNodesItems.clear();
    }

    @GuardedBy(value="myLock")
    private void clearAllData() {
        this.myClasses.clear();
        this.myClassesRemovedByUser.clear();
        this.myPackages.clear();
        this.myPackagesRemovedByUser.clear();
        this.myEdgesRemovedByUser.clear();
    }

    @GuardedBy(value="myLock")
    private boolean isAllowedToShow(@Nullable PsiClass psiClass) {
        PsiElement initialElement = this.getInitialElement();
        DiagramScopeManager<PsiClass> scopeManager = this.getScopeManager();
        return psiClass != null && psiClass.isValid() && !ContainerUtil.exists(this.myClassesRemovedByUser.values(), it -> psiClass.equals(it.getElement())) && (scopeManager == null || scopeManager.contains(psiClass)) && !this.isInsidePackages(psiClass) && !UmlKotlinUtils.DefaultImpls.isDefaultImplsCompanion(psiClass) && (this.myUseInnerClasses || psiClass.getContainingClass() == null || initialElement instanceof PsiClass && JavaUmlDataModel.equals(psiClass, (PsiClass)initialElement));
    }

    private boolean isAllowedToShow(@NotNull PsiPackage aPackage) {
        if (aPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(48);
        }
        DiagramScopeManager<PsiPackage> scopeManager = this.getScopeManager();
        return aPackage.isValid() && (scopeManager == null || scopeManager.contains(aPackage));
    }

    private static boolean equals(@Nullable PsiClass one, @Nullable PsiClass another) {
        return one != null && one.isValid() && another != null && another.isValid() && Objects.equals(UmlPsiUtil.getClassQualifiedName(one), UmlPsiUtil.getClassQualifiedName(another));
    }

    @GuardedBy(value="myLock")
    @NotNull
    private CompletableFuture<Void> updateDataModel(@Nullable ProgressIndicator indicator) {
        DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("java.build.progress.searching.for.classes", new Object[0]));
        Set classes = (Set)ReadAction.compute(() -> this.getAllClassesFromCurrentModel());
        this.updatePackages();
        this.updateClasses(classes);
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        this.updateNodesItems(indicator);
        this.updateNodesItemsPresentation(indicator);
        this.updateEdges(indicator, classes, (ElementToNodeCache)ReadAction.compute(() -> ElementToNodeCache.compute(this.myNodes)));
        if (this.isShowDependencies()) {
            if (indicator == null && UmlShowDependencies.isShowDependenciesActionInProgress(this.getBuilder())) {
                return this.showDependenciesLater(classes);
            }
            this.doShowDependenciesNow(indicator, classes);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            JavaUmlDataModel.$$$reportNull$$$0(49);
        }
        return completableFuture;
    }

    @GuardedBy(value="myLock")
    private void updatePackages() {
        ReadAction.run(() -> {
            PsiElement initElement = JavaUmlDataModel.dereference(this.myInitialElement);
            if (initElement instanceof PsiPackage) {
                PsiPackage initPackage = (PsiPackage)initElement;
                Arrays.stream(initPackage.getSubPackages()).map(it -> Pair.create((Object)it.getQualifiedName(), (Object)it)).filter(it -> !this.myPackages.containsKey(it.first) && !this.myPackagesRemovedByUser.containsKey(it.first)).forEach(it -> this.myPackages.put((String)it.first, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)((PsiPackage)it.second))));
            }
            Set<String> packageFqns = this.myPackages.keySet();
            this.myPackages.values().stream().map(it -> (PsiPackage)it.getElement()).filter(psiPackage -> {
                String fqn = psiPackage != null ? UmlJavaUtils.getFQN((PsiElement)psiPackage) : null;
                return fqn != null && this.isAllowedToShow((PsiPackage)psiPackage) && !ContainerUtil.exists((Iterable)packageFqns, it -> fqn.startsWith(it + "."));
            }).forEach(this::addNode);
        });
    }

    @GuardedBy(value="myLock")
    private void updateClasses(@NotNull Set<PsiClass> classes) {
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(50);
        }
        DiagramContainerUtil.forEachChunkedIndexed(classes, 30, (__, chunk) -> {
            ProgressManager.checkCanceled();
            ReadAction.run(() -> {
                for (PsiClass psiClass : chunk) {
                    if (!this.isAllowedToShow(psiClass)) continue;
                    this.addNode((PsiElement)psiClass);
                    if (!this.myContainsKotlinClassesOnly || UmlKotlinUtils.isFromKotlin((PsiElement)psiClass)) continue;
                    this.myContainsKotlinClassesOnly = false;
                }
            });
        });
    }

    @GuardedBy(value="myLock")
    private void updateNodesItems(@Nullable ProgressIndicator indicator) {
        DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("java.build.progress.searching.for.class.members", new Object[0]));
        JavaUmlElementManager elementManager = (JavaUmlElementManager)this.getProvider().getElementManager();
        DiagramContainerUtil.forEachChunkedIndexed(this.myNodes, 30, (chunkIndex, chunk) -> ReadAction.run(() -> {
            ProgressManager.checkCanceled();
            int totalProcessed = chunkIndex * 30;
            for (DiagramNode node : chunk) {
                PsiElement element;
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setFraction(SEARCHING_FOR_NODE_ITEMS_PART.getFractionWrtWholeProgress((double)totalProcessed / (double)this.myNodes.size()));
                }
                if ((element = (PsiElement)node.getIdentifyingElement()) instanceof PsiClass) {
                    PsiClass psiClass = (PsiClass)element;
                    if (indicator != null) {
                        indicator.setText2(DiagramBundle.message("java.build.progress.analyzing", psiClass.getName()));
                    }
                    this.myNodesItems.put((SmartPsiElementPointer<PsiElement>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiClass), elementManager.getNodeJavaUmlItems((PsiElement)psiClass));
                }
                node.precachePresentation();
                ++totalProcessed;
            }
        }));
    }

    @GuardedBy(value="myLock")
    private void updateNodesItemsPresentation(@Nullable ProgressIndicator indicator) {
        DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("java.build.progress.inferring.nullability", new Object[0]));
        DiagramContainerUtil.forEachChunkedIndexed(this.myNodesItems.values(), 30, (chunkIndex, chunk) -> ReadAction.run(() -> {
            int totalProcessed = chunkIndex * 30;
            for (JavaUmlNodeItems nodeItems : chunk) {
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setFraction(COMPUTING_NODE_ITEMS_PRESENTATION_PART.getFractionWrtWholeProgress((double)totalProcessed / (double)this.myNodes.size()));
                }
                nodeItems.forcePresentationEvaluation();
                ++totalProcessed;
            }
        }));
    }

    private void updateEdges(@Nullable ProgressIndicator indicator, @NotNull Set<PsiClass> classes, @NotNull ElementToNodeCache elementToNodeCache) {
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(51);
        }
        if (elementToNodeCache == null) {
            JavaUmlDataModel.$$$reportNull$$$0(52);
        }
        DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("java.build.progress.inferring.relationships", new Object[0]));
        Set interfaces = (Set)ReadAction.compute(() -> ContainerUtil.map2SetNotNull((Collection)classes, it -> it.isInterface() ? it.getQualifiedName() : null));
        Set annotations = (Set)ReadAction.compute(() -> ContainerUtil.map2SetNotNull((Collection)classes, it -> it.isAnnotationType() ? it.getQualifiedName() : null));
        DiagramContainerUtil.forEachChunkedIndexed(classes, 30, (chunkIndex, chunk) -> ReadAction.run(() -> {
            int totalProcessed = chunkIndex * 30;
            for (PsiClass psiClass : chunk) {
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setFraction(INFERRING_RELATIONSHIP_PART.getFractionWrtWholeProgress((double)totalProcessed / (double)classes.size()));
                    indicator.setText2(DiagramBundle.message("java.build.progress.analyzing", psiClass.getName()));
                }
                if (elementToNodeCache.containsKey((PsiElement)psiClass)) {
                    this.updateClassGeneralizationEdgesFor(psiClass, elementToNodeCache);
                    this.updateInterfaceGeneralizationEdgesFor(psiClass, elementToNodeCache, interfaces);
                    this.updateInterfaceRealizationEdgesFor(psiClass, elementToNodeCache);
                    this.updateInnerClassEdgesFor(psiClass, elementToNodeCache, classes);
                    this.updateAnnotationEdgesFor(psiClass, elementToNodeCache, annotations);
                    this.updateTypeParametersEdgesFor(psiClass, elementToNodeCache);
                }
                ++totalProcessed;
            }
        }));
    }

    @GuardedBy(value="myLock")
    private void updateClassGeneralizationEdgesFor(@NotNull PsiClass psiClass, @NotNull ElementToNodeCache elementToNodeCache) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(53);
        }
        if (elementToNodeCache == null) {
            JavaUmlDataModel.$$$reportNull$$$0(54);
        }
        if (JavaUmlDataModel.isGeneralizationEdgeAllowed(psiClass)) {
            DiagramNode<PsiElement> target = null;
            for (PsiClass superClass = psiClass.getSuperClass(); target == null && superClass != null; superClass = superClass.getSuperClass()) {
                target = elementToNodeCache.get((PsiElement)superClass);
            }
            DiagramNode<PsiElement> source = elementToNodeCache.get((PsiElement)psiClass);
            if (target != null && source != null && source != target) {
                this.addEdge(source, target, JavaUmlRelationships.GENERALIZATION);
            }
        }
    }

    @GuardedBy(value="myLock")
    private void updateInterfaceGeneralizationEdgesFor(@NotNull PsiClass psiClass, @NotNull ElementToNodeCache elementToNodeCache, @NotNull Set<@NlsSafe String> interfaces) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(55);
        }
        if (elementToNodeCache == null) {
            JavaUmlDataModel.$$$reportNull$$$0(56);
        }
        if (interfaces == null) {
            JavaUmlDataModel.$$$reportNull$$$0(57);
        }
        if (psiClass.isInterface()) {
            DiagramNode<PsiElement> source = elementToNodeCache.get((PsiElement)psiClass);
            JavaUmlDataModel.findNearestInterfaces(psiClass, interfaces).distinct().forEach(inter -> {
                DiagramNode<PsiElement> target = elementToNodeCache.get((PsiElement)inter);
                if (target != null && source != null && source != target) {
                    this.addEdge(source, target, JavaUmlRelationships.INTERFACE_GENERALIZATION);
                }
            });
        }
    }

    @GuardedBy(value="myLock")
    private void updateInterfaceRealizationEdgesFor(@NotNull PsiClass psiClass, @NotNull ElementToNodeCache elementToNodeCache) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(58);
        }
        if (elementToNodeCache == null) {
            JavaUmlDataModel.$$$reportNull$$$0(59);
        }
        if (psiClass.isInterface()) {
            return;
        }
        HashSet allInterfaces = new HashSet();
        ContainerUtil.addAll(allInterfaces, (Object[])psiClass.getInterfaces());
        for (PsiClass curr = psiClass.getSuperClass(); curr != null && !elementToNodeCache.containsKey((PsiElement)curr); curr = curr.getSuperClass()) {
            ContainerUtil.addAll(allInterfaces, (Object[])curr.getInterfaces());
        }
        DiagramNode<PsiElement> source = elementToNodeCache.get((PsiElement)psiClass);
        ArrayDeque queue = new ArrayDeque(allInterfaces);
        while (!queue.isEmpty()) {
            PsiClass interface_ = (PsiClass)queue.pollFirst();
            DiagramNode<PsiElement> target = elementToNodeCache.get((PsiElement)interface_);
            if (target != null && source != null && source != target) {
                this.addEdge(source, target, JavaUmlRelationships.REALIZATION);
                continue;
            }
            ContainerUtil.addAll(queue, (Object[])interface_.getInterfaces());
        }
    }

    @GuardedBy(value="myLock")
    private void updateInnerClassEdgesFor(@NotNull PsiClass psiClass, @NotNull ElementToNodeCache elementToNodeCache, @NotNull Set<PsiClass> classes) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(60);
        }
        if (elementToNodeCache == null) {
            JavaUmlDataModel.$$$reportNull$$$0(61);
        }
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(62);
        }
        if (!this.isInsidePackages(psiClass) && this.myUseInnerClasses) {
            DiagramNode<PsiElement> target = elementToNodeCache.get((PsiElement)psiClass);
            for (PsiClass inner : psiClass.getInnerClasses()) {
                DiagramNode<PsiElement> source;
                if (!classes.contains(inner) || (source = elementToNodeCache.get((PsiElement)inner)) == null || target == null || source == target) continue;
                this.addEdge(source, target, JavaUmlRelationships.INNER_CLASS);
            }
        }
    }

    @GuardedBy(value="myLock")
    private void updateAnnotationEdgesFor(@NotNull PsiClass psiClass, @NotNull ElementToNodeCache elementToNodeCache, @NotNull Set<@Nullable @NlsSafe String> annotations) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(63);
        }
        if (elementToNodeCache == null) {
            JavaUmlDataModel.$$$reportNull$$$0(64);
        }
        if (annotations == null) {
            JavaUmlDataModel.$$$reportNull$$$0(65);
        }
        DiagramNode<PsiElement> source = elementToNodeCache.get((PsiElement)psiClass);
        for (PsiClass annotation : UmlPsiUtil.findAnnotationsForClass(psiClass)) {
            DiagramNode<PsiElement> target;
            if (!annotations.contains(annotation.getQualifiedName()) || (target = elementToNodeCache.get((PsiElement)annotation)) == null || source == null || source == target) continue;
            this.addEdge(source, target, JavaUmlRelationships.ANNOTATION);
        }
    }

    @GuardedBy(value="myLock")
    private void updateTypeParametersEdgesFor(@NotNull PsiClass psiClass, @NotNull ElementToNodeCache elementToNodeCache) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(66);
        }
        if (elementToNodeCache == null) {
            JavaUmlDataModel.$$$reportNull$$$0(67);
        }
        DiagramNode<PsiElement> source = elementToNodeCache.get((PsiElement)psiClass);
        for (PsiClass extClass : UmlPsiUtil.getTypeParametersForClass(psiClass)) {
            DiagramNode<PsiElement> target = elementToNodeCache.get((PsiElement)extClass);
            if (target == null || source == null || source == target) continue;
            this.addEdge(source, target, JavaUmlRelationships.DEPENDENCY);
        }
    }

    @NotNull
    private static Stream<? extends PsiClass> findNearestInterfaces(@NotNull PsiClass psiClass, @NotNull Set<String> interfaces) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(68);
        }
        if (interfaces == null) {
            JavaUmlDataModel.$$$reportNull$$$0(69);
        }
        Stream stream = Arrays.stream(psiClass.getInterfaces()).flatMap(it -> interfaces.contains(it.getQualifiedName()) ? Stream.of(it) : JavaUmlDataModel.findNearestInterfaces(it, interfaces));
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(70);
        }
        return stream;
    }

    private static boolean isGeneralizationEdgeAllowed(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(71);
        }
        return !psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    @GuardedBy(value="myLock")
    private boolean isInsidePackages(@NotNull PsiClass psiClass) {
        String clsFqn;
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(72);
        }
        return (clsFqn = UmlJavaUtils.getFQN((PsiElement)psiClass)) != null && this.myPackages.keySet().stream().anyMatch(packageFqn -> clsFqn.startsWith(packageFqn + "."));
    }

    @GuardedBy(value="myLock")
    private void addNode(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(73);
        }
        this.myNodes.add(this.createJavaNode(psiElement));
    }

    @GuardedBy(value="myLock")
    private void addEdge(@NotNull DiagramNode<PsiElement> source, @NotNull DiagramNode<PsiElement> target, @NotNull DiagramRelationshipInfo relationship) {
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(74);
        }
        if (target == null) {
            JavaUmlDataModel.$$$reportNull$$$0(75);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(76);
        }
        this.addEdge(source, target, relationship, source.getIdentifyingElement(), this.myEdges);
    }

    @GuardedBy(value="myLock")
    private void addDependencyEdge(@NotNull DiagramNode<PsiElement> source, @NotNull DiagramNode<PsiElement> target, @NotNull DiagramRelationshipInfo relationship, @Nullable PsiElement navigationElement) {
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(77);
        }
        if (target == null) {
            JavaUmlDataModel.$$$reportNull$$$0(78);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(79);
        }
        this.addEdge(source, target, relationship, navigationElement, this.myDependencyEdges);
    }

    @GuardedBy(value="myLock")
    private void addEdge(@NotNull DiagramNode<PsiElement> source, @NotNull DiagramNode<PsiElement> target, @NotNull DiagramRelationshipInfo relationship, @Nullable PsiElement navigationElement, @NotNull Collection<DiagramEdge<PsiElement>> storage) {
        PsiElement[] psiElementArray;
        if (source == null) {
            JavaUmlDataModel.$$$reportNull$$$0(80);
        }
        if (target == null) {
            JavaUmlDataModel.$$$reportNull$$$0(81);
        }
        if (relationship == null) {
            JavaUmlDataModel.$$$reportNull$$$0(82);
        }
        if (storage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(83);
        }
        if (navigationElement != null) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = navigationElement;
        } else {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        }
        JavaUmlEdge newEdge = new JavaUmlEdge(source, target, relationship, psiElementArray);
        if (this.myEdgesRemovedByUser.contains(DiagramEdgeIdentity.of(newEdge))) {
            return;
        }
        JavaUmlRelationshipManager relationshipManager = (JavaUmlRelationshipManager)this.getProvider().getRelationshipManager();
        JavaUmlEdge subEdge = Stream.concat(this.myEdges.stream(), this.myDependencyEdges.stream()).filter(it -> relationshipManager.isSubtype((DiagramEdge<PsiElement>)it, newEdge)).findFirst().orElse(null);
        if (subEdge != null) {
            relationshipManager.mergeIntoSubEdge(subEdge, newEdge);
        } else {
            List existingSuppressedEdges = ContainerUtil.filter(this.myDependencyEdges, it -> relationshipManager.isSubtype(newEdge, (DiagramEdge<PsiElement>)it));
            for (DiagramEdge suppressedEdge : existingSuppressedEdges) {
                this.myDependencyEdges.remove(suppressedEdge);
                relationshipManager.mergeIntoSubEdge(newEdge, (JavaUmlEdge)suppressedEdge);
            }
            storage.add(newEdge);
        }
    }

    @GuardedBy(value="myLock")
    @NotNull
    private Set<PsiClass> getAllClassesFromCurrentModel() {
        PsiElement initElement = JavaUmlDataModel.dereference(this.myInitialElement);
        PsiPackage initPackage = initElement instanceof PsiPackage ? (PsiPackage)initElement : null;
        Stream<PsiClass> classesAddedByUser = this.myClasses.values().stream().map(it -> (PsiClass)it.getElement());
        Stream initPackageClasses = initPackage != null ? Arrays.stream(initPackage.getClasses()) : Stream.empty();
        Stream myPackagesClasses = this.myPackages.values().stream().map(it -> (PsiPackage)it.getElement()).filter(it -> it != null).flatMap(it -> Arrays.stream(it.getClasses()));
        List<PsiClass> topLevel = Stream.of(classesAddedByUser, initPackageClasses, myPackagesClasses).flatMap(it -> it).filter(it -> it != null).toList();
        Stream inner = this.myUseInnerClasses ? topLevel.stream().flatMap(it -> UmlPsiUtil.getAllInnerClasses(it).stream()) : Stream.empty();
        Set<PsiClass> set = Stream.concat(topLevel.stream(), inner).filter(it -> it != null && it.isValid() && !this.myClassesRemovedByUser.containsKey(UmlPsiUtil.getClassQualifiedName(it))).collect(Collectors.toSet());
        if (set == null) {
            JavaUmlDataModel.$$$reportNull$$$0(84);
        }
        return set;
    }

    @NotNull
    private static Stream<PsiClass> findAllParentsForClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(85);
        }
        Stream supers = Arrays.stream(psiClass.getSupers()).flatMap(base -> {
            if (base.getSuperClass() != null) {
                return JavaUmlDataModel.findAllParentsForClass(base);
            }
            if (!psiClass.isInterface() && !JavaUmlDataModel.isJavaLangObject(base)) {
                return Stream.of(base);
            }
            return Stream.empty();
        });
        Stream annotations = UmlPsiUtil.getAnnotationClassesForClass(psiClass).stream();
        Stream typeParameters = UmlPsiUtil.getTypeParametersForClass(psiClass).stream();
        Stream<PsiClass> stream = Stream.of(Stream.of(psiClass), supers, annotations, typeParameters).flatMap(it -> it).distinct();
        if (stream == null) {
            JavaUmlDataModel.$$$reportNull$$$0(86);
        }
        return stream;
    }

    private static boolean isJavaLangObject(@Nullable PsiClass cls) {
        return cls != null && "java.lang.Object".equals(cls.getQualifiedName());
    }

    public boolean containsKotlinClassesOnly() {
        return this.myContainsKotlinClassesOnly;
    }

    @NotNull
    public JavaUmlNodeItems getItemsOf(@NotNull PsiElement psiElement) {
        JavaUmlNodeItems result;
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(87);
        }
        JavaUmlNodeItems javaUmlNodeItems = (result = this.myNodesItems.get(this.getElementPointer(psiElement))) != null ? result : JavaUmlNodeItems.empty();
        if (javaUmlNodeItems == null) {
            JavaUmlDataModel.$$$reportNull$$$0(88);
        }
        return javaUmlNodeItems;
    }

    public boolean isPartOfProperty(@NotNull PsiElement psiElement, @NotNull PsiField field) {
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(89);
        }
        if (field == null) {
            JavaUmlDataModel.$$$reportNull$$$0(90);
        }
        JavaUmlNodeItems items = this.getItemsOf(psiElement);
        return items.getProperties().stream().anyMatch(it -> field.equals(it.getField()));
    }

    public boolean isPartOfProperty(@NotNull PsiElement psiElement, @NotNull PsiMethod method) {
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(91);
        }
        if (method == null) {
            JavaUmlDataModel.$$$reportNull$$$0(92);
        }
        JavaUmlNodeItems items = this.getItemsOf(psiElement);
        return items.getProperties().stream().anyMatch(it -> method.equals(it.getGetter()) || method.equals(it.getSetter()));
    }

    @Nullable
    public SimpleColoredText getItemName(@NotNull PsiElement psiElement, @Nullable Object nodeItem) {
        JavaUmlNodeItems result;
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(93);
        }
        return (result = this.myNodesItems.get(this.getElementPointer(psiElement))) != null ? result.getItemName(nodeItem) : null;
    }

    @Nullable
    public SimpleColoredText getItemType(@NotNull PsiElement psiElement, @Nullable Object nodeItem) {
        JavaUmlNodeItems result;
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(94);
        }
        return (result = this.myNodesItems.get(this.getElementPointer(psiElement))) != null ? (SimpleColoredText)ReadAction.compute(() -> result.getItemType(nodeItem)) : null;
    }

    @Nullable
    public Icon getItemIcon(@NotNull PsiElement psiElement, @Nullable Object nodeItem) {
        JavaUmlNodeItems result;
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(95);
        }
        return (result = this.myNodesItems.get(this.getElementPointer(psiElement))) != null ? result.getItemIcon(nodeItem) : null;
    }

    @GuardedBy(value="myLock")
    @Nullable
    private DiagramNode<PsiElement> findNode(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(96);
        }
        return this.myNodes.stream().filter(it -> {
            String fqn = UmlJavaUtils.getFQN((PsiElement)it.getIdentifyingElement());
            return fqn != null && fqn.equals(UmlJavaUtils.getFQN(psiElement));
        }).findAny().orElseGet(() -> {
            String packageName = UmlJavaUtils.getPackageName(psiElement);
            PsiPackage aPackage = (PsiPackage)JavaUmlDataModel.dereference(packageName != null ? this.myPackages.get(packageName) : null);
            return aPackage == null || aPackage == psiElement ? null : this.findNode((PsiElement)aPackage);
        });
    }

    public void dispose() {
    }

    @GuardedBy(value="myLock")
    private void removeElement(@NotNull PsiElement element) {
        DiagramNode<PsiElement> node;
        if (element == null) {
            JavaUmlDataModel.$$$reportNull$$$0(97);
        }
        if ((node = this.findNode(element)) == null) {
            this.myClasses.remove(UmlJavaUtils.getFQN(element));
        } else {
            this.myNodes.remove(node);
            ContainerUtil.filter(this.myEdges, e -> e.getTarget().equals(node) || e.getSource().equals(node)).forEach(this.myEdges::remove);
            ContainerUtil.filter(this.myDependencyEdges, e -> e.getTarget().equals(node) || e.getSource().equals(node)).forEach(this.myDependencyEdges::remove);
            if (element instanceof PsiClass) {
                this.removeClass((PsiClass)element);
            }
            if (element instanceof PsiPackage) {
                this.removePackage((PsiPackage)element);
            }
        }
    }

    @GuardedBy(value="myLock")
    private void removePackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(98);
        }
        String packageName = psiPackage.getQualifiedName();
        this.myPackages.remove(packageName);
        this.myPackagesRemovedByUser.put(packageName, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.myClasses.entrySet().stream().filter(it -> {
            PsiClass psiClass = (PsiClass)JavaUmlDataModel.dereference((SmartPsiElementPointer)it.getValue());
            return psiClass != null && Objects.equals(packageName, UmlJavaUtils.getRealPackageName((PsiElement)psiClass));
        }).collect(Collectors.toSet()).forEach(e -> this.myClasses.remove(e.getKey()));
    }

    @GuardedBy(value="myLock")
    private void removeClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaUmlDataModel.$$$reportNull$$$0(99);
        }
        String fqn = UmlPsiUtil.getClassQualifiedName(psiClass);
        this.myClassesRemovedByUser.put(fqn, (SmartPsiElementPointer<PsiClass>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiClass));
        this.myClasses.remove(fqn);
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            String innerFqn = UmlPsiUtil.getClassQualifiedName(innerClass);
            this.myClassesRemovedByUser.put(innerFqn, (SmartPsiElementPointer<PsiClass>)this.mySpManager.createSmartPsiElementPointer((PsiElement)innerClass));
            this.myClasses.remove(innerFqn);
        }
    }

    @GuardedBy(value="myLock")
    private void expandPackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(100);
        }
        String packageName = psiPackage.getQualifiedName();
        this.myPackages.remove(packageName);
        this.myPackagesRemovedByUser.put(packageName, (SmartPsiElementPointer<PsiPackage>)this.mySpManager.createSmartPsiElementPointer((PsiElement)psiPackage));
        this.addClasses(false, psiPackage.getClasses());
        for (PsiPackage aPackage : psiPackage.getSubPackages()) {
            this.addPackage(aPackage);
        }
    }

    @NotNull
    private CompletableFuture<Void> showDependenciesLater(@NotNull Set<PsiClass> classes) {
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(101);
        }
        CompletionStage completionStage = ((CompletableFuture)Futures.runProgressInBackground((Project)this.getProject(), (String)DiagramBundle.message("uml.java.calculating.dependencies", new Object[0]), (boolean)true, (PerformInBackgroundOption)PerformInBackgroundOption.DEAF, () -> this.setShowDependencies(false), indicator -> this.wrapInNonBlockingRA(() -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Object object = this.myLock;
            synchronized (object) {
                this.doShowDependenciesNow((ProgressIndicator)indicator, (Set<? extends PsiClass>)classes);
            }
            return null;
        }, (ProgressIndicator)indicator).executeSynchronously()).thenRunAsync(() -> this.getBuilder().queryUpdate().withDataReload().withPresentationUpdate().run(), Futures.inEdt())).whenComplete(Futures.logIfFailed(JavaUmlDataModel.class));
        if (completionStage == null) {
            JavaUmlDataModel.$$$reportNull$$$0(102);
        }
        return completionStage;
    }

    @GuardedBy(value="myLock")
    private void doShowDependenciesNow(@Nullable ProgressIndicator indicator, @NotNull Set<? extends PsiClass> classes) {
        if (classes == null) {
            JavaUmlDataModel.$$$reportNull$$$0(103);
        }
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        ElementToNodeCache elementToNodeCache = (ElementToNodeCache)ReadAction.compute(() -> ElementToNodeCache.compute(this.myNodes));
        ArrayList computedDependencies = new ArrayList();
        int classInd = 1;
        for (PsiClass psiClass : classes) {
            ReadAction.run(() -> {
                DiagramProgressUtil.checkAndSetText(indicator, DiagramBundle.message("uml.java.analyzing.0", psiClass.getName()));
                DiagramNode<PsiElement> sourceNode = elementToNodeCache.get((PsiElement)psiClass);
                if (sourceNode != null) {
                    Pair classDependencies = new Pair(sourceNode, new UastClassDependencyAnalyzer().compute(psiClass));
                    computedDependencies.add(classDependencies);
                }
            });
            DiagramProgressUtil.checkAndSetFraction(indicator, (double)(++classInd) / (double)classes.size());
        }
        ReadAction.run(() -> {
            for (Pair dependencyInfo : computedDependencies) {
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                DiagramNode sourceNode = (DiagramNode)dependencyInfo.first;
                for (RelationshipAnalysisSimpleResult dependency : (Collection)dependencyInfo.second) {
                    DiagramNode<PsiElement> targetNode = elementToNodeCache.get((PsiElement)dependency.getTarget());
                    if (targetNode == null) continue;
                    this.addDependencyEdge(sourceNode, targetNode, dependency.getRelationshipInfo(), dependency.getNavigationElement());
                }
            }
        });
    }

    @Nullable
    public PsiElement getInitialElement() {
        PsiElement result = JavaUmlDataModel.dereference(this.myInitialElement);
        return result == null || !result.isValid() ? null : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasElement(@Nullable PsiElement element) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            return element != null && this.findNode(element) != null;
        }
    }

    @Override
    public boolean isDependencyDiagramSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collapseNode(@NotNull DiagramNode<PsiElement> node) {
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(104);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            this.collapseToPackage(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expandNode(@NotNull DiagramNode<PsiElement> node) {
        PsiElement element;
        if (node == null) {
            JavaUmlDataModel.$$$reportNull$$$0(105);
        }
        if ((element = node.getIdentifyingElement()) instanceof PsiPackage) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Object object = this.myLock;
            synchronized (object) {
                this.expandPackage((PsiPackage)element);
            }
        }
    }

    @Override
    public boolean isPsiListener() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuild(@Nullable PsiElement element) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Object object = this.myLock;
        synchronized (object) {
            super.rebuild(element);
            this.clearAllData();
            this.clearAllNodesAndEdges();
            this.init(element);
            this.refreshDataModel();
        }
    }

    @NotNull
    private SmartPsiElementPointer<PsiElement> getElementPointer(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            JavaUmlDataModel.$$$reportNull$$$0(106);
        }
        SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)ReadAction.compute(() -> this.mySpManager.createSmartPsiElementPointer(psiElement));
        if (smartPsiElementPointer == null) {
            JavaUmlDataModel.$$$reportNull$$$0(107);
        }
        return smartPsiElementPointer;
    }

    @Nullable
    private static <T extends PsiElement> T dereference(@Nullable SmartPsiElementPointer<T> pointer) {
        return (T)(pointer == null ? null : pointer.getElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 8, 9, 10, 13, 15, 17, 18, 19, 22, 23, 27, 30, 31, 32, 33, 43, 44, 45, 46, 47, 49, 70, 84, 86, 88, 102, 107 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPresentationModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 70: 
            case 84: 
            case 86: 
            case 88: 
            case 102: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/JavaUmlDataModel";
                break;
            }
            case 5: 
            case 50: 
            case 51: 
            case 62: 
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 7: 
            case 98: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "umlNode";
                break;
            }
            case 21: 
            case 37: 
            case 104: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 26: 
            case 74: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dst";
                break;
            }
            case 34: 
            case 42: 
            case 76: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationship";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstName";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 61: 
            case 64: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToNodeCache";
                break;
            }
            case 53: 
            case 55: 
            case 58: 
            case 60: 
            case 63: 
            case 66: 
            case 68: 
            case 71: 
            case 72: 
            case 85: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 57: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 73: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 75: 
            case 78: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/JavaUmlDataModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addMultiNodeElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addPackage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaNode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForClass";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "inferRelationshipInfo";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageForEdgeRemoval";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModel";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInNonBlockingRA";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDataModel";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "findNearestInterfaces";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassesFromCurrentModel";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllParentsForClass";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsOf";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "showDependenciesLater";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 70: 
            case 84: 
            case 86: 
            case 88: 
            case 102: 
            case 107: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addClasses";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPackage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createJavaNode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collapseToPackage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNameForClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "inferRelationshipInfo";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeCreationCommandName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removeEdgeFromCode";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getMessageForEdgeRemoval";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedToShow";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "updateClasses";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "updateEdges";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "updateClassGeneralizationEdgesFor";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "updateInterfaceGeneralizationEdgesFor";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "updateInterfaceRealizationEdgesFor";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "updateInnerClassEdgesFor";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "updateAnnotationEdgesFor";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "updateTypeParametersEdgesFor";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findNearestInterfaces";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralizationEdgeAllowed";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePackages";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addDependencyEdge";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentsForClass";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getItemsOf";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfProperty";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getItemType";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "removeElement";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "removePackage";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "removeClass";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "expandPackage";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "showDependenciesLater";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "doShowDependenciesNow";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "collapseNode";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "expandNode";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getElementPointer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 8, 9, 10, 13, 15, 17, 18, 19, 22, 23, 27, 30, 31, 32, 33, 43, 44, 45, 46, 47, 49, 70, 84, 86, 88, 102, 107 -> new IllegalStateException(string);
        };
    }

    private static final class ElementToNodeCache {
        @NotNull
        private final Map<String, DiagramNode<PsiElement>> myData;

        private ElementToNodeCache(@NotNull Map<String, DiagramNode<PsiElement>> data) {
            if (data == null) {
                ElementToNodeCache.$$$reportNull$$$0(0);
            }
            this.myData = data;
        }

        @NotNull
        private static ElementToNodeCache compute(@NotNull Collection<DiagramNode<PsiElement>> nodes) {
            if (nodes == null) {
                ElementToNodeCache.$$$reportNull$$$0(1);
            }
            HashMap<String, DiagramNode<PsiElement>> data = new HashMap<String, DiagramNode<PsiElement>>();
            for (DiagramNode<PsiElement> node : nodes) {
                data.put(UmlJavaUtils.getFQN(node.getIdentifyingElement()), node);
            }
            return new ElementToNodeCache(data);
        }

        @Nullable
        public DiagramNode<PsiElement> get(@Nullable PsiElement element) {
            return element != null ? this.myData.get(UmlJavaUtils.getFQN(element)) : null;
        }

        public boolean containsKey(@Nullable PsiElement element) {
            return element != null && this.myData.containsKey(UmlJavaUtils.getFQN(element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/uml/java/JavaUmlDataModel$ElementToNodeCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ProgressPart {
        private final double startingFrom;
        private final double share;

        private ProgressPart(double startingFrom, double share) {
            this.startingFrom = startingFrom;
            this.share = share;
        }

        private double getFractionWrtWholeProgress(double partAbsoluteFraction) {
            return this.startingFrom + this.share * partAbsoluteFraction;
        }
    }
}

