/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.uml.java.JavaUmlCategoryManager;
import com.intellij.uml.java.actions.CreateNewEnumConstantDialog;
import com.intellij.uml.java.actions.NewJavaClassElement;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NewEnumConstant
extends NewJavaClassElement {
    public NewEnumConstant() {
        super(CodeInsightBundle.messagePointer((String)"new.enum.constant.text", (Object[])new Object[0]), CodeInsightBundle.messagePointer((String)"new.enum.constant.description", (Object[])new Object[0]), PlatformIcons.ENUM_ICON);
    }

    @Override
    public DiagramCategory getCategory() {
        return JavaUmlCategoryManager.FIELDS;
    }

    @Override
    public Runnable createWriteAction(PsiClass psiClass, DiagramBuilder builder) {
        CreateNewEnumConstantDialog dialog = new CreateNewEnumConstantDialog(psiClass);
        JComponent view = builder.getView().getCanvasComponent();
        Point vP = view.getLocationOnScreen();
        Dimension dSize = dialog.getPreferredSize();
        Dimension vSize = view.getSize();
        Point p = new Point(vP.x + (vSize.height - dSize.height) / 2, vP.y + (vSize.width - dSize.width) / 2);
        dialog.setLocation(p);
        if (dialog.showAndGet()) {
            return () -> {
                Project project = builder.getProject();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                try {
                    String[] names;
                    for (String name : names = dialog.getNames()) {
                        if ((name = name.trim()).length() == 0) continue;
                        try {
                            PsiEnumConstant newEnumConst = factory.createEnumConstantFromText(name, (PsiElement)psiClass);
                            List existConsts = ContainerUtil.filterIsInstance((Object[])psiClass.getAllFields(), PsiEnumConstant.class);
                            psiClass.addAfter((PsiElement)newEnumConst, existConsts.isEmpty() ? psiClass.getLBrace() : (PsiElement)existConsts.get(existConsts.size() - 1));
                            new OptimizeImportsProcessor((AbstractLayoutCodeProcessor)new ReformatCodeProcessor(project, psiClass.getContainingFile(), null, false)).run();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            };
        }
        return null;
    }

    @Override
    public boolean isEnabledOn(PsiElement element) {
        return super.isEnabledOn(element) && ((PsiClass)element).isEnum();
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramJavaBundle.message("action.name.new.enum.constant", new Object[0]);
        if (string == null) {
            NewEnumConstant.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/java/actions/NewEnumConstant", "getActionName"));
    }
}

