/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.firefox.FirefoxBreakpoint;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxScript;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Location;
import com.jetbrains.firefox.rdp.SetBreakpointResult;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.rpc.RequestPromise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\bJ:\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J.\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!H\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00172\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/firefox/FirefoxBreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lcom/jetbrains/firefox/FirefoxBreakpoint;", "vm", "Lcom/jetbrains/firefox/FirefoxVm;", "<init>", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "findRelatedBreakpoints", "", "Lorg/jetbrains/debugger/Breakpoint;", "breakpointActors", "", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "ignoreCount", "enabled", "", "doSetBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "url", "Lcom/intellij/util/Url;", "breakpoint", "sendSetBreakpoint", "", "script", "Lcom/jetbrains/firefox/FirefoxScript;", "scriptUrl", "bpPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "doClearBreakpoint", "Ljava/lang/Void;", "getMuteMode", "Lorg/jetbrains/debugger/BreakpointManager$MUTE_MODE;", "intellij.javascript.firefox.connector"})
public final class FirefoxBreakpointManager
extends BreakpointManagerBase<FirefoxBreakpoint> {
    @NotNull
    private final FirefoxVm vm;

    public FirefoxBreakpointManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }

    @NotNull
    public final List<Breakpoint> findRelatedBreakpoints(@Nullable List<String> breakpointActors) {
        if (ContainerUtil.isEmpty((Collection)breakpointActors)) {
            return CollectionsKt.emptyList();
        }
        SmartList result = new SmartList();
        for (FirefoxBreakpoint breakpoint : this.getBreakpoints()) {
            String actor = breakpoint.getActor();
            if (actor == null) continue;
            List<String> list = breakpointActors;
            Intrinsics.checkNotNull(list);
            if (!list.contains(actor)) continue;
            result.add((Object)breakpoint);
        }
        return (List)result;
    }

    @NotNull
    protected FirefoxBreakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new FirefoxBreakpoint(target, line, column, condition, enabled);
    }

    @NotNull
    protected Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull FirefoxBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
        String string = ((BreakpointTarget.ScriptName)target).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String scriptUrl = string;
        FirefoxScript firefoxScript = (FirefoxScript)this.vm.getScriptManager().findScriptByUrl(scriptUrl);
        if (firefoxScript == null) {
            return Promises.rejectedPromise((String)("Script wasn't found: " + scriptUrl));
        }
        FirefoxScript script = firefoxScript;
        AsyncPromise result = new AsyncPromise();
        this.sendSetBreakpoint(breakpoint, script, scriptUrl, (AsyncPromise<Breakpoint>)result);
        return (Promise)result;
    }

    private final void sendSetBreakpoint(FirefoxBreakpoint breakpoint, FirefoxScript script, String scriptUrl, AsyncPromise<Breakpoint> bpPromise) {
        String string = this.vm.getThreadActor();
        Intrinsics.checkNotNull((Object)string);
        FirefoxRequest<SetBreakpointResult> message = FirefoxRequest.Companion.setBreakpoint(string, scriptUrl, breakpoint.getLine(), breakpoint.getColumn());
        RequestPromise callback = new RequestPromise(message.getMethodName());
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string2 = this.vm.getThreadActor();
        Intrinsics.checkNotNull((Object)string2);
        firefoxCommandProcessor.doSendFromPaused(message, string2, callback);
        callback.then(arg_0 -> FirefoxBreakpointManager.sendSetBreakpoint$lambda$1(arg_0 -> FirefoxBreakpointManager.sendSetBreakpoint$lambda$0(scriptUrl, breakpoint, this, arg_0), arg_0)).onSuccess(arg_0 -> FirefoxBreakpointManager.sendSetBreakpoint$lambda$3(arg_0 -> FirefoxBreakpointManager.sendSetBreakpoint$lambda$2(bpPromise, arg_0), arg_0)).onError(arg_0 -> FirefoxBreakpointManager.sendSetBreakpoint$lambda$5(arg_0 -> FirefoxBreakpointManager.sendSetBreakpoint$lambda$4(bpPromise, arg_0), arg_0));
    }

    @NotNull
    protected Promise<Void> doClearBreakpoint(@NotNull FirefoxBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string = breakpoint.getActor();
        Intrinsics.checkNotNull((Object)string);
        return firefoxCommandProcessor.send(FirefoxRequest.Companion.deleteBreakpoint(string));
    }

    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        return BreakpointManager.MUTE_MODE.NONE;
    }

    private static final FirefoxBreakpoint sendSetBreakpoint$lambda$0(String $scriptUrl, FirefoxBreakpoint $breakpoint, FirefoxBreakpointManager this$0, SetBreakpointResult result) {
        org.jetbrains.debugger.Location location = null;
        Location rawLocation = result.actualLocation();
        if (rawLocation == null) {
            Url url = Urls.parseEncoded((String)$scriptUrl);
            Intrinsics.checkNotNull((Object)url);
            location = new org.jetbrains.debugger.Location(url, $breakpoint.getLine(), $breakpoint.getColumn());
        } else {
            String string = rawLocation.source().url();
            Intrinsics.checkNotNull((Object)string);
            Url url = Urls.parseEncoded((String)string);
            Intrinsics.checkNotNull((Object)url);
            location = new org.jetbrains.debugger.Location(url, rawLocation.line() - 1, rawLocation.column());
        }
        $breakpoint.setRemoteData(result.actor(), location);
        this$0.notifyBreakpointResolvedListener($breakpoint);
        return $breakpoint;
    }

    private static final FirefoxBreakpoint sendSetBreakpoint$lambda$1(Function1 $tmp0, Object p0) {
        return (FirefoxBreakpoint)((Object)$tmp0.invoke(p0));
    }

    private static final Unit sendSetBreakpoint$lambda$2(AsyncPromise $bpPromise, FirefoxBreakpoint it) {
        $bpPromise.setResult((Object)it);
        return Unit.INSTANCE;
    }

    private static final void sendSetBreakpoint$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit sendSetBreakpoint$lambda$4(AsyncPromise $bpPromise, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        $bpPromise.setError(it);
        return Unit.INSTANCE;
    }

    private static final void sendSetBreakpoint$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

