/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.google.gson.stream.JsonToken;
import com.jetbrains.firefox.FirefoxArray;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxFunction;
import com.jetbrains.firefox.FirefoxObject;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Grip;
import com.jetbrains.firefox.rdp.PropertyDescriptor;
import com.jetbrains.firefox.rdp.SafeGetterValue;
import com.jetbrains.firefox.rdp.ValueHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.ObjectPropertyImpl;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0012J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00132\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010!\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010\u00152\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020'J&\u0010%\u001a\u0004\u0018\u00010\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u00152\b\u0010(\u001a\u0004\u0018\u00010\n2\b\u0010)\u001a\u0004\u0018\u00010*J\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0,J&\u0010.\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u00152\b\u0010(\u001a\u0004\u0018\u00010\n2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u000e\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0,J\b\u00100\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetbrains/firefox/FirefoxValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;", "vm", "Lcom/jetbrains/firefox/FirefoxVm;", "<init>", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "getVm", "()Lcom/jetbrains/firefox/FirefoxVm;", "refToValue", "Ljava/util/HashMap;", "", "Lorg/jetbrains/debugger/values/Value;", "actorsNotYetPromotedToThreadLifetime", "Ljava/util/ArrayList;", "createProperties", "", "Lorg/jetbrains/debugger/Variable;", "propertyDescriptors", "", "Lcom/jetbrains/firefox/rdp/PropertyDescriptor;", "prototypeGrip", "Lcom/jetbrains/firefox/rdp/Grip;", "safeGetterValues", "Lcom/jetbrains/firefox/rdp/SafeGetterValue;", "createProtoVariable", "Lorg/jetbrains/debugger/VariableImpl;", "createProperty", "name", "descriptor", "getterValueDescriptor", "createValueAccessor", "Lorg/jetbrains/debugger/values/FunctionValue;", "grip", "createVariable", "valueData", "valueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "createValue", "valueHolder", "Lcom/jetbrains/firefox/rdp/ValueHolder;", "primitiveValue", "primitiveValueType", "Lcom/google/gson/stream/JsonToken;", "promoteRecentlyAddedActorsToThreadLifetime", "Lorg/jetbrains/concurrency/Promise;", "", "doCreateValue", "release", "clearCaches", "", "intellij.javascript.firefox.connector"})
public final class FirefoxValueManager
extends ValueManager {
    @NotNull
    private final FirefoxVm vm;
    @NotNull
    private final HashMap<String, Value> refToValue;
    @NotNull
    private final ArrayList<String> actorsNotYetPromotedToThreadLifetime;

    public FirefoxValueManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.refToValue = new HashMap();
        this.actorsNotYetPromotedToThreadLifetime = new ArrayList();
    }

    @NotNull
    public final FirefoxVm getVm() {
        return this.vm;
    }

    @NotNull
    public final List<Variable> createProperties(@Nullable Map<String, ? extends PropertyDescriptor> propertyDescriptors, @Nullable Grip prototypeGrip, @Nullable Map<String, ? extends SafeGetterValue> safeGetterValues) {
        Grip grip = prototypeGrip;
        VariableImpl prototype = grip == null ? null : this.createProtoVariable(grip);
        Map<String, ? extends PropertyDescriptor> map = propertyDescriptors;
        if (map == null || map.isEmpty()) {
            VariableImpl variableImpl = prototype;
            return variableImpl == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)variableImpl);
        }
        Variable[] variables = new Variable[propertyDescriptors.size() + (prototype == null ? 0 : 1)];
        int i = 0;
        for (Map.Entry<String, ? extends PropertyDescriptor> entry : propertyDescriptors.entrySet()) {
            String name = entry.getKey();
            PropertyDescriptor value = entry.getValue();
            int n = i++;
            Map<String, ? extends SafeGetterValue> map2 = safeGetterValues;
            variables[n] = this.createProperty(name, value, map2 != null ? map2.get(name) : null);
        }
        if (prototype != null) {
            variables[variables.length - 1] = prototype;
        }
        List<Variable> list = Arrays.asList(Arrays.copyOf(variables, variables.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(...)");
        return list;
    }

    @NotNull
    public final VariableImpl createProtoVariable(@Nullable Grip prototypeGrip) {
        return this.createVariable("__proto__", prototypeGrip, null);
    }

    @NotNull
    public final Variable createProperty(@NotNull String name, @NotNull PropertyDescriptor descriptor, @Nullable SafeGetterValue getterValueDescriptor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int flags = 0;
        if (descriptor.writable()) {
            flags |= 1;
        }
        if (descriptor.configurable()) {
            flags |= 2;
        }
        if (descriptor.enumerable()) {
            flags |= 4;
        }
        SafeGetterValue safeGetterValue = getterValueDescriptor;
        return (Variable)new ObjectPropertyImpl(name, this.createValue(safeGetterValue != null ? (ValueHolder)safeGetterValue : (ValueHolder)descriptor), getterValueDescriptor == null ? this.createValueAccessor(descriptor.get()) : null, getterValueDescriptor == null ? this.createValueAccessor(descriptor.set()) : null, null, flags);
    }

    private final FunctionValue createValueAccessor(Grip grip) {
        if (grip == null || grip.type() == Grip.Type.UNDEFINED) {
            return null;
        }
        Value value = this.createValue(grip, null, null);
        return value instanceof FunctionValue ? (FunctionValue)value : null;
    }

    @NotNull
    public final VariableImpl createVariable(@NotNull String name, @Nullable Grip valueData, @Nullable ValueModifier valueModifier) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new VariableImpl(name, this.createValue(valueData, null, null), valueModifier);
    }

    @Nullable
    public final Value createValue(@NotNull ValueHolder valueHolder) {
        Intrinsics.checkNotNullParameter((Object)valueHolder, (String)"valueHolder");
        return this.createValue(valueHolder.value(), valueHolder.primitiveValue(), valueHolder.primitiveValueType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value createValue(@Nullable Grip valueData, @Nullable String primitiveValue, @Nullable JsonToken primitiveValueType) {
        if (valueData == null && primitiveValue == null) {
            return null;
        }
        Object object = valueData;
        if (object == null || (object = object.actor()) == null) {
            return this.doCreateValue(valueData, primitiveValue, primitiveValueType);
        }
        Object actor = object;
        HashMap<String, Value> hashMap = this.refToValue;
        synchronized (hashMap) {
            boolean bl = false;
            Value value = this.refToValue.get(actor);
            if (value == null) {
                value = this.doCreateValue(valueData, primitiveValue, primitiveValueType);
                this.refToValue.put((String)actor, value);
                this.actorsNotYetPromotedToThreadLifetime.add((String)actor);
            }
            Value value2 = value;
            return value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Object> promoteRecentlyAddedActorsToThreadLifetime() {
        HashMap<String, Value> hashMap = this.refToValue;
        synchronized (hashMap) {
            void var3_5;
            block4: {
                boolean bl = false;
                if (!this.actorsNotYetPromotedToThreadLifetime.isEmpty()) break block4;
                Promise promise = Promises.resolvedPromise();
                return promise;
            }
            FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
            String string = this.vm.getThreadActor();
            Intrinsics.checkNotNull((Object)string);
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.pauseLifetimeGripsToThreadLifetime(string, (List<String>)this.actorsNotYetPromotedToThreadLifetime));
            this.actorsNotYetPromotedToThreadLifetime.clear();
            void var4_6 = var3_5;
            return var4_6;
        }
    }

    private final Value doCreateValue(Grip valueData, String primitiveValue, JsonToken primitiveValueType) {
        boolean bl;
        if (primitiveValue != null) {
            boolean bl2;
            ValueType valueType = null;
            boolean bl3 = bl2 = primitiveValueType != null;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            JsonToken jsonToken = primitiveValueType;
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    valueType = ValueType.STRING;
                    break;
                }
                case 2: {
                    valueType = ValueType.NUMBER;
                    break;
                }
                case 3: {
                    return (Value)PrimitiveValue.Companion.bool(primitiveValue);
                }
                case 4: {
                    return (Value)PrimitiveValue.NULL;
                }
                default: {
                    JsonToken jsonToken2 = primitiveValueType;
                    Intrinsics.checkNotNull((Object)jsonToken2);
                    throw new UnsupportedOperationException("Unsupported type " + jsonToken2);
                }
            }
            return (Value)new PrimitiveValue(valueType, primitiveValue);
        }
        boolean bl4 = bl = valueData != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Grip grip = valueData;
        Intrinsics.checkNotNull((Object)grip);
        switch (WhenMappings.$EnumSwitchMapping$1[grip.type().ordinal()]) {
            case 1: {
                ValueType valueType = null;
                Grip.Preview preview = valueData.preview();
                if (preview != null) {
                    if (preview.kind() == Grip.Preview.Kind.DOM_NODE) {
                        valueType = ValueType.NODE;
                    } else if (preview.kind() == Grip.Preview.Kind.ARRAY_LIKE) {
                        if (preview.length() == -1) {
                            valueType = ValueType.ARRAY;
                        } else {
                            return (Value)new FirefoxArray(preview.length(), valueData, this);
                        }
                    }
                }
                if (valueType == null) {
                    if (Intrinsics.areEqual((Object)"Array", (Object)valueData.className())) {
                        valueType = ValueType.ARRAY;
                    } else {
                        if (Intrinsics.areEqual((Object)"Function", (Object)valueData.className())) {
                            return (Value)new FirefoxFunction(valueData, this);
                        }
                        valueType = ValueType.OBJECT;
                    }
                }
                return (Value)new FirefoxObject(valueType, valueData, this);
            }
            case 2: {
                return (Value)PrimitiveValue.Companion.getNAN();
            }
            case 3: {
                return (Value)PrimitiveValue.Companion.getINFINITY();
            }
            case 4: {
                return (Value)PrimitiveValue.UNDEFINED;
            }
            case 5: {
                return (Value)PrimitiveValue.NULL;
            }
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Object> release() {
        this.markObsolete();
        HashMap<String, Value> hashMap = this.refToValue;
        synchronized (hashMap) {
            void var3_5;
            block4: {
                boolean bl = false;
                this.actorsNotYetPromotedToThreadLifetime.clear();
                if (!this.refToValue.isEmpty()) break block4;
                Promise promise = Promises.resolvedPromise();
                return promise;
            }
            FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
            String string = this.vm.getThreadActor();
            Intrinsics.checkNotNull((Object)string);
            Set<String> set = this.refToValue.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.release(string, (Collection<String>)set));
            this.refToValue.clear();
            void var4_6 = var3_5;
            return var4_6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        HashMap<String, Value> hashMap = this.refToValue;
        synchronized (hashMap) {
            boolean bl = false;
            this.refToValue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.BOOLEAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.NULL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Grip.Type.values().length];
            try {
                nArray[Grip.Type.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Grip.Type.NA_N.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Grip.Type.INFINITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Grip.Type.UNDEFINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Grip.Type.NULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

