/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.ElementPresentation;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.RootDomParentStrategy;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.util.xml.stubs.FileStub;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileElementImpl<T extends DomElement>
implements DomFileElement<T>,
SemElement {
    private static final DomGenericInfo EMPTY_DOM_GENERIC_INFO = new DomGenericInfo(){

        @Nullable
        public GenericDomValue getNameDomElement(DomElement element) {
            return null;
        }

        @NotNull
        public List<? extends CustomDomChildrenDescription> getCustomNameChildrenDescription() {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Nullable
        public String getElementName(DomElement element) {
            return null;
        }

        @NotNull
        public List<DomChildrenDescription> getChildrenDescriptions() {
            List<DomChildrenDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                1.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        public List<DomFixedChildDescription> getFixedChildrenDescriptions() {
            List<DomFixedChildDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                1.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @NotNull
        public List<DomCollectionChildDescription> getCollectionChildrenDescriptions() {
            List<DomCollectionChildDescription> list2 = Collections.emptyList();
            if (list2 == null) {
                1.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public List<DomAttributeChildDescription<?>> getAttributeChildrenDescriptions() {
            List<DomAttributeChildDescription<?>> list2 = Collections.emptyList();
            if (list2 == null) {
                1.$$$reportNull$$$0(4);
            }
            return list2;
        }

        public boolean isTagValueElement() {
            return false;
        }

        @Nullable
        public DomFixedChildDescription getFixedChildDescription(String tagName) {
            return null;
        }

        @Nullable
        public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName, @NonNls String namespace) {
            return null;
        }

        @Nullable
        public DomCollectionChildDescription getCollectionChildDescription(String tagName) {
            return null;
        }

        @Nullable
        public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName, @NonNls String namespace) {
            return null;
        }

        public DomAttributeChildDescription getAttributeChildDescription(String attributeName) {
            return null;
        }

        @Nullable
        public DomAttributeChildDescription getAttributeChildDescription(@NonNls String attributeName, @NonNls String namespace) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/xml/impl/DomFileElementImpl$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCustomNameChildrenDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenDescriptions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixedChildrenDescriptions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCollectionChildrenDescriptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributeChildrenDescriptions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private final XmlFile myFile;
    private final DomFileDescription<T> myFileDescription;
    private final DomRootInvocationHandler myRootHandler;
    private final Class<T> myRootElementClass;
    private final EvaluatedXmlNameImpl myRootTagName;
    private final DomManagerImpl myManager;
    private final Map<Key, Object> myUserData = new HashMap<Key, Object>();

    protected DomFileElementImpl(XmlFile file, EvaluatedXmlNameImpl rootTagName, DomFileDescription<T> fileDescription, FileStub stub) {
        this.myFile = file;
        this.myRootElementClass = fileDescription.getRootElementClass();
        this.myRootTagName = rootTagName;
        this.myManager = DomManagerImpl.getDomManager(file.getProject());
        this.myFileDescription = fileDescription;
        this.myRootHandler = new DomRootInvocationHandler(this.myRootElementClass, new RootDomParentStrategy(this), this, (EvaluatedXmlName)rootTagName, stub == null ? null : stub.getRootTagStub());
    }

    @NotNull
    public final XmlFile getFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            DomFileElementImpl.$$$reportNull$$$0(0);
        }
        return xmlFile;
    }

    @NotNull
    public XmlFile getOriginalFile() {
        XmlFile xmlFile = (XmlFile)this.myFile.getOriginalFile();
        if (xmlFile == null) {
            DomFileElementImpl.$$$reportNull$$$0(1);
        }
        return xmlFile;
    }

    @Nullable
    public XmlTag getRootTag() {
        XmlTag tag;
        if (!this.myFile.isValid()) {
            return null;
        }
        XmlDocument document = this.myFile.getDocument();
        if (document != null && (tag = document.getRootTag()) != null) {
            if (tag.getTextLength() > 0 && this.getFileDescription().acceptsOtherRootTagNames()) {
                return tag;
            }
            if (this.myRootTagName.getXmlName().getLocalName().equals(tag.getLocalName()) && this.myRootTagName.isNamespaceAllowed((DomFileElement)this, tag.getNamespace())) {
                return tag;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DomFileElementImpl)) {
            return false;
        }
        DomFileElementImpl that = (DomFileElementImpl)o;
        if (this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null) {
            return false;
        }
        if (this.myRootElementClass != null ? !this.myRootElementClass.equals(that.myRootElementClass) : that.myRootElementClass != null) {
            return false;
        }
        return !(this.myRootTagName != null ? !this.myRootTagName.equals((Object)that.myRootTagName) : that.myRootTagName != null);
    }

    public int hashCode() {
        int result2 = this.myFile != null ? this.myFile.hashCode() : 0;
        result2 = 31 * result2 + (this.myRootElementClass != null ? this.myRootElementClass.hashCode() : 0);
        result2 = 31 * result2 + (this.myRootTagName != null ? this.myRootTagName.hashCode() : 0);
        return result2;
    }

    @NotNull
    public final DomManagerImpl getManager() {
        DomManagerImpl domManagerImpl = this.myManager;
        if (domManagerImpl == null) {
            DomFileElementImpl.$$$reportNull$$$0(2);
        }
        return domManagerImpl;
    }

    public final Type getDomElementType() {
        return this.getClass();
    }

    @NotNull
    public AbstractDomChildrenDescription getChildDescription() {
        throw new UnsupportedOperationException("Method getChildDescription is not yet implemented in " + this.getClass().getName());
    }

    public DomNameStrategy getNameStrategy() {
        return this.getRootHandler().getNameStrategy();
    }

    @NotNull
    public ElementPresentation getPresentation() {
        return new ElementPresentation(){

            @NonNls
            public String getElementName() {
                return "<ROOT>";
            }

            @NonNls
            public String getTypeName() {
                return "<ROOT>";
            }

            public Icon getIcon() {
                return null;
            }
        };
    }

    public GlobalSearchScope getResolveScope() {
        return this.myFile.getResolveScope();
    }

    @Nullable
    public <T extends DomElement> T getParentOfType(Class<T> requiredClass, boolean strict) {
        return (T)(DomFileElement.class.isAssignableFrom(requiredClass) && !strict ? this : null);
    }

    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getFile());
    }

    public void copyFrom(DomElement other) {
        throw new UnsupportedOperationException("Method copyFrom is not yet implemented in " + this.getClass().getName());
    }

    public final <T extends DomElement> T createMockCopy(boolean physical) {
        throw new UnsupportedOperationException("Method createMockCopy is not yet implemented in " + this.getClass().getName());
    }

    public final <T extends DomElement> T createStableCopy() {
        PsiManager psiManager = this.myFile.getManager();
        VirtualFile vFile = this.myFile.getViewProvider().getVirtualFile();
        return this.myManager.createStableValue(() -> this.myManager.getFileElement((XmlFile)ObjectUtils.tryCast((Object)psiManager.findFile(vFile), XmlFile.class)));
    }

    @NotNull
    public String getXmlElementNamespace() {
        return "";
    }

    @NonNls
    @Nullable
    public String getXmlElementNamespaceKey() {
        return null;
    }

    @NotNull
    public final T getRootElement() {
        if (!this.isValid()) {
            PsiUtilCore.ensureValid((PsiElement)this.myFile);
            throw new AssertionError((Object)(this + " is not equal to " + (DomFileElementImpl)this.myManager.getFileElement(this.myFile)));
        }
        DomElement domElement = this.getRootHandler().getProxy();
        if (domElement == null) {
            DomFileElementImpl.$$$reportNull$$$0(3);
        }
        return (T)domElement;
    }

    @NotNull
    public Class<T> getRootElementClass() {
        Class<T> clazz = this.myRootElementClass;
        if (clazz == null) {
            DomFileElementImpl.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    @NotNull
    public DomFileDescription<T> getFileDescription() {
        DomFileDescription<T> domFileDescription = this.myFileDescription;
        if (domFileDescription == null) {
            DomFileElementImpl.$$$reportNull$$$0(5);
        }
        return domFileDescription;
    }

    @NotNull
    protected final DomRootInvocationHandler getRootHandler() {
        DomRootInvocationHandler domRootInvocationHandler = this.myRootHandler;
        if (domRootInvocationHandler == null) {
            DomFileElementImpl.$$$reportNull$$$0(6);
        }
        return domRootInvocationHandler;
    }

    @NonNls
    public String toString() {
        return "File " + this.myFile.toString();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    public final XmlTag getXmlTag() {
        return null;
    }

    @NotNull
    public <T extends DomElement> DomFileElementImpl<T> getRoot() {
        DomFileElementImpl domFileElementImpl = this;
        if (domFileElementImpl == null) {
            DomFileElementImpl.$$$reportNull$$$0(7);
        }
        return domFileElementImpl;
    }

    @Nullable
    public DomElement getParent() {
        return null;
    }

    public final XmlTag ensureTagExists() {
        return null;
    }

    public final XmlElement getXmlElement() {
        return this.getFile();
    }

    public final XmlElement ensureXmlElementExists() {
        return this.ensureTagExists();
    }

    public void undefine() {
    }

    public final boolean isValid() {
        return this.checkValidity() == null;
    }

    public boolean exists() {
        return true;
    }

    @Nullable
    public String checkValidity() {
        if (!this.myFile.isValid()) {
            return "Invalid file";
        }
        DomFileElement fileElement = this.myManager.getFileElement(this.myFile);
        if (!this.equals(fileElement)) {
            return "file element changed: " + (DomFileElementImpl)fileElement + "; fileType=" + this.myFile.getFileType();
        }
        return null;
    }

    @NotNull
    public final DomGenericInfo getGenericInfo() {
        DomGenericInfo domGenericInfo = EMPTY_DOM_GENERIC_INFO;
        if (domGenericInfo == null) {
            DomFileElementImpl.$$$reportNull$$$0(8);
        }
        return domGenericInfo;
    }

    @NotNull
    public String getXmlElementName() {
        return "";
    }

    public void accept(DomElementVisitor visitor2) {
        this.myManager.getApplicationComponent().getVisitorDescription(visitor2.getClass()).acceptElement(visitor2, (DomElement)this);
    }

    public void acceptChildren(DomElementVisitor visitor2) {
        this.getRootElement().accept(visitor2);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            DomFileElementImpl.$$$reportNull$$$0(9);
        }
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            DomFileElementImpl.$$$reportNull$$$0(10);
        }
        this.myUserData.put(key, value);
    }

    public final long getModificationCount() {
        return this.myFile.getModificationStamp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomFileElementImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElementClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomFileElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

