/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.output.CommandBlock;
import org.jetbrains.plugins.terminal.block.output.CommandBlockImpl;
import org.jetbrains.plugins.terminal.block.output.CommandBlockInfo;
import org.jetbrains.plugins.terminal.block.output.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighterKt;
import org.jetbrains.plugins.terminal.block.output.TextAttributesKeyAdapter;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextWithAttributes;
import org.jetbrains.plugins.terminal.block.output.TextWithHighlightings;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J$\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0017J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\nH\u0017J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\nH\u0017J\u0010\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\nH\u0002J\b\u0010+\u001a\u00020\u001aH\u0017J\b\u0010,\u001a\u00020\u0014H\u0017J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010(\u001a\u00020\nH\u0017J\u001e\u0010.\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0017J\u0018\u0010/\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0012H\u0017J\u0012\u00101\u001a\u0004\u0018\u00010\u00122\u0006\u0010(\u001a\u00020\nH\u0017J\b\u00102\u001a\u00020\u001aH\u0017J\u0010\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020$H\u0002J\u0018\u00105\u001a\u00020$2\u0006\u00104\u001a\u00020$2\u0006\u00106\u001a\u00020$H\u0002J\u0018\u00107\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\n2\u0006\u00108\u001a\u00020*H\u0003J\u0018\u00109\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\n2\u0006\u00108\u001a\u00020*H\u0002J\u0018\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020*H\u0002J\b\u0010=\u001a\u00020$H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModelImpl;", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "blocks", "", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlock;", "getBlocks", "()Ljava/util/List;", "highlightings", "", "", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "blockInfos", "Lorg/jetbrains/plugins/terminal/block/output/CommandBlockInfo;", "highlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "document", "Lcom/intellij/openapi/editor/Document;", "listeners", "Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModelListener;", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "createBlock", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "terminalWidth", "", "finalizeBlock", "activeBlock", "removeBlock", "block", "findBlockRangeToDelete", "Lcom/intellij/openapi/util/TextRange;", "clearBlocks", "getHighlightingsSnapshot", "getHighlightings", "putHighlightings", "setBlockInfo", "info", "getBlockInfo", "trimOutput", "trimTopBlock", "maxCapacity", "findTopBlockCountToRemove", "textLength", "deleteDocumentRange", "deleteRange", "deleteDocumentRangeInHighlightings", "findIntersectionLength", "range1", "range2", "getMaxCapacity", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputModelImpl\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n310#2,5:313\n1863#3,2:318\n1863#3,2:320\n1863#3,2:322\n1863#3,2:330\n1863#3,2:332\n360#3,7:334\n1611#3,9:341\n1863#3:350\n1864#3:352\n1620#3:353\n77#4:324\n97#4,5:325\n1#5:351\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputModelImpl\n*L\n61#1:313,5\n91#1:318,2\n99#1:320,2\n115#1:322,2\n173#1:330,2\n190#1:332,2\n211#1:334,7\n231#1:341,9\n231#1:350\n231#1:352\n231#1:353\n153#1:324\n153#1:325,5\n231#1:351\n*E\n"})
public final class TerminalOutputModelImpl
implements TerminalOutputModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<CommandBlock> blocks;
    @NotNull
    private final Map<CommandBlock, List<HighlightingInfo>> highlightings;
    @NotNull
    private final Map<CommandBlock, CommandBlockInfo> blockInfos;
    @Nullable
    private TerminalOutputHighlightingsSnapshot highlightingsSnapshot;
    @NotNull
    private final Document document;
    @NotNull
    private final List<TerminalOutputModelListener> listeners;

    public TerminalOutputModelImpl(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.blocks = list;
        this.highlightings = new LinkedHashMap();
        this.blockInfos = new HashMap();
        DocumentEx documentEx = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.document = (Document)documentEx;
        this.listeners = new CopyOnWriteArrayList();
    }

    @Override
    @NotNull
    public EditorEx getEditor() {
        return this.editor;
    }

    @Override
    @NotNull
    public List<CommandBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    public void addListener(@NotNull TerminalOutputModelListener listener2, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> TerminalOutputModelImpl.addListener$lambda$0(this, listener2));
        }
    }

    @Override
    @RequiresEdt
    @NotNull
    public CommandBlock createBlock(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt, int terminalWidth) {
        Document $this$executeInBulk$iv = this.document;
        boolean $i$f$executeInBulk = false;
        Ref.ObjectRef result$iv = new Ref.ObjectRef();
        DocumentUtil.executeInBulk((Document)$this$executeInBulk$iv, (Runnable)new Runnable(result$iv, this, prompt, command2, terminalWidth){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ TerminalOutputModelImpl this$0;
            final /* synthetic */ TerminalPromptRenderingInfo $prompt$inlined;
            final /* synthetic */ String $command$inlined;
            final /* synthetic */ int $terminalWidth$inlined;
            {
                this.$result = $result;
                this.this$0 = terminalOutputModelImpl;
                this.$prompt$inlined = terminalPromptRenderingInfo;
                this.$command$inlined = string;
                this.$terminalWidth$inlined = n;
            }

            public final void run() {
                TextAttributesKeyAdapter commandAttributes;
                TextWithHighlightings commandAndRightPrompt;
                Ref.ObjectRef objectRef = this.$result;
                boolean bl = false;
                if (TerminalOutputModelImpl.access$getDocument$p(this.this$0).getTextLength() > 0) {
                    TerminalOutputModelImpl.access$getDocument$p(this.this$0).insertString(TerminalOutputModelImpl.access$getDocument$p(this.this$0).getTextLength(), (CharSequence)"\n");
                }
                int startOffset = TerminalOutputModelImpl.access$getDocument$p(this.this$0).getTextLength();
                List blockHighlightings = new ArrayList<E>();
                if (this.$prompt$inlined != null) {
                    TerminalOutputModelImpl.access$createBlock$lambda$1$appendTextWithHighlightings(this.this$0, blockHighlightings, this.$prompt$inlined.getText(), this.$prompt$inlined.getHighlightings());
                }
                if (((CharSequence)(commandAndRightPrompt = TerminalOutputModelImpl.Companion.createCommandAndRightPromptText$intellij_terminal(this.$command$inlined, this.$prompt$inlined, commandAttributes = new TextAttributesKeyAdapter((Editor)this.this$0.getEditor(), BlockTerminalColors.COMMAND), this.$terminalWidth$inlined)).getText()).length() > 0) {
                    TerminalOutputModelImpl.access$createBlock$lambda$1$appendTextWithHighlightings(this.this$0, blockHighlightings, commandAndRightPrompt.getText(), commandAndRightPrompt.getHighlightings());
                }
                RangeMarker rangeMarker = TerminalOutputModelImpl.access$getDocument$p(this.this$0).createRangeMarker(startOffset, TerminalOutputModelImpl.access$getDocument$p(this.this$0).getTextLength());
                Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
                RangeMarker marker = rangeMarker;
                marker.setGreedyToRight(true);
                CommandBlockImpl block = new CommandBlockImpl(this.$command$inlined, this.$prompt$inlined != null ? this.$prompt$inlined.getText() : null, this.$prompt$inlined != null ? this.$prompt$inlined.getRightText() : null, marker, commandAndRightPrompt.getText().length());
                this.this$0.getBlocks().add(block);
                this.this$0.putHighlightings(block, blockHighlightings);
                objectRef.element = block;
            }
        });
        Object object = result$iv.element;
        Intrinsics.checkNotNull((Object)object);
        CommandBlockImpl block = (CommandBlockImpl)object;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputModelListener it = (TerminalOutputModelListener)element$iv;
            boolean bl = false;
            it.blockCreated(block);
        }
        return block;
    }

    @Override
    @RequiresEdt
    public void finalizeBlock(@NotNull CommandBlock activeBlock) {
        Intrinsics.checkNotNullParameter((Object)activeBlock, (String)"activeBlock");
        ((CommandBlockImpl)activeBlock).getRange().setGreedyToRight(false);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputModelListener it = (TerminalOutputModelListener)element$iv;
            boolean bl = false;
            it.blockFinalized(activeBlock);
        }
    }

    @Override
    @RequiresEdt
    public void removeBlock(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        int startBlockInd = this.getBlocks().indexOf(block);
        if (!(startBlockInd >= 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        TextRange rangeToDelete = this.findBlockRangeToDelete(block);
        int n = this.getBlocks().size();
        for (int blockInd = startBlockInd + 1; blockInd < n; ++blockInd) {
            this.deleteDocumentRangeInHighlightings(this.getBlocks().get(blockInd), rangeToDelete);
        }
        this.getBlocks().remove(block);
        this.highlightings.remove(block);
        this.highlightingsSnapshot = null;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputModelListener it = (TerminalOutputModelListener)element$iv;
            boolean bl = false;
            it.blockRemoved(block);
        }
        this.document.deleteString(rangeToDelete.getStartOffset(), rangeToDelete.getEndOffset());
        ((CommandBlockImpl)block).getRange().dispose();
    }

    private final TextRange findBlockRangeToDelete(CommandBlock block) {
        TextRange textRange;
        TextRange blockRange = new TextRange(block.getStartOffset(), block.getEndOffset());
        if (blockRange.getStartOffset() > 0) {
            if (!(this.document.getCharsSequence().charAt(blockRange.getStartOffset() - 1) == '\n')) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            textRange = new TextRange(blockRange.getStartOffset() - 1, blockRange.getEndOffset());
        } else if (blockRange.getEndOffset() < this.document.getTextLength()) {
            if (!(this.document.getCharsSequence().charAt(blockRange.getEndOffset()) == '\n')) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            textRange = new TextRange(blockRange.getStartOffset(), blockRange.getEndOffset() + 1);
        } else {
            textRange = blockRange;
        }
        return textRange;
    }

    @Override
    @RequiresEdt
    public void clearBlocks() {
        List blocksCopy = CollectionsKt.reversed((Iterable)this.getBlocks());
        for (CommandBlock block : blocksCopy) {
            this.removeBlock(block);
        }
        this.getEditor().getDocument().setText((CharSequence)"");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    @NotNull
    public TerminalOutputHighlightingsSnapshot getHighlightingsSnapshot() {
        TerminalOutputHighlightingsSnapshot snapshot = this.highlightingsSnapshot;
        if (snapshot == null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            DocumentEx documentEx = this.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            Map<CommandBlock, List<HighlightingInfo>> map2 = this.highlightings;
            Document document = (Document)documentEx;
            boolean $i$f$flatMap = false;
            void var4_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = (Iterable)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Document document2 = document;
            this.highlightingsSnapshot = snapshot = new TerminalOutputHighlightingsSnapshot(document2, list);
        }
        return snapshot;
    }

    @Override
    @RequiresEdt
    @NotNull
    public List<HighlightingInfo> getHighlightings(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        List list = this.highlightings.get(block);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @RequiresEdt
    public void putHighlightings(@NotNull CommandBlock block, @NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.highlightings.put(block, highlightings);
        this.highlightingsSnapshot = null;
    }

    @Override
    @RequiresEdt
    public void setBlockInfo(@NotNull CommandBlock block, @NotNull CommandBlockInfo info) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.blockInfos.put(block, info);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputModelListener it = (TerminalOutputModelListener)element$iv;
            boolean bl = false;
            it.blockInfoUpdated(block, info);
        }
    }

    @Override
    @RequiresEdt
    @Nullable
    public CommandBlockInfo getBlockInfo(@NotNull CommandBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return this.blockInfos.get(block);
    }

    @Override
    @RequiresEdt
    public void trimOutput() {
        int maxCapacity = this.getMaxCapacity();
        int textLength = this.document.getTextLength();
        if (textLength <= maxCapacity) {
            return;
        }
        int topBlockCountToRemove = this.findTopBlockCountToRemove(maxCapacity, textLength);
        List topBlocksToRemove = CollectionsKt.toList((Iterable)this.getBlocks().subList(0, topBlockCountToRemove));
        Iterable $this$forEach$iv = topBlocksToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandBlock it = (CommandBlock)element$iv;
            boolean bl = false;
            this.removeBlock(it);
        }
        this.trimTopBlock(maxCapacity);
    }

    private final void trimTopBlock(int maxCapacity) {
        int textLength = this.document.getTextLength();
        int textLengthToRemove = textLength - maxCapacity;
        if (textLengthToRemove <= 0) {
            return;
        }
        CommandBlock commandBlock = (CommandBlock)CollectionsKt.firstOrNull(this.getBlocks());
        if (commandBlock == null) {
            return;
        }
        CommandBlock block = commandBlock;
        int outputStartOffset = block.getOutputStartOffset();
        int outputLengthToRemove = Math.min(block.getEndOffset() - outputStartOffset, textLengthToRemove);
        int linesCountBefore = this.document.getLineCount();
        this.deleteDocumentRange(block, new TextRange(outputStartOffset, outputStartOffset + outputLengthToRemove));
        block.setTrimmedLinesCount(block.getTrimmedLinesCount() + (linesCountBefore - this.document.getLineCount()));
    }

    private final int findTopBlockCountToRemove(int maxCapacity, int textLength) {
        int n;
        block2: {
            List<CommandBlock> $this$indexOfFirst$iv = this.getBlocks();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<CommandBlock> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                CommandBlock item$iv;
                CommandBlock it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getEndOffset() + maxCapacity > textLength) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstRetainedBlockInd = n;
        return RangesKt.coerceAtLeast((int)firstRetainedBlockInd, (int)0);
    }

    @RequiresEdt
    private final void deleteDocumentRange(CommandBlock block, TextRange deleteRange) {
        int startBlockInd = this.getBlocks().indexOf(block);
        if (!(startBlockInd >= 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!deleteRange.isEmpty()) {
            int n = this.getBlocks().size();
            for (int blockInd = startBlockInd; blockInd < n; ++blockInd) {
                this.deleteDocumentRangeInHighlightings(this.getBlocks().get(blockInd), deleteRange);
            }
            this.document.deleteString(deleteRange.getStartOffset(), deleteRange.getEndOffset());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteDocumentRangeInHighlightings(CommandBlock block, TextRange deleteRange) {
        void $this$mapNotNullTo$iv$iv;
        List<HighlightingInfo> highlightings = this.getHighlightings(block);
        Iterable $this$mapNotNull$iv = highlightings;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HighlightingInfo highlightingInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            HighlightingInfo it = (HighlightingInfo)element$iv$iv;
            boolean bl2 = false;
            if (it.getEndOffset() <= deleteRange.getStartOffset()) {
                highlightingInfo = it;
            } else if (it.getStartOffset() >= deleteRange.getEndOffset()) {
                int newRangeStart = it.getStartOffset() - deleteRange.getLength();
                highlightingInfo = new HighlightingInfo(newRangeStart, newRangeStart + it.getLength(), it.getTextAttributesProvider());
            } else {
                int newRangeEnd;
                int intersectionLength = this.findIntersectionLength(it, deleteRange);
                if (!(intersectionLength > 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                int newRangeStart = Math.min(it.getStartOffset(), deleteRange.getStartOffset());
                highlightingInfo = newRangeStart != (newRangeEnd = newRangeStart + it.getLength() - intersectionLength) ? new HighlightingInfo(newRangeStart, newRangeEnd, it.getTextAttributesProvider()) : null;
            }
            if (highlightingInfo == null) continue;
            HighlightingInfo it$iv$iv = highlightingInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List updatedHighlightings = (List)destination$iv$iv;
        this.putHighlightings(block, updatedHighlightings);
    }

    private final int findIntersectionLength(HighlightingInfo range1, TextRange range2) {
        int intersectionLength = Math.min(range1.getEndOffset(), range2.getEndOffset()) - Math.max(range1.getStartOffset(), range2.getStartOffset());
        return Math.max(intersectionLength, 0);
    }

    private final int getMaxCapacity() {
        return RangesKt.coerceIn((int)AdvancedSettings.Companion.getInt("new.terminal.output.capacity.kb"), (int)1, (int)10240) * 1024;
    }

    private static final void addListener$lambda$0(TerminalOutputModelImpl this$0, TerminalOutputModelListener $listener) {
        this$0.listeners.remove($listener);
    }

    private static final void createBlock$lambda$1$appendTextWithHighlightings(TerminalOutputModelImpl this$0, List<HighlightingInfo> blockHighlightings, String text, List<HighlightingInfo> highlightings) {
        List<HighlightingInfo> adjustedHighlightings = TerminalTextHighlighterKt.rebase(highlightings, this$0.document.getTextLength());
        this$0.document.insertString(this$0.document.getTextLength(), (CharSequence)text);
        blockHighlightings.addAll((Collection<HighlightingInfo>)adjustedHighlightings);
    }

    public static final /* synthetic */ Document access$getDocument$p(TerminalOutputModelImpl $this) {
        return $this.document;
    }

    public static final /* synthetic */ void access$createBlock$lambda$1$appendTextWithHighlightings(TerminalOutputModelImpl this$0, List blockHighlightings, String text, List highlightings) {
        TerminalOutputModelImpl.createBlock$lambda$1$appendTextWithHighlightings(this$0, blockHighlightings, text, highlightings);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputModelImpl$Companion;", "", "<init>", "()V", "createCommandAndRightPromptText", "Lorg/jetbrains/plugins/terminal/block/output/TextWithHighlightings;", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "commandAttributes", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "terminalWidth", "", "createCommandAndRightPromptText$intellij_terminal", "createCommandText", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalOutputModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputModelImpl$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,312:1\n170#2,6:313\n1#3:319\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModelImpl.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputModelImpl$Companion\n*L\n275#1:313,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        public final TextWithHighlightings createCommandAndRightPromptText$intellij_terminal(@Nullable String command2, @Nullable TerminalPromptRenderingInfo prompt, @NotNull TextAttributesProvider commandAttributes, int terminalWidth) {
            TextWithHighlightings textWithHighlightings;
            int commandFirstLineLength;
            int n;
            int n2;
            Object rightPromptText;
            String commandText;
            block10: {
                void $this$indexOfLast$iv;
                Object object;
                Intrinsics.checkNotNullParameter((Object)commandAttributes, (String)"commandAttributes");
                String string = command2;
                if (string == null) {
                    string = commandText = "";
                }
                if ((object = prompt) == null || (object = ((TerminalPromptRenderingInfo)object).getRightText()) == null) {
                    object = "";
                }
                if (((CharSequence)(rightPromptText = object)).length() == 0) {
                    return this.createCommandText(commandText, commandAttributes);
                }
                TerminalPromptRenderingInfo terminalPromptRenderingInfo = prompt;
                Intrinsics.checkNotNull((Object)terminalPromptRenderingInfo);
                String promptText = terminalPromptRenderingInfo.getText();
                CharSequence charSequence = promptText;
                n2 = promptText.length();
                boolean $i$f$indexOfLast = false;
                int n3 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n3) {
                    do {
                        int index$iv = n3--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it == '\n')) continue;
                        n = index$iv;
                        break block10;
                    } while (0 <= n3);
                }
                n = -1;
            }
            int n4 = n;
            int promptLastLineLength = n2 - (n4 + 1);
            Integer n5 = StringsKt.indexOf$default((CharSequence)commandText, (char)'\n', (int)0, (boolean)false, (int)6, null);
            int it = ((Number)n5).intValue();
            boolean bl = false;
            Integer n6 = it != -1 ? n5 : null;
            int n7 = commandFirstLineLength = n6 != null ? n6.intValue() : commandText.length();
            if (promptLastLineLength + commandFirstLineLength + ((String)rightPromptText).length() < terminalWidth) {
                List list;
                int spacesCount = terminalWidth - promptLastLineLength - commandFirstLineLength - ((String)rightPromptText).length();
                List $this$createCommandAndRightPromptText_u24lambda_u242 = list = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                if (commandFirstLineLength > 0) {
                    String string = commandText.substring(0, commandFirstLineLength);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$createCommandAndRightPromptText_u24lambda_u242.add(new TextWithAttributes(string, commandAttributes));
                }
                $this$createCommandAndRightPromptText_u24lambda_u242.add(new TextWithAttributes(StringsKt.repeat((CharSequence)" ", (int)spacesCount), EmptyTextAttributesProvider.INSTANCE));
                for (HighlightingInfo highlighting : prompt.getRightHighlightings()) {
                    String string = ((String)rightPromptText).substring(highlighting.getStartOffset(), highlighting.getEndOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$createCommandAndRightPromptText_u24lambda_u242.add(new TextWithAttributes(string, highlighting.getTextAttributesProvider()));
                }
                if (commandFirstLineLength < commandText.length()) {
                    String string = commandText.substring(commandFirstLineLength);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    $this$createCommandAndRightPromptText_u24lambda_u242.add(new TextWithAttributes(string, commandAttributes));
                }
                List components = CollectionsKt.build((List)list);
                textWithHighlightings = TerminalTextHighlighterKt.toTextWithHighlightings(components);
            } else {
                textWithHighlightings = this.createCommandText(commandText, commandAttributes);
            }
            return textWithHighlightings;
        }

        private final TextWithHighlightings createCommandText(String command2, TextAttributesProvider commandAttributes) {
            List highlightings = ((CharSequence)command2).length() > 0 ? CollectionsKt.listOf((Object)new HighlightingInfo(0, command2.length(), commandAttributes)) : CollectionsKt.emptyList();
            return new TextWithHighlightings(command2, highlightings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

