/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui.browser;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.changes.ui.browser.BulkMovesOnlyChangesFilter;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u000e\b\u0007\u0018\u0000 02\u00020\u0001:\b01234567B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001b2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020#H\u0007J\u0006\u0010$\u001a\u00020\u001bJ\u0012\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010'\u001a\u00020\u001bH\u0002JH\u0010(\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010&\u001a\u00020\u00162\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140*H\u0002J\b\u0010-\u001a\u00020\u001bH\u0002J\b\u0010.\u001a\u00020\u001bH\u0002J\b\u0010/\u001a\u00020\u0011H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "listener", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getListener", "()Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;", "LOCK", "", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "rawChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "activeFilter", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "processedChanges", "pendingChanges", "filteredOutChanges", "dispose", "", "setChanges", "changes", "getFilteredChanges", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState;", "getProgress", "", "hasActiveFilter", "", "clearFilter", "setFilter", "filter", "restartLoading", "filterChanges", "pending", "", "processed", "filteredOut", "queueUpdatePresentation", "updatePresentation", "resetFilter", "Companion", "Filter", "MovesOnlyFilter", "NonImportantFilter", "Listener", "FilteredState", "FilterGroup", "ToggleFilterAction", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nChangesFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesFilterer.kt\ncom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,344:1\n1#2:345\n14#3:346\n*S KotlinDebug\n*F\n+ 1 ChangesFilterer.kt\ncom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer\n*L\n40#1:346\n*E\n"})
public final class ChangesFilterer
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Object LOCK;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private ProgressIndicator progressIndicator;
    @Nullable
    private List<? extends Change> rawChanges;
    @Nullable
    private Filter activeFilter;
    @Nullable
    private List<? extends Change> processedChanges;
    @Nullable
    private List<? extends Change> pendingChanges;
    @Nullable
    private List<? extends Change> filteredOutChanges;
    @JvmField
    @NotNull
    public static final DataKey<ChangesFilterer> DATA_KEY = DataKey.Companion.create("com.intellij.openapi.vcs.changes.ui.browser.ChangesFilterer");
    @NotNull
    private static final Logger LOG;

    public ChangesFilterer(@Nullable Project project, @NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.project = project;
        this.listener = listener2;
        this.LOCK = new Object();
        this.updateQueue = new MergingUpdateQueue("ChangesFilterer", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, false, 96, null);
        this.progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Listener getListener() {
        return this.listener;
    }

    public void dispose() {
        this.resetFilter();
    }

    @RequiresEdt
    public final void setChanges(@Nullable List<? extends Change> changes) {
        List<? extends Change> oldChanges = this.rawChanges;
        if (oldChanges == null && changes == null) {
            return;
        }
        if (oldChanges != null && changes != null && ContainerUtil.equalsIdentity(oldChanges, changes)) {
            return;
        }
        List<? extends Change> list = changes;
        List list2 = this.rawChanges = list != null ? CollectionsKt.toList((Iterable)list) : null;
        if (this.activeFilter != null) {
            this.restartLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    @NotNull
    public final FilteredState getFilteredChanges() {
        Object object = this.LOCK;
        synchronized (object) {
            FilteredState filteredState;
            boolean bl = false;
            List<? extends Change> processed = this.processedChanges;
            List<? extends Change> pending = this.pendingChanges;
            List<? extends Change> filteredOut = this.filteredOutChanges;
            if (processed != null && pending != null && filteredOut != null) {
                filteredState = FilteredState.Companion.create(processed, pending, filteredOut);
            } else {
                List list = this.rawChanges;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                filteredState = FilteredState.Companion.create(list);
            }
            FilteredState filteredState2 = filteredState;
            return filteredState2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final float getProgress() {
        Integer totalCount;
        Integer n;
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            List<? extends Change> list = this.pendingChanges;
            n = list != null ? Integer.valueOf(list.size()) : null;
        }
        Integer pendingCount = n;
        List<? extends Change> list = this.rawChanges;
        Integer n2 = totalCount = list != null ? Integer.valueOf(list.size()) : null;
        if (pendingCount == null || totalCount == null || totalCount == 0) {
            return 1.0f;
        }
        return RangesKt.coerceAtLeast((float)(1.0f - (float)pendingCount.intValue() / (float)totalCount.intValue()), (float)0.0f);
    }

    @NotNull
    public final boolean hasActiveFilter() {
        return this.activeFilter != null;
    }

    public final void clearFilter() {
        this.setFilter(null);
    }

    private final void setFilter(Filter filter) {
        this.activeFilter = filter;
        this.restartLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restartLoading() {
        ProgressIndicator indicator = this.resetFilter();
        Filter filter = this.activeFilter;
        List<? extends Change> changesToFilter = this.rawChanges;
        if (filter == null || changesToFilter == null) {
            this.updatePresentation();
            return;
        }
        Iterable iterable = changesToFilter;
        Comparator<Change> comparator = ChangesComparator.getInstance(false);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"getInstance(...)");
        List changes = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        List pending = CollectionsKt.asReversedMutable((List)SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.asReversed((List)changes)), ChangesFilterer::restartLoading$lambda$2)));
        List processed = new ArrayList();
        List filteredOut = new ArrayList();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            this.processedChanges = processed;
            this.pendingChanges = pending;
            this.filteredOutChanges = filteredOut;
            Unit unit = Unit.INSTANCE;
        }
        this.updatePresentation();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ChangesFilterer.restartLoading$lambda$5(indicator, this, changes, filter, pending, processed, filteredOut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void filterChanges(List<? extends Change> changes, Filter filter, List<Change> pending, List<Change> processed, List<Change> filteredOut) {
        this.queueUpdatePresentation();
        Collection<Change> filteredChanges = filter.acceptBulk(this, changes);
        if (filteredChanges != null) {
            Object object = this.LOCK;
            synchronized (object) {
                boolean bl = false;
                ProgressManager.checkCanceled();
                pending.clear();
                processed.addAll(filteredChanges);
                Set filteredOutSet = CollectionsKt.toMutableSet((Iterable)changes);
                filteredOutSet.removeAll(filteredChanges);
                bl = filteredOut.addAll(filteredOutSet);
            }
            this.updatePresentation();
            return;
        }
        for (Change change : changes) {
            boolean bl;
            ProgressManager.checkCanceled();
            try {
                bl = filter.accept(this, change);
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                bl = true;
            }
            boolean accept = bl;
            Object object = this.LOCK;
            synchronized (object) {
                boolean bl2 = false;
                ProgressManager.checkCanceled();
                pending.remove(0);
                boolean bl3 = accept ? processed.add(change) : filteredOut.add(change);
            }
            this.queueUpdatePresentation();
        }
        this.updatePresentation();
    }

    private final void queueUpdatePresentation() {
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)((Disposable)this.updateQueue), (Object)"update", () -> ChangesFilterer.queueUpdatePresentation$lambda$8(this));
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.updateQueue.queue((Update)disposableUpdate);
    }

    private final void updatePresentation() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> ChangesFilterer.updatePresentation$lambda$9(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProgressIndicator resetFilter() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            this.processedChanges = null;
            this.pendingChanges = null;
            this.filteredOutChanges = null;
            this.progressIndicator.cancel();
            ProgressIndicator progressIndicator = this.progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            return progressIndicator;
        }
    }

    private static final Change restartLoading$lambda$2(Change it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Change(it.getBeforeRevision(), it.getAfterRevision(), FileStatus.OBSOLETE);
    }

    private static final void restartLoading$lambda$5$lambda$4(ChangesFilterer this$0, List $changes, Filter $filter, List $pending, List $processed, List $filteredOut) {
        this$0.filterChanges($changes, $filter, $pending, $processed, $filteredOut);
    }

    private static final void restartLoading$lambda$5(ProgressIndicator $indicator, ChangesFilterer this$0, List $changes, Filter $filter, List $pending, List $processed, List $filteredOut) {
        ProgressManager.getInstance().runProcess(() -> ChangesFilterer.restartLoading$lambda$5$lambda$4(this$0, $changes, $filter, $pending, $processed, $filteredOut), $indicator);
    }

    private static final void queueUpdatePresentation$lambda$8(ChangesFilterer this$0) {
        this$0.updatePresentation();
    }

    private static final void updatePresentation$lambda$9(ChangesFilterer this$0) {
        this$0.updateQueue.cancelAllUpdates();
        this$0.listener.updateChanges();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChangesFilterer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Companion;", "", "<init>", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&J&\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\b\u0010\r\u001a\u00020\u000eH'J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "", "isAvailable", "", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "accept", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "acceptBulk", "", "changes", "", "getText", "", "getDescription", "intellij.platform.vcs.impl"})
    private static interface Filter {
        default public boolean isAvailable(@NotNull ChangesFilterer filterer) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            return true;
        }

        public boolean accept(@NotNull ChangesFilterer var1, @NotNull Change var2);

        @Nullable
        default public Collection<Change> acceptBulk(@NotNull ChangesFilterer filterer, @NotNull List<? extends Change> changes) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return null;
        }

        @Nls
        @NotNull
        public String getText();

        @Nls
        @Nullable
        default public String getDescription() {
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilterGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nChangesFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesFilterer.kt\ncom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilterGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,344:1\n774#2:345\n865#2,2:346\n1557#2:348\n1628#2,3:349\n37#3,2:352\n*S KotlinDebug\n*F\n+ 1 ChangesFilterer.kt\ncom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilterGroup\n*L\n323#1:345\n323#1:346,2\n324#1:348\n324#1:349,3\n325#1:352,2\n*E\n"})
    public static final class FilterGroup
    extends ActionGroup
    implements Toggleable,
    DumbAware {
        public FilterGroup() {
            this.setPopup(false);
            this.getTemplatePresentation().setText(VcsBundle.message((String)"action.filter.filter.by.text", (Object[])new Object[0]));
            this.getTemplatePresentation().setIconSupplier(FilterGroup::_init_$lambda$0);
            this.getTemplatePresentation().setDisableGroupIfEmpty(false);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChangesFilterer filterer = (ChangesFilterer)e.getData(DATA_KEY);
            if (filterer == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(filterer.rawChanges != null);
            Toggleable.setSelected((Presentation)e.getPresentation(), (filterer.activeFilter != null ? 1 : 0) != 0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Filter it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object = e;
            if (object == null || (object = (ChangesFilterer)object.getData(DATA_KEY)) == null) {
                Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return AnAction.EMPTY_ARRAY;
            }
            Object filterer = object;
            Object object2 = new AnAction[]{new Separator(VcsBundle.message((String)"action.filter.separator.text", (Object[])new Object[0]))};
            Object[] objectArray = object2;
            object2 = new Filter[]{MovesOnlyFilter.INSTANCE, NonImportantFilter.INSTANCE};
            object2 = CollectionsKt.listOf((Object[])object2);
            Object[] objectArray2 = objectArray;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Filter)element$iv$iv;
                boolean bl = false;
                if (!it.isAvailable((ChangesFilterer)filterer)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Filter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ToggleFilterAction((ChangesFilterer)filterer, it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return (AnAction[])ArraysKt.plus((Object[])objectArray2, (Object[])thisCollection$iv.toArray(new ToggleFilterAction[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        private static final Icon _init_$lambda$0() {
            return AllIcons.General.Filter;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \r2\u00020\u0001:\u0001\rB3\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState;", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "pending", "filteredOut", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getChanges", "()Ljava/util/List;", "getPending", "getFilteredOut", "Companion", "intellij.platform.vcs.impl"})
    public static final class FilteredState {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Change> changes;
        @NotNull
        private final List<Change> pending;
        @NotNull
        private final List<Change> filteredOut;

        private FilteredState(List<? extends Change> changes, List<? extends Change> pending, List<? extends Change> filteredOut) {
            this.changes = changes;
            this.pending = pending;
            this.filteredOut = filteredOut;
        }

        @NotNull
        public final List<Change> getChanges() {
            return this.changes;
        }

        @NotNull
        public final List<Change> getPending() {
            return this.pending;
        }

        @NotNull
        public final List<Change> getFilteredOut() {
            return this.filteredOut;
        }

        @JvmStatic
        @NotNull
        public static final FilteredState create(@NotNull List<? extends Change> changes) {
            return Companion.create(changes);
        }

        public /* synthetic */ FilteredState(List changes, List pending, List filteredOut, DefaultConstructorMarker $constructor_marker) {
            this(changes, pending, filteredOut);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007J0\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$FilteredState;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "pending", "filteredOut", "intellij.platform.vcs.impl"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final FilteredState create(@NotNull List<? extends Change> changes) {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                return this.create(changes, CollectionsKt.emptyList(), CollectionsKt.emptyList());
            }

            @NotNull
            public final FilteredState create(@NotNull List<? extends Change> changes, @NotNull List<? extends Change> pending, @NotNull List<? extends Change> filteredOut) {
                Intrinsics.checkNotNullParameter(changes, (String)"changes");
                Intrinsics.checkNotNullParameter(pending, (String)"pending");
                Intrinsics.checkNotNullParameter(filteredOut, (String)"filteredOut");
                return new FilteredState(CollectionsKt.toList((Iterable)changes), CollectionsKt.toList((Iterable)pending), CollectionsKt.toList((Iterable)filteredOut), null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Listener;", "", "updateChanges", "", "intellij.platform.vcs.impl"})
    public static interface Listener {
        public void updateChanges();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J&\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$MovesOnlyFilter;", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "<init>", "()V", "getText", "", "acceptBulk", "", "Lcom/intellij/openapi/vcs/changes/Change;", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "changes", "", "accept", "", "change", "intellij.platform.vcs.impl"})
    private static final class MovesOnlyFilter
    implements Filter {
        @NotNull
        public static final MovesOnlyFilter INSTANCE = new MovesOnlyFilter();

        private MovesOnlyFilter() {
        }

        @Override
        @NotNull
        public String getText() {
            String string = VcsBundle.message((String)"action.filter.moved.files.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @Nullable
        public Collection<Change> acceptBulk(@NotNull ChangesFilterer filterer, @NotNull List<? extends Change> changes) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            for (BulkMovesOnlyChangesFilter epFilter : BulkMovesOnlyChangesFilter.EP_NAME.getExtensionList()) {
                Collection<Change> filteredChanges = epFilter.filter(filterer.getProject(), changes);
                if (filteredChanges == null) continue;
                return filteredChanges;
            }
            return null;
        }

        @Override
        public boolean accept(@NotNull ChangesFilterer filterer, @NotNull Change change) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            ContentRevision contentRevision = change.getBeforeRevision();
            if (contentRevision == null) {
                return true;
            }
            ContentRevision bRev = contentRevision;
            ContentRevision contentRevision2 = change.getAfterRevision();
            if (contentRevision2 == null) {
                return true;
            }
            ContentRevision aRev = contentRevision2;
            if (Intrinsics.areEqual((Object)bRev.getFile(), (Object)aRev.getFile())) {
                return true;
            }
            if (bRev instanceof ByteBackedContentRevision && aRev instanceof ByteBackedContentRevision) {
                byte[] byArray = ((ByteBackedContentRevision)bRev).getContentAsBytes();
                if (byArray == null) {
                    return true;
                }
                byte[] bytes1 = byArray;
                byte[] byArray2 = ((ByteBackedContentRevision)aRev).getContentAsBytes();
                if (byArray2 == null) {
                    return true;
                }
                byte[] bytes2 = byArray2;
                return !Arrays.equals(bytes1, bytes2);
            }
            String string = bRev.getContent();
            if (string == null) {
                return true;
            }
            String content1 = string;
            String string2 = aRev.getContent();
            if (string2 == null) {
                return true;
            }
            String content2 = string2;
            return !Intrinsics.areEqual((Object)content1, (Object)content2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$NonImportantFilter;", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "<init>", "()V", "getText", "", "isAvailable", "", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "accept", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "intellij.platform.vcs.impl"})
    private static final class NonImportantFilter
    implements Filter {
        @NotNull
        public static final NonImportantFilter INSTANCE = new NonImportantFilter();

        private NonImportantFilter() {
        }

        @Override
        @NotNull
        public String getText() {
            String string = VcsBundle.message((String)"action.filter.non.important.files.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull ChangesFilterer filterer) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            return filterer.getProject() != null;
        }

        @Override
        public boolean accept(@NotNull ChangesFilterer filterer, @NotNull Change change) {
            Object object;
            DocumentContent diffContent2;
            DocumentContent diffContent1;
            String content2;
            String content1;
            Project project;
            block6: {
                Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                project = filterer.getProject();
                ContentRevision contentRevision = change.getBeforeRevision();
                if (contentRevision == null) {
                    return true;
                }
                ContentRevision bRev = contentRevision;
                ContentRevision contentRevision2 = change.getAfterRevision();
                if (contentRevision2 == null) {
                    return true;
                }
                ContentRevision aRev = contentRevision2;
                String string = bRev.getContent();
                if (string == null) {
                    return true;
                }
                content1 = string;
                String string2 = aRev.getContent();
                if (string2 == null) {
                    return true;
                }
                content2 = string2;
                DocumentContent documentContent = DiffContentFactory.getInstance().create(project, content1, bRev.getFile());
                Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
                diffContent1 = documentContent;
                DocumentContent documentContent2 = DiffContentFactory.getInstance().create(project, content2, aRev.getFile());
                Intrinsics.checkNotNullExpressionValue((Object)documentContent2, (String)"create(...)");
                diffContent2 = documentContent2;
                for (Object object2 : DiffIgnoredRangeProvider.EP_NAME.getExtensions()) {
                    DiffIgnoredRangeProvider it = (DiffIgnoredRangeProvider)object2;
                    boolean bl = false;
                    if (!(it.accepts(project, (DiffContent)diffContent1) && it.accepts(project, (DiffContent)diffContent2))) continue;
                    object = object2;
                    break block6;
                }
                object = null;
            }
            DiffIgnoredRangeProvider provider = (DiffIgnoredRangeProvider)object;
            if (provider == null) {
                return !Intrinsics.areEqual((Object)content1, (Object)content2);
            }
            List list = provider.getIgnoredRanges(project, (CharSequence)content1, (DiffContent)diffContent1);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIgnoredRanges(...)");
            List ignoredRanges1 = list;
            List list2 = provider.getIgnoredRanges(project, (CharSequence)content2, (DiffContent)diffContent2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIgnoredRanges(...)");
            List ignoredRanges2 = list2;
            BitSet bitSet = ComparisonManagerImpl.collectIgnoredRanges((List)ignoredRanges1);
            Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"collectIgnoredRanges(...)");
            BitSet ignored1 = bitSet;
            BitSet bitSet2 = ComparisonManagerImpl.collectIgnoredRanges((List)ignoredRanges2);
            Intrinsics.checkNotNullExpressionValue((Object)bitSet2, (String)"collectIgnoredRanges(...)");
            BitSet ignored2 = bitSet2;
            Range range = TrimUtil.trimExpandText((CharSequence)content1, (CharSequence)content2, (int)0, (int)0, (int)content1.length(), (int)content2.length(), (BitSet)ignored1, (BitSet)ignored2);
            return !range.isEmpty();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$ToggleFilterAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "filterer", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "filter", "Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;)V", "getFilterer", "()Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer;", "getFilter", "()Lcom/intellij/openapi/vcs/changes/ui/browser/ChangesFilterer$Filter;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.platform.vcs.impl"})
    private static final class ToggleFilterAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ChangesFilterer filterer;
        @NotNull
        private final Filter filter;

        public ToggleFilterAction(@NotNull ChangesFilterer filterer, @NotNull Filter filter) {
            Intrinsics.checkNotNullParameter((Object)filterer, (String)"filterer");
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            super(filter.getText(), filter.getDescription(), null);
            this.filterer = filterer;
            this.filter = filter;
        }

        @NotNull
        public final ChangesFilterer getFilterer() {
            return this.filterer;
        }

        @NotNull
        public final Filter getFilter() {
            return this.filter;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return Intrinsics.areEqual((Object)this.filterer.activeFilter, (Object)this.filter);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.filterer.setFilter(state ? this.filter : null);
        }
    }
}

