/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.inlay;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayGroup;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel;
import com.intellij.codeInsight.hints.settings.InlaySettingsConfigurableKt;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.inlay.UrlPathInlayAction;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProvider;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProviderSemElement;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProviderSemElementKt;
import com.intellij.microservices.url.inlay.UrlPathInlayLanguagesProvider;
import com.intellij.microservices.url.references.UrlPathContextKt;
import com.intellij.microservices.utils.MicroservicesUsageCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.semantic.SemService;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001-B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010,\u001a\u00020\u001b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001dR\u0016\u0010(\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001d\u00a8\u0006."}, d2={"Lcom/intellij/microservices/url/inlay/UrlPathInlayHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "languagesProvider", "Lcom/intellij/microservices/url/inlay/UrlPathInlayLanguagesProvider;", "UrlPathInlayHintsProvider", "(Lcom/intellij/microservices/url/inlay/UrlPathInlayLanguagesProvider;)V", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "Q", "", "event", "Ljava/awt/event/MouseEvent;", "actions", "", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "hint", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHint;", "createSettings", "name", "", "getName", "()Ljava/lang/String;", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "group", "Lcom/intellij/codeInsight/hints/InlayGroup;", "getGroup", "()Lcom/intellij/codeInsight/hints/InlayGroup;", "description", "getDescription", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "Q", "Companion", "intellij.microservices"})
public final class UrlPathInlayHintsProvider
implements InlayHintsProvider<NoSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPathInlayLanguagesProvider languagesProvider;
    @NotNull
    private static final ExtensionPointName<UrlPathInlayAction> EP_NAME = ExtensionPointName.Companion.create("com.intellij.microservices.urlInlayAction");
    @NotNull
    private static final SettingsKey<NoSettings> KEY = new SettingsKey("microservices.url.path.inlay.hints");

    public UrlPathInlayHintsProvider(@NotNull UrlPathInlayLanguagesProvider languagesProvider) {
        Intrinsics.checkNotNullParameter((Object)languagesProvider, (String)"languagesProvider");
        this.languagesProvider = languagesProvider;
    }

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project) || file.getProject().isDefault()) {
            return null;
        }
        SemService semService = SemService.getSemService((Project)file.getProject());
        return (InlayHintsCollector)new FactoryInlayHintsCollector(editor, this, semService, file){
            final /* synthetic */ UrlPathInlayHintsProvider this$0;
            final /* synthetic */ SemService $semService;
            final /* synthetic */ PsiFile $file;
            {
                this.this$0 = $receiver;
                this.$semService = $semService;
                this.$file = $file;
                super($editor);
            }

            public boolean collect(PsiElement element, Editor editor, InlayHintsSink sink) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                UrlPathContextKt.forbidExpensiveUrlContext(() -> getCollectorFor.1.Q(this.this$0, element, this.$semService, this.$file, this, sink, editor));
                return true;
            }

            private static final Sequence Q(UrlPathInlayHintsProviderSemElement urlPathInlayHintsProviderSemElement) {
                Intrinsics.checkNotNullParameter((Object)urlPathInlayHintsProviderSemElement, (String)"it");
                return CollectionsKt.asSequence((Iterable)urlPathInlayHintsProviderSemElement.getInlayHints());
            }

            private static final void Q(List list, Editor editor, PsiFile psiFile, UrlPathInlayHint urlPathInlayHint, UrlPathInlayHintsProvider urlPathInlayHintsProvider, MouseEvent mouseEvent, Point point) {
                Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"event");
                Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
                if (list.isEmpty()) {
                    HintManager.getInstance().showInformationHint(editor, MicroservicesBundle.message("microservices.inlay.no.actions.message", new Object[0]));
                } else if (list.size() == 1) {
                    ((UrlPathInlayAction)list.get(0)).actionPerformed(psiFile, editor, urlPathInlayHint, mouseEvent);
                } else {
                    UrlPathInlayHintsProvider.access$showPopupForActions(urlPathInlayHintsProvider, editor, psiFile, mouseEvent, list, urlPathInlayHint);
                }
                FeatureUsageTracker.getInstance().triggerFeatureUsed("spring.endpoint.actions");
            }

            private static final Unit Q(UrlPathInlayHintsProvider urlPathInlayHintsProvider, PsiElement psiElement, SemService semService, PsiFile psiFile, getCollectorFor.1 var4_4, InlayHintsSink inlayHintsSink, Editor editor) {
                UrlPathInlayLanguagesProvider urlPathInlayLanguagesProvider = UrlPathInlayHintsProvider.access$getLanguagesProvider$p(urlPathInlayHintsProvider);
                Intrinsics.checkNotNull((Object)semService);
                Sequence<UrlPathInlayHintsProviderSemElement> sequence = UrlPathInlayHintsProviderSemElementKt.selectProvidersFromGroups(UrlPathInlayHintsProvider.Companion.inlaysInElement$intellij_microservices(urlPathInlayLanguagesProvider, psiElement, semService));
                Sequence sequence2 = SequencesKt.flatMap(sequence, getCollectorFor.1::Q);
                block4: for (UrlPathInlayHint urlPathInlayHint : sequence2) {
                    List<UrlPathInlayAction> list = urlPathInlayHint.getAvailableActions(psiFile);
                    PresentationFactory presentationFactory = var4_4.getFactory();
                    boolean bl = false;
                    InlayPresentation inlayPresentation = presentationFactory.referenceOnHover(presentationFactory.withTooltip(UrlPathInlayHintsProvider.access$getTooltip(urlPathInlayHintsProvider, list), urlPathInlayHint.getPresentation(editor, var4_4.getFactory())), (arg_0, arg_1) -> getCollectorFor.1.Q(list, editor, psiFile, urlPathInlayHint, urlPathInlayHintsProvider, arg_0, arg_1));
                    switch (getCollectorFor.WhenMappings.$EnumSwitchMapping$0[urlPathInlayHint.getStyle().ordinal()]) {
                        case 1: {
                            inlayHintsSink.addBlockElement(urlPathInlayHint.getOffset(), false, true, urlPathInlayHint.getPriority(), inlayPresentation);
                            continue block4;
                        }
                        case 2: {
                            inlayHintsSink.addInlineElement(urlPathInlayHint.getOffset(), false, inlayPresentation, false);
                            continue block4;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
            }
        };
    }

    private final void Q(Editor editor, PsiFile psiFile, MouseEvent mouseEvent, List<? extends UrlPathInlayAction> list, UrlPathInlayHint urlPathInlayHint) {
        MicroservicesUsageCollector.INSTANCE.getURL_INLAY_ACTIONS_EVENT().log(psiFile.getProject());
        String string = MicroservicesBundle.message("microservices.inlay.actions.title", new Object[0]);
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<UrlPathInlayAction>(list, psiFile, editor, urlPathInlayHint, mouseEvent, string){
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ UrlPathInlayHint $hint;
            final /* synthetic */ MouseEvent $event;
            {
                this.$file = $file;
                this.$editor = $editor;
                this.$hint = $hint;
                this.$event = $event;
                super($super_call_param$1, $actions);
            }

            public Icon getIconFor(UrlPathInlayAction value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getIcon();
            }

            public String getTextFor(UrlPathInlayAction value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getName();
            }

            public PopupStep<?> onChosen(UrlPathInlayAction selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                return this.doFinalStep(() -> showPopupForActions.1.Q(selectedValue, this.$file, this.$editor, this.$hint, this.$event));
            }

            private static final void Q(UrlPathInlayAction urlPathInlayAction, PsiFile psiFile, Editor editor, UrlPathInlayHint urlPathInlayHint, MouseEvent mouseEvent) {
                urlPathInlayAction.actionPerformed(psiFile, editor, urlPathInlayHint, mouseEvent);
            }
        }).show(new RelativePoint(mouseEvent));
    }

    @NotNull
    public NoSettings createSettings() {
        return new NoSettings();
    }

    @NotNull
    public String getName() {
        return MicroservicesBundle.message("microservices.inlay.provider.name", new Object[0]);
    }

    @NotNull
    public SettingsKey<NoSettings> getKey() {
        return KEY;
    }

    @NotNull
    public InlayGroup getGroup() {
        return InlayGroup.URL_PATH_GROUP;
    }

    @NotNull
    public String getDescription() {
        return MicroservicesBundle.message("inlay.microservices.url.path.inlay.hints.description", new Object[0]);
    }

    @Nullable
    public String getPreviewText() {
        return null;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            public JComponent createComponent(ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return (JComponent)BuilderKt.panel(createConfigurable.1::Q);
            }

            private static final Unit Q(Panel panel) {
                Intrinsics.checkNotNullParameter((Object)panel, (String)"$this$panel");
                return Unit.INSTANCE;
            }
        };
    }

    @Nls
    private final String Q(List<? extends UrlPathInlayAction> list) {
        if (list.size() == 1) {
            Object[] objectArray = new Object[]{list.get(0).getName()};
            return MicroservicesBundle.message("microservices.inlay.one.action.tooltip", objectArray);
        }
        return MicroservicesBundle.message("microservices.inlay.tooltip", new Object[0]);
    }

    public static final /* synthetic */ void access$showPopupForActions(UrlPathInlayHintsProvider $this, Editor editor, PsiFile file, MouseEvent event, List actions, UrlPathInlayHint hint) {
        $this.Q(editor, file, event, actions, hint);
    }

    public static final /* synthetic */ String access$getTooltip(UrlPathInlayHintsProvider $this, List actions) {
        return $this.Q(actions);
    }

    public static final /* synthetic */ UrlPathInlayLanguagesProvider access$getLanguagesProvider$p(UrlPathInlayHintsProvider $this) {
        return $this.languagesProvider;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001eJ\u001d\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\"R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/microservices/url/inlay/UrlPathInlayHintsProvider$Companion;", "", "UrlPathInlayHintsProvider$Companion", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayAction;", "getEP_NAME$intellij_microservices", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "KEY", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/codeInsight/hints/NoSettings;", "inlaysInElement", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHintsProviderSemElement;", "urlPathInlayLanguagesProvider", "Lcom/intellij/microservices/url/inlay/UrlPathInlayLanguagesProvider;", "element", "Lcom/intellij/psi/PsiElement;", "semService", "Lcom/intellij/semantic/SemService;", "inlaysInElement$intellij_microservices", "setUrlPathInlaysEnabledForLanguage", "", "language", "Lcom/intellij/lang/Language;", "enabled", "", "setUrlPathInlaysEnabledForLanguage$intellij_microservices", "isUrlPathInlaysEnabledForLanguage", "isUrlPathInlaysEnabledForLanguage$intellij_microservices", "openUrlPathInlaySettings", "project", "Lcom/intellij/openapi/project/Project;", "openUrlPathInlaySettings$intellij_microservices", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<UrlPathInlayAction> getEP_NAME$intellij_microservices() {
            return EP_NAME;
        }

        @NotNull
        public final Sequence<UrlPathInlayHintsProviderSemElement> inlaysInElement$intellij_microservices(@NotNull UrlPathInlayLanguagesProvider urlPathInlayLanguagesProvider, @NotNull PsiElement element, @NotNull SemService semService) {
            Intrinsics.checkNotNullParameter((Object)urlPathInlayLanguagesProvider, (String)"urlPathInlayLanguagesProvider");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)semService, (String)"semService");
            return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)urlPathInlayLanguagesProvider.getPotentialElementsWithHintsProviders(element)), arg_0 -> Companion.Q(semService, arg_0));
        }

        public final void setUrlPathInlaysEnabledForLanguage$intellij_microservices(@NotNull Language language, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            InlayHintsSettings.Companion.instance().changeHintTypeStatus(KEY, language, enabled);
        }

        public final boolean isUrlPathInlaysEnabledForLanguage$intellij_microservices(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return InlayHintsSettings.Companion.instance().hintsShouldBeShown(KEY, language);
        }

        public final void openUrlPathInlaySettings$intellij_microservices(@NotNull Project project, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            InlaySettingsConfigurableKt.showInlaySettings((Project)project, (Language)language, Companion::Q);
        }

        private static final Sequence Q(SemService semService, PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"it");
            List list = semService.getSemElementsNoCache(UrlPathInlayHintsProviderSemElement.INLAY_HINT_SEM_KEY, psiElement);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSemElementsNoCache(...)");
            return CollectionsKt.asSequence((Iterable)list);
        }

        private static final boolean Q(InlayProviderSettingsModel inlayProviderSettingsModel) {
            Intrinsics.checkNotNullParameter((Object)inlayProviderSettingsModel, (String)"it");
            return Intrinsics.areEqual((Object)KEY.getId(), (Object)inlayProviderSettingsModel.getId());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

