/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.util.ast.DelimitedNode;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public abstract class DelimitedNodeImpl
extends Node
implements DelimitedNode {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        DelimitedNodeImpl.delimitedSegmentSpanChars(out, this.openingMarker, this.text, this.closingMarker, "text");
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    public DelimitedNodeImpl() {
    }

    public DelimitedNodeImpl(BasedSequence chars) {
        super(chars);
    }

    public DelimitedNodeImpl(BasedSequence openingMarker, BasedSequence text2, BasedSequence closingMarker) {
        super(openingMarker.baseSubSequence(openingMarker.getStartOffset(), closingMarker.getEndOffset()));
        this.openingMarker = openingMarker;
        this.text = text2;
        this.closingMarker = closingMarker;
    }

    @Override
    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    @Override
    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    @Override
    public BasedSequence getText() {
        return this.text;
    }

    @Override
    public void setText(BasedSequence text2) {
        this.text = text2;
    }

    @Override
    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    @Override
    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }
}

