/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.highlight;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.diff.Diff;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.highlight.HighlightedReportData;
import org.jetbrains.qodana.highlight.ProblemWithRange;
import org.jetbrains.qodana.highlight.QodanaRevisionData;
import org.jetbrains.qodana.problem.SarifProblem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0002J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\rH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/qodana/highlight/QodanaRangeCalculator;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "highlightedReportData", "Lorg/jetbrains/qodana/highlight/HighlightedReportData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/qodana/highlight/HighlightedReportData;)V", "calculateTextRanges", "", "Lorg/jetbrains/qodana/highlight/ProblemWithRange;", "relevantProblems", "Lorg/jetbrains/qodana/problem/SarifProblem;", "data", "Lorg/jetbrains/qodana/highlight/QodanaRevisionData;", "calculateTextRanges$intellij_qodana", "getTextRangesForRevision", "problems", "revisionDocument", "tryTranslateOffsetsByDiffs", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "", "endOffset", "diffs", "Lcom/intellij/diff/fragments/DiffFragment;", "isProblemSuppressed", "", "problem", "textRange", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaRangeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaRangeCalculator.kt\norg/jetbrains/qodana/highlight/QodanaRangeCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,122:1\n1485#2:123\n1510#2,3:124\n1513#2,3:134\n1557#2:143\n1628#2,3:144\n1863#2,2:147\n1734#2,3:149\n381#3,7:127\n77#4:137\n97#4,5:138\n*S KotlinDebug\n*F\n+ 1 QodanaRangeCalculator.kt\norg/jetbrains/qodana/highlight/QodanaRangeCalculator\n*L\n27#1:123\n27#1:124,3\n27#1:134,3\n42#1:143\n42#1:144,3\n89#1:147,2\n120#1:149,3\n27#1:127,7\n28#1:137\n28#1:138,5\n*E\n"})
public final class QodanaRangeCalculator {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Document document;
    @NotNull
    private final HighlightedReportData highlightedReportData;

    public QodanaRangeCalculator(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document, @NotNull HighlightedReportData highlightedReportData2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)highlightedReportData2, (String)"highlightedReportData");
        this.project = project;
        this.file = file;
        this.document = document;
        this.highlightedReportData = highlightedReportData2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProblemWithRange> calculateTextRanges$intellij_qodana(@NotNull List<SarifProblem> relevantProblems, @NotNull QodanaRevisionData data) {
        List list2;
        Intrinsics.checkNotNullParameter(relevantProblems, (String)"relevantProblems");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        QodanaRevisionData qodanaRevisionData = data;
        if (qodanaRevisionData instanceof QodanaRevisionData.VCSInfo) {
            void $this$flatMapTo$iv$iv;
            Map problemsByRevision;
            Object list$iv$iv;
            boolean bl;
            Map $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = relevantProblems;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object t2 = iterator2.next();
                SarifProblem it = (SarifProblem)t2;
                bl = false;
                String key$iv$iv = it.getRevisionId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                list$iv$iv = (List)object;
                list$iv$iv.add(t2);
            }
            Map $this$flatMap$iv = problemsByRevision = destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$groupByTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Map.Entry entry : $this$flatMapTo$iv$iv.entrySet()) {
                list$iv$iv = entry;
                bl = false;
                String revisionId = (String)list$iv$iv.getKey();
                List problems2 = (List)list$iv$iv.getValue();
                PsiFile psiFile2 = ((QodanaRevisionData.VCSInfo)data).getRevisionPsiFiles().get(revisionId);
                list$iv$iv = this.getTextRangesForRevision(problems2, psiFile2 != null && (psiFile2 = psiFile2.getViewProvider()) != null ? psiFile2.getDocument() : null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else if (qodanaRevisionData instanceof QodanaRevisionData.LocalInfo) {
            list2 = this.getTextRangesForRevision(relevantProblems, ((QodanaRevisionData.LocalInfo)data).getLocalDocumentData().getDocument());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List ranges2 = list2;
        return ranges2;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ProblemWithRange> getTextRangesForRevision(List<SarifProblem> problems, Document revisionDocument) {
        if (problems.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        $this$map$iv = problems;
        $i$f$map = false;
        var6_6 = $this$map$iv;
        destination$iv$iv = (ArrayList<ProblemWithRange>)new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var11_14 = (SarifProblem)item$iv$iv;
            var21_18 = destination$iv$iv;
            $i$a$-map-QodanaRangeCalculator$getTextRangesForRevision$rangesInCurrentDocument$1 = false;
            var21_18.add(new ProblemWithRange((SarifProblem)it, it.getTextRangeInDocument(this.document)));
        }
        rangesInCurrentDocument = destination$iv$iv;
        if (revisionDocument == null) {
            return rangesInCurrentDocument;
        }
        changes = Diff.buildChanges((CharSequence)revisionDocument.getText(), (CharSequence)this.document.getText());
        v0 = ByWordRt.compare((CharSequence)revisionDocument.getText(), (CharSequence)this.document.getText(), (ComparisonPolicy)ComparisonPolicy.DEFAULT, (CancellationChecker)CancellationChecker.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"compare(...)");
        diffs = v0;
        var6_7 = problems.size();
        var7_8 = new ArrayList<ProblemWithRange>(var6_7);
        for (var8_9 = 0; var8_9 < var6_7; ++var8_9) {
            block12: {
                block14: {
                    block13: {
                        block11: {
                            item$iv$iv = var9_11 = var8_9;
                            var21_18 = var7_8;
                            $i$a$-List-QodanaRangeCalculator$getTextRangesForRevision$1 = false;
                            problem = problems.get((int)index);
                            problemWithNullRange = new ProblemWithRange(problem, null);
                            localProblem = (ProblemWithRange)rangesInCurrentDocument.get((int)index);
                            if (problem.getStartLine() != null && problem.getStartLine() < revisionDocument.getLineCount() && problem.getStartColumn() != null) break block11;
                            v1 = localProblem;
                            break block12;
                        }
                        if (problem.getSnippetText() != null || Diff.translateLine((Diff.Change)changes, (int)problem.getStartLine()) != -1) break block13;
                        v1 = problemWithNullRange;
                        break block12;
                    }
                    v2 = problem.getCharLength();
                    if (v2 == null) break block14;
                    v3 = v2;
                    ** GOTO lbl48
                }
                if (problem.getEndLine() == null || problem.getEndLine() >= revisionDocument.getLineCount() || problem.getEndColumn() == null) {
                    v1 = localProblem;
                } else {
                    v3 = revisionDocument.getLineStartOffset(problem.getEndLine().intValue()) + problem.getEndColumn() - revisionDocument.getLineStartOffset(problem.getStartLine().intValue()) - problem.getStartColumn();
lbl48:
                    // 2 sources

                    problemLength = v3;
                    startOffsetInRevisionFile = revisionDocument.getLineStartOffset(problem.getStartLine().intValue()) + problem.getStartColumn();
                    lastRelatedIndex = CollectionsKt.binarySearch$default((List)diffs, (int)0, (int)0, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getTextRangesForRevision$lambda$4$lambda$3(int com.intellij.diff.fragments.DiffFragment ), (Lcom/intellij/diff/fragments/DiffFragment;)Ljava/lang/Integer;)((int)startOffsetInRevisionFile), (int)3, null);
                    if (lastRelatedIndex < 0) {
                        lastRelatedIndex = -lastRelatedIndex - 1;
                    }
                    if (this.tryTranslateOffsetsByDiffs(startOffsetInRevisionFile, startOffsetInRevisionFile + problemLength, relatedDiffs = diffs.subList(0, Math.min(lastRelatedIndex + 1, diffs.size()))) == null) {
                        v1 = localProblem;
                    } else if (textRange.getEndOffset() > this.document.getTextLength()) {
                        v1 = localProblem;
                    } else {
                        v4 = this.document.getText(textRange);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getText(...)");
                        textEqualToSnippet = problem.isEqualToSnippet(v4);
                        v1 = textEqualToSnippet == false ? problemWithNullRange : (this.isProblemSuppressed(problems.get((int)index), textRange, this.highlightedReportData) != false ? problemWithNullRange : new ProblemWithRange(problems.get((int)index), textRange));
                    }
                }
            }
            var21_18.add(v1);
        }
        return var7_8;
    }

    private final TextRange tryTranslateOffsetsByDiffs(int startOffset, int endOffset, List<? extends DiffFragment> diffs) {
        int newStartOffset = 0;
        newStartOffset = startOffset;
        int newEndOffset = 0;
        newEndOffset = endOffset;
        Iterable $this$forEach$iv = diffs;
        boolean bl = false;
        for (Object element$iv : $this$forEach$iv) {
            DiffFragment it = (DiffFragment)element$iv;
            boolean bl2 = false;
            if (it.getEndOffset1() > startOffset) continue;
            newStartOffset += it.getEndOffset2() - it.getStartOffset2() - (it.getEndOffset1() - it.getStartOffset1());
            newEndOffset += it.getEndOffset2() - it.getStartOffset2() - (it.getEndOffset1() - it.getStartOffset1());
        }
        for (DiffFragment diffFragment : diffs) {
            if (diffFragment.getStartOffset1() > startOffset || startOffset >= diffFragment.getEndOffset1()) continue;
            newStartOffset = diffFragment.getStartOffset2() + startOffset - diffFragment.getStartOffset1();
            newEndOffset = diffFragment.getStartOffset2() + endOffset - diffFragment.getStartOffset1();
            break;
        }
        for (DiffFragment diffFragment : diffs) {
            if (diffFragment.getStartOffset1() >= endOffset || endOffset > diffFragment.getEndOffset1() || startOffset > diffFragment.getStartOffset1()) continue;
            newEndOffset = diffFragment.getEndOffset2() + endOffset - diffFragment.getEndOffset1();
            break;
        }
        if (newEndOffset < newStartOffset) {
            return null;
        }
        return new TextRange(newStartOffset, newEndOffset);
    }

    private final boolean isProblemSuppressed(SarifProblem problem, TextRange textRange, HighlightedReportData highlightedReportData2) {
        boolean bl;
        block7: {
            if (DumbService.Companion.isDumb(this.project)) {
                return false;
            }
            PsiElement psiElement = this.file.findElementAt(textRange.getStartOffset());
            if (psiElement == null) {
                return false;
            }
            PsiElement element = psiElement;
            Language language = LanguageUtil.getFileLanguage((VirtualFile)element.getContainingFile().getVirtualFile());
            if (language == null) {
                return false;
            }
            Language language2 = language;
            List list2 = LanguageInspectionSuppressors.INSTANCE.allForLanguage(language2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"allForLanguage(...)");
            List inspectionSuppressors = list2;
            String string = highlightedReportData2.getInspectionsInfoProvider().getSuppressIdByInspection(problem.getInspectionId());
            if (string == null) {
                return false;
            }
            String toolId = string;
            Iterable $this$all$iv = inspectionSuppressors;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    InspectionSuppressor it = (InspectionSuppressor)element$iv;
                    boolean bl2 = false;
                    if (!it.isSuppressedFor(element, toolId)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return !bl;
    }

    private static final int getTextRangesForRevision$lambda$4$lambda$3(int $startOffsetInRevisionFile, DiffFragment it) {
        return it.getEndOffset1() - $startOffsetInRevisionFile;
    }
}

