/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnConfiguration;

public class PresentationSettingsPanel
implements ConfigurableUi<SvnConfiguration> {
    @NotNull
    private final Project myProject;
    private JPanel myMainPanel;
    private JCheckBox myCheckNestedInQuickMerge;
    private JCheckBox myIgnoreWhitespaceDifferenciesInCheckBox;
    private JCheckBox myShowMergeSourceInAnnotate;
    private JCheckBox myMaximumNumberOfRevisionsCheckBox;
    private JSpinner myNumRevsInAnnotations;

    public PresentationSettingsPanel(@NotNull Project project) {
        if (project == null) {
            PresentationSettingsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myMaximumNumberOfRevisionsCheckBox.addActionListener(e -> this.myNumRevsInAnnotations.setEnabled(this.myMaximumNumberOfRevisionsCheckBox.isSelected()));
        this.myNumRevsInAnnotations.setEnabled(this.myMaximumNumberOfRevisionsCheckBox.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            PresentationSettingsPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public void reset(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            PresentationSettingsPanel.$$$reportNull$$$0(2);
        }
        this.myCheckNestedInQuickMerge.setSelected(configuration.isCheckNestedForQuickMerge());
        this.myIgnoreWhitespaceDifferenciesInCheckBox.setSelected(configuration.isIgnoreSpacesInAnnotate());
        this.myShowMergeSourceInAnnotate.setSelected(configuration.isShowMergeSourcesInAnnotate());
        int annotateRevisions = configuration.getMaxAnnotateRevisions();
        if (annotateRevisions == -1) {
            this.myMaximumNumberOfRevisionsCheckBox.setSelected(false);
            this.myNumRevsInAnnotations.setValue(500);
        } else {
            this.myMaximumNumberOfRevisionsCheckBox.setSelected(true);
            this.myNumRevsInAnnotations.setValue(annotateRevisions);
        }
        this.myNumRevsInAnnotations.setEnabled(this.myMaximumNumberOfRevisionsCheckBox.isSelected());
    }

    public boolean isModified(@NotNull SvnConfiguration configuration) {
        boolean useMaxInAnnot;
        if (configuration == null) {
            PresentationSettingsPanel.$$$reportNull$$$0(3);
        }
        if (configuration.isCheckNestedForQuickMerge() != this.myCheckNestedInQuickMerge.isSelected()) {
            return true;
        }
        if (configuration.isIgnoreSpacesInAnnotate() != this.myIgnoreWhitespaceDifferenciesInCheckBox.isSelected()) {
            return true;
        }
        if (configuration.isShowMergeSourcesInAnnotate() != this.myShowMergeSourceInAnnotate.isSelected()) {
            return true;
        }
        int annotateRevisions = configuration.getMaxAnnotateRevisions();
        boolean bl = useMaxInAnnot = annotateRevisions != -1;
        if (useMaxInAnnot != this.myMaximumNumberOfRevisionsCheckBox.isSelected()) {
            return true;
        }
        return this.myMaximumNumberOfRevisionsCheckBox.isSelected() && annotateRevisions != ((SpinnerNumberModel)this.myNumRevsInAnnotations.getModel()).getNumber().intValue();
    }

    public void apply(@NotNull SvnConfiguration configuration) {
        if (configuration == null) {
            PresentationSettingsPanel.$$$reportNull$$$0(4);
        }
        configuration.setCheckNestedForQuickMerge(this.myCheckNestedInQuickMerge.isSelected());
        configuration.setIgnoreSpacesInAnnotate(this.myIgnoreWhitespaceDifferenciesInCheckBox.isSelected());
        configuration.setShowMergeSourcesInAnnotate(this.myShowMergeSourceInAnnotate.isSelected());
        if (!this.myMaximumNumberOfRevisionsCheckBox.isSelected()) {
            configuration.setMaxAnnotateRevisions(-1);
        } else {
            configuration.setMaxAnnotateRevisions(((SpinnerNumberModel)this.myNumRevsInAnnotations.getModel()).getNumber().intValue());
        }
    }

    private void createUIComponents() {
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        int value = configuration.getMaxAnnotateRevisions();
        value = value == -1 ? 500 : value;
        this.myNumRevsInAnnotations = new JSpinner(new SpinnerNumberModel(value, 10, 100000, 100));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCheckNestedInQuickMerge = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/SvnBundle", PresentationSettingsPanel.class).getString("settings.check.mergeinfo"));
        jPanel.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myMaximumNumberOfRevisionsCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/SvnBundle", PresentationSettingsPanel.class).getString("settings.maximum.revisions.number"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        JSpinner jSpinner = this.myNumRevsInAnnotations;
        jPanel.add((Component)jSpinner, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(70, -1), null));
        this.myShowMergeSourceInAnnotate = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/SvnBundle", PresentationSettingsPanel.class).getString("annotation.show.merge.sources.default.text"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoreWhitespaceDifferenciesInCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/SvnBundle", PresentationSettingsPanel.class).getString("svn.option.ignore.whitespace.in.annotate"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/PresentationSettingsPanel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/PresentationSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

