/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.HierarchicalColumnsCollapseManager;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.DataGridColors;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableEditorStructureViewModel
implements StructureViewModel,
StructureViewModel.ElementInfoProvider {
    private final Project myProject;
    private final DataGrid myDataGrid;
    private final List<Object> myListeners;
    private final Disposable myDisposable;

    public TableEditorStructureViewModel(@NotNull TableEditorBase editor) {
        if (editor == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(0);
        }
        this(editor.getProject(), editor.getDataGrid());
    }

    public TableEditorStructureViewModel(@NotNull Project project, @NotNull DataGrid dataGrid) {
        if (project == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(1);
        }
        if (dataGrid == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(2);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project;
        this.myDataGrid = dataGrid;
        this.myDataGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onSelectionChanged(DataGrid dataGrid) {
                for (Object listener2 : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener2 instanceof FileEditorPositionListener)) continue;
                    ((FileEditorPositionListener)listener2).onCurrentElementChanged();
                }
            }

            @Override
            public void onContentChanged(DataGrid dataGrid, @Nullable GridRequestSource.RequestPlace place) {
                for (Object listener2 : TableEditorStructureViewModel.this.myListeners) {
                    if (!(listener2 instanceof ModelListener)) continue;
                    ((ModelListener)listener2).onModelChanged();
                }
            }
        }, this.myDisposable);
    }

    @Nullable
    public Object getCurrentEditorElement() {
        ModelIndex column = this.myDataGrid.getSelectionModel().getSelectedColumn();
        return column.isValid((CoreGrid)this.myDataGrid) ? DataGridPomTarget.wrapColumn(this.myProject, this.myDataGrid, (ModelIndex<GridColumn>)column) : null;
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        if (listener2 == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(listener2);
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(5);
        }
        this.myListeners.add(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(6);
        }
        this.myListeners.remove(modelListener);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return new RootElement();
    }

    public Grouper @NotNull [] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(7);
        }
        return Grouper.EMPTY_ARRAY;
    }

    public Sorter @NotNull [] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(8);
        }
        return sorterArray;
    }

    public Filter @NotNull [] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            TableEditorStructureViewModel.$$$reportNull$$$0(9);
        }
        return Filter.EMPTY_ARRAY;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        return element instanceof ColElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/TableEditorStructureViewModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/TableEditorStructureViewModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addEditorPositionListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorPositionListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModelListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeModelListener";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private class RootElement
    implements StructureViewTreeElement {
        private RootElement() {
        }

        public Object getValue() {
            return this;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return new PresentationData();
        }

        public TreeElement @NotNull [] getChildren() {
            GridModel model2 = TableEditorStructureViewModel.this.myDataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            List columns = model2.getColumnIndices().asList();
            if (!columns.isEmpty()) {
                TreeElement[] result = new TreeElement[columns.size()];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = new ColElement(DataGridPomTarget.wrapColumn(TableEditorStructureViewModel.this.myProject, TableEditorStructureViewModel.this.myDataGrid, (ModelIndex<GridColumn>)((ModelIndex)columns.get(i))));
                }
                if (result == null) {
                    RootElement.$$$reportNull$$$0(0);
                }
                return result;
            }
            TreeElement[] treeElementArray = (TreeElement[])GridHelper.get(TableEditorStructureViewModel.this.myDataGrid).getChildrenFromModel(TableEditorStructureViewModel.this.myDataGrid).toArray((Object[])TreeElement.EMPTY_ARRAY);
            if (treeElementArray == null) {
                RootElement.$$$reportNull$$$0(1);
            }
            return treeElementArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$RootElement", "getChildren"));
        }
    }

    private static final class ColElement
    extends PsiTreeElementBase<PsiElement>
    implements ColoredItemPresentation,
    LocationPresentation {
        private ColElement(PsiElement element) {
            super(element);
        }

        public void navigate(boolean requestFocus) {
            HierarchicalColumnsCollapseManager collapseManager;
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return;
            }
            boolean enabled = target.dataGrid.isColumnEnabled(target.column);
            if (!enabled) {
                target.dataGrid.setColumnEnabled(target.column, true);
            }
            if ((collapseManager = target.dataGrid.getHierarchicalColumnsCollapseManager()) != null && collapseManager.isColumnHiddenDueToCollapse(target.column)) {
                return;
            }
            target.navigate(requestFocus);
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                ColElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public String getPresentableText() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            GridColumn column = target != null ? target.getColumn() : null;
            return column != null ? column.getName() : null;
        }

        public Icon getIcon(boolean open) {
            GridColumn column;
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            GridColumn gridColumn = column = target == null ? null : target.getColumn();
            if (column == null) {
                return null;
            }
            return GridHelper.get(target.dataGrid).getColumnIcon(target.dataGrid, column, true);
        }

        public String getLocationString() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            if (target == null) {
                return null;
            }
            return GridHelper.get(target.dataGrid).getLocationString(this.getElement());
        }

        public boolean isSearchInLocationString() {
            return true;
        }

        public String getLocationPrefix() {
            return " ";
        }

        public String getLocationSuffix() {
            return "";
        }

        @Nullable
        public TextAttributesKey getTextAttributesKey() {
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(this.getElement());
            ModelIndex<GridColumn> column = target != null ? target.column : null;
            return column != null && !target.dataGrid.isColumnEnabled(column) ? DataGridColors.STRUCTURE_HIDDEN_COLUMN : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/TableEditorStructureViewModel$ColElement", "getChildrenBase"));
        }
    }
}

