/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class GridCellRendererFactories {
    private static final Key<GridCellRendererFactories> RENDERER_FACTORIES_KEY = new Key("RENDERER_FACTORIES_KEY");
    private final List<GridCellRendererFactory> myDefaultFactories;

    public GridCellRendererFactories(@NotNull List<GridCellRendererFactory> factories) {
        if (factories == null) {
            GridCellRendererFactories.$$$reportNull$$$0(0);
        }
        this.myDefaultFactories = factories;
    }

    public void reinitSettings() {
        for (GridCellRendererFactory factory : this.myDefaultFactories) {
            factory.reinitSettings();
        }
    }

    public static void set(@NotNull DataGrid grid, @NotNull GridCellRendererFactories factories) {
        if (grid == null) {
            GridCellRendererFactories.$$$reportNull$$$0(1);
        }
        if (factories == null) {
            GridCellRendererFactories.$$$reportNull$$$0(2);
        }
        grid.putUserData(RENDERER_FACTORIES_KEY, factories);
    }

    @NotNull
    public static GridCellRendererFactories get(@NotNull DataGrid grid) {
        if (grid == null) {
            GridCellRendererFactories.$$$reportNull$$$0(3);
        }
        GridCellRendererFactories gridCellRendererFactories = Objects.requireNonNull((GridCellRendererFactories)grid.getUserData(RENDERER_FACTORIES_KEY));
        if (gridCellRendererFactories == null) {
            GridCellRendererFactories.$$$reportNull$$$0(4);
        }
        return gridCellRendererFactories;
    }

    List<GridCellRendererFactory> getFactoriesFor(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            GridCellRendererFactories.$$$reportNull$$$0(5);
        }
        if (column == null) {
            GridCellRendererFactories.$$$reportNull$$$0(6);
        }
        return ContainerUtil.filter(this.myDefaultFactories, factory -> factory.supports(row, column));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/GridCellRendererFactories";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFactoriesFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

