/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.cli.model.DockerRunCliValidator;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.settings.DockerExtraHost;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\t\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\rH\u0002\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u000eH\u0002\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u000f\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"PUBLISH_ALL_PORTS_OPTION", "", "PUBLISH_PORT_OPTION", "VOLUME_OPTION", "ENV_OPTION", "ADD_HOST_OPTION", "LINK_OPTION", "toCliPresentationOptions", "", "Lcom/intellij/docker/remote/DockerContainerSettings;", "tryReformatDockerRunCliOptions", "options", "toCliPresentation", "Lcom/intellij/docker/agent/settings/DockerPortBindingImpl;", "Lcom/intellij/docker/agent/settings/DockerVolumeBindingImpl;", "Lcom/intellij/docker/remote/settings/DockerExtraHost;", "Lcom/intellij/docker/agent/settings/DockerLink;", "intellij.clouds.docker.remoteRun"})
@JvmName(name="DockerCliPresentationUtil")
@SourceDebugExtension(value={"SMAP\nDockerCliPresentationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerCliPresentationUtil.kt\ncom/intellij/docker/remote/DockerCliPresentationUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1557#2:92\n1628#2,3:93\n1557#2:96\n1628#2,3:97\n1557#2:100\n1628#2,3:101\n1557#2:104\n1628#2,2:105\n1630#2:108\n1#3:107\n*S KotlinDebug\n*F\n+ 1 DockerCliPresentationUtil.kt\ncom/intellij/docker/remote/DockerCliPresentationUtil\n*L\n56#1:92\n56#1:93,3\n58#1:96\n58#1:97,3\n60#1:100\n60#1:101,3\n61#1:104\n61#1:105,2\n61#1:108\n*E\n"})
public final class DockerCliPresentationUtil {
    @NotNull
    private static final String PUBLISH_ALL_PORTS_OPTION = "-P";
    @NotNull
    private static final String PUBLISH_PORT_OPTION = "-p";
    @NotNull
    private static final String VOLUME_OPTION = "-v";
    @NotNull
    private static final String ENV_OPTION = "--env";
    @NotNull
    private static final String ADD_HOST_OPTION = "--add-host";
    @NotNull
    private static final String LINK_OPTION = "--link";

    @NotNull
    public static final List<String> toCliPresentationOptions(@NotNull DockerContainerSettings $this$toCliPresentationOptions) {
        List options;
        block9: {
            Object it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$map;
            List list2;
            Intrinsics.checkNotNullParameter((Object)$this$toCliPresentationOptions, (String)"<this>");
            options = new ArrayList();
            if ($this$toCliPresentationOptions.isPublishAllPorts()) {
                options.add(PUBLISH_ALL_PORTS_OPTION);
            } else {
                List<DockerPortBindingImpl> list3 = $this$toCliPresentationOptions.getPortBindings();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"getPortBindings(...)");
                if (!((Collection)list3).isEmpty()) {
                    List<DockerPortBindingImpl> list4 = $this$toCliPresentationOptions.getPortBindings();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"getPortBindings(...)");
                    options.add(CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)" ", null, null, (int)0, null, DockerCliPresentationUtil::toCliPresentationOptions$lambda$0, (int)30, null));
                }
            }
            if ($this$toCliPresentationOptions.getVersion() < 2) {
                List<DockerLinkImpl> list5 = $this$toCliPresentationOptions.getLinks();
                Intrinsics.checkNotNullExpressionValue(list5, (String)"getLinks(...)");
                Iterable iterable = list5;
                list2 = options;
                $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    DockerLinkImpl dockerLinkImpl = (DockerLinkImpl)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(DockerCliPresentationUtil.toCliPresentation((DockerLink)it));
                }
                list2.addAll((List)destination$iv$iv);
                List<DockerExtraHost> list6 = $this$toCliPresentationOptions.getExtraHosts();
                Intrinsics.checkNotNullExpressionValue(list6, (String)"getExtraHosts(...)");
                $this$map$iv = list6;
                list2 = options;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (DockerExtraHost)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(DockerCliPresentationUtil.toCliPresentation((DockerExtraHost)it));
                }
                list2.addAll((List)destination$iv$iv);
            }
            List<DockerVolumeBindingImpl> list7 = $this$toCliPresentationOptions.getVolumeBindings();
            Intrinsics.checkNotNullExpressionValue(list7, (String)"getVolumeBindings(...)");
            $this$map$iv = list7;
            list2 = options;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DockerVolumeBindingImpl)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(DockerCliPresentationUtil.toCliPresentation((DockerVolumeBindingImpl)it));
            }
            list2.addAll((List)destination$iv$iv);
            List<DockerEnvVarImpl> list8 = $this$toCliPresentationOptions.getEnvVars();
            Intrinsics.checkNotNullExpressionValue(list8, (String)"getEnvVars(...)");
            $this$map$iv = list8;
            list2 = options;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (DockerEnvVarImpl)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String rightPart = ParametersListUtil.escape((CharSequence)(((DockerEnvVarImpl)it).getName() + "=" + ((DockerEnvVarImpl)it).getValue()));
                boolean bl2 = false;
                collection.add("--env " + rightPart);
            }
            list2.addAll((List)destination$iv$iv);
            if ($this$toCliPresentationOptions.getVersion() < 2) break block9;
            String string = $this$toCliPresentationOptions.getRunCliOptions();
            if (string != null) {
                String it2 = string;
                boolean bl = false;
                options.add(it2);
            }
        }
        return DockerCliPresentationUtil.tryReformatDockerRunCliOptions(options);
    }

    private static final List<String> tryReformatDockerRunCliOptions(List<String> options) {
        List<String> list2;
        String optionsLine = CollectionsKt.joinToString$default((Iterable)options, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        try {
            list2 = new DockerRunCliValidator().tryValidateCliOptions(optionsLine).groupByOptions();
        }
        catch (ParseException e) {
            list2 = options;
        }
        catch (CliParserBase.IllegalOptionException e) {
            list2 = options;
        }
        return list2;
    }

    private static final String toCliPresentation(DockerPortBindingImpl $this$toCliPresentation) {
        return "-p " + $this$toCliPresentation.toCommandLineString();
    }

    private static final String toCliPresentation(DockerVolumeBindingImpl $this$toCliPresentation) {
        return "-v " + $this$toCliPresentation.toCommandLineString();
    }

    @NotNull
    public static final String toCliPresentation(@NotNull DockerExtraHost $this$toCliPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$toCliPresentation, (String)"<this>");
        return "--add-host=" + $this$toCliPresentation.getHostname() + ":" + $this$toCliPresentation.getIP();
    }

    @NotNull
    public static final String toCliPresentation(@NotNull DockerLink $this$toCliPresentation) {
        Intrinsics.checkNotNullParameter((Object)$this$toCliPresentation, (String)"<this>");
        return "--link " + $this$toCliPresentation.getName() + ":" + $this$toCliPresentation.getAlias();
    }

    private static final CharSequence toCliPresentationOptions$lambda$0(DockerPortBindingImpl it) {
        Intrinsics.checkNotNull((Object)it);
        return DockerCliPresentationUtil.toCliPresentation(it);
    }
}

