/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.image.layers;

import com.intellij.docker.agent.image.layers.DockerImageLayersAnalyzer;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.view.details.image.layers.DockerImageLayerDownloadNonOpenableFile;
import com.intellij.docker.view.details.image.layers.DockerImageLayerFileNodeWrapper;
import com.intellij.docker.view.details.image.layers.DockerImageLayerFileNodeWrapperKt;
import com.intellij.docker.view.details.image.layers.DockerImageLayersOpenFileAction;
import com.intellij.docker.view.details.image.layers.DockerImageLayersSortByActionGroup;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/view/details/image/layers/DockerImageLayerFilesTree;", "Lcom/intellij/ui/treeStructure/Tree;", "image", "Lcom/intellij/docker/runtimes/DockerImageRuntime;", "roots", "", "Lcom/intellij/docker/agent/image/layers/DockerImageLayersAnalyzer$Layer$LayerFileNode;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/docker/runtimes/DockerImageRuntime;Ljava/util/Set;Lcom/intellij/openapi/project/Project;)V", "sortModel", "", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/docker/view/details/image/layers/DockerImageLayerFileNodeWrapper;", "Lkotlin/Comparator;", "DockerImageLayersTreeCellRenderer", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerImageLayerFilesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerImageLayerFilesTree.kt\ncom/intellij/docker/view/details/image/layers/DockerImageLayerFilesTree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1863#2,2:112\n*S KotlinDebug\n*F\n+ 1 DockerImageLayerFilesTree.kt\ncom/intellij/docker/view/details/image/layers/DockerImageLayerFilesTree\n*L\n56#1:112,2\n*E\n"})
public final class DockerImageLayerFilesTree
extends Tree {
    @NotNull
    private final DockerImageRuntime image;
    @NotNull
    private final Set<DockerImageLayersAnalyzer.Layer.LayerFileNode> roots;
    @NotNull
    private final Project project;

    /*
     * WARNING - void declaration
     */
    public DockerImageLayerFilesTree(@NotNull DockerImageRuntime image, @NotNull Set<DockerImageLayersAnalyzer.Layer.LayerFileNode> roots, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.image = image;
        this.roots = roots;
        this.project = project;
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)((Object)this));
        Object object = new KeyStroke[]{KeyStroke.getKeyStroke(10, 0)};
        UiUtils.addKeyboardAction((JComponent)((JComponent)((Object)this)), (KeyStroke[])object, arg_0 -> DockerImageLayerFilesTree._init_$lambda$0(this, arg_0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getClickCount() == 2) {
                    Object object = this.getLastSelectedPathComponent();
                    DockerImageLayerFileNodeWrapper dockerImageLayerFileNodeWrapper = object instanceof DockerImageLayerFileNodeWrapper ? (DockerImageLayerFileNodeWrapper)object : null;
                    if (dockerImageLayerFileNodeWrapper == null) {
                        return;
                    }
                    DockerImageLayerFileNodeWrapper node = dockerImageLayerFileNodeWrapper;
                    DockerImageLayerFileNodeWrapperKt.openFileInEditorIfPossible(node, project, image);
                }
            }
        });
        this.setLargeModel(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        Object object2 = object = new DefaultMutableTreeNode();
        DockerImageLayerFilesTree dockerImageLayerFilesTree = this;
        boolean bl = false;
        Iterable $this$forEach$iv = this.roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void root;
            DockerImageLayersAnalyzer.Layer.LayerFileNode it = (DockerImageLayersAnalyzer.Layer.LayerFileNode)element$iv;
            boolean bl2 = false;
            root.add(new DockerImageLayerFileNodeWrapper(it));
        }
        TreeNode treeNode = (TreeNode)object;
        dockerImageLayerFilesTree.setModel(new DefaultTreeModel(treeNode));
        this.setCellRenderer((TreeCellRenderer)((Object)new DockerImageLayersTreeCellRenderer()));
        object = new AnAction[]{new DockerImageLayerDownloadNonOpenableFile(this, this.image), new DockerImageLayersOpenFileAction(this, this.image)};
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this)), (ActionGroup)((ActionGroup)new DefaultActionGroup((AnAction[])object)), (String)"unknown");
        this.sortModel(DockerImageLayersSortByActionGroup.SortByOptions.NAME.getComparator());
    }

    public final void sortModel(@NotNull Comparator<DockerImageLayerFileNodeWrapper> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        TreeModel treeModel = this.getModel();
        Intrinsics.checkNotNull((Object)treeModel, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        DefaultTreeModel model2 = (DefaultTreeModel)treeModel;
        TreeUtil.sort((DefaultTreeModel)model2, comparator);
        model2.reload();
        TreeUtil.expand((JTree)((JTree)((Object)this)), (int)3);
    }

    private static final Unit _init_$lambda$0(DockerImageLayerFilesTree this$0, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object object = this$0.getLastSelectedPathComponent();
            DockerImageLayerFileNodeWrapper dockerImageLayerFileNodeWrapper = object instanceof DockerImageLayerFileNodeWrapper ? (DockerImageLayerFileNodeWrapper)object : null;
            if (dockerImageLayerFileNodeWrapper == null) break block0;
            DockerImageLayerFileNodeWrapperKt.openFileInEditorIfPossible(dockerImageLayerFileNodeWrapper, this$0.project, this$0.image);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/view/details/image/layers/DockerImageLayerFilesTree$DockerImageLayersTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.clouds.docker"})
    private static final class DockerImageLayersTreeCellRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            DockerImageLayerFileNodeWrapper dockerImageLayerFileNodeWrapper = value instanceof DockerImageLayerFileNodeWrapper ? (DockerImageLayerFileNodeWrapper)value : null;
            if (dockerImageLayerFileNodeWrapper == null) {
                return;
            }
            DockerImageLayerFileNodeWrapper node = dockerImageLayerFileNodeWrapper;
            DockerImageLayersAnalyzer.FileInfo fileInfo = node.getInfo();
            if (fileInfo.getLink() == null) {
                this.append(node.getName());
                this.setIcon(fileInfo.isDirectory() ? AllIcons.Nodes.Folder : FileTypeManagerEx.getInstanceEx().getFileTypeByFileName(node.getName()).getIcon());
                this.append(DockerUiUtilsKt.asNlsSafe(" (" + FileUtils.byteCountToDisplaySize((long)node.getSize()) + ")"), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                this.append(node.getName() + DockerUiUtilsKt.asNlsSafe(" -> " + fileInfo.getLink()));
                this.setIcon(AllIcons.Nodes.Symlink);
            }
            if (fileInfo.getTempFileForPreviewPath() != null) {
                DockerUiUtilsKt.appendSpace((SimpleColoredComponent)this);
                this.append(DockerBundle.message("DockerImageLayersTab.element.openable", new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            }
        }
    }
}

