/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.core.jupyter.remote.vfs;

import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterVFileEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J,\u0010\u0014\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ4\u0010\u001b\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017J\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0006R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVfsEventDispatcher;", "", "<init>", "()V", "legacyEvents", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "busPublisher", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterVFileEvent$Listener;", "getBusPublisher", "()Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterVFileEvent$Listener;", "clear", "", "fireFileCreatedLocally", "requestor", "file", "Lcom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "fireFileCreatedRemotely", "withFileDeletedLocallyEvent", "T", "handler", "Lkotlin/Function0;", "fireFileDeletedRemotely", "path", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "withFileRenamedLocallyEvent", "newName", "", "fireAuthorityCreated", "fireFileUploadQueued", "fireFileUploadFinished", "removeVirtualFileListener", "listener", "addVirtualFileListener", "intellij.notebooks.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteVfsEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteVfsEventDispatcher.kt\ncom/intellij/notebooks/core/jupyter/remote/vfs/JupyterRemoteVfsEventDispatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class JupyterRemoteVfsEventDispatcher {
    @NotNull
    private final EventDispatcher<VirtualFileListener> legacyEvents;

    public JupyterRemoteVfsEventDispatcher() {
        EventDispatcher eventDispatcher = EventDispatcher.create(VirtualFileListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.legacyEvents = eventDispatcher;
    }

    private final JupyterVFileEvent.Listener getBusPublisher() {
        return (JupyterVFileEvent.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JupyterVFileEvent.Companion.getTOPIC());
    }

    public final void clear() {
        for (VirtualFileListener listener2 : this.legacyEvents.getListeners()) {
            this.legacyEvents.removeListener((EventListener)listener2);
        }
    }

    public final void fireFileCreatedLocally(@Nullable Object requestor, @NotNull JupyterRemoteVirtualFile file) {
        block0: {
            JupyterVFileEvent.AuthorityCreated authorityCreated;
            Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
            Pair pair = file.getJupyterRemoteParent() != null ? TuplesKt.to((Object)new VFileCreateEvent(requestor, (VirtualFile)file.getJupyterRemoteParent(), file.getName(), file.isDirectory(), null, null, null), null) : TuplesKt.to(null, (Object)new JupyterVFileEvent.AuthorityCreated(file));
            VFileCreateEvent newStyleEvent = (VFileCreateEvent)pair.component1();
            JupyterVFileEvent.AuthorityCreated jupyterEvent = (JupyterVFileEvent.AuthorityCreated)pair.component2();
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
            BulkFileListener publisher = (BulkFileListener)messageBus.syncPublisher(topic);
            ActionsKt.runWriteAction(() -> JupyterRemoteVfsEventDispatcher.fireFileCreatedLocally$lambda$2(newStyleEvent, this, file, publisher));
            JupyterVFileEvent.AuthorityCreated authorityCreated2 = jupyterEvent;
            if (authorityCreated2 == null) break block0;
            JupyterVFileEvent.AuthorityCreated it = authorityCreated = authorityCreated2;
            boolean bl = false;
            this.getBusPublisher().invoke(it);
        }
    }

    public final void fireFileCreatedRemotely(@NotNull JupyterRemoteVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.getBusPublisher().invoke(new JupyterVFileEvent.CreatedOnServer(file));
    }

    public final <T> void withFileDeletedLocallyEvent(@Nullable Object requestor, @NotNull JupyterRemoteVirtualFile file, @NotNull Function0<? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ((VirtualFileListener)this.legacyEvents.getMulticaster()).beforeFileDeletion(new VirtualFileEvent(requestor, (VirtualFile)file, file.getParent(), 0L, 0L));
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus.syncPublisher(topic)).before(CollectionsKt.listOf((Object)new VFileDeleteEvent(requestor, (VirtualFile)file)));
        handler.invoke();
        ((VirtualFileListener)this.legacyEvents.getMulticaster()).fileDeleted(new VirtualFileEvent(requestor, (VirtualFile)file, file.getParent(), 0L, 0L));
        MessageBus messageBus2 = ApplicationManager.getApplication().getMessageBus();
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus2.syncPublisher(topic2)).after(CollectionsKt.listOf((Object)new VFileDeleteEvent(requestor, (VirtualFile)file)));
    }

    public final void fireFileDeletedRemotely(@NotNull JupyterRemotePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.getBusPublisher().invoke(new JupyterVFileEvent.DeletedOnServer(path));
    }

    public final <T> void withFileRenamedLocallyEvent(@Nullable Object requestor, @NotNull JupyterRemoteVirtualFile file, @NotNull String newName, @NotNull Function0<? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        String oldName = file.getName();
        VirtualFilePropertyEvent legacyEvent = new VirtualFilePropertyEvent(requestor, (VirtualFile)file, "name", (Object)oldName, (Object)newName);
        VFilePropertyChangeEvent event = new VFilePropertyChangeEvent(requestor, (VirtualFile)file, "name", (Object)oldName, (Object)newName);
        ((VirtualFileListener)this.legacyEvents.getMulticaster()).beforePropertyChange(legacyEvent);
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus.syncPublisher(topic)).before(CollectionsKt.listOf((Object)event));
        handler.invoke();
        ((VirtualFileListener)this.legacyEvents.getMulticaster()).propertyChanged(legacyEvent);
        MessageBus messageBus2 = ApplicationManager.getApplication().getMessageBus();
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus2.syncPublisher(topic2)).after(CollectionsKt.listOf((Object)event));
    }

    public final void fireAuthorityCreated(@NotNull JupyterRemoteVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.getBusPublisher().invoke(new JupyterVFileEvent.AuthorityCreated(file));
    }

    public final void fireFileUploadQueued(@NotNull JupyterRemotePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.getBusPublisher().invoke(new JupyterVFileEvent.UploadQueued(path));
    }

    public final void fireFileUploadFinished(@NotNull JupyterRemotePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.getBusPublisher().invoke(new JupyterVFileEvent.UploadFinished(path));
    }

    public final void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.legacyEvents.removeListener((EventListener)listener2);
    }

    public final void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.legacyEvents.addListener((EventListener)listener2);
    }

    private static final Unit fireFileCreatedLocally$lambda$2(VFileCreateEvent $newStyleEvent, JupyterRemoteVfsEventDispatcher this$0, JupyterRemoteVirtualFile $file, BulkFileListener $publisher) {
        Unit unit;
        VFileCreateEvent it;
        VFileCreateEvent vFileCreateEvent = $newStyleEvent;
        if (vFileCreateEvent != null) {
            it = vFileCreateEvent;
            boolean bl = false;
            $publisher.before(CollectionsKt.listOf((Object)it));
        }
        ((VirtualFileListener)this$0.legacyEvents.getMulticaster()).fileCreated(new VirtualFileEvent(null, (VirtualFile)$file, $file.getParent(), 0L, 0L));
        VFileCreateEvent vFileCreateEvent2 = $newStyleEvent;
        if (vFileCreateEvent2 != null) {
            it = vFileCreateEvent2;
            boolean bl = false;
            $publisher.after(CollectionsKt.listOf((Object)it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }
}

