/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.r.inlays.components;

import com.intellij.notebooks.visualization.r.inlays.components.HSLUtilKt;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002J'\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001c\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/components/ImageInverter;", "", "foreground", "Ljava/awt/Color;", "background", "<init>", "(Ljava/awt/Color;Ljava/awt/Color;)V", "rgb", "", "hsl", "whiteHsl", "blackHsl", "shouldInvert", "", "image", "Ljava/awt/image/BufferedImage;", "brightnessThreshold", "", "getImageSample", "", "getBrightness", "", "argb", "", "hasAlpha", "hasLightBackground", "colors", "([IZD)Ljava/lang/Boolean;", "invert", "color", "", "content", "invertInPlace", "", "outputImage", "createImageWithInvertedPalette", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nImageInverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageInverter.kt\ncom/intellij/notebooks/visualization/r/inlays/components/ImageInverter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n11195#2:181\n11530#2,3:182\n10649#2:185\n10889#2,3:186\n10892#2,3:196\n381#3,7:189\n1#4:199\n*S KotlinDebug\n*F\n+ 1 ImageInverter.kt\ncom/intellij/notebooks/visualization/r/inlays/components/ImageInverter\n*L\n43#1:181\n43#1:182,3\n97#1:185\n97#1:186,3\n97#1:196,3\n97#1:189,7\n*E\n"})
public final class ImageInverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] rgb;
    @NotNull
    private final float[] hsl;
    @NotNull
    private final float[] whiteHsl;
    @NotNull
    private final float[] blackHsl;
    private static final int SATURATION = 1;
    private static final int LUMINANCE = 2;
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;

    public ImageInverter(@NotNull Color foreground, @NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        this.rgb = new float[3];
        this.hsl = new float[3];
        this.whiteHsl = new float[3];
        this.blackHsl = new float[3];
        foreground.getRGBColorComponents(this.rgb);
        HSLUtilKt.convertRGBtoHSL(this.rgb, this.whiteHsl);
        background.getRGBColorComponents(this.rgb);
        HSLUtilKt.convertRGBtoHSL(this.rgb, this.blackHsl);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean shouldInvert(@NotNull BufferedImage image, double brightnessThreshold) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int[] colors = this.getImageSample(image);
        int numberOfColorsInComplexImage = 5000;
        int numberOfPixels = colors.length;
        int numberOfColorsThreshold = Math.min(numberOfPixels / 3, numberOfColorsInComplexImage);
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int[] $this$map$iv = colors;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var18_16 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(this.getBrightness((int)it, hasAlpha)));
        }
        float averageBrightness = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv)) / (float)numberOfPixels;
        Set numberOfColors = ArraysKt.toSet((int[])colors);
        return (double)averageBrightness > brightnessThreshold && numberOfColors.size() < numberOfColorsThreshold || Intrinsics.areEqual((Object)this.hasLightBackground(colors, hasAlpha, brightnessThreshold), (Object)true);
    }

    public static /* synthetic */ boolean shouldInvert$default(ImageInverter imageInverter, BufferedImage bufferedImage, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.7;
        }
        return imageInverter.shouldInvert(bufferedImage, d);
    }

    private final int[] getImageSample(BufferedImage image) {
        if (image.getHeight() < 10 || image.getWidth() < 10) {
            int[] colors = new int[image.getHeight() * image.getWidth()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), colors, 0, image.getWidth());
            return colors;
        }
        int defaultSpotSize = Math.min(Math.max(image.getHeight() / 10, image.getWidth() / 10), Math.min(image.getHeight(), image.getWidth()));
        int spotHeight = Math.min(image.getHeight(), defaultSpotSize);
        int spotWidth = Math.min(image.getWidth(), defaultSpotSize);
        int spotSize = spotHeight * spotWidth;
        int[] colors = new int[spotSize * 5];
        image.getRGB(0, 0, spotWidth, spotHeight, colors, 0, spotWidth);
        image.getRGB(image.getWidth() - spotWidth, 0, spotWidth, spotHeight, colors, spotSize, spotWidth);
        image.getRGB(0, image.getHeight() - spotHeight, spotWidth, spotHeight, colors, 2 * spotSize, spotWidth);
        image.getRGB(image.getWidth() - spotWidth, image.getHeight() - spotHeight, spotWidth, spotHeight, colors, 3 * spotSize, spotWidth);
        int centralSpotX = image.getWidth() / spotWidth / 2 * spotWidth;
        int centralSpotY = image.getHeight() / spotHeight / 2 * spotHeight;
        image.getRGB(centralSpotX, centralSpotY, spotWidth, spotHeight, colors, 4 * spotSize, spotWidth);
        return colors;
    }

    private final float getBrightness(int argb, boolean hasAlpha) {
        Color color = new Color(argb, hasAlpha);
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return hsb[2];
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean hasLightBackground(int[] colors, boolean hasAlpha, double brightnessThreshold) {
        Object v1;
        void $this$groupByTo$iv$iv;
        int[] $this$groupBy$iv = colors;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        int n = ((void)$this$groupByTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            void element$iv$iv;
            void it = element$iv$iv = $this$groupByTo$iv$iv[i];
            boolean bl = false;
            Integer key$iv$iv = (int)it;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add((int)element$iv$iv);
        }
        Iterable iterable = destination$iv$iv.entrySet();
        object = iterable.iterator();
        if (!object.hasNext()) {
            v1 = null;
        } else {
            Object e = object.next();
            if (!object.hasNext()) {
                v1 = e;
            } else {
                Map.Entry it = (Map.Entry)e;
                boolean bl = false;
                int n2 = ((List)it.getValue()).size();
                do {
                    Object e2 = object.next();
                    Map.Entry it2 = (Map.Entry)e2;
                    $i$a$-maxByOrNull-ImageInverter$hasLightBackground$dominantColorPair$2 = false;
                    n = ((List)it2.getValue()).size();
                    if (n2 >= n) continue;
                    e = e2;
                    n2 = n;
                } while (object.hasNext());
                v1 = e;
            }
        }
        Map.Entry entry = v1;
        if (entry == null) {
            return null;
        }
        Map.Entry dominantColorPair = entry;
        int dominantColor = ((Number)dominantColorPair.getKey()).intValue();
        List dominantPixels = (List)dominantColorPair.getValue();
        return (double)dominantPixels.size() / (double)colors.length > 0.5 && (double)this.getBrightness(dominantColor, hasAlpha) > brightnessThreshold;
    }

    @NotNull
    public final Color invert(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float alpha = this.invert(color.getRGB());
        int argb = HSLUtilKt.convertHSLtoRGB(this.hsl, alpha);
        return new Color(argb, true);
    }

    @NotNull
    public final BufferedImage invert(@NotNull BufferedImage image) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage outputImage = bufferedImage = this.createImageWithInvertedPalette(image);
        boolean bl = false;
        this.invertInPlace(image, outputImage);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] invert(@NotNull byte[] content) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(content));
        if (bufferedImage == null) {
            return content;
        }
        BufferedImage image = bufferedImage;
        BufferedImage outputImage = this.createImageWithInvertedPalette(image);
        this.invertInPlace(image, outputImage);
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            ImageIO.write((RenderedImage)outputImage, "png", outputStream);
            outputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    private final void invertInPlace(BufferedImage image, BufferedImage outputImage) {
        int[] rgbArray = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
        Intrinsics.checkNotNull((Object)rgbArray);
        if (rgbArray.length == 0) {
            return;
        }
        int prevArgb = rgbArray[0];
        int prevConverted = HSLUtilKt.convertHSLtoRGB(this.hsl, this.invert(prevArgb));
        int n = rgbArray.length;
        for (int i = 0; i < n; ++i) {
            int argb = rgbArray[i];
            if (argb != prevArgb) {
                prevArgb = argb;
                prevConverted = HSLUtilKt.convertHSLtoRGB(this.hsl, this.invert(argb));
            }
            rgbArray[i] = prevConverted;
        }
        outputImage.setRGB(0, 0, image.getWidth(), image.getHeight(), rgbArray, 0, image.getWidth());
    }

    private final BufferedImage createImageWithInvertedPalette(BufferedImage image) {
        ColorModel model = image.getColorModel();
        if (!(model instanceof IndexColorModel)) {
            return image;
        }
        int[] palette = new int[((IndexColorModel)model).getMapSize()];
        ((IndexColorModel)model).getRGBs(palette);
        int n = palette.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            int argb = palette[i];
            float alpha = this.invert(argb);
            palette[index] = HSLUtilKt.convertHSLtoRGB(this.hsl, alpha);
        }
        return new BufferedImage(image.getWidth(), image.getHeight(), 13);
    }

    private final float invert(int argb) {
        float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.rgb[0] = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.rgb[1] = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.rgb[2] = (float)(argb & 0xFF) / 255.0f;
        HSLUtilKt.convertRGBtoHSL(this.rgb, this.hsl);
        this.hsl[1] = this.hsl[1] * (50.0f + this.whiteHsl[1]) / 1.5f / 100.0f;
        this.hsl[2] = ((float)100 - this.hsl[2]) * (this.whiteHsl[2] - this.blackHsl[2]) / 100.0f + this.blackHsl[2];
        return alpha;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/notebooks/visualization/r/inlays/components/ImageInverter$Companion;", "", "<init>", "()V", "SATURATION", "", "LUMINANCE", "R", "G", "B", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

