/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables;

import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.scientific.tables.ColumnTreeNode;
import com.intellij.scientific.tables.ColumnTreeNodeKt;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.DSTableDataManager;
import com.intellij.scientific.tables.DSTableDataRetrieverFromDataSourceImplKt;
import com.intellij.scientific.tables.DSTableRateExceededException;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.FilterExpression;
import com.intellij.scientific.tables.fus.DSTableDataProviderLogger;
import com.intellij.util.concurrency.EdtScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020-H\u0017J\u0017\u0010?\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b@2\u0006\u0010>\u001a\u00020-H\u0016J$\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020-2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020F0DH\u0002J\u0018\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020EH\u0002J \u0010J\u001a\u00020E2\u0006\u0010K\u001a\u00020-2\u0006\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020EH\u0002J \u0010L\u001a\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J \u0010M\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\n\u0010N\u001a\u0004\u0018\u00010;H\u0016J\n\u0010O\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010P\u001a\u00020\u0005H\u0016J\b\u0010Q\u001a\u00020\tH\u0016Jl\u0010R\u001a\u00020F2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020-2\u0006\u0010V\u001a\u00020-2\u000e\u0010W\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010X28\u0010Y\u001a4\u0012\u0015\u0012\u0013\u0018\u00010E\u00a2\u0006\f\b[\u0012\b\b\\\u0012\u0004\b\b(]\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b[\u0012\b\b\\\u0012\u0004\b\b(^\u0012\u0004\u0012\u00020F0ZH\u0016J\u0010\u0010_\u001a\u00020-2\u0006\u0010B\u001a\u00020-H\u0002J\u0010\u0010`\u001a\u00020-2\u0006\u0010B\u001a\u00020-H\u0002J4\u0010a\u001a\u0004\u0018\u00010E2\u0006\u0010b\u001a\u00020\u00112\u0006\u0010c\u001a\u00020\u00112\b\u0010d\u001a\u0004\u0018\u00010E2\u0006\u0010U\u001a\u00020-2\u0006\u0010V\u001a\u00020-H\u0002J\n\u0010e\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010f\u001a\u0004\u0018\u00010gH\u0016J\b\u0010h\u001a\u00020FH\u0016J\u0010\u0010i\u001a\u00020F2\u0006\u0010j\u001a\u00020\u0014H\u0016J\u0010\u0010k\u001a\u00020F2\u0006\u0010l\u001a\u00020\u0007H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010%R\u0014\u0010\u0012\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010 R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010 R\u0014\u0010,\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u0014\u00102\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u001c\u00104\u001a\u00020-8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010/\"\u0004\b6\u00107R\u0014\u00108\u001a\u00020-8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010/R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/intellij/scientific/tables/DSTableDataRetrieverFromDataSourceImpl;", "Lcom/intellij/scientific/tables/api/DSTableDataRetrieverFromDataSource;", "dataId", "Lcom/intellij/scientific/tables/DataId;", "dataManager", "Lcom/intellij/scientific/tables/DSTableDataManager;", "currentTableExpression", "", "tableDataProvider", "Lcom/intellij/scientific/tables/api/DSTableDataProvider;", "tableCommandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "dataFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "panelInfo", "Lcom/intellij/scientific/tables/api/DSPanelInfo;", "isDynamicTable", "", "initialTableExpression", "disposableParent", "Lcom/intellij/openapi/Disposable;", "sortKeys", "", "Ljavax/swing/RowSorter$SortKey;", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "format", "<init>", "(Lcom/intellij/scientific/tables/DataId;Lcom/intellij/scientific/tables/DSTableDataManager;Ljava/lang/String;Lcom/intellij/scientific/tables/api/DSTableDataProvider;Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;Lcom/intellij/scientific/tables/api/DSDataFrameInfo;Lcom/intellij/scientific/tables/api/DSPanelInfo;ZLjava/lang/String;Lcom/intellij/openapi/Disposable;Ljava/util/List;Lcom/intellij/scientific/tables/api/FilterExpression;Ljava/lang/String;)V", "getDataId", "()Lcom/intellij/scientific/tables/DataId;", "getCurrentTableExpression", "()Ljava/lang/String;", "getDataFrameInfo", "()Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "getPanelInfo", "()Lcom/intellij/scientific/tables/api/DSPanelInfo;", "()Z", "getInitialTableExpression", "getSortKeys", "()Ljava/util/List;", "getFilters", "()Lcom/intellij/scientific/tables/api/FilterExpression;", "getFormat", "nColumns", "", "getNColumns", "()I", "nRows", "getNRows", "indexColumnWidth", "getIndexColumnWidth", "chunkSize", "getChunkSize", "setChunkSize", "(I)V", "nChunks", "getNChunks", "hierarchyRoot", "Lcom/intellij/scientific/tables/ColumnTreeNode;", "columnNames", "getColumnName", "index", "getColumnDataType", "Lcom/intellij/openapi/util/NlsSafe;", "tryToLoadDataFromHistory", "chunkIndex", "callback", "Lkotlin/Function1;", "Lcom/intellij/scientific/tables/DSTableRawData;", "", "isChunkInsideHistoryData", "end", "tableData", "getChunkFromHistoryData", "start", "sortAndFilterBy", "getTableVariableExpression", "getHierarchyRoot", "getTableCommandExecutor", "getDataManager", "getTableDataProvider", "loadInChunks", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "offset", "limit", "onErrorCallback", "Lkotlin/Function0;", "onLoaded", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "chunk", "endOfTableReached", "chunkEndIdx", "chunkStartIdx", "trimRows", "isFirstChunk", "isLastChunk", "data", "getDimensionText", "getTableType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "dispose", "registerDisposable", "parent", "showNotificationAboutLoadingDataFailed", "content", "intellij.scientific.tables"})
@SourceDebugExtension(value={"SMAP\nDSTableDataRetrieverFromDataSourceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DSTableDataRetrieverFromDataSourceImpl.kt\ncom/intellij/scientific/tables/DSTableDataRetrieverFromDataSourceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1863#2,2:243\n1#3:245\n*S KotlinDebug\n*F\n+ 1 DSTableDataRetrieverFromDataSourceImpl.kt\ncom/intellij/scientific/tables/DSTableDataRetrieverFromDataSourceImpl\n*L\n92#1:243,2\n*E\n"})
public final class DSTableDataRetrieverFromDataSourceImpl
implements DSTableDataRetrieverFromDataSource {
    @NotNull
    private final DataId dataId;
    @NotNull
    private final DSTableDataManager dataManager;
    @NotNull
    private final String currentTableExpression;
    @NotNull
    private final DSTableDataProvider tableDataProvider;
    @Nullable
    private final DSTableCommandExecutor tableCommandExecutor;
    @NotNull
    private final DSDataFrameInfo dataFrameInfo;
    @NotNull
    private final DSPanelInfo panelInfo;
    private final boolean isDynamicTable;
    @NotNull
    private final String initialTableExpression;
    @Nullable
    private Disposable disposableParent;
    @NotNull
    private final List<RowSorter.SortKey> sortKeys;
    @Nullable
    private final FilterExpression filters;
    @Nullable
    private final String format;
    private final int nColumns;
    private final int nRows;
    private final int indexColumnWidth;
    private int chunkSize;
    @Nullable
    private final ColumnTreeNode hierarchyRoot;
    @NotNull
    private final List<String> columnNames;

    public DSTableDataRetrieverFromDataSourceImpl(@NotNull DataId dataId, @NotNull DSTableDataManager dataManager, @NotNull String currentTableExpression, @NotNull DSTableDataProvider tableDataProvider, @Nullable DSTableCommandExecutor tableCommandExecutor, @NotNull DSDataFrameInfo dataFrameInfo, @NotNull DSPanelInfo panelInfo, boolean isDynamicTable, @NotNull String initialTableExpression, @Nullable Disposable disposableParent, @NotNull List<? extends RowSorter.SortKey> sortKeys, @Nullable FilterExpression filters, @Nullable String format) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        Intrinsics.checkNotNullParameter((Object)currentTableExpression, (String)"currentTableExpression");
        Intrinsics.checkNotNullParameter((Object)tableDataProvider, (String)"tableDataProvider");
        Intrinsics.checkNotNullParameter((Object)dataFrameInfo, (String)"dataFrameInfo");
        Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
        Intrinsics.checkNotNullParameter((Object)initialTableExpression, (String)"initialTableExpression");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        this.dataId = dataId;
        this.dataManager = dataManager;
        this.currentTableExpression = currentTableExpression;
        this.tableDataProvider = tableDataProvider;
        this.tableCommandExecutor = tableCommandExecutor;
        this.dataFrameInfo = dataFrameInfo;
        this.panelInfo = panelInfo;
        this.isDynamicTable = isDynamicTable;
        this.initialTableExpression = initialTableExpression;
        this.disposableParent = disposableParent;
        this.sortKeys = sortKeys;
        this.filters = filters;
        this.format = format;
        this.nColumns = this.getDataFrameInfo().getColumnNames().size();
        this.nRows = this.getDataFrameInfo().getRows();
        this.indexColumnWidth = this.getDataFrameInfo().getIndexColumnWidth();
        this.chunkSize = 25;
        this.hierarchyRoot = this.getDataFrameInfo().getHierarchyRoot();
        Object object = this.hierarchyRoot;
        if (object == null || (object = ColumnTreeNodeKt.getLeafsFullyQualifiedNames$default((ColumnTreeNode)object, false, 1, null)) == null) {
            object = CollectionsKt.toMutableList((Collection)this.getDataFrameInfo().getColumnNames());
        }
        this.columnNames = object;
    }

    public /* synthetic */ DSTableDataRetrieverFromDataSourceImpl(DataId dataId, DSTableDataManager dSTableDataManager, String string, DSTableDataProvider dSTableDataProvider, DSTableCommandExecutor dSTableCommandExecutor, DSDataFrameInfo dSDataFrameInfo, DSPanelInfo dSPanelInfo, boolean bl, String string2, Disposable disposable, List list, FilterExpression filterExpression, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            string2 = string;
        }
        if ((n & 0x200) != 0) {
            disposable = null;
        }
        if ((n & 0x400) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x800) != 0) {
            filterExpression = null;
        }
        if ((n & 0x1000) != 0) {
            string3 = null;
        }
        this(dataId, dSTableDataManager, string, dSTableDataProvider, dSTableCommandExecutor, dSDataFrameInfo, dSPanelInfo, bl, string2, disposable, list, filterExpression, string3);
    }

    @Override
    @NotNull
    public DataId getDataId() {
        return this.dataId;
    }

    @Override
    @NotNull
    public String getCurrentTableExpression() {
        return this.currentTableExpression;
    }

    @Override
    @NotNull
    public DSDataFrameInfo getDataFrameInfo() {
        return this.dataFrameInfo;
    }

    @Override
    @NotNull
    public DSPanelInfo getPanelInfo() {
        return this.panelInfo;
    }

    @Override
    public boolean isDynamicTable() {
        return this.isDynamicTable;
    }

    @Override
    @NotNull
    public String getInitialTableExpression() {
        return this.initialTableExpression;
    }

    @Override
    @NotNull
    public List<RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    @Nullable
    public FilterExpression getFilters() {
        return this.filters;
    }

    @Nullable
    public final String getFormat() {
        return this.format;
    }

    @Override
    public int getNColumns() {
        return this.nColumns;
    }

    @Override
    public int getNRows() {
        return this.nRows;
    }

    @Override
    public int getIndexColumnWidth() {
        return this.indexColumnWidth;
    }

    @Override
    public int getChunkSize() {
        int adjustedChunkSizeForRows = RangesKt.coerceAtLeast((int)(100000 / this.getNColumns()), (int)1);
        return switch (this.chunkSize) {
            case 0 -> 25;
            case -1 -> Math.min(adjustedChunkSizeForRows, this.getNRows());
            default -> Math.min(adjustedChunkSizeForRows, this.chunkSize);
        };
    }

    @Override
    public void setChunkSize(int n) {
        this.chunkSize = n;
    }

    private final int getNChunks() {
        return (this.getNRows() + this.getChunkSize() - 1) / this.getChunkSize();
    }

    @Override
    @NlsSafe
    @NotNull
    public String getColumnName(int index) {
        return this.getDataFrameInfo().getColumnNames().get(index);
    }

    @Override
    @Nullable
    public String getColumnDataType(int index) {
        return this.getDataFrameInfo().getColumnTypes().get(index);
    }

    private final boolean tryToLoadDataFromHistory(int chunkIndex, Function1<? super DSTableRawData, Unit> callback) {
        DSTableRawData dSTableRawData = this.dataManager.tryToLoadDataFromHistory(this.getDataId());
        if (dSTableRawData != null) {
            DSTableRawData historyData = dSTableRawData;
            boolean bl = false;
            int start = this.chunkStartIdx(chunkIndex);
            int end = this.chunkEndIdx(chunkIndex);
            if (this.isChunkInsideHistoryData(end, historyData)) {
                callback.invoke((Object)this.getChunkFromHistoryData(start, end, historyData));
                return true;
            }
        }
        return false;
    }

    private final boolean isChunkInsideHistoryData(int end, DSTableRawData tableData) {
        Collection collection = tableData.getCols();
        return !(collection == null || collection.isEmpty()) && end <= tableData.getCols().get(0).size();
    }

    private final DSTableRawData getChunkFromHistoryData(int start, int end, DSTableRawData tableData) {
        List chunkCols;
        block1: {
            chunkCols = new ArrayList();
            List<List<Object>> list = tableData.getCols();
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl = false;
                chunkCols.add(it.subList(start, end));
            }
        }
        return new DSTableRawData(tableData.getId(), chunkCols);
    }

    @Override
    @NotNull
    public DSTableDataRetrieverFromDataSource sortAndFilterBy(@NotNull List<? extends RowSorter.SortKey> sortKeys, @Nullable FilterExpression filters) {
        DSTableDataRetrieverFromDataSourceImpl dSTableDataRetrieverFromDataSourceImpl;
        block3: {
            Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
            if (this.tableCommandExecutor == null) {
                return this;
            }
            if (!Intrinsics.areEqual(sortKeys, this.getSortKeys())) {
                DSTableDataProviderLogger.INSTANCE.tableDataSorted(this.tableDataProvider.getType(), PluginInfoDetectorKt.getPluginInfo(this.getClass()), this.tableCommandExecutor.getDataAccessorClass(), this.getDataFrameInfo().getRows(), this.getDataFrameInfo().getColumnNames().size());
            }
            if (!Intrinsics.areEqual((Object)filters, (Object)this.getFilters())) {
                DSTableDataProviderLogger.INSTANCE.tableDataFiltered(this.tableDataProvider.getType(), PluginInfoDetectorKt.getPluginInfo(this.getClass()), this.tableCommandExecutor.getDataAccessorClass(), this.getDataFrameInfo().getRows(), this.getDataFrameInfo().getColumnNames().size());
            }
            String newTableVariableExpression = this.getTableVariableExpression(sortKeys, filters);
            this.dataManager.addToHistory(this.getDataId(), newTableVariableExpression);
            DSTableDataRetrieverFromDataSourceImpl newDataFrame = dSTableDataRetrieverFromDataSourceImpl = new DSTableDataRetrieverFromDataSourceImpl(this.getDataId(), this.dataManager, newTableVariableExpression, this.tableDataProvider, this.tableCommandExecutor, this.getDataFrameInfo(), this.getPanelInfo(), this.isDynamicTable(), this.getInitialTableExpression(), null, sortKeys, filters, this.format, 512, null);
            boolean bl = false;
            Disposable disposable = this.disposableParent;
            if (disposable == null) break block3;
            Disposable it = disposable;
            boolean bl2 = false;
            newDataFrame.registerDisposable(it);
        }
        return dSTableDataRetrieverFromDataSourceImpl;
    }

    private final String getTableVariableExpression(List<? extends RowSorter.SortKey> sortKeys, FilterExpression filters) {
        String it = this.getInitialTableExpression();
        boolean bl = false;
        it = this.tableDataProvider.getFilteringCommand(it, filters);
        boolean bl2 = false;
        return this.tableDataProvider.getSortingCommand(it, sortKeys, this.columnNames, this.getIndexColumnWidth());
    }

    @Override
    @Nullable
    public ColumnTreeNode getHierarchyRoot() {
        return this.hierarchyRoot;
    }

    @Override
    @Nullable
    public DSTableCommandExecutor getTableCommandExecutor() {
        return this.tableCommandExecutor;
    }

    @Override
    @NotNull
    public DSTableDataManager getDataManager() {
        return this.dataManager;
    }

    @Override
    @NotNull
    public DSTableDataProvider getTableDataProvider() {
        return this.tableDataProvider;
    }

    @Override
    public void loadInChunks(@Nullable ProgressIndicator indicator, int offset, int limit, @Nullable Function0<Unit> onErrorCallback, @NotNull Function2<? super DSTableRawData, ? super Boolean, Unit> onLoaded) {
        int firstChunk;
        Intrinsics.checkNotNullParameter(onLoaded, (String)"onLoaded");
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setIndeterminate(false);
        }
        int n = this.getNChunks();
        for (int chunkIndex = firstChunk = offset / this.getChunkSize(); chunkIndex < n; ++chunkIndex) {
            DSTableRawData dSTableRawData;
            boolean isLastChunk;
            if (indicator != null && indicator.isCanceled()) {
                return;
            }
            if (this.chunkStartIdx(chunkIndex) >= offset + limit) {
                onLoaded.invoke(null, (Object)false);
                return;
            }
            boolean isFirstChunk = chunkIndex == firstChunk;
            boolean bl = isLastChunk = (chunkIndex + 1) * this.getChunkSize() > offset + limit;
            if (this.tableCommandExecutor == null) {
                boolean loadedFromHistory = this.tryToLoadDataFromHistory(chunkIndex, (Function1<? super DSTableRawData, Unit>)((Function1)arg_0 -> DSTableDataRetrieverFromDataSourceImpl.loadInChunks$lambda$6(onLoaded, this, isFirstChunk, isLastChunk, offset, limit, arg_0)));
                if (loadedFromHistory) break;
                this.showNotificationAboutLoadingDataFailed(DSTableBundle.message("ds.table.load.error.message", new Object[0]));
                break;
            }
            int start = this.chunkStartIdx(chunkIndex);
            int end = this.chunkEndIdx(chunkIndex);
            try {
                dSTableRawData = this.tableDataProvider.loadDynamicTableData(this.tableCommandExecutor, this.getDataId(), this.getCurrentTableExpression(), this.format, start, end);
            }
            catch (DSTableDataException e) {
                if (e instanceof DSTableRateExceededException) {
                    this.setChunkSize(this.getChunkSize() / 2);
                    if (this.getChunkSize() > 0) {
                        this.loadInChunks(indicator, offset, limit, onErrorCallback, onLoaded);
                        return;
                    }
                }
                Function0<Unit> function0 = onErrorCallback;
                if (function0 != null) {
                    function0.invoke();
                }
                this.dataManager.fallbackToPreviousValidTable(this.getDataId(), this.tableCommandExecutor, this.tableDataProvider, this.getPanelInfo());
                String string = e.getMessage();
                if (string == null) {
                    string = "";
                }
                this.showNotificationAboutLoadingDataFailed(string);
                ApplicationManager.getApplication().invokeLater(() -> DSTableDataRetrieverFromDataSourceImpl.loadInChunks$lambda$7(this));
                return;
            }
            DSTableRawData dataFrameData = dSTableRawData;
            if (chunkIndex == 0) {
                ApplicationManager.getApplication().invokeLater(() -> DSTableDataRetrieverFromDataSourceImpl.loadInChunks$lambda$8(this));
            }
            onLoaded.invoke((Object)this.trimRows(isFirstChunk, isLastChunk, dataFrameData, offset, limit), (Object)false);
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 == null) continue;
            progressIndicator3.setFraction((double)chunkIndex / (double)this.getNChunks());
        }
        onLoaded.invoke(null, (Object)true);
    }

    private final int chunkEndIdx(int chunkIndex) {
        return Math.min((chunkIndex + 1) * this.getChunkSize(), this.getNRows());
    }

    private final int chunkStartIdx(int chunkIndex) {
        return chunkIndex * this.getChunkSize();
    }

    private final DSTableRawData trimRows(boolean isFirstChunk, boolean isLastChunk, DSTableRawData data, int offset, int limit) {
        DSTableRawData res = data;
        if (isLastChunk) {
            DSTableRawData dSTableRawData = res;
            DSTableRawData dSTableRawData2 = res = dSTableRawData != null ? DSTableDataRetrieverFromDataSourceImplKt.access$takeRows(dSTableRawData, (offset + limit) % this.getChunkSize()) : null;
        }
        if (isFirstChunk) {
            DSTableRawData dSTableRawData = res;
            res = dSTableRawData != null ? DSTableDataRetrieverFromDataSourceImplKt.access$dropRows(dSTableRawData, offset % this.getChunkSize()) : null;
        }
        return res;
    }

    @Override
    @Nullable
    public String getDimensionText() {
        return this.getDataFrameInfo().getDim();
    }

    @Override
    @Nullable
    public DSTableDataType getTableType() {
        return this.getDataFrameInfo().getTableType();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void registerDisposable(@NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.disposableParent = parent;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    private final void showNotificationAboutLoadingDataFailed(String content) {
        ApplicationManager.getApplication().invokeLater(() -> DSTableDataRetrieverFromDataSourceImpl.showNotificationAboutLoadingDataFailed$lambda$10(content, this));
    }

    private static final Unit loadInChunks$lambda$6(Function2 $onLoaded, DSTableDataRetrieverFromDataSourceImpl this$0, boolean $isFirstChunk, boolean $isLastChunk, int $offset, int $limit, DSTableRawData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        $onLoaded.invoke((Object)this$0.trimRows($isFirstChunk, $isLastChunk, data, $offset, $limit), (Object)false);
        return Unit.INSTANCE;
    }

    private static final void loadInChunks$lambda$7(DSTableDataRetrieverFromDataSourceImpl this$0) {
        this$0.tableCommandExecutor.notifyAsyncOutputLoaded();
    }

    private static final void loadInChunks$lambda$8(DSTableDataRetrieverFromDataSourceImpl this$0) {
        this$0.tableCommandExecutor.notifyAsyncOutputLoaded();
    }

    private static final void showNotificationAboutLoadingDataFailed$lambda$10$lambda$9(Notification $notification) {
        $notification.hideBalloon();
    }

    private static final void showNotificationAboutLoadingDataFailed$lambda$10(String $content, DSTableDataRetrieverFromDataSourceImpl this$0) {
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("DSTableLoadingError").createNotification(DSTableBundle.message("ds.table.load.error.title", new Object[0]), $content, NotificationType.INFORMATION);
        notification.notify(this$0.dataManager.getProject());
        EdtScheduler.Companion.getInstance().schedule-VtjQ1oo(DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), () -> DSTableDataRetrieverFromDataSourceImpl.showNotificationAboutLoadingDataFailed$lambda$10$lambda$9(notification));
    }
}

