/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.qml.QmlElementTypes;
import com.intellij.lang.qml.QmlFileType;
import com.intellij.lang.qml.psi.impl.QmlElementDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlImportAliasExpressionImpl;
import com.intellij.lang.qml.psi.impl.QmlImportReferenceExpressionImpl;
import com.intellij.lang.qml.psi.impl.QmlLocalImplicitElementImpl;
import com.intellij.lang.qml.settings.QmlSettings;
import com.intellij.lang.qml.settings.QmlSettingsListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class QmlImportDeclarationImpl
extends JSElementImpl {
    public static final String RESERVED_NAME = "jetbrainsReserved";
    private static final String QMLTYPES_SUFFIX = ".qmltypes";
    private static final String PLUGINS_QMLTYPES = "plugins.qmltypes";
    private static final String QMLDIR = "qmldir";
    private static final String DEFAULT_IMPORT = "default import ";
    private String myName = "";
    private String myAlias = "";
    private boolean myNotSubscribed = true;
    private HashMap<String, QmlComponentTemplate> myComponents = null;
    private HashMap<String, Ref<JSType>> myTypesCache = null;
    private static final String QT_OBJECT_TYPE_NAME = "QtObject";
    private static final String QSTRING_TYPE_NAME = "QString";
    private static final String COMPONENT_TYPE_NAME = "Component";
    private static final String DOUBLE_TYPE_NAME = "double";
    private static final String REAL_TYPE_NAME = "real";
    private static final String INT_TYPE_NAME = "int";
    private static final String BOOL_TYPE_NAME = "bool";
    private static final String URL_TYPE_NAME = "url";
    private static final String COLOR_TYPE_NAME = "color";
    private static final String DATE_TYPE_NAME = "date";
    private static final String POINT_TYPE_NAME = "point";
    private static final String RECT_TYPE_NAME = "rect";
    private static final String SIZE_TYPE_NAME = "size";
    private static final String LOCALE_TYPE_NAME = "Locale";
    private static final HashMap<String, Ref<JSType>> myBuiltinTypes = QmlImportDeclarationImpl.createBuiltinTypes();

    public QmlImportDeclarationImpl(IElementType elementType) {
        super(elementType);
    }

    @Nullable
    public PsiFile getContainingFile() {
        return SharedImplUtil.getContainingFile((ASTNode)this);
    }

    public PsiReference @NotNull [] getReferences() {
        if (PsiReference.EMPTY_ARRAY == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(0);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    public String getStringInQuotes() {
        Pair pair = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)this);
        if (pair == null) {
            return null;
        }
        return StringUtil.trimEnd((String)StringUtil.trimStart((String)((String)pair.first), (String)"\""), (String)"\"");
    }

    public boolean isJSImport() {
        @Nullable String fileName = this.getStringInQuotes();
        if (fileName == null) {
            return false;
        }
        @Nullable @NlsSafe String extension = "." + PathUtil.getFileExtension((String)fileName);
        return Arrays.stream(TypeScriptUtil.JAVASCRIPT_EXTENSIONS).toList().contains(extension);
    }

    @NotNull
    private static Pair<String, String> extractName(JSLiteralExpression expr, boolean allowVersion) {
        String name = expr.getStringValue();
        if (name == null) {
            return new Pair((Object)"", (Object)"");
        }
        if (!name.contains(" ")) {
            return new Pair((Object)name, (Object)"");
        }
        if (!allowVersion) {
            return new Pair((Object)"", (Object)"");
        }
        String[] nameAndVersion = name.split(" ");
        return new Pair((Object)nameAndVersion[0].split("/")[1], (Object)nameAndVersion[1]);
    }

    private static synchronized QmlComponentTemplate getComponentByType(String typeName, HashMap<String, QmlComponentTemplate> components) {
        for (QmlComponentTemplate component : components.values()) {
            if (!component.getType().equals(typeName)) continue;
            return component;
        }
        return null;
    }

    private static Ref<JSType> getOrCreateType(String typeName, HashMap<String, QmlComponentTemplate> components, HashMap<String, Ref<JSType>> typesCache) {
        JSType jSType;
        Ref type = typesCache.get(typeName);
        if (type != null) {
            return type;
        }
        QmlComponentTemplate component = QmlImportDeclarationImpl.getComponentByType(typeName, components);
        if (component == null) {
            return null;
        }
        ArrayList<PropertySignatureImpl> curTypeMembers = new ArrayList<PropertySignatureImpl>();
        type = new Ref();
        typesCache.put(typeName, (Ref<JSType>)type);
        @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)component.myBaseComponent, (boolean)true);
        if (component.getProperties() != null) {
            for (QmlMember property : component.getProperties()) {
                Ref typeRef = null;
                @NotNull JSTypeSource propertySrc = JSTypeSourceFactory.createTypeSource((PsiElement)property.baseElement, (boolean)true);
                if (!property.type.isEmpty() && (typeRef = QmlImportDeclarationImpl.getOrCreateType(property.type, components, typesCache)) == null) {
                    typeRef = new Ref((Object)new QmlRecordType(typeSrc, curTypeMembers, property.type));
                }
                if (property.kind != QmlMember.Kind.Method) {
                    curTypeMembers.add(new QmlPropertySignatureImpl(property.name, propertySrc, typeRef, property.kind));
                } else {
                    ArrayList<JSParameterTypeDecoratorImpl> parameters = new ArrayList<JSParameterTypeDecoratorImpl>();
                    for (QmlMember param : property.parameters) {
                        Ref<JSType> paramType = QmlImportDeclarationImpl.getOrCreateType(param.type, components, typesCache);
                        parameters.add(new JSParameterTypeDecoratorImpl(param.name, paramType == null ? null : (JSType)paramType.get(), false, false, false));
                    }
                    curTypeMembers.add(new QmlMethodSignatureImpl(property.name, propertySrc, parameters, (Ref<JSType>)(typeRef != null ? typeRef : new Ref())));
                }
                if (property.kind != QmlMember.Kind.Property) continue;
                String eventName = "on" + StringUtil.capitalize((String)property.name.substring(0, 1)) + property.name.substring(1) + "Changed";
                curTypeMembers.add(new QmlPropertySignatureImpl(eventName, propertySrc, null, property.kind));
            }
        }
        if ((jSType = component.myLastPrototype) instanceof QmlRecordType) {
            QmlRecordType qmlRecord = (QmlRecordType)jSType;
            curTypeMembers.addAll(qmlRecord.getTypeMembers());
        }
        QmlRecordType curJSType = new QmlRecordType(typeSrc, curTypeMembers, component.getRelatedElement().getName());
        type.set((Object)curJSType);
        return type;
    }

    private List<String> getImportParts() {
        ASTNode node = this.getNode();
        if ((node = node.getFirstChildNode()) == null) {
            return Collections.emptyList();
        }
        if ((node = node.getTreeNext()) == null) {
            return Collections.emptyList();
        }
        if ((node = node.getTreeNext()) == null) {
            return Collections.emptyList();
        }
        if (node instanceof JSLiteralExpression) {
            return Collections.emptyList();
        }
        if (!(node instanceof JSReferenceExpression)) {
            return Collections.emptyList();
        }
        String importText = ((JSReferenceExpression)node).getText();
        return new ArrayList<String>(Arrays.asList(importText.split("\\.")));
    }

    private static Ref<JSType> createQtType(@NotNull JSTypeSource typeSrc, HashMap<String, Ref<JSType>> otherBuiltinTypes) {
        if (typeSrc == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(1);
        }
        ArrayList<PropertySignatureImpl> curTypeMembers = new ArrayList<PropertySignatureImpl>();
        Ref qtType = new Ref();
        ArrayList emptyParameters = new ArrayList();
        Stream.of("application", "inputMethod", "platform", "styleHints").forEach(name -> curTypeMembers.add(new QmlPropertySignatureImpl((String)name, typeSrc, null, QmlMember.Kind.Property)));
        curTypeMembers.add(new QmlPropertySignatureImpl("uiLanguage", typeSrc, otherBuiltinTypes.get(QSTRING_TYPE_NAME), QmlMember.Kind.Property));
        ArrayList<JSParameterTypeDecoratorImpl> alphaParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        alphaParameters.add(new JSParameterTypeDecoratorImpl("baseColor", (JSType)otherBuiltinTypes.get(COLOR_TYPE_NAME).get(), false, false, false));
        alphaParameters.add(new JSParameterTypeDecoratorImpl("value", (JSType)otherBuiltinTypes.get(REAL_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("alpha", typeSrc, alphaParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> atobParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        atobParameters.add(new JSParameterTypeDecoratorImpl("data", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("atob", typeSrc, atobParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> bindingParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        bindingParameters.add(new JSParameterTypeDecoratorImpl("function", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("binding", typeSrc, bindingParameters, (Ref<JSType>)new Ref()));
        ArrayList<JSParameterTypeDecoratorImpl> btoaParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        btoaParameters.add(new JSParameterTypeDecoratorImpl("data", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("btoa", typeSrc, btoaParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> callLaterParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        callLaterParameters.add(new JSParameterTypeDecoratorImpl("function", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("callLater", typeSrc, callLaterParameters, (Ref<JSType>)new Ref()));
        ArrayList<JSParameterTypeDecoratorImpl> colorParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        colorParameters.add(new JSParameterTypeDecoratorImpl("name", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl(COLOR_TYPE_NAME, typeSrc, colorParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> colorEqualParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        colorEqualParameters.add(new JSParameterTypeDecoratorImpl("baseColor", (JSType)otherBuiltinTypes.get(COLOR_TYPE_NAME).get(), false, false, false));
        colorEqualParameters.add(new JSParameterTypeDecoratorImpl("name", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("colorEqual", typeSrc, colorEqualParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> createComponentParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        createComponentParameters.add(new JSParameterTypeDecoratorImpl(URL_TYPE_NAME, (JSType)otherBuiltinTypes.get(URL_TYPE_NAME).get(), false, false, false));
        createComponentParameters.add(new JSParameterTypeDecoratorImpl("mode", null, false, false, false));
        createComponentParameters.add(new JSParameterTypeDecoratorImpl("parent", (JSType)otherBuiltinTypes.get(QT_OBJECT_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("createComponent", typeSrc, createComponentParameters, otherBuiltinTypes.get(COMPONENT_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> createQmlObjectParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        createQmlObjectParameters.add(new JSParameterTypeDecoratorImpl("qml", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        createQmlObjectParameters.add(new JSParameterTypeDecoratorImpl("parent", null, false, false, false));
        createQmlObjectParameters.add(new JSParameterTypeDecoratorImpl("filepath", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("createQmlObject", typeSrc, createQmlObjectParameters, (Ref<JSType>)new Ref()));
        ArrayList<JSParameterTypeDecoratorImpl> darkerParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        darkerParameters.add(new JSParameterTypeDecoratorImpl("baseColor", (JSType)otherBuiltinTypes.get(COLOR_TYPE_NAME).get(), false, false, false));
        darkerParameters.add(new JSParameterTypeDecoratorImpl("factor", (JSType)otherBuiltinTypes.get(REAL_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("darker", typeSrc, darkerParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> exitParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        exitParameters.add(new JSParameterTypeDecoratorImpl("retCode", (JSType)otherBuiltinTypes.get(INT_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("exit", typeSrc, exitParameters, (Ref<JSType>)new Ref()));
        ArrayList<JSParameterTypeDecoratorImpl> fontParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        fontParameters.add(new JSParameterTypeDecoratorImpl("fontSpecifier", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("font", typeSrc, fontParameters, (Ref<JSType>)new Ref()));
        curTypeMembers.add(new QmlMethodSignatureImpl("fontFamilies", typeSrc, emptyParameters, (Ref<JSType>)new Ref()));
        ArrayList<JSParameterTypeDecoratorImpl> formatDateParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        formatDateParameters.add(new JSParameterTypeDecoratorImpl(DATE_TYPE_NAME, (JSType)otherBuiltinTypes.get(DATE_TYPE_NAME).get(), false, false, false));
        formatDateParameters.add(new JSParameterTypeDecoratorImpl("format", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        formatDateParameters.add(new JSParameterTypeDecoratorImpl("localeFormatOption", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("formatDate", typeSrc, formatDateParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> formatDateTimeParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        formatDateTimeParameters.add(new JSParameterTypeDecoratorImpl("dateTime", (JSType)otherBuiltinTypes.get(DATE_TYPE_NAME).get(), false, false, false));
        formatDateTimeParameters.add(new JSParameterTypeDecoratorImpl("format", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        formatDateTimeParameters.add(new JSParameterTypeDecoratorImpl("localeFormatOption", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("formatDateTime", typeSrc, formatDateTimeParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> formatTimeParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        formatTimeParameters.add(new JSParameterTypeDecoratorImpl("time", (JSType)otherBuiltinTypes.get(DATE_TYPE_NAME).get(), false, false, false));
        formatTimeParameters.add(new JSParameterTypeDecoratorImpl("format", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        formatTimeParameters.add(new JSParameterTypeDecoratorImpl("localeFormatOption", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("formatTime", typeSrc, formatTimeParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList hslaParameters = new ArrayList();
        Stream.of("hue", "saturation", "lightness", "alpha").forEach(name -> hslaParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("hsla", typeSrc, hslaParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList hsvaParameters = new ArrayList();
        Stream.of("hue", "saturation", "value", "alpha").forEach(name -> hsvaParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("hsva", typeSrc, hsvaParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> isQtObjectParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        isQtObjectParameters.add(new JSParameterTypeDecoratorImpl("object", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("isQtObject", typeSrc, isQtObjectParameters, otherBuiltinTypes.get(BOOL_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> lighterParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        lighterParameters.add(new JSParameterTypeDecoratorImpl("baseColor", (JSType)otherBuiltinTypes.get(COLOR_TYPE_NAME).get(), false, false, false));
        lighterParameters.add(new JSParameterTypeDecoratorImpl("factor", (JSType)otherBuiltinTypes.get(REAL_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("lighter", typeSrc, lighterParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> localeParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        localeParameters.add(new JSParameterTypeDecoratorImpl("name", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("locale", typeSrc, localeParameters, otherBuiltinTypes.get(LOCALE_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> md5Parameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        md5Parameters.add(new JSParameterTypeDecoratorImpl("data", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("md5", typeSrc, md5Parameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList matrix4x4Parameters = new ArrayList();
        Stream.of("m11", "m12", "m13", "m14", "m21", "m22", "m23", "m24", "m31", "m32", "m33", "m34", "m41", "m42", "m43", "m44").forEach(name -> matrix4x4Parameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("matrix4x4", typeSrc, matrix4x4Parameters, (Ref<JSType>)new Ref()));
        ArrayList<JSParameterTypeDecoratorImpl> openUrlExternallyParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        openUrlExternallyParameters.add(new JSParameterTypeDecoratorImpl("target", (JSType)otherBuiltinTypes.get(URL_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("openUrlExternally", typeSrc, openUrlExternallyParameters, otherBuiltinTypes.get(BOOL_TYPE_NAME)));
        ArrayList pointParameters = new ArrayList();
        Stream.of("x", "y").forEach(name -> pointParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl(POINT_TYPE_NAME, typeSrc, pointParameters, otherBuiltinTypes.get(POINT_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> qsTrParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        Stream.of("sourceText", "disambiguation").forEach(name -> qsTrParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(QSTRING_TYPE_NAME)).get(), false, false, false)));
        qsTrParameters.add(new JSParameterTypeDecoratorImpl("n", (JSType)otherBuiltinTypes.get(INT_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("qsTr", typeSrc, qsTrParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        curTypeMembers.add(new QmlMethodSignatureImpl("qsTrNoOp", typeSrc, qsTrParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> qsTrIdParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        qsTrIdParameters.add(new JSParameterTypeDecoratorImpl("id", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        qsTrIdParameters.add(new JSParameterTypeDecoratorImpl("n", (JSType)otherBuiltinTypes.get(INT_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("qsTrId", typeSrc, qsTrIdParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> qsTrIdNoOpParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        qsTrIdNoOpParameters.add(new JSParameterTypeDecoratorImpl("id", (JSType)otherBuiltinTypes.get(QSTRING_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("qsTrIdNoOp", typeSrc, qsTrIdNoOpParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList qsTranslateNoOpParameters = new ArrayList();
        Stream.of("context", "sourceText", "disambiguation").forEach(name -> qsTranslateNoOpParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(QSTRING_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("qsTranslateNoOp", typeSrc, qsTranslateNoOpParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> qsTranslateParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        Stream.of("context", "sourceText", "disambiguation").forEach(name -> qsTranslateParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(QSTRING_TYPE_NAME)).get(), false, false, false)));
        qsTranslateParameters.add(new JSParameterTypeDecoratorImpl("n", (JSType)otherBuiltinTypes.get(INT_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("qsTranslate", typeSrc, qsTranslateParameters, otherBuiltinTypes.get(QSTRING_TYPE_NAME)));
        ArrayList quaternionParameters = new ArrayList();
        Stream.of("scalar", "x", "y", "z").forEach(name -> quaternionParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("quaternion", typeSrc, quaternionParameters, (Ref<JSType>)new Ref()));
        curTypeMembers.add(new QmlMethodSignatureImpl("quit", typeSrc, emptyParameters, (Ref<JSType>)new Ref()));
        ArrayList rectParameters = new ArrayList();
        Stream.of("x", "y", "width", "height").forEach(name -> rectParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl(RECT_TYPE_NAME, typeSrc, rectParameters, otherBuiltinTypes.get(RECT_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> resolvedUrlParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        resolvedUrlParameters.add(new JSParameterTypeDecoratorImpl(URL_TYPE_NAME, (JSType)otherBuiltinTypes.get(URL_TYPE_NAME).get(), false, false, false));
        resolvedUrlParameters.add(new JSParameterTypeDecoratorImpl("context", null, false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("resolvedUrl", typeSrc, resolvedUrlParameters, otherBuiltinTypes.get(URL_TYPE_NAME)));
        ArrayList<JSParameterTypeDecoratorImpl> urlParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        urlParameters.add(new JSParameterTypeDecoratorImpl(URL_TYPE_NAME, (JSType)otherBuiltinTypes.get(URL_TYPE_NAME).get(), false, false, false));
        curTypeMembers.add(new QmlMethodSignatureImpl("resolvedUrl", typeSrc, urlParameters, otherBuiltinTypes.get(URL_TYPE_NAME)));
        curTypeMembers.add(new QmlMethodSignatureImpl(URL_TYPE_NAME, typeSrc, urlParameters, otherBuiltinTypes.get(URL_TYPE_NAME)));
        ArrayList rgbaParameters = new ArrayList();
        Stream.of("red", "green", "blue", "alpha").forEach(name -> rgbaParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("rgba", typeSrc, rgbaParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList sizeParameters = new ArrayList();
        Stream.of("width", "height").forEach(name -> sizeParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl(SIZE_TYPE_NAME, typeSrc, sizeParameters, otherBuiltinTypes.get(RECT_TYPE_NAME)));
        ArrayList tintParameters = new ArrayList();
        Stream.of("baseColor", "tintColor").forEach(name -> tintParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(COLOR_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("tint", typeSrc, tintParameters, otherBuiltinTypes.get(COLOR_TYPE_NAME)));
        ArrayList vector2dParameters = new ArrayList();
        Stream.of("x", "y").forEach(name -> vector2dParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("vector2d", typeSrc, vector2dParameters, otherBuiltinTypes.get(RECT_TYPE_NAME)));
        ArrayList vector3dParameters = new ArrayList();
        Stream.of("x", "y", "z").forEach(name -> vector3dParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("vector3d", typeSrc, vector3dParameters, otherBuiltinTypes.get(RECT_TYPE_NAME)));
        ArrayList vector4dParameters = new ArrayList();
        Stream.of("x", "y", "z", "w").forEach(name -> vector4dParameters.add(new JSParameterTypeDecoratorImpl(name, (JSType)((Ref)otherBuiltinTypes.get(REAL_TYPE_NAME)).get(), false, false, false)));
        curTypeMembers.add(new QmlMethodSignatureImpl("vector4d", typeSrc, vector4dParameters, otherBuiltinTypes.get(RECT_TYPE_NAME)));
        qtType.set((Object)new QmlRecordType(typeSrc, curTypeMembers, "Qt", false));
        return qtType;
    }

    private static HashMap<String, Ref<JSType>> createBuiltinTypes() {
        HashMap<String, Ref<JSType>> builtinTypes = new HashMap<String, Ref<JSType>>();
        @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource(null, (boolean)true);
        builtinTypes.put(BOOL_TYPE_NAME, new Ref((Object)new JSBooleanLiteralTypeImpl(true, true, typeSrc)));
        builtinTypes.put(INT_TYPE_NAME, new Ref((Object)new JSIntType(true, typeSrc, JSTypeContext.INSTANCE)));
        Ref doubleType = new Ref((Object)JSNamedTypeFactory.createNumberPrimitiveType((JSTypeSource)typeSrc));
        builtinTypes.put(DOUBLE_TYPE_NAME, doubleType);
        builtinTypes.put(REAL_TYPE_NAME, doubleType);
        Ref stringType = new Ref((Object)JSNamedTypeFactory.createStringPrimitiveType((JSTypeSource)typeSrc));
        builtinTypes.put(QSTRING_TYPE_NAME, stringType);
        ArrayList emptyParameters = new ArrayList();
        ArrayList<Object> curTypeMembers = new ArrayList<Object>();
        Stream.of(URL_TYPE_NAME, DATE_TYPE_NAME, POINT_TYPE_NAME, RECT_TYPE_NAME, SIZE_TYPE_NAME, COLOR_TYPE_NAME).forEach(name -> builtinTypes.put((String)name, (Ref<JSType>)new Ref((Object)new QmlRecordType(typeSrc, (List<? extends JSRecordType.TypeMember>)curTypeMembers, (String)name, false, (JSType)stringType.get()))));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("id", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("objectName", typeSrc, (Ref<JSType>)stringType, QmlMember.Kind.Property));
        builtinTypes.put(QT_OBJECT_TYPE_NAME, new Ref((Object)new QmlRecordType(typeSrc, curTypeMembers, QT_OBJECT_TYPE_NAME)));
        curTypeMembers.clear();
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("id", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("progress", typeSrc, (Ref<JSType>)((Ref)builtinTypes.get(REAL_TYPE_NAME)), QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("status", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl(URL_TYPE_NAME, typeSrc, (Ref<JSType>)((Ref)builtinTypes.get(URL_TYPE_NAME)), QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("onCompleted", typeSrc, null, QmlMember.Kind.Signal));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("onDestruction", typeSrc, null, QmlMember.Kind.Signal));
        ArrayList<JSParameterTypeDecoratorImpl> createObjParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        createObjParameters.add(new JSParameterTypeDecoratorImpl("parent", (JSType)((Ref)builtinTypes.get(QT_OBJECT_TYPE_NAME)).get(), false, false, false));
        createObjParameters.add(new JSParameterTypeDecoratorImpl("properties", null, true, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("createObject", typeSrc, createObjParameters, (Ref<JSType>)((Ref)builtinTypes.get(QT_OBJECT_TYPE_NAME))));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("errorString", typeSrc, emptyParameters, (Ref<JSType>)((Ref)builtinTypes.get(QSTRING_TYPE_NAME))));
        ArrayList<JSParameterTypeDecoratorImpl> incubateObjectParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        incubateObjectParameters.add(new JSParameterTypeDecoratorImpl("parent", (JSType)((Ref)builtinTypes.get(QT_OBJECT_TYPE_NAME)).get(), false, false, false));
        incubateObjectParameters.add(new JSParameterTypeDecoratorImpl("properties", null, false, false, false));
        incubateObjectParameters.add(new JSParameterTypeDecoratorImpl("mode", null, false, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("incubateObject", typeSrc, incubateObjectParameters, (Ref<JSType>)new Ref()));
        builtinTypes.put(COMPONENT_TYPE_NAME, new Ref((Object)new QmlRecordType(typeSrc, curTypeMembers, COMPONENT_TYPE_NAME)));
        curTypeMembers.clear();
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("delayed", typeSrc, (Ref<JSType>)((Ref)builtinTypes.get(BOOL_TYPE_NAME)), QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("property", typeSrc, (Ref<JSType>)stringType, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("restoreMode", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("target", typeSrc, (Ref<JSType>)((Ref)builtinTypes.get(QT_OBJECT_TYPE_NAME)), QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("value", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("when", typeSrc, (Ref<JSType>)((Ref)builtinTypes.get(BOOL_TYPE_NAME)), QmlMember.Kind.Property));
        builtinTypes.put("Binding", new Ref((Object)new QmlRecordType(typeSrc, curTypeMembers, "Binding")));
        curTypeMembers.clear();
        Stream.of("amText", "decimalPoint", "exponential", "groupSeparator", "name", "nativeCountryName", "nativeLanguageName", "negativeSign", "percent", "pmText", "positiveSign", "zeroDigit").forEach(name -> curTypeMembers.add((Object)new QmlPropertySignatureImpl((String)name, typeSrc, (Ref<JSType>)stringType, QmlMember.Kind.Property)));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("firstDayOfWeek", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("measurementSystem", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("numberOptions", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("textDirection", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("uiLanguages", typeSrc, null, QmlMember.Kind.Property));
        curTypeMembers.add((Object)new QmlPropertySignatureImpl("weekDays", typeSrc, null, QmlMember.Kind.Property));
        ArrayList<JSParameterTypeDecoratorImpl> currencySymbolParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        currencySymbolParameters.add(new JSParameterTypeDecoratorImpl("format", null, false, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("currencySymbol", typeSrc, currencySymbolParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> dateTimeParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        dateTimeParameters.add(new JSParameterTypeDecoratorImpl("type", null, false, false, false));
        Stream.of("dateFormat", "dateTimeFormat", "timeFormat").forEach(name -> curTypeMembers.add((Object)new QmlMethodSignatureImpl((String)name, typeSrc, (List<? extends JSParameterTypeDecorator>)dateTimeParameters, (Ref<JSType>)stringType)));
        ArrayList<JSParameterTypeDecoratorImpl> dayTypeParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        dayTypeParameters.add(new JSParameterTypeDecoratorImpl("day", null, false, false, false));
        dayTypeParameters.add(new JSParameterTypeDecoratorImpl("type", null, false, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("dayName", typeSrc, dayTypeParameters, (Ref<JSType>)stringType));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("standaloneDayName", typeSrc, dayTypeParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> formattedDataSizeParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        formattedDataSizeParameters.add(new JSParameterTypeDecoratorImpl("bytes", (JSType)((Ref)builtinTypes.get(INT_TYPE_NAME)).get(), false, false, false));
        formattedDataSizeParameters.add(new JSParameterTypeDecoratorImpl("precision", (JSType)((Ref)builtinTypes.get(INT_TYPE_NAME)).get(), false, false, false));
        formattedDataSizeParameters.add(new JSParameterTypeDecoratorImpl("format", null, false, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("formattedDataSize", typeSrc, formattedDataSizeParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> monthTypeParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        monthTypeParameters.add(new JSParameterTypeDecoratorImpl("month", null, false, false, false));
        monthTypeParameters.add(new JSParameterTypeDecoratorImpl("type", null, false, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("monthName", typeSrc, monthTypeParameters, (Ref<JSType>)stringType));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("standaloneMonthName", typeSrc, monthTypeParameters, (Ref<JSType>)stringType));
        builtinTypes.put(LOCALE_TYPE_NAME, new Ref((Object)new QmlRecordType(typeSrc, curTypeMembers, LOCALE_TYPE_NAME)));
        curTypeMembers.clear();
        ArrayList<JSParameterTypeDecoratorImpl> numberParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        numberParameters.add(new JSParameterTypeDecoratorImpl("value", (JSType)doubleType.get(), true, false, false));
        curTypeMembers.add(new QmlCallSignatureImpl(typeSrc, numberParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> fromLocaleStringParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        fromLocaleStringParameters.add(new JSParameterTypeDecoratorImpl("locale", (JSType)((Ref)builtinTypes.get(LOCALE_TYPE_NAME)).get(), true, false, false));
        fromLocaleStringParameters.add(new JSParameterTypeDecoratorImpl("number", (JSType)((Ref)builtinTypes.get(QSTRING_TYPE_NAME)).get(), true, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("fromLocaleString", typeSrc, fromLocaleStringParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> toLocaleCurrencyStringParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        toLocaleCurrencyStringParameters.add(new JSParameterTypeDecoratorImpl("locale", (JSType)((Ref)builtinTypes.get(LOCALE_TYPE_NAME)).get(), true, false, false));
        toLocaleCurrencyStringParameters.add(new JSParameterTypeDecoratorImpl("symbol", null, true, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("toLocaleCurrencyString", typeSrc, toLocaleCurrencyStringParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> toLocaleStringParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        toLocaleStringParameters.add(new JSParameterTypeDecoratorImpl("locale", (JSType)((Ref)builtinTypes.get(LOCALE_TYPE_NAME)).get(), true, false, false));
        toLocaleStringParameters.add(new JSParameterTypeDecoratorImpl("format", null, true, false, false));
        toLocaleStringParameters.add(new JSParameterTypeDecoratorImpl("precision", (JSType)((Ref)builtinTypes.get(INT_TYPE_NAME)).get(), false, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("toLocaleString", typeSrc, toLocaleStringParameters, (Ref<JSType>)stringType));
        builtinTypes.put("Number", new Ref((Object)new QmlRecordType(typeSrc, curTypeMembers, "Number")));
        curTypeMembers.clear();
        ArrayList<JSParameterTypeDecoratorImpl> fromLocaleDateStringParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        fromLocaleDateStringParameters.add(new JSParameterTypeDecoratorImpl("locale", (JSType)((Ref)builtinTypes.get(LOCALE_TYPE_NAME)).get(), true, false, false));
        fromLocaleDateStringParameters.add(new JSParameterTypeDecoratorImpl("dateString", (JSType)stringType.get(), false, false, false));
        fromLocaleDateStringParameters.add(new JSParameterTypeDecoratorImpl("format", null, true, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("fromLocaleDateString", typeSrc, fromLocaleDateStringParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> fromLocaleString2Parameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        fromLocaleString2Parameters.add(new JSParameterTypeDecoratorImpl("locale", (JSType)((Ref)builtinTypes.get(LOCALE_TYPE_NAME)).get(), true, false, false));
        fromLocaleString2Parameters.add(new JSParameterTypeDecoratorImpl("dateTimeString", (JSType)stringType.get(), false, false, false));
        fromLocaleString2Parameters.add(new JSParameterTypeDecoratorImpl("format", null, true, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("fromLocaleString", typeSrc, fromLocaleString2Parameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> fromLocaleTimeStringParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        fromLocaleTimeStringParameters.add(new JSParameterTypeDecoratorImpl("locale", (JSType)((Ref)builtinTypes.get(LOCALE_TYPE_NAME)).get(), true, false, false));
        fromLocaleTimeStringParameters.add(new JSParameterTypeDecoratorImpl("timeString", (JSType)stringType.get(), false, false, false));
        fromLocaleTimeStringParameters.add(new JSParameterTypeDecoratorImpl("format", null, true, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("fromLocaleTimeString", typeSrc, fromLocaleTimeStringParameters, (Ref<JSType>)stringType));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("timeZoneUpdated", typeSrc, emptyParameters, (Ref<JSType>)stringType));
        ArrayList<JSParameterTypeDecoratorImpl> toLocaleDateStringParameters = new ArrayList<JSParameterTypeDecoratorImpl>();
        toLocaleDateStringParameters.add(new JSParameterTypeDecoratorImpl("locale", (JSType)((Ref)builtinTypes.get(LOCALE_TYPE_NAME)).get(), true, false, false));
        toLocaleDateStringParameters.add(new JSParameterTypeDecoratorImpl("format", null, true, false, false));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("toLocaleDateString", typeSrc, toLocaleDateStringParameters, (Ref<JSType>)stringType));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("toLocaleString", typeSrc, toLocaleDateStringParameters, (Ref<JSType>)stringType));
        curTypeMembers.add((Object)new QmlMethodSignatureImpl("toLocaleTimeString", typeSrc, toLocaleDateStringParameters, (Ref<JSType>)stringType));
        builtinTypes.put("Date", new Ref((Object)new QmlRecordType(typeSrc, curTypeMembers, "Date")));
        builtinTypes.put("Qt", QmlImportDeclarationImpl.createQtType(typeSrc, builtinTypes));
        return builtinTypes;
    }

    private String getVersionStr() {
        ASTNode node = this.getNode().getFirstChildNode().getTreeNext().getTreeNext();
        if ((node = node.getTreeNext()) == null) {
            return "";
        }
        return (node = node.getTreeNext()) == null ? "" : node.getText();
    }

    @Nullable
    private static VirtualFile getQmltypesFile(@NotNull VirtualFile rootDir, @NotNull String relativePath, @NotNull String lastFolder) {
        Object relativePathPrefix;
        VirtualFile file;
        if (rootDir == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(2);
        }
        if (relativePath == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(3);
        }
        if (lastFolder == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(4);
        }
        if ((file = rootDir.findFileByRelativePath((String)(relativePathPrefix = relativePath.isEmpty() ? "" : relativePath + "/") + PLUGINS_QMLTYPES)) != null && file.exists()) {
            return file;
        }
        file = rootDir.findFileByRelativePath((String)relativePathPrefix + lastFolder + QMLTYPES_SUFFIX);
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getQmldirFile(@NotNull VirtualFile rootDir, @NotNull String relativePath) {
        Object relativePathPrefix;
        VirtualFile file;
        if (rootDir == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(5);
        }
        if (relativePath == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(6);
        }
        if ((file = rootDir.findFileByRelativePath((String)(relativePathPrefix = relativePath.isEmpty() ? "" : relativePath + "/") + QMLDIR)) != null && file.exists()) {
            return file;
        }
        return null;
    }

    protected List<VirtualFile> getImportFiles(@NotNull List<VirtualFile> qmlDirs, @NotNull List<String> parts, @NotNull String versionStr, boolean isDirectoryImportByPath) {
        if (qmlDirs == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(7);
        }
        if (parts == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(8);
        }
        if (versionStr == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(9);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Version version = versionStr.isEmpty() ? null : Version.parseVersion((String)versionStr);
        ArrayList<String> partsWithVersion = new ArrayList<String>(parts);
        if (version != null && version.major > 1) {
            partsWithVersion.set(parts.size() - 1, parts.get(parts.size() - 1) + "." + version.major);
        }
        String mainPath = parts.isEmpty() ? "" : StringUtil.join(partsWithVersion, (String)"/");
        for (VirtualFile qmlDir : qmlDirs) {
            @Nullable VirtualFile file = QmlImportDeclarationImpl.getQmltypesFile(qmlDir, mainPath, parts.isEmpty() ? "" : parts.get(parts.size() - 1));
            @Nullable VirtualFile qmldirFile = QmlImportDeclarationImpl.getQmldirFile(qmlDir, mainPath);
            if (file == null && !parts.isEmpty()) {
                mainPath = StringUtil.join(parts, (String)"/");
                file = QmlImportDeclarationImpl.getQmltypesFile(qmlDir, mainPath, parts.get(parts.size() - 1));
            }
            if (file == null && qmldirFile == null) {
                if (!isDirectoryImportByPath) continue;
                for (VirtualFile child : qmlDir.getChildren()) {
                    if (!"qml".equals(child.getExtension())) continue;
                    files.add(child);
                }
                return files;
            }
            if (file != null && file.exists()) {
                files.add(file);
            }
            if (qmldirFile != null && qmldirFile.exists()) {
                ArrayList<VirtualFile> additionalFiles = new ArrayList<VirtualFile>();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(qmldirFile.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    HashSet<String> uniqueNames = new HashSet<String>();
                    while ((line = reader.readLine()) != null) {
                        int qmlFileNameIndex;
                        String qmlFileName;
                        if (line.startsWith(DEFAULT_IMPORT)) {
                            ArrayList<String> innerParts;
                            int endIndex = (line = line.substring(DEFAULT_IMPORT.length())).indexOf(" ");
                            if (endIndex != -1) {
                                line = line.substring(0, endIndex);
                            }
                            if ((innerParts = new ArrayList<String>(Arrays.asList(line.split("\\.")))).size() <= parts.size()) continue;
                            additionalFiles.addAll(this.getImportFiles(qmlDirs, innerParts, versionStr, false));
                            continue;
                        }
                        if (!line.endsWith(".qml") || uniqueNames.contains(qmlFileName = line.substring(qmlFileNameIndex = line.lastIndexOf(32) + 1))) continue;
                        uniqueNames.add(qmlFileName);
                        @Nullable VirtualFile qmlFile = qmldirFile.getParent().findFileByRelativePath(qmlFileName);
                        if (qmlFile == null) continue;
                        additionalFiles.add(qmlFile);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                files.addAll(additionalFiles);
            }
            return files;
        }
        return Collections.emptyList();
    }

    private synchronized HashMap<String, Ref<JSType>> getTypesCache() {
        this.readQmlTypesWhenRequired();
        return this.myTypesCache;
    }

    private boolean aliasNameIsTheSame() {
        QmlImportAliasExpressionImpl alias = this.getAlias();
        if (alias == null) {
            return this.myAlias.isEmpty();
        }
        return alias.getText().equals(this.myAlias);
    }

    protected boolean qmlDirExists(@Nullable VirtualFile qmlDir) {
        return qmlDir != null && qmlDir.exists();
    }

    protected boolean shouldAddBuiltinTypes(List<PsiElement> importsBeforeCurrent) {
        return importsBeforeCurrent.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readQmlTypesWhenRequired() {
        QmlSettings qmlSettings;
        HashMap<String, QmlComponentTemplate> components;
        if (this.getParent() == null) {
            return;
        }
        Project project = this.getProject();
        if (this.myNotSubscribed) {
            this.myNotSubscribed = false;
            project.getMessageBus().connect().subscribe(QmlSettingsListener.TOPIC, (Object)new QmlSettingsListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResetImports() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        QmlImportDeclarationImpl.this.myComponents = null;
                        QmlImportDeclarationImpl.this.myTypesCache = null;
                    }
                }
            });
        }
        PsiElement[] children = this.getNode().getPsi().getChildren();
        List<PsiElement> importName = Arrays.stream(children).filter(elem -> elem instanceof QmlImportReferenceExpressionImpl).toList();
        @Nullable String quotedString = this.getStringInQuotes();
        if (importName.isEmpty() && (quotedString == null || this.isJSImport())) {
            this.myComponents = null;
            return;
        }
        if (quotedString == null) {
            if (this.myName.equals(importName.get(0).getText()) && this.aliasNameIsTheSame() && this.myComponents != null) {
                return;
            }
            this.myName = importName.get(0).getText();
        } else {
            if (this.myName.equals(quotedString) && this.aliasNameIsTheSame() && this.myComponents != null) {
                return;
            }
            this.myName = quotedString;
        }
        QmlImportAliasExpressionImpl alias = this.getAlias();
        if (alias != null) {
            this.myAlias = alias.getText();
        }
        if ((components = (qmlSettings = QmlSettings.getInstance(project)).getComponents(this.myName)) != null) {
            this.myComponents = components;
            this.myTypesCache = qmlSettings.getTypesCache(this.myName);
            return;
        }
        QmlImportDeclarationImpl qmlImportDeclarationImpl = this;
        synchronized (qmlImportDeclarationImpl) {
            PsiFile builtinsFile;
            List<String> parts;
            this.myComponents = new HashMap();
            this.myTypesCache = new HashMap<String, Ref<JSType>>(myBuiltinTypes);
            QtSettings settings = QtSettings.getInstance((Project)project);
            @Nullable VirtualFile qmlMainDir = LocalFileSystem.getInstance().findFileByPath(settings.getResultingQmlDir());
            if (quotedString == null && !this.qmlDirExists(qmlMainDir)) {
                return;
            }
            @Nullable PsiFile currentFile = this.getContainingFile();
            if (currentFile != null) {
                currentFile = currentFile.getOriginalFile();
            }
            VirtualFile importedFolder = null;
            if (quotedString != null && !this.isJSImport() && currentFile != null && currentFile.getVirtualFile() != null) {
                VirtualFile parentFolder = currentFile.getVirtualFile().getParent();
                importedFolder = parentFolder.findFileByRelativePath(quotedString);
                if (importedFolder == null) {
                    return;
                }
                qmlMainDir = importedFolder;
            }
            if ((parts = this.getImportParts()).isEmpty() && importedFolder == null) {
                return;
            }
            ArrayList<VirtualFile> qmlDirs = new ArrayList<VirtualFile>();
            qmlDirs.add(qmlMainDir);
            if (importedFolder == null) {
                for (String path : qmlSettings.getExtraQmlPaths(settings.getCurrentProfile())) {
                    @Nullable VirtualFile foundPath = LocalFileSystem.getInstance().findFileByPath(path);
                    if (foundPath == null) continue;
                    qmlDirs.add(foundPath);
                }
            }
            List<VirtualFile> importFiles = this.getImportFiles(qmlDirs, parts, this.getVersionStr(), importedFolder != null);
            List importsBeforeCurrent = ContainerUtil.filter((Object[])this.getNode().getPsi().getContainingFile().getChildren(), element -> element instanceof QmlImportDeclarationImpl && element.getNode().getStartOffset() < this.getNode().getStartOffset());
            for (PsiElement importBefore : importsBeforeCurrent) {
                if (!(importBefore instanceof QmlImportDeclarationImpl)) continue;
                QmlImportDeclarationImpl importImpl = (QmlImportDeclarationImpl)importBefore;
                this.myTypesCache.putAll(importImpl.getTypesCache());
            }
            QmlLocalImplicitElementImpl componentElement = new QmlLocalImplicitElementImpl(COMPONENT_TYPE_NAME, null, (PsiElement)(importName.isEmpty() ? this : importName.get(0)), JSImplicitElement.Type.Class);
            QmlComponentTemplate componentTemplate = new QmlComponentTemplate(componentElement, COMPONENT_TYPE_NAME, null);
            Ref<JSType> componentType = QmlImportDeclarationImpl.getOrCreateType(COMPONENT_TYPE_NAME, this.myComponents, this.myTypesCache);
            assert (componentType != null);
            componentTemplate.setJSType((JSType)componentType.get());
            this.myComponents.put(COMPONENT_TYPE_NAME, componentTemplate);
            HashMap members = new HashMap();
            HashMap prototypes = new HashMap();
            ArrayList<@NotNull PsiFile> qmlPsiFiles = new ArrayList<PsiFile>();
            if (this.shouldAddBuiltinTypes(importsBeforeCurrent) && qmlMainDir != null && (builtinsFile = this.readFile(qmlMainDir.findFileByRelativePath("builtins.qmltypes"))) != null) {
                qmlPsiFiles.add(builtinsFile);
            }
            for (VirtualFile importFile : importFiles) {
                @Nullable PsiFile qmlPsiFile = this.readFile(importFile);
                if (qmlPsiFile == null) continue;
                qmlPsiFiles.add(qmlPsiFile);
            }
            ProgressManager.getInstance().executeNonCancelableSection(() -> {
                for (PsiFile file : qmlPsiFiles) {
                    if (!file.getName().endsWith(QMLTYPES_SUFFIX)) continue;
                    this.readQmlTypes(file, members, prototypes);
                }
                QmlImportDeclarationImpl.setUpComponents(this.myComponents, this.myTypesCache, members, prototypes);
                for (PsiFile file : qmlPsiFiles) {
                    QmlLocalImplicitElementImpl item;
                    if (!file.getName().endsWith(".qml") || (item = QmlImportDeclarationImpl.createImplicitElementFromFile(file, true)) == null) continue;
                    QmlComponentTemplate qmlFileTemplate = new QmlComponentTemplate(item, item.getName(), null);
                    qmlFileTemplate.setJSType(item.getJSType());
                    this.myComponents.put(item.getName(), qmlFileTemplate);
                }
            });
        }
        qmlSettings.putComponents(this.myName, this.myComponents);
        qmlSettings.putTypesCache(this.myName, this.myTypesCache);
    }

    private static void setUpComponents(HashMap<String, QmlComponentTemplate> allComponents, HashMap<String, Ref<JSType>> typesCache, HashMap<String, ArrayList<QmlMember>> members, HashMap<String, String> prototypes) {
        for (QmlComponentTemplate component : allComponents.values()) {
            ArrayList<QmlMember> itemProperties = members.get(component.getType());
            String qtPrototypeName = prototypes.get(component.getType());
            while (qtPrototypeName != null) {
                ArrayList<QmlMember> curMembers = members.get(qtPrototypeName);
                if (curMembers != null) {
                    List<QmlMember> currentProperties = curMembers.stream().filter(prop -> !prop.name.equals("id")).toList();
                    itemProperties.addAll(currentProperties);
                } else if (prototypes.get(qtPrototypeName) == null) {
                    Ref<JSType> prototype = typesCache.get(qtPrototypeName);
                    if (prototype == null) break;
                    component.myLastPrototype = (JSType)prototype.get();
                    break;
                }
                qtPrototypeName = prototypes.get(qtPrototypeName);
            }
            component.setProperties(itemProperties);
        }
        for (QmlComponentTemplate component : allComponents.values()) {
            Ref<JSType> jsType = QmlImportDeclarationImpl.getOrCreateType(component.getType(), allComponents, typesCache);
            if (jsType == null) continue;
            component.setJSType((JSType)jsType.get());
        }
    }

    @TestOnly
    public static HashMap<String, QmlComponentTemplate> readQmlTypesTest(Project project, String fileText, PsiElement provider) {
        HashMap<String, QmlComponentTemplate> allComponents = new HashMap<String, QmlComponentTemplate>();
        HashMap<String, Ref<JSType>> typesCache = new HashMap<String, Ref<JSType>>(myBuiltinTypes);
        HashMap<String, ArrayList<QmlMember>> members = new HashMap<String, ArrayList<QmlMember>>();
        HashMap<String, String> prototypes = new HashMap<String, String>();
        QmlLocalImplicitElementImpl componentElement = new QmlLocalImplicitElementImpl(COMPONENT_TYPE_NAME, null, provider, JSImplicitElement.Type.Class);
        QmlComponentTemplate componentTemplate = new QmlComponentTemplate(componentElement, COMPONENT_TYPE_NAME, null);
        Ref<JSType> componentType = QmlImportDeclarationImpl.getOrCreateType(COMPONENT_TYPE_NAME, allComponents, typesCache);
        assert (componentType != null);
        componentTemplate.setJSType((JSType)componentType.get());
        allComponents.put(COMPONENT_TYPE_NAME, componentTemplate);
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (FileType)QmlFileType.INSTANCE, (CharSequence)fileText);
        QmlImportDeclarationImpl.readQmlTypesFromFile(file, allComponents, typesCache, members, prototypes);
        QmlImportDeclarationImpl.setUpComponents(allComponents, typesCache, members, prototypes);
        return allComponents;
    }

    private static Pair<@NotNull String, @NotNull String> extractNameAndType(@NotNull PsiElement scope) {
        String typeStr;
        List typeLiteral;
        String nameStr;
        List nameLiteral;
        if (scope == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(10);
        }
        String name = "";
        String type = "";
        List nameElem = ContainerUtil.filter((Object[])scope.getChildren(), element -> element instanceof JSAssignmentExpression && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("name"));
        List typeElem = ContainerUtil.filter((Object[])scope.getChildren(), element -> element instanceof JSAssignmentExpression && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("type"));
        if (!(nameElem.isEmpty() || (nameLiteral = ContainerUtil.filter((Object[])((PsiElement)nameElem.get(0)).getChildren(), element -> element instanceof JSLiteralExpression)).isEmpty() || (nameStr = ((JSLiteralExpression)nameLiteral.get(0)).getStringValue()) == null || nameStr.startsWith("_q_"))) {
            name = nameStr;
        }
        if (!typeElem.isEmpty() && !(typeLiteral = ContainerUtil.filter((Object[])((PsiElement)typeElem.get(0)).getChildren(), element -> element instanceof JSLiteralExpression)).isEmpty() && (typeStr = ((JSLiteralExpression)typeLiteral.get(0)).getStringValue()) != null) {
            type = typeStr;
        }
        return new Pair((Object)name, (Object)type);
    }

    private static void readQmlTypesFromFile(@NotNull PsiFile file, HashMap<String, QmlComponentTemplate> allComponents, HashMap<String, Ref<JSType>> typesCache, HashMap<String, ArrayList<QmlMember>> members, HashMap<String, String> prototypes) {
        Optional<PsiElement> optModuleElem;
        if (file == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(11);
        }
        if ((optModuleElem = Arrays.stream(file.getChildren()).filter(element -> element instanceof QmlElementDeclarationImpl).findFirst()).isEmpty()) {
            return;
        }
        List<PsiElement> moduleScope = Arrays.stream(optModuleElem.get().getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
        if (moduleScope.isEmpty()) {
            return;
        }
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        @NotNull List components = ContainerUtil.filter((Object[])moduleScope.get(0).getChildren(), element -> element instanceof QmlElementDeclarationImpl && element.getChildren().length > 0 && element.getChildren()[0].getText().equals(COMPONENT_TYPE_NAME));
        for (PsiElement component : components) {
            List prototypeNameLiteral;
            Object object;
            String type;
            List componentNameLiteral;
            List<PsiElement> componentScope = Arrays.stream(component.getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
            if (componentScope.isEmpty()) continue;
            List exports = ContainerUtil.filter((Object[])componentScope.get(0).getChildren(), element -> element instanceof JSAssignmentExpression && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("exports"));
            List componentName = ContainerUtil.filter((Object[])componentScope.get(0).getChildren(), element -> element instanceof JSAssignmentExpression && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("name"));
            if (componentName.isEmpty() || (componentNameLiteral = ContainerUtil.filter((Object[])((PsiElement)componentName.get(0)).getChildren(), element -> element instanceof JSLiteralExpression)).isEmpty() || (type = (String)QmlImportDeclarationImpl.extractName((JSLiteralExpression)((JSLiteralExpression)componentNameLiteral.get((int)0)), (boolean)false).first).isEmpty()) continue;
            QmlLocalImplicitElementImpl item = null;
            Object uniqueName = "";
            if (exports.isEmpty()) {
                String suffix = file.getVirtualFile() != null ? file.getVirtualFile().getPath() : "";
                uniqueName = nameGenerator.generateUniqueName(RESERVED_NAME) + suffix;
                item = new QmlLocalImplicitElementImpl((String)uniqueName, null, component, JSImplicitElement.Type.Class);
            } else {
                JSExpression[] expressions;
                int n;
                int n2;
                List exportsArray = ContainerUtil.filter((Object[])((PsiElement)exports.get(0)).getChildren(), element -> element instanceof JSArrayLiteralExpression);
                if (!exportsArray.isEmpty() && (n2 = 0) < (n = ((JSExpression[])(object = (expressions = ((JSArrayLiteralExpression)exportsArray.get(0)).getExpressions()))).length)) {
                    JSExpression expr = object[n2];
                    @NotNull Pair<String, String> nameAndVersion = QmlImportDeclarationImpl.extractName((JSLiteralExpression)expr, true);
                    item = new QmlLocalImplicitElementImpl((String)nameAndVersion.first, null, component, JSImplicitElement.Type.Class);
                    uniqueName = (String)nameAndVersion.first + (String)nameAndVersion.second;
                }
            }
            if (item == null || allComponents.containsKey(item.getName())) continue;
            QmlComponentTemplate elementDeclaration = new QmlComponentTemplate(item, type, component);
            allComponents.put((String)uniqueName, elementDeclaration);
            ArrayList<QmlMember> currentMembers = new ArrayList<QmlMember>();
            currentMembers.add(new QmlMember(QmlMember.Kind.Property, "id"));
            for (PsiElement prop : ContainerUtil.filter((Object[])componentScope.get(0).getChildren(), element -> {
                if (element instanceof QmlElementDeclarationImpl && element.getChildren().length > 1) {
                    String text = element.getChildren()[0].getText();
                    return text.equals("Property") || text.equals("Method") || text.equals("Signal");
                }
                return false;
            })) {
                List<PsiElement> propScope = Arrays.stream(prop.getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
                if (propScope.isEmpty()) continue;
                Pair<String, String> propNameAndType = QmlImportDeclarationImpl.extractNameAndType(propScope.get(0));
                if (((String)propNameAndType.first).isEmpty()) continue;
                QmlMember.Kind kind = QmlMember.Kind.Property;
                PsiElement propKind = prop.getChildren()[0];
                switch (propKind.getText()) {
                    case "Method": {
                        kind = QmlMember.Kind.Method;
                        break;
                    }
                    case "Signal": {
                        kind = QmlMember.Kind.Signal;
                        break;
                    }
                }
                if (kind == QmlMember.Kind.Method) {
                    ArrayList<QmlMember> parameters = new ArrayList<QmlMember>();
                    @NotNull List paramNodes = ContainerUtil.filter((Object[])propScope.get(0).getChildren(), element -> element instanceof QmlElementDeclarationImpl && element.getChildren()[0].getText().equals("Parameter"));
                    for (PsiElement paramNode : paramNodes) {
                        List<PsiElement> paramNodeScope = Arrays.stream(paramNode.getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
                        if (paramNodeScope.isEmpty()) continue;
                        Pair<String, String> paramNameAndType = QmlImportDeclarationImpl.extractNameAndType(paramNodeScope.get(0));
                        if (((String)paramNameAndType.second).isEmpty()) continue;
                        parameters.add(new QmlMember(QmlMember.Kind.Property, (String)paramNameAndType.first, (String)paramNameAndType.second, paramNode));
                    }
                    currentMembers.add(new QmlMember((String)propNameAndType.first, (String)propNameAndType.second, parameters, prop));
                    continue;
                }
                currentMembers.add(new QmlMember(kind, (String)propNameAndType.first, (String)propNameAndType.second, prop));
            }
            object = ContainerUtil.filter((Object[])componentScope.get(0).getChildren(), element -> element instanceof QmlElementDeclarationImpl && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("Enum")).iterator();
            while (object.hasNext()) {
                List valuesArray;
                List nameLiteral;
                List enumName;
                PsiElement currentEnum = (PsiElement)object.next();
                List<PsiElement> enumScope = Arrays.stream(currentEnum.getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
                if (enumScope.isEmpty() || (enumName = ContainerUtil.filter((Object[])enumScope.get(0).getChildren(), element -> element instanceof JSAssignmentExpression && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("name"))).isEmpty() || (nameLiteral = ContainerUtil.filter((Object[])((PsiElement)enumName.get(0)).getChildren(), element -> element instanceof JSLiteralExpression)).isEmpty()) continue;
                @Nullable String enumTypeName = ((JSLiteralExpression)nameLiteral.get(0)).getStringValue();
                @NotNull JSTypeSource typeSrc = JSTypeSourceFactory.createTypeSource((PsiElement)currentEnum, (boolean)true);
                ArrayList<QmlPropertySignatureImpl> enumTypeMembers = new ArrayList<QmlPropertySignatureImpl>();
                Ref enumTypeRef = new Ref();
                List values = ContainerUtil.filter((Object[])enumScope.get(0).getChildren(), element -> element instanceof JSAssignmentExpression && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("values"));
                if (!values.isEmpty() && !(valuesArray = ContainerUtil.filter((Object[])((PsiElement)values.get(0)).getChildren(), element -> element instanceof JSArrayLiteralExpression)).isEmpty()) {
                    JSExpression[] valueExprs;
                    for (JSExpression expr : valueExprs = ((JSArrayLiteralExpression)valuesArray.get(0)).getExpressions()) {
                        String name;
                        if (!(expr instanceof JSLiteralExpression) || (name = ((JSLiteralExpression)expr).getStringValue()) == null) continue;
                        currentMembers.add(new QmlMember(QmlMember.Kind.EnumValue, name, enumTypeName, (PsiElement)expr));
                        enumTypeMembers.add(new QmlPropertySignatureImpl(name, JSTypeSourceFactory.createTypeSource((PsiElement)expr, (boolean)true), (Ref<JSType>)enumTypeRef, QmlMember.Kind.EnumValue));
                    }
                }
                QmlRecordType enumJSType = new QmlRecordType(typeSrc, enumTypeMembers, enumTypeName, false);
                enumTypeRef.set((Object)enumJSType);
                typesCache.put(enumTypeName, (Ref<JSType>)enumTypeRef);
            }
            members.put(type, currentMembers);
            List prototypeName = ContainerUtil.filter((Object[])componentScope.get(0).getChildren(), element -> element instanceof JSAssignmentExpression && element.getChildren().length > 1 && element.getChildren()[0].getText().equals("prototype"));
            if (prototypeName.isEmpty() || (prototypeNameLiteral = ContainerUtil.filter((Object[])((PsiElement)prototypeName.get(0)).getChildren(), element -> element instanceof JSLiteralExpression)).isEmpty()) continue;
            prototypes.put(type, ((JSLiteralExpression)prototypeNameLiteral.get(0)).getStringValue());
        }
    }

    @Nullable
    public static PsiFile readQmlFile(@NotNull VirtualFile vFile, @NotNull Project project) {
        Document document;
        if (vFile == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(12);
        }
        if (project == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(13);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(vFile)) == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
    }

    @Nullable
    public static QmlLocalImplicitElementImpl createImplicitElementFromFile(@Nullable PsiFile qmlPsiFile, boolean needType) {
        return QmlImportDeclarationImpl.createImplicitElementFromFile(qmlPsiFile, needType, new HashSet<VirtualFile>());
    }

    @Nullable
    public static QmlLocalImplicitElementImpl createImplicitElementFromFile(@Nullable PsiFile qmlPsiFile, boolean needType, @NotNull HashSet<VirtualFile> visitedFiles) {
        if (visitedFiles == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(14);
        }
        if (qmlPsiFile == null) {
            return null;
        }
        @Nullable ASTNode parentElementDecl = qmlPsiFile.getNode().findChildByType(QmlElementTypes.QML_ELEMENT_DECLARATION);
        if (parentElementDecl == null) {
            return null;
        }
        PsiElement parentElementDeclPsi = parentElementDecl.getPsi();
        if (!(parentElementDeclPsi instanceof QmlElementDeclarationImpl)) {
            return null;
        }
        QmlElementDeclarationImpl elemDecl = (QmlElementDeclarationImpl)parentElementDecl.getPsi();
        String name = qmlPsiFile.getName().substring(0, qmlPsiFile.getName().length() - "qml".length() - 1);
        JSType jsType = needType ? elemDecl.getLastJsType(visitedFiles) : null;
        return new QmlLocalImplicitElementImpl(name, jsType, (PsiElement)qmlPsiFile, JSImplicitElement.Type.Class);
    }

    @Nullable
    protected PsiFile readFile(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return QmlImportDeclarationImpl.readQmlFile(file, this.getProject());
    }

    private synchronized void readQmlTypes(PsiFile file, HashMap<String, ArrayList<QmlMember>> members, HashMap<String, String> prototypes) {
        QmlImportDeclarationImpl.readQmlTypesFromFile(file, this.myComponents, this.myTypesCache, members, prototypes);
    }

    public QmlImportAliasExpressionImpl getAlias() {
        return this.getLastChild() instanceof QmlImportAliasExpressionImpl ? (QmlImportAliasExpressionImpl)this.getLastChild() : null;
    }

    public synchronized boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        QmlImportAliasExpressionImpl alias;
        if (processor == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(17);
        }
        if ((alias = this.getAlias()) != null) {
            QmlLocalImplicitElementImpl aliasElement = new QmlLocalImplicitElementImpl(alias.getText(), null, (PsiElement)this, JSImplicitElement.Type.Namespace);
            processor.execute((PsiElement)aliasElement, state);
            return super.processDeclarations(processor, state, lastParent, place);
        }
        return this.processDeclarationsWithoutAliasCheck(processor, state, lastParent, place);
    }

    public synchronized boolean processDeclarationsWithoutAliasCheck(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(18);
        }
        if (state == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(19);
        }
        if (place == null) {
            QmlImportDeclarationImpl.$$$reportNull$$$0(20);
        }
        this.readQmlTypesWhenRequired();
        if (this.myComponents == null || this.getContainingFile() == null) {
            return super.processDeclarations(processor, state, lastParent, place);
        }
        for (QmlComponentTemplate qmlComponentTemplate : this.myComponents.values()) {
            QmlLocalImplicitElementImpl element = qmlComponentTemplate.getRelatedElement();
            if (element.getName().startsWith(RESERVED_NAME)) continue;
            processor.execute((PsiElement)element, state);
        }
        for (Ref ref : this.myTypesCache.values()) {
            QmlRecordType qmlRecord;
            Object object = ref.get();
            if (!(object instanceof QmlRecordType) || (qmlRecord = (QmlRecordType)((Object)object)).isInternal()) continue;
            @Nullable PsiElement srcElement = ((JSType)ref.get()).getSource().getSourceElement();
            QmlLocalImplicitElementImpl typeElement = new QmlLocalImplicitElementImpl(((JSType)ref.get()).getTypeText(), (JSType)ref.get(), (PsiElement)(srcElement == null ? this : srcElement), JSImplicitElement.Type.Class);
            processor.execute((PsiElement)typeElement, state);
        }
        List<String> parts = this.getImportParts();
        for (String part : parts) {
            QmlLocalImplicitElementImpl importElement = new QmlLocalImplicitElementImpl(part, null, (PsiElement)this, JSImplicitElement.Type.Class);
            processor.execute((PsiElement)importElement, state);
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public synchronized List<QmlComponentTemplate> getAllComponents() {
        this.readQmlTypesWhenRequired();
        if (this.myComponents == null) {
            return Collections.emptyList();
        }
        return this.myComponents.values().stream().toList();
    }

    public synchronized QmlComponentTemplate getComponent(String name) {
        this.readQmlTypesWhenRequired();
        if (this.myComponents == null) {
            return null;
        }
        QmlImportAliasExpressionImpl alias = this.getAlias();
        if (alias != null) {
            if (!name.startsWith(this.getLastChild().getText() + ".")) {
                return null;
            }
            name = name.substring(this.getLastChild().getText().length() + 1);
        }
        String finalName = name;
        Optional<QmlComponentTemplate> found = this.myComponents.values().stream().filter(component -> component.getRelatedElement().getName().equals(finalName)).findFirst();
        return found.orElse(null);
    }

    public synchronized JSType getType(String name) {
        this.readQmlTypesWhenRequired();
        if (this.myTypesCache == null) {
            return null;
        }
        Ref<JSType> typeRef = this.myTypesCache.get(name);
        return typeRef == null ? null : (JSType)typeRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSrc";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastFolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qmlDirs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionStr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedFiles";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createQtType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQmltypesFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQmldirFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImportFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractNameAndType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readQmlTypesFromFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readQmlFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitElementFromFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsWithoutAliasCheck";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }

    public static class QmlComponentTemplate {
        @NotNull
        private final QmlLocalImplicitElementImpl myRelatedElement;
        @NotNull
        private final String myType;
        private ArrayList<QmlMember> myProperties;
        private JSType myLastPrototype;
        private JSType myJSType;
        @Nullable
        private final PsiElement myBaseComponent;

        private QmlComponentTemplate(@NotNull QmlLocalImplicitElementImpl relatedElement, @NotNull String type, @Nullable PsiElement baseComponent) {
            if (relatedElement == null) {
                QmlComponentTemplate.$$$reportNull$$$0(0);
            }
            if (type == null) {
                QmlComponentTemplate.$$$reportNull$$$0(1);
            }
            this.myProperties = null;
            this.myLastPrototype = null;
            this.myJSType = null;
            this.myRelatedElement = relatedElement;
            this.myType = type;
            this.myBaseComponent = baseComponent;
        }

        @NotNull
        public QmlLocalImplicitElementImpl getRelatedElement() {
            QmlLocalImplicitElementImpl qmlLocalImplicitElementImpl = this.myRelatedElement;
            if (qmlLocalImplicitElementImpl == null) {
                QmlComponentTemplate.$$$reportNull$$$0(2);
            }
            return qmlLocalImplicitElementImpl;
        }

        public void setJSType(JSType jsType) {
            this.myJSType = jsType;
        }

        public JSType getJSType() {
            return this.myJSType;
        }

        public void setProperties(ArrayList<QmlMember> properties) {
            this.myProperties = properties;
        }

        public ArrayList<QmlMember> getProperties() {
            return this.myProperties;
        }

        @NotNull
        public String getType() {
            String string = this.myType;
            if (string == null) {
                QmlComponentTemplate.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relatedElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlComponentTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlComponentTemplate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelatedElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class QmlMember {
        public Kind kind;
        public String name;
        public String type;
        public List<QmlMember> parameters;
        @Nullable
        public PsiElement baseElement;

        public QmlMember(Kind kind, String name) {
            this(kind, name, "", null);
        }

        public QmlMember(Kind kind, String name, String type, @Nullable PsiElement baseElement) {
            this.kind = kind;
            this.name = name;
            this.type = type;
            this.baseElement = baseElement;
        }

        public QmlMember(String name, String type, List<QmlMember> parameters, @Nullable PsiElement baseElement) {
            this.kind = Kind.Method;
            this.name = name;
            this.type = type;
            this.parameters = parameters;
            this.baseElement = baseElement;
        }

        public static enum Kind {
            Property,
            EnumValue,
            Signal,
            Method;

        }
    }

    public static class QmlRecordType
    extends JSRecordTypeImpl {
        private final String myTypeName;
        private final boolean myIsInternal;
        @Nullable
        private final JSType myConvertableFromType;

        public QmlRecordType(@NotNull JSTypeSource source, @NotNull List<? extends JSRecordType.TypeMember> typeMembers, String typeName, boolean isInternal, @Nullable JSType convertableFromType) {
            if (source == null) {
                QmlRecordType.$$$reportNull$$$0(0);
            }
            if (typeMembers == null) {
                QmlRecordType.$$$reportNull$$$0(1);
            }
            super(source, typeMembers);
            this.myTypeName = typeName;
            this.myIsInternal = isInternal;
            this.myConvertableFromType = convertableFromType;
        }

        public QmlRecordType(@NotNull JSTypeSource source, @NotNull List<? extends JSRecordType.TypeMember> typeMembers, String typeName, boolean isInternal) {
            if (source == null) {
                QmlRecordType.$$$reportNull$$$0(2);
            }
            if (typeMembers == null) {
                QmlRecordType.$$$reportNull$$$0(3);
            }
            this(source, typeMembers, typeName, isInternal, null);
        }

        public QmlRecordType(@NotNull JSTypeSource source, @NotNull List<? extends JSRecordType.TypeMember> typeMembers, String typeName) {
            if (source == null) {
                QmlRecordType.$$$reportNull$$$0(4);
            }
            if (typeMembers == null) {
                QmlRecordType.$$$reportNull$$$0(5);
            }
            this(source, typeMembers, typeName, true);
        }

        protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
            if (format == null) {
                QmlRecordType.$$$reportNull$$$0(6);
            }
            if (builder == null) {
                QmlRecordType.$$$reportNull$$$0(7);
            }
            builder.append(this.myTypeName);
        }

        public boolean isInternal() {
            return this.myIsInternal;
        }

        @NotNull
        public JSType transformTypeHierarchy(@NotNull JSRecursiveTypeTransformer transformation) {
            if (transformation == null) {
                QmlRecordType.$$$reportNull$$$0(8);
            }
            QmlRecordType qmlRecordType = this;
            if (qmlRecordType == null) {
                QmlRecordType.$$$reportNull$$$0(9);
            }
            return qmlRecordType;
        }

        public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
            if (type == null) {
                QmlRecordType.$$$reportNull$$$0(10);
            }
            return true;
        }

        @TestOnly
        public List<JSRecordType.TypeMember> getAllProperties() {
            return this.myAllTypeMembers.stream().filter(member -> member instanceof QmlPropertySignatureImpl && ((QmlPropertySignatureImpl)member).myKind == QmlMember.Kind.Property).toList();
        }

        @TestOnly
        public List<JSRecordType.TypeMember> getAllMethods() {
            return this.myAllTypeMembers.stream().filter(member -> member instanceof QmlMethodSignatureImpl).toList();
        }

        @TestOnly
        public List<JSRecordType.TypeMember> getAllEnumValues() {
            return this.myAllTypeMembers.stream().filter(member -> member instanceof QmlPropertySignatureImpl && ((QmlPropertySignatureImpl)member).myKind == QmlMember.Kind.EnumValue).toList();
        }

        @TestOnly
        public List<JSRecordType.TypeMember> getAllSignals() {
            return this.myAllTypeMembers.stream().filter(member -> member instanceof QmlPropertySignatureImpl && ((QmlPropertySignatureImpl)member).myKind == QmlMember.Kind.Signal).toList();
        }

        protected boolean checkAlwaysAssignableType(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
            if (elementType == null) {
                QmlRecordType.$$$reportNull$$$0(11);
            }
            if (this.myConvertableFromType != null && JSResolveUtil.isAssignableJSType((JSType)this.myConvertableFromType, (JSType)elementType, (ProcessingContext)processingContext)) {
                return true;
            }
            return super.checkAlwaysAssignableType(elementType, processingContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeMembers";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transformation";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlRecordType";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlRecordType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformTypeHierarchy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTypeTextImpl";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "transformTypeHierarchy";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isEquivalentToWithSameClass";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "checkAlwaysAssignableType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 9 -> new IllegalStateException(string);
            };
        }
    }

    public static class QmlPropertySignatureImpl
    extends PropertySignatureImpl {
        @NotNull
        private final JSTypeSource mySource;
        private final Ref<JSType> myTypeRef;
        private final QmlMember.Kind myKind;

        public QmlPropertySignatureImpl(@NotNull String name, @NotNull JSTypeSource source, @Nullable Ref<JSType> typeRef, QmlMember.Kind kind) {
            if (name == null) {
                QmlPropertySignatureImpl.$$$reportNull$$$0(0);
            }
            if (source == null) {
                QmlPropertySignatureImpl.$$$reportNull$$$0(1);
            }
            super(name, null, false, false);
            this.mySource = source;
            this.myTypeRef = typeRef;
            this.myKind = kind;
        }

        @Nullable
        public JSType getJSType() {
            return this.myTypeRef == null ? super.getJSType() : (JSType)this.myTypeRef.get();
        }

        public int getMemberHashCode() {
            return Objects.hash(((Object)((Object)this)).getClass(), this.getMemberName(), JSTypeHashCodeUtil.getHashCodeSafe((JSType)super.getJSType()), this.isOptional());
        }

        public QmlMember.Kind getKind() {
            return this.myKind;
        }

        @NotNull
        public JSTypeSource getSource() {
            JSTypeSource jSTypeSource = this.mySource;
            if (jSTypeSource == null) {
                QmlPropertySignatureImpl.$$$reportNull$$$0(2);
            }
            return jSTypeSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlPropertySignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlPropertySignatureImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class QmlMethodSignatureImpl
    extends PropertySignatureImpl
    implements JSRecordType.FunctionMember {
        @NotNull
        private final JSTypeSource mySource;
        @NotNull
        private final List<? extends JSParameterTypeDecorator> myParameters;
        @NotNull
        private final Ref<JSType> myReturnTypeRef;

        public QmlMethodSignatureImpl(@NotNull String name, @NotNull JSTypeSource source, @NotNull List<? extends JSParameterTypeDecorator> parameters, @NotNull Ref<JSType> returnTypeRef) {
            if (name == null) {
                QmlMethodSignatureImpl.$$$reportNull$$$0(0);
            }
            if (source == null) {
                QmlMethodSignatureImpl.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                QmlMethodSignatureImpl.$$$reportNull$$$0(2);
            }
            if (returnTypeRef == null) {
                QmlMethodSignatureImpl.$$$reportNull$$$0(3);
            }
            super(name, null, false, false);
            this.mySource = source;
            this.myParameters = parameters;
            this.myReturnTypeRef = returnTypeRef;
        }

        @Nullable
        public JSType getJSType() {
            return new QmlFunctionType(this.mySource, this.myParameters, this.myReturnTypeRef);
        }

        public int getMemberHashCode() {
            int hash = Objects.hash(((Object)((Object)this)).getClass(), this.getMemberName(), this.isOptional());
            for (JSParameterTypeDecorator jSParameterTypeDecorator : this.myParameters) {
                hash = Objects.hash(hash, jSParameterTypeDecorator.getName());
            }
            return hash;
        }

        public JSTypeSource getSource() {
            return this.mySource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "returnTypeRef";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlMethodSignatureImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class QmlCallSignatureImpl
    implements CallSignatureCommonImpl {
        @NotNull
        private final JSTypeSource mySource;
        @NotNull
        private final List<? extends JSParameterTypeDecorator> myParameters;
        @NotNull
        private final Ref<JSType> myReturnTypeRef;

        public QmlCallSignatureImpl(@NotNull JSTypeSource source, @NotNull List<? extends JSParameterTypeDecorator> parameters, @NotNull Ref<JSType> returnTypeRef) {
            if (source == null) {
                QmlCallSignatureImpl.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                QmlCallSignatureImpl.$$$reportNull$$$0(1);
            }
            if (returnTypeRef == null) {
                QmlCallSignatureImpl.$$$reportNull$$$0(2);
            }
            this.mySource = source;
            this.myParameters = parameters;
            this.myReturnTypeRef = returnTypeRef;
        }

        public boolean hasNew() {
            return false;
        }

        @NotNull
        public JSFunctionType getFunctionType() {
            return new QmlFunctionType(this.mySource, this.myParameters, this.myReturnTypeRef);
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource((PsiElement)this.mySource.getSourceElement());
            if (memberSource == null) {
                QmlCallSignatureImpl.$$$reportNull$$$0(3);
            }
            return memberSource;
        }

        public int getMemberHashCode() {
            return Objects.hash(this.getClass());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnTypeRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlCallSignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlCallSignatureImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class QmlFunctionType
    extends JSFunctionTypeImpl {
        @NotNull
        private final Ref<JSType> myReturnTypeRef;

        public QmlFunctionType(@NotNull JSTypeSource source, @NotNull List<? extends JSParameterTypeDecorator> parameters, @NotNull Ref<JSType> returnTypeRef) {
            if (source == null) {
                QmlFunctionType.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                QmlFunctionType.$$$reportNull$$$0(1);
            }
            if (returnTypeRef == null) {
                QmlFunctionType.$$$reportNull$$$0(2);
            }
            super(source, parameters, null);
            this.myReturnTypeRef = returnTypeRef;
        }

        protected int hashCodeImpl() {
            int hash = Objects.hash(((Object)((Object)this)).getClass());
            for (JSParameterTypeDecorator param : this.getParameters()) {
                hash = Objects.hash(hash, param.getName());
            }
            return hash;
        }

        @Nullable
        public JSType getReturnType() {
            return (JSType)this.myReturnTypeRef.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "returnTypeRef";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/qml/psi/impl/QmlImportDeclarationImpl$QmlFunctionType";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

