/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.lang.puppet.project.meta.PuppetEnvironmentMetadata;
import com.intellij.lang.puppet.project.meta.PuppetMetadata;
import com.intellij.lang.puppet.project.meta.PuppetModuleMetadata;
import com.intellij.psi.PsiDirectory;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PuppetPsiDirectoryNode<T extends PuppetMetadata>
extends PsiDirectoryNode {
    private final T myMetadata;

    PuppetPsiDirectoryNode(PsiDirectoryNode original, T metadata) {
        super(original.getProject(), (PsiDirectory)original.getValue(), original.getSettings());
        this.myMetadata = metadata;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        if (data == null) {
            PuppetPsiDirectoryNode.$$$reportNull$$$0(0);
        }
        super.updateImpl(data);
        data.setIcon(this.computeIcon());
        data.setLocationString("(" + this.computeLocationString() + ")");
    }

    @Nullable
    protected abstract Icon computeIcon();

    @NotNull
    protected String computeLocationString() {
        String string = this.myMetadata.getPresentableName();
        if (string == null) {
            PuppetPsiDirectoryNode.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static PuppetPsiDirectoryNode getNode(@NotNull PsiDirectoryNode original, @NotNull PuppetMetadata metadata) {
        if (original == null) {
            PuppetPsiDirectoryNode.$$$reportNull$$$0(2);
        }
        if (metadata == null) {
            PuppetPsiDirectoryNode.$$$reportNull$$$0(3);
        }
        if (metadata instanceof PuppetModuleMetadata) {
            return new Module(original, (PuppetModuleMetadata)metadata);
        }
        if (metadata instanceof PuppetEnvironmentMetadata) {
            return new Environment(original, (PuppetEnvironmentMetadata)metadata);
        }
        throw new RuntimeException("Unknown metadata class: " + metadata.getClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/structure/PuppetPsiDirectoryNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/structure/PuppetPsiDirectoryNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLocationString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class Module
    extends PuppetPsiDirectoryNode<PuppetModuleMetadata> {
        Module(PsiDirectoryNode original, PuppetModuleMetadata metadata) {
            super(original, metadata);
        }

        @Override
        @NotNull
        protected Icon computeIcon() {
            Icon icon = AllIcons.Nodes.Method;
            if (icon == null) {
                Module.$$$reportNull$$$0(0);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/project/structure/PuppetPsiDirectoryNode$Module", "computeIcon"));
        }
    }

    private static class Environment
    extends PuppetPsiDirectoryNode<PuppetEnvironmentMetadata> {
        Environment(PsiDirectoryNode original, PuppetEnvironmentMetadata metadata) {
            super(original, metadata);
        }

        @Override
        @NotNull
        protected Icon computeIcon() {
            Icon icon = AllIcons.Nodes.Enum;
            if (icon == null) {
                Environment.$$$reportNull$$$0(0);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/project/structure/PuppetPsiDirectoryNode$Environment", "computeIcon"));
        }
    }
}

