/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.manipulators;

import com.intellij.lang.puppet.psi.PuppetQuotedString;
import com.intellij.lang.puppet.util.PuppetElementFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PuppetQuotedTextManipulator
extends AbstractElementManipulator<PuppetQuotedString> {
    @NotNull
    public TextRange getRangeInElement(@NotNull PuppetQuotedString element) {
        TextRange range;
        if (element == null) {
            PuppetQuotedTextManipulator.$$$reportNull$$$0(0);
        }
        if ((range = element.getTextRange()).getLength() < 2) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                PuppetQuotedTextManipulator.$$$reportNull$$$0(1);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)1, (int)(range.getLength() - 1));
        if (textRange == null) {
            PuppetQuotedTextManipulator.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public PuppetQuotedString handleContentChange(@NotNull PuppetQuotedString element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            PuppetQuotedTextManipulator.$$$reportNull$$$0(3);
        }
        if (range == null) {
            PuppetQuotedTextManipulator.$$$reportNull$$$0(4);
        }
        String oldText = element.getText();
        assert (range.getStartOffset() > 0 && range.getEndOffset() < oldText.length()) : "String range must be inside quotes, got " + range;
        String newText = range.replace(oldText, newContent);
        if (newText.length() > 2) {
            TextRange contentRange = TextRange.create((int)1, (int)(newText.length() - 1));
            if (newText.charAt(0) == '\'') {
                newText = contentRange.replace(newText, PuppetElementFactory.smartEscapeChar(contentRange.substring(newText), '\''));
            } else if (newText.charAt(0) == '\"') {
                newText = contentRange.replace(newText, PuppetElementFactory.smartEscapeChar(contentRange.substring(newText), '\"'));
            }
        }
        return (PuppetQuotedString)element.replace(PuppetElementFactory.createQuotedStringElement(element.getProject(), newText));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/manipulators/PuppetQuotedTextManipulator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/manipulators/PuppetQuotedTextManipulator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

