/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.resolve;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.psi.PsiElement;
import com.intellij.swagger.core.documentation.SwUrlFakeElement;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwMediaType;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.providers.resolve.SwTargetInfo;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/swagger/core/providers/resolve/SwEndpointTargetInfo;", "Lcom/intellij/swagger/core/providers/resolve/SwTargetInfo;", "Lcom/intellij/swagger/core/model/api/SwHttpOperation;", "modelElement", "path", "Lcom/intellij/microservices/url/UrlPath;", "schemes", "", "", "authorities", "Lcom/intellij/microservices/url/Authority;", "isRemote", "", "<init>", "(Lcom/intellij/swagger/core/model/api/SwHttpOperation;Lcom/intellij/microservices/url/UrlPath;Ljava/util/List;Ljava/util/List;Z)V", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "isDeprecated", "()Z", "documentationPsiElement", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "parameters", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/model/api/SwParameter;", "getParameters", "()Lkotlin/sequences/Sequence;", "contentTypes", "", "getContentTypes", "()Ljava/util/Set;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlTargetUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlTargetUtils.kt\ncom/intellij/swagger/core/providers/resolve/SwEndpointTargetInfo\n+ 2 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n38#2,2:185\n1557#3:187\n1628#3,3:188\n*S KotlinDebug\n*F\n+ 1 SwUrlTargetUtils.kt\ncom/intellij/swagger/core/providers/resolve/SwEndpointTargetInfo\n*L\n169#1:185,2\n183#1:187\n183#1:188,3\n*E\n"})
public final class SwEndpointTargetInfo
extends SwTargetInfo<SwHttpOperation> {
    @NotNull
    private final UrlPath path;

    public SwEndpointTargetInfo(@NotNull SwHttpOperation modelElement, @NotNull UrlPath path, @NotNull List<String> schemes2, @NotNull List<? extends Authority> authorities2, boolean isRemote) {
        Intrinsics.checkNotNullParameter((Object)modelElement, (String)"modelElement");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(schemes2, (String)"schemes");
        Intrinsics.checkNotNullParameter(authorities2, (String)"authorities");
        SwModelElement swModelElement = modelElement;
        String string = modelElement.getHttpMethod().getValue().toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        super(swModelElement, schemes2, authorities2, SetsKt.setOf((Object)string), isRemote);
        this.path = path;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement resolveToPsiElement() {
        void $this$iv;
        SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
        Object swElement$iv = this.getModelElement();
        boolean withSelf$iv = false;
        boolean $i$f$getParentOfType = false;
        SwUrl swUrl = $this$iv.getParentOfType(swElement$iv.getSourcePsi(), SwUrl.class, withSelf$iv);
        return swUrl != null ? swUrl.getSourcePsi() : null;
    }

    public boolean isDeprecated() {
        return ((SwHttpOperation)this.getModelElement()).isDeprecated().getValue();
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        SwUrlFakeElement swUrlFakeElement;
        PsiElement psiElement = ((SwHttpOperation)this.getModelElement()).getSourcePsi();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            swUrlFakeElement = new SwUrlFakeElement(it, ((SwHttpOperation)this.getModelElement()).getUrl());
        } else {
            swUrlFakeElement = null;
        }
        return (PsiElement)swUrlFakeElement;
    }

    @Override
    @NotNull
    public Sequence<SwParameter> getParameters() {
        return CollectionsKt.asSequence((Iterable)((SwHttpOperation)this.getModelElement()).getParameters());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getContentTypes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((SwHttpOperation)this.getModelElement()).getConsumes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwMediaType swMediaType = (SwMediaType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().getValue());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

