/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing.utils;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0000J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/swagger/core/visualEditing/utils/SwInterval;", "", "start", "", "end", "<init>", "(II)V", "getStart", "()I", "getEnd", "length", "getLength", "contains", "", "value", "isInsideMaybeOverlap", "existingNode", "isSameAs", "isStrictlyOutside", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwIntervalTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwIntervalTree.kt\ncom/intellij/swagger/core/visualEditing/utils/SwInterval\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class SwInterval {
    private final int start;
    private final int end;

    public SwInterval(int start, int end) {
        boolean bl;
        this.start = start;
        this.end = end;
        boolean bl2 = bl = this.start <= this.end;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Invalid interval with end offset less than start offset";
            throw new AssertionError((Object)string);
        }
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final int getLength() {
        return this.end - this.start + 1;
    }

    public final boolean contains(int value) {
        int n = this.start;
        return value <= this.end ? n <= value : false;
    }

    public final boolean isInsideMaybeOverlap(@NotNull SwInterval existingNode) {
        Intrinsics.checkNotNullParameter((Object)existingNode, (String)"existingNode");
        return this.start >= existingNode.start && this.end <= existingNode.end;
    }

    public final boolean isSameAs(@NotNull SwInterval existingNode) {
        Intrinsics.checkNotNullParameter((Object)existingNode, (String)"existingNode");
        return Intrinsics.areEqual((Object)this, (Object)existingNode);
    }

    public final boolean isStrictlyOutside(@NotNull SwInterval existingNode) {
        Intrinsics.checkNotNullParameter((Object)existingNode, (String)"existingNode");
        return this.end < existingNode.start || this.start > existingNode.end;
    }

    public final int component1() {
        return this.start;
    }

    public final int component2() {
        return this.end;
    }

    @NotNull
    public final SwInterval copy(int start, int end) {
        return new SwInterval(start, end);
    }

    public static /* synthetic */ SwInterval copy$default(SwInterval swInterval, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = swInterval.start;
        }
        if ((n3 & 2) != 0) {
            n2 = swInterval.end;
        }
        return swInterval.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "SwInterval(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.start);
        result2 = result2 * 31 + Integer.hashCode(this.end);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwInterval)) {
            return false;
        }
        SwInterval swInterval = (SwInterval)other;
        if (this.start != swInterval.start) {
            return false;
        }
        return this.end == swInterval.end;
    }
}

