/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueType;
import com.intellij.psi.css.impl.CssTermTypeImpl;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssFunctionDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssMediaFeatureDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssPropertyDescriptorImplEx;
import com.intellij.psi.css.impl.descriptor.CssPseudoClassDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.CssPseudoElementDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.value.CssAngleValue;
import com.intellij.psi.css.impl.descriptor.value.CssAnyValueImpl;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssDecibelValue;
import com.intellij.psi.css.impl.descriptor.value.CssExpressionValue;
import com.intellij.psi.css.impl.descriptor.value.CssFlexValue;
import com.intellij.psi.css.impl.descriptor.value.CssFrequencyValue;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssIdValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssIntegerValue;
import com.intellij.psi.css.impl.descriptor.value.CssJavaScriptValue;
import com.intellij.psi.css.impl.descriptor.value.CssLengthValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssNumberValue;
import com.intellij.psi.css.impl.descriptor.value.CssPercentageValue;
import com.intellij.psi.css.impl.descriptor.value.CssPositionValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssResolutionValue;
import com.intellij.psi.css.impl.descriptor.value.CssSelectorValue;
import com.intellij.psi.css.impl.descriptor.value.CssSemitonesValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssTimeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrangeValue;
import com.intellij.psi.css.impl.descriptor.value.CssUrlValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import com.intellij.psi.css.impl.util.scheme.CssSchemeConstants;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorConstants;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDescriptorsLoader {
    private final CssDescriptorsHolder myDescriptors = new CssDescriptorsHolder();
    private static final Logger LOG = Logger.getInstance(CssDescriptorsLoader.class);
    private static final Function<String, String> PROCESS_VALUE_PRESENTABLE_NAME = presentableName -> !Strings.isNullOrEmpty((String)presentableName) && !StringUtil.startsWithChar((CharSequence)presentableName, (char)'<') && presentableName.length() > 1 ? "<" + presentableName + ">" : presentableName;
    private static final Function<String, String> PROCESS_FUNCTION_PRESENTABLE_NAME = presentableName -> presentableName + "()";
    private static final CssContextType[] ANY_AT_RULE_TYPES = new CssContextType[]{CssContextType.ANY};
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings();
    private static final Pattern DOCUMENTATION_LINK_PATTERN = Pattern.compile("<see[\n\r ]+cref=\"([^:]*:([^\"]+))\"\\s*/>");

    public CssDescriptorsLoader() {
    }

    @Deprecated(forRemoval=true)
    public CssDescriptorsLoader(@Nullable ProgressIndicator progressIndicator) {
    }

    public void loadDescriptors(@NotNull URL resource) {
        if (resource == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(0);
        }
        try {
            for (Element element : JDOMUtil.load((URL)resource).getChildren()) {
                ProgressManager.checkCanceled();
                String tagName = element.getName();
                if ("property".equals(tagName)) {
                    this.loadPropertyDescriptor(element);
                    continue;
                }
                if ("prefixed-property".equals(tagName)) {
                    this.loadPrefixedPropertyDescriptor(element);
                    continue;
                }
                if ("pseudo-element".equals(tagName)) {
                    this.loadPseudoElementDescriptor(element);
                    continue;
                }
                if ("pseudo-class".equals(tagName)) {
                    this.loadPseudoClassDescriptor(element);
                    continue;
                }
                if ("function".equals(tagName)) {
                    this.loadFunctionDescriptor(element);
                    continue;
                }
                if ("prefixed-function".equals(tagName)) {
                    this.loadPrefixedFunctionDescriptor(element);
                    continue;
                }
                if ("named-value".equals(tagName)) {
                    this.loadNamedValueDescriptor(element);
                    continue;
                }
                if (!"media-feature".equals(tagName)) continue;
                this.loadMediaFeatureDescriptor(element);
            }
        }
        catch (IOException | JDOMException e) {
            LOG.error("Error loading " + resource.getPath(), e);
        }
    }

    @NotNull
    public CssDescriptorsHolder getDescriptors() {
        CssDescriptorsHolder cssDescriptorsHolder = this.myDescriptors;
        if (cssDescriptorsHolder == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(1);
        }
        return cssDescriptorsHolder;
    }

    private void loadPropertyDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(2);
        }
        String name = element.getAttributeValue("id");
        CssMediaGroup[] mediaGroup = CssDescriptorsLoader.parseMediaGroups(element);
        String initialValue = element.getAttributeValue("initial");
        String appliesToValue = element.getAttributeValue("applies");
        String percentageValue = element.getAttributeValue("percentage");
        boolean inherited = CssDescriptorsLoader.parseBoolean(element, "inherited", false);
        this.myDescriptors.properties.putValue((Object)StringUtil.toLowerCase((String)name), (Object)new CssPropertyDescriptorImplEx(CssDescriptorsLoader.parseCommonDescriptorData(element), this.loadValueOfElement(element), initialValue, appliesToValue, percentageValue, inherited, mediaGroup));
    }

    private void loadPrefixedPropertyDescriptor(@NotNull Element element) {
        CssElementDescriptor.CssVersion cssVersion;
        String name;
        ArrayList descriptors;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(3);
        }
        if ((descriptors = new ArrayList(this.myDescriptors.properties.get((Object)(name = element.getAttributeValue("id"))))).isEmpty()) {
            LOG.error("Property should be declared before using prefixed declaration.", new String[]{name});
            return;
        }
        CssPropertyDescriptor originalProperty = (CssPropertyDescriptor)ContainerUtil.getLastItem(descriptors);
        String prefix = element.getAttributeValue("prefix");
        String propertyName = "-" + prefix + "-" + name;
        BrowserVersion[] browserVersions = CssDescriptorsLoader.parseBrowsers(element);
        assert (originalProperty != null);
        String url = element.getAttributeValue("url");
        CssElementDescriptor.CssVersion cssVersion2 = cssVersion = url != null ? originalProperty.getCssVersion() : CssElementDescriptor.CssVersion.UNKNOWN;
        if (url == null) {
            url = originalProperty.getSpecificationUrl();
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(propertyName, "-" + prefix + "-" + originalProperty.getPresentableName(), originalProperty.getAllowedContextTypes(), browserVersions, cssVersion, url, originalProperty.getDescription());
        this.myDescriptors.properties.putValue((Object)StringUtil.toLowerCase((String)propertyName), (Object)new CssPropertyDescriptorImplEx(commonDescriptorData, originalProperty.getValueDescriptor(), originalProperty.getInitialValue(), originalProperty.getAppliesToValue(), originalProperty.getPercentageValue(), originalProperty.isInherited(), originalProperty.getMediaGroups()));
    }

    private void loadFunctionDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(4);
        }
        String name = element.getAttributeValue("id");
        String returnTypeName = element.getAttributeValue("returnType");
        CssTermType returnType = StringUtil.isNotEmpty((String)returnTypeName) ? CssTermTypeImpl.find(returnTypeName) : CssTermType.UNKNOWN;
        this.myDescriptors.functions.putValue((Object)StringUtil.toLowerCase((String)name), (Object)new CssFunctionDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element, "", PROCESS_FUNCTION_PRESENTABLE_NAME), this.loadValueOfElement(element), returnType));
    }

    private void loadPrefixedFunctionDescriptor(@NotNull Element element) {
        CssElementDescriptor.CssVersion cssVersion;
        String name;
        Collection descriptors;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(5);
        }
        if ((descriptors = this.myDescriptors.functions.get((Object)(name = element.getAttributeValue("id")))).size() != 1) {
            LOG.error("Function should be declared before using prefixed declaration.", new String[]{name});
            return;
        }
        CssFunctionDescriptor originalFunction = (CssFunctionDescriptor)ContainerUtil.getFirstItem((Collection)descriptors);
        String prefix = element.getAttributeValue("prefix");
        String functionName = "-" + prefix + "-" + name;
        BrowserVersion[] browserVersions = CssDescriptorsLoader.parseBrowsers(element);
        assert (originalFunction != null);
        String url = element.getAttributeValue("url");
        CssElementDescriptor.CssVersion cssVersion2 = cssVersion = url != null ? originalFunction.getCssVersion() : CssElementDescriptor.CssVersion.UNKNOWN;
        if (url == null) {
            url = originalFunction.getSpecificationUrl();
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(functionName, "-" + prefix + "-" + originalFunction.getPresentableName(), originalFunction.getAllowedContextTypes(), browserVersions, cssVersion, url, originalFunction.getDescription());
        this.myDescriptors.functions.putValue((Object)StringUtil.toLowerCase((String)functionName), (Object)new CssFunctionDescriptorImpl(commonDescriptorData, originalFunction.getValueDescriptor(), originalFunction.getType()));
    }

    private void loadMediaFeatureDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(6);
        }
        String name = StringUtil.toLowerCase((String)element.getAttributeValue("id"));
        CssValueDescriptor valueDescriptor = this.loadValueOfElement(element);
        CssCommonDescriptorData commonDescriptorData = CssDescriptorsLoader.parseCommonDescriptorData(element);
        CssMediaGroup[] mediaGroups = CssDescriptorsLoader.parseMediaGroups(element);
        String appliesToValue = element.getAttributeValue("applies");
        this.myDescriptors.mediaFeatures.putValue((Object)name, (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData, valueDescriptor));
        boolean acceptsMinMaxPrefixed = CssDescriptorsLoader.parseBoolean(element, "min-max", false);
        if (acceptsMinMaxPrefixed) {
            this.myDescriptors.mediaFeatures.putValue((Object)("min-" + name), (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData.cloneWithPrefix("min-"), valueDescriptor));
            this.myDescriptors.mediaFeatures.putValue((Object)("max-" + name), (Object)new CssMediaFeatureDescriptorImpl(appliesToValue, mediaGroups, commonDescriptorData.cloneWithPrefix("max-"), valueDescriptor));
        }
    }

    private void loadNamedValueDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(7);
        }
        String name = element.getAttributeValue("id");
        CssValueDescriptor valueDescriptor = CssValueDescriptorModificator.withCommonData(this.loadValueOfElement(element), CssDescriptorsLoader.parseCommonDescriptorData(element));
        this.myDescriptors.namedValues.putValue((Object)StringUtil.toLowerCase((String)name), (Object)valueDescriptor);
    }

    private void loadPseudoClassDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(8);
        }
        boolean hasArguments = element.getChildren().size() > element.getChildren("description", CssSchemeConstants.NAMESPACE).size();
        String name = element.getAttributeValue("id");
        this.myDescriptors.pseudoSelectors.putValue((Object)StringUtil.toLowerCase((String)name), (Object)new CssPseudoClassDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element), CssDescriptorsLoader.parseBoolean(element, "elementRequired", false), hasArguments));
    }

    private void loadPseudoElementDescriptor(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(9);
        }
        String name = element.getAttributeValue("id");
        boolean hasArguments = element.getChildren().size() > element.getChildren("description", CssSchemeConstants.NAMESPACE).size();
        this.myDescriptors.pseudoSelectors.putValue((Object)StringUtil.toLowerCase((String)name), (Object)new CssPseudoElementDescriptorImpl(CssDescriptorsLoader.parseCommonDescriptorData(element), CssDescriptorsLoader.parseBoolean(element, "elementRequired", false), hasArguments));
    }

    private static boolean parseBoolean(@NotNull Element element, String attributeName, boolean defaultValue) {
        String attributeValue;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(10);
        }
        return (attributeValue = element.getAttributeValue(attributeName)) != null ? "yes".equals(attributeValue) : defaultValue;
    }

    private static int parseInt(@NotNull Element element, String attributeName, int defaultValue) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(11);
        }
        try {
            Attribute attribute = element.getAttribute(attributeName);
            return attribute != null ? attribute.getIntValue() : defaultValue;
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    private static CssContextType @NotNull [] parseContextTypes(@NotNull Element element) {
        String rules;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(12);
        }
        if (Strings.isNullOrEmpty((String)(rules = element.getAttributeValue("rules")))) {
            if (ANY_AT_RULE_TYPES == null) {
                CssDescriptorsLoader.$$$reportNull$$$0(13);
            }
            return ANY_AT_RULE_TYPES;
        }
        TreeSet result = Sets.newTreeSet(CssContextType.COMPARATOR);
        for (String rule : COMMA_SPLITTER.split((CharSequence)rules)) {
            result.add(CssContextType.fromString(rule));
        }
        CssContextType[] cssContextTypeArray = result.toArray(CssContextType.EMPTY_ARRAY);
        if (cssContextTypeArray == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(14);
        }
        return cssContextTypeArray;
    }

    @NotNull
    private static CssElementDescriptor.CssVersion parseVersion(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(15);
        }
        CssElementDescriptor.CssVersion cssVersion = CssElementDescriptor.CssVersion.fromString(element.getAttributeValue("declared-in"));
        if (cssVersion == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(16);
        }
        return cssVersion;
    }

    @Nullable
    private static CssElementDescriptor.CssVersion parseObsoleteVersion(@NotNull Element element) {
        String obsoleteInValue;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(17);
        }
        return (obsoleteInValue = element.getAttributeValue("obsolete-in")) != null ? CssElementDescriptor.CssVersion.fromString(obsoleteInValue) : null;
    }

    @Nullable
    private static String parseDescription(@NotNull Element element) {
        Element descriptionTag;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(18);
        }
        if ((descriptionTag = element.getChild("description", CssSchemeConstants.NAMESPACE)) != null) {
            return CssDescriptorsLoader.processDocumentation(descriptionTag.getTextTrim());
        }
        String value = element.getAttributeValue("tooltip");
        return CssDescriptorsLoader.processDocumentation(value == null ? null : StringUtil.escapeXmlEntities((String)value));
    }

    @Nullable
    private static String processDocumentation(@Nullable String result) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        Matcher matcher = DOCUMENTATION_LINK_PATTERN.matcher(result);
        if (matcher.find()) {
            result = matcher.replaceAll("<a href=\"psi_element://$1\">$2</a>");
        }
        return result;
    }

    private static BrowserVersion[] parseBrowsers(@NotNull Element element) {
        String browsers;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(19);
        }
        if (Strings.isNullOrEmpty((String)(browsers = element.getAttributeValue("browsers")))) {
            return BrowserVersion.EMPTY_ARRAY;
        }
        TreeSet<BrowserVersion> result = new TreeSet<BrowserVersion>(BrowserVersion.COMPARATOR);
        for (String browser : COMMA_SPLITTER.split((CharSequence)browsers)) {
            result.add(BrowserVersion.fromString(browser));
        }
        return result.toArray(BrowserVersion.EMPTY_ARRAY);
    }

    @NotNull
    private CssValueDescriptor loadValueOfElement(@NotNull Element valueOwnerElement) {
        if (valueOwnerElement == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(20);
        }
        List children = valueOwnerElement.getChildren();
        for (Element child : children) {
            CssValueDescriptor valueDescriptor = this.parseValue(child, null);
            if (valueDescriptor == null) continue;
            CssValueDescriptor cssValueDescriptor = valueDescriptor;
            if (cssValueDescriptor == null) {
                CssDescriptorsLoader.$$$reportNull$$$0(21);
            }
            return cssValueDescriptor;
        }
        throw new IllegalArgumentException("Value cannot be empty");
    }

    @Nullable
    private CssValueDescriptor parseValue(@NotNull Element valueElement, @Nullable CssValueDescriptor parent) {
        if (valueElement == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        String name = valueElement.getName();
        if ("description".equalsIgnoreCase(name)) {
            return null;
        }
        CssValueType valueType = CssValueType.fromTag(name);
        if (valueType == null) {
            throw new IllegalArgumentException("Unknown value: " + valueElement.toString());
        }
        return switch (valueType) {
            default -> throw new IncompatibleClassChangeError();
            case CssValueType.GROUP -> this.parseGroupValue(valueElement, parent);
            case CssValueType.INLINE -> this.parseInlineValue(valueElement, parent);
            case CssValueType.URI -> this.parseUriValue(valueElement, parent);
            case CssValueType.STRING -> this.parseStringValue(valueElement, parent);
            case CssValueType.INTEGER -> this.parseIntegerValue(valueElement, parent);
            case CssValueType.PERCENTAGE -> this.parsePercentageValue(valueElement, parent);
            case CssValueType.NAME -> this.parseNameValue(valueElement, parent);
            case CssValueType.PROPERTY -> this.parsePropertyReferenceValue(valueElement, parent);
            case CssValueType.ANGLE -> this.parseAngleValue(valueElement, parent);
            case CssValueType.FREQUENCY -> this.parseFrequencyValue(valueElement, parent);
            case CssValueType.POSITION -> this.parsePositionValue(valueElement, parent);
            case CssValueType.RESOLUTION -> this.parseResolutionValue(valueElement, parent);
            case CssValueType.LENGTH -> this.parseLengthValue(valueElement, parent);
            case CssValueType.NUMBER -> this.parseNumberValue(valueElement, parent);
            case CssValueType.TIME -> this.parseTimeValue(valueElement, parent);
            case CssValueType.DECIBEL -> this.parseDecibelValue(valueElement, parent);
            case CssValueType.SEMITONES -> this.parseSemitoneValue(valueElement, parent);
            case CssValueType.FLEX -> this.parseFlexValue(valueElement, parent);
            case CssValueType.URANGE -> this.parseUrangeValue(valueElement, parent);
            case CssValueType.INVOKE -> this.parseFunctionValue(valueElement, parent);
            case CssValueType.TEXT -> this.parseTextValue(valueElement, parent);
            case CssValueType.COLOR -> this.parseColorValue(valueElement, parent);
            case CssValueType.EXPRESSION -> this.parseExpressionValue(valueElement, parent);
            case CssValueType.JAVASCRIPT -> this.parseJavaScriptValue(valueElement, parent);
            case CssValueType.SELECTOR -> this.parseSelectorValue(valueElement, parent);
            case CssValueType.ANY -> this.parseAnyValue(valueElement, parent);
        };
    }

    @NotNull
    private CssValueDescriptor parseFunctionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(23);
        }
        return new CssFunctionInvocationValue(element.getAttributeValue("name"), CssDescriptorsLoader.parseCommonDescriptorData(element, "", PROCESS_FUNCTION_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parsePropertyReferenceValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(24);
        }
        String refId = element.getAttributeValue("id");
        assert (StringUtil.isNotEmpty((String)refId));
        return new CssPropertyReferenceValue(refId, CssDescriptorsLoader.parseCommonDescriptorData(element, refId, PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseNameValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(25);
        }
        String value = element.getAttributeValue("value");
        ContainerUtil.addIfNotNull(this.myDescriptors.valueIdentifiers, (Object)value);
        return new CssNameValue(value, false, CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("name.value.presentable.name", new Object[0])), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseJavaScriptValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(26);
        }
        return new CssJavaScriptValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("java.script.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseAngleValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(27);
        }
        return new CssAngleValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("angle.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseFrequencyValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(28);
        }
        return new CssFrequencyValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("frequency.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parsePositionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(29);
        }
        return new CssPositionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("position.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseResolutionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(30);
        }
        return new CssResolutionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("resolution.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseLengthValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(31);
        }
        return new CssLengthValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("length.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseNumberValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(32);
        }
        return new CssNumberValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("number.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseTimeValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(33);
        }
        return new CssTimeValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("time.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseDecibelValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(34);
        }
        return new CssDecibelValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("decibel.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseSemitoneValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(35);
        }
        return new CssSemitonesValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("semitones.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseFlexValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(36);
        }
        return new CssFlexValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("flex.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseUrangeValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(37);
        }
        return new CssUrangeValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("urange.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parsePercentageValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(38);
        }
        return new CssPercentageValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("percentage.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseColorValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(39);
        }
        return new CssColorValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("color.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent), true);
    }

    @NotNull
    private CssValueDescriptor parseAnyValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(40);
        }
        return new CssAnyValueImpl(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("any.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseIntegerValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(41);
        }
        return new CssIntegerValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("integer.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseStringValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(42);
        }
        return new CssStringValue(element.getAttributeValue("value"), CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("string.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseTextValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(43);
        }
        String value = element.getAttributeValue("value");
        ContainerUtil.addIfNotNull(this.myDescriptors.valueIdentifiers, (Object)value);
        return new CssTextValue(value, CssDescriptorsLoader.parseCommonDescriptorData(element), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseExpressionValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(44);
        }
        return new CssExpressionValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("expression.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseSelectorValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(45);
        }
        return new CssSelectorValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("selector.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseUriValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(46);
        }
        return new CssUrlValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("url.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
    }

    @NotNull
    private CssValueDescriptor parseInlineValue(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(47);
        }
        boolean inline = CssDescriptorsLoader.parseBoolean(element, "inline", false);
        String name = element.getAttributeValue("id");
        if ("id".equalsIgnoreCase(name)) {
            return new CssIdValue(CssDescriptorsLoader.parseCommonDescriptorData(element, CssBundle.message("id.value.presentable.name", new Object[0]), PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        }
        CssInlineValue inlineValue = new CssInlineValue(name, CssDescriptorsLoader.parseCommonDescriptorData(element, name, PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(element, parent));
        if (inline) {
            CssValueDescriptor namedValue;
            Collection namedValues = this.myDescriptors.namedValues.get((Object)name);
            if (namedValues.size() == 1 && (namedValue = (CssValueDescriptor)ContainerUtil.getFirstItem((Collection)namedValues)) != null) {
                CssValueDescriptor result = CssValueDescriptorModificator.withParent(namedValue, parent);
                if (inlineValue.isCommaSeparated() || inlineValue.getMinOccur() != 1 || inlineValue.getMaxOccur() != 1) {
                    CssValueDescriptor cssValueDescriptor = CssValueDescriptorModificator.withQuantifiers(result, inlineValue.getMinOccur(), inlineValue.getMaxOccur(), inlineValue.isCommaSeparated());
                    if (cssValueDescriptor == null) {
                        CssDescriptorsLoader.$$$reportNull$$$0(48);
                    }
                    return cssValueDescriptor;
                }
                CssValueDescriptor cssValueDescriptor = result;
                if (cssValueDescriptor == null) {
                    CssDescriptorsLoader.$$$reportNull$$$0(49);
                }
                return cssValueDescriptor;
            }
            LOG.error("Named value should be declared before inlining.", new String[]{name});
        }
        CssInlineValue cssInlineValue = inlineValue;
        if (cssInlineValue == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(50);
        }
        return cssInlineValue;
    }

    @NotNull
    private CssValueDescriptor parseGroupValue(@NotNull Element valueElement, @Nullable CssValueDescriptor parent) {
        if (valueElement == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(51);
        }
        CssGroupValue cssGroupValue = CssGroupValue.create(CssDescriptorsLoader.parseCommonDescriptorData(valueElement, "", PROCESS_VALUE_PRESENTABLE_NAME), this.parseValueDescriptorData(valueElement, parent), CssDescriptorsLoader.parseBoolean(valueElement, "ignoreWhitespaces", true), this.parseSeparator(valueElement), CssDescriptorsLoader.parseGroupType(valueElement));
        for (Element child : valueElement.getChildren()) {
            CssValueDescriptor descriptor;
            if ("separator".equals(child.getName()) || (descriptor = this.parseValue(child, cssGroupValue)) == null) continue;
            cssGroupValue.addChild(descriptor);
        }
        CssGroupValue cssGroupValue2 = cssGroupValue;
        if (cssGroupValue2 == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(52);
        }
        return cssGroupValue2;
    }

    @Nullable
    private CssValueDescriptor parseSeparator(@NotNull Element element) {
        Element separatorTag;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(53);
        }
        return (separatorTag = element.getChild("separator", CssSchemeConstants.NAMESPACE)) != null ? this.loadValueOfElement(separatorTag) : null;
    }

    @Nullable
    private CssValueDescriptor parseExclusion(@NotNull Element element) {
        Element exclusionTag;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(54);
        }
        return (exclusionTag = element.getChild("exclusion", CssSchemeConstants.NAMESPACE)) != null ? this.loadValueOfElement(exclusionTag) : null;
    }

    @NotNull
    private static CssGroupValue.Type parseGroupType(@NotNull Element element) {
        String typeAttributeValue;
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(55);
        }
        CssGroupValue.Type type = Strings.isNullOrEmpty((String)(typeAttributeValue = element.getAttributeValue("type"))) ? CssGroupValue.Type.ALL : CssGroupValue.Type.valueOf(StringUtil.toUpperCase((String)typeAttributeValue));
        if (type == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(56);
        }
        return type;
    }

    @NotNull
    private CssValueDescriptorData parseValueDescriptorData(@NotNull Element element, @Nullable CssValueDescriptor parent) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(57);
        }
        boolean commaSeparated = CssDescriptorsLoader.parseBoolean(element, "comma-separated", false);
        int minOccur = CssDescriptorsLoader.parseInt(element, "min", 1);
        int maxOccur = CssDescriptorsLoader.parseInt(element, "max", commaSeparated ? -1 : 1);
        if (maxOccur != -1 && maxOccur < minOccur) {
            maxOccur = minOccur;
        }
        String value = element.getAttributeValue("obsolete-tooltip");
        return new CssValueDescriptorData(CssDescriptorsLoader.parseBoolean(element, "completion", true), minOccur, maxOccur, CssDescriptorsLoader.parseObsoleteVersion(element), CssDescriptorsLoader.processDocumentation(value == null ? null : StringUtil.escapeXmlEntities((String)value)), parent, this.parseExclusion(element), commaSeparated);
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(58);
        }
        return CssDescriptorsLoader.parseCommonDescriptorData(element, "", (Function<String, String>)Functions.id());
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element, @NotNull String defaultPresentableName) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(59);
        }
        if (defaultPresentableName == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(60);
        }
        return CssDescriptorsLoader.parseCommonDescriptorData(element, defaultPresentableName, (Function<String, String>)Functions.id());
    }

    @NotNull
    private static CssCommonDescriptorData parseCommonDescriptorData(@NotNull Element element, @NotNull String defaultPresentableName, @NotNull Function<String, String> processPresentableName) {
        if (element == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(61);
        }
        if (defaultPresentableName == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(62);
        }
        if (processPresentableName == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(63);
        }
        String id = element.getAttributeValue("id", defaultPresentableName);
        String valueAttribute = element.getAttributeValue("value", id);
        String presentableName = (String)processPresentableName.fun((Object)element.getAttributeValue("name", valueAttribute));
        return new CssCommonDescriptorData(id, presentableName, CssDescriptorsLoader.parseContextTypes(element), CssDescriptorsLoader.parseBrowsers(element), CssDescriptorsLoader.parseVersion(element), element.getAttributeValue("url"), Strings.nullToEmpty((String)CssDescriptorsLoader.parseDescription(element)));
    }

    private static CssMediaGroup @NotNull [] parseMediaGroups(Element element) {
        LinkedHashSet<CssMediaGroup> result = new LinkedHashSet<CssMediaGroup>();
        for (String s : StringUtil.split((String)StringUtil.toUpperCase((String)element.getAttributeValue("media", "all")), (String)" ")) {
            try {
                result.add(CssMediaGroup.valueOf(s.trim()));
            }
            catch (IllegalArgumentException e) {
                Collections.addAll(result, CssMediaType.valueOf(s.trim()).getSupportedGroups());
            }
        }
        CssMediaGroup[] cssMediaGroupArray = !result.isEmpty() ? result.toArray(new CssMediaGroup[0]) : CssElementDescriptorConstants.EMPTY_MEDIA_GROUP;
        if (cssMediaGroupArray == null) {
            CssDescriptorsLoader.$$$reportNull$$$0(64);
        }
        return cssMediaGroupArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 13, 14, 16, 21, 48, 49, 50, 52, 56, 64 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 53: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueOwnerElement";
                break;
            }
            case 22: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPresentableName";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/scheme/CssDescriptorsLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContextTypes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadValueOfElement";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInlineValue";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGroupValue";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGroupType";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMediaGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptors";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 64: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadPropertyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadPrefixedPropertyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFunctionDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadPrefixedFunctionDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadMediaFeatureDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadNamedValueDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadPseudoClassDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadPseudoElementDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseBoolean";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseInt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseContextTypes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseObsoleteVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseDescription";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseBrowsers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadValueOfElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseFunctionValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyReferenceValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parseNameValue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseJavaScriptValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "parseAngleValue";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "parseFrequencyValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parsePositionValue";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "parseResolutionValue";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseLengthValue";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseNumberValue";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseTimeValue";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "parseDecibelValue";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parseSemitoneValue";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "parseFlexValue";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "parseUrangeValue";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "parsePercentageValue";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "parseColorValue";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "parseAnyValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "parseIntegerValue";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "parseStringValue";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseTextValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "parseExpressionValue";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "parseSelectorValue";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "parseUriValue";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "parseInlineValue";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "parseGroupValue";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "parseSeparator";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "parseExclusion";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "parseGroupType";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "parseValueDescriptorData";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "parseCommonDescriptorData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 13, 14, 16, 21, 48, 49, 50, 52, 56, 64 -> new IllegalStateException(string);
        };
    }
}

