/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.profiler.FileReader;
import com.intellij.util.io.CountingGZIPInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\nH\u0014R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/GZIPExtractor;", "Lcom/intellij/profiler/FileReader;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "countingStream", "Lcom/intellij/util/io/CountingGZIPInputStream;", "Lorg/jetbrains/annotations/NotNull;", "compressedFileSize", "", "createReader", "Ljava/io/BufferedReader;", "withProgressFraction", "", "progressFraction", "intellij.profiler.common"})
public final class GZIPExtractor
extends FileReader {
    @NotNull
    private final CountingGZIPInputStream countingStream;
    private final double compressedFileSize;

    public GZIPExtractor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CountingGZIPInputStream countingGZIPInputStream = CountingGZIPInputStream.create((InputStream)new FileInputStream(file));
        Intrinsics.checkNotNullExpressionValue((Object)countingGZIPInputStream, (String)"create(...)");
        this.countingStream = countingGZIPInputStream;
        this.compressedFileSize = file.length();
    }

    @Override
    @NotNull
    protected BufferedReader createReader() {
        InputStream inputStream = (InputStream)this.countingStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
    }

    @Override
    protected boolean withProgressFraction() {
        return true;
    }

    @Override
    protected double progressFraction() {
        return (double)this.countingStream.getCompressedBytesRead() / this.compressedFileSize;
    }
}

