/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.remote.DockerCliPresentationUtil;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.docker.remote.run.target.configuration.DockerTargetType;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.nodejs.remote.NodeRemoteTargetRunSetup;
import com.jetbrains.nodejs.remote.NodeRemoteTargetRunSetupFactory;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/nodejs/remote/docker/NodeDockerTargetRunSetupFactory;", "Lcom/jetbrains/nodejs/remote/NodeRemoteTargetRunSetupFactory;", "Lcom/intellij/docker/remote/DockerCredentialsHolder;", "<init>", "()V", "credentialType", "Lcom/intellij/docker/remote/DockerCredentialsType;", "getTargetEnvironmentType", "Lcom/intellij/docker/remote/run/target/configuration/DockerTargetType;", "createTargetRunSetup", "Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData;", "options", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;", "credentials", "createDockerEnvironmentRequest", "Lcom/intellij/docker/remote/run/target/DockerRemoteRequest;", "holder", "getCliOptions", "", "settings", "Lcom/intellij/docker/remote/DockerContainerSettings;", "Companion", "intellij.nodeJS.remoteInterpreter"})
@SourceDebugExtension(value={"SMAP\nNodeDockerTargetRunSetupFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeDockerTargetRunSetupFactory.kt\ncom/jetbrains/nodejs/remote/docker/NodeDockerTargetRunSetupFactory\n+ 2 TargetEnvironmentType.kt\ncom/intellij/execution/target/TargetEnvironmentTypeKt\n*L\n1#1,75:1\n133#2:76\n*S KotlinDebug\n*F\n+ 1 NodeDockerTargetRunSetupFactory.kt\ncom/jetbrains/nodejs/remote/docker/NodeDockerTargetRunSetupFactory\n*L\n29#1:76\n*E\n"})
public final class NodeDockerTargetRunSetupFactory
implements NodeRemoteTargetRunSetupFactory<DockerCredentialsHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_CLI_OPTION = "--rm";

    @NotNull
    public DockerCredentialsType credentialType() {
        DockerCredentialsType dockerCredentialsType = DockerCredentialsType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)dockerCredentialsType, (String)"getInstance(...)");
        return dockerCredentialsType;
    }

    @NotNull
    public DockerTargetType getTargetEnvironmentType() throws IllegalStateException {
        boolean $i$f$findTargetEnvironmentType = false;
        return (DockerTargetType)TargetEnvironmentType.Companion.findInstance(DockerTargetType.class);
    }

    @Override
    @NotNull
    public NodeTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeJSRemoteSdkAdditionalData data, @NotNull NodeTargetRunOptions options, @NotNull DockerCredentialsHolder credentials) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        DockerRemoteRequest request = this.createDockerEnvironmentRequest(credentials, project, options);
        return new NodeRemoteTargetRunSetup(options, data, (TargetEnvironmentRequest)request, null);
    }

    private final DockerRemoteRequest createDockerEnvironmentRequest(DockerCredentialsHolder holder, Project project, NodeTargetRunOptions options) throws ExecutionException {
        DockerTargetEnvironmentConfiguration dockerTargetEnvironmentConfiguration;
        RemoteDockerRuntime dockerRuntime;
        block3: {
            RemoteDockerRuntime remoteDockerRuntime;
            RemoteServer remoteServer = RemoteServersManager.getInstance().findByName(holder.getAccountName(), (ServerType)DockerCloudType.getInstance());
            if (remoteServer == null) {
                Object[] objectArray = new Object[]{holder.getAccountName()};
                throw new ExecutionException(NodeJSBundle.message((String)"remote.docker.cannot.find.docker.server.error.message", (Object[])objectArray));
            }
            RemoteServer dockerServer = remoteServer;
            ServerConfiguration serverConfiguration = dockerServer.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
            DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)serverConfiguration;
            try {
                remoteDockerRuntime = RemoteDockerRuntime.Companion.create(dockerCloudConfiguration, project);
            }
            catch (ServerRuntimeException e) {
                throw new ExecutionException(NodeJSBundle.message((String)"remote.docker.cannot.create.docker.runtime", (Object[])new Object[0]), (Throwable)e);
            }
            dockerRuntime = remoteDockerRuntime;
            dockerTargetEnvironmentConfiguration = new DockerTargetEnvironmentConfiguration();
            dockerTargetEnvironmentConfiguration.getValues().setDockerServerName(holder.getAccountName());
            dockerTargetEnvironmentConfiguration.getValues().setBuildNotPull(false);
            dockerTargetEnvironmentConfiguration.getValues().getPullImageConfig().setTagToPull(holder.getImageName());
            RunConfigurationBase runConfigurationBase = options.getRunConfiguration();
            String string = this.getCliOptions(runConfigurationBase != null ? (DockerContainerSettings)runConfigurationBase.getCopyableUserData(DockerContainerSettings.KEY) : null);
            if (string == null) break block3;
            String it = string;
            boolean bl = false;
            dockerTargetEnvironmentConfiguration.getValues().getContainerConfig().setRunCliOptions(it);
        }
        return new DockerRemoteRequest(dockerRuntime, dockerTargetEnvironmentConfiguration);
    }

    private final String getCliOptions(DockerContainerSettings settings) {
        if (settings == null) {
            return null;
        }
        List cliOptions = CollectionsKt.toMutableList((Collection)DockerCliPresentationUtil.toCliPresentationOptions((DockerContainerSettings)settings));
        cliOptions.remove("--entrypoint");
        if (!cliOptions.contains(DEFAULT_CLI_OPTION)) {
            cliOptions.add(DEFAULT_CLI_OPTION);
        }
        return CollectionsKt.joinToString$default((Iterable)cliOptions, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/nodejs/remote/docker/NodeDockerTargetRunSetupFactory$Companion;", "", "<init>", "()V", "DEFAULT_CLI_OPTION", "", "intellij.nodeJS.remoteInterpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

