/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.execution.ssl.SslCertStore;
import com.intellij.httpClient.execution.ssl.SslCertificate;
import com.intellij.httpClient.execution.ssl.SslCertificatePrivateKey;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.execution.ssl.SslConfigurationContext;
import com.intellij.httpClient.execution.ssl.SslConfigurationTarget;
import com.intellij.httpClient.execution.ssl.SslErrorDescriptor;
import java.security.KeyStore;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \n2\u00020\u0001:\u0004\u0007\b\t\nJ!\u0010\u0002\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0005H&\u00a2\u0006\u0002\u0010\u0006\u0082\u0001\u0003\u000b\f\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "", "applyTo", "T", "configurator", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;", "(Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;)Ljava/lang/Object;", "Error", "NotYetConfigured", "Configured", "Companion", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Configured;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Error;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration$NotYetConfigured;", "intellij.httpClient.executor"})
public interface SslConfiguration {
    @NotNull
    public static final Companion Companion = com.intellij.httpClient.execution.ssl.SslConfiguration$Companion.$$INSTANCE;

    public <T> T applyTo(@NotNull SslConfigurationTarget<T> var1) throws HttpRequestSslConfigurationException;

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JQ\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2 \u0010\u000e\u001a\u001c\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "certificate", "Lcom/intellij/httpClient/execution/ssl/SslCertificate;", "key", "Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;", "insecureSslConnection", "", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphraseProvider", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/intellij/httpClient/execution/ssl/SslCertificate;Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;ZLcom/intellij/httpClient/execution/ssl/SslConfigurationContext;Lkotlin/jvm/functions/Function1;)Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "intellij.httpClient.executor"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final SslConfiguration create(@Nullable SslCertificate certificate, @Nullable SslCertificatePrivateKey key, boolean insecureSslConnection, @NotNull SslConfigurationContext context, @Nullable Function1<? super Continuation<? super String>, ? extends Object> passphraseProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (passphraseProvider == null) {
                return new Configured(certificate, key, insecureSslConnection, null, context);
            }
            return new NotYetConfigured(certificate, key, insecureSslConnection, context, passphraseProvider);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J!\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u000bH\u00c2\u0003JA\u0010\"\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Configured;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "certificate", "Lcom/intellij/httpClient/execution/ssl/SslCertificate;", "key", "Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;", "insecureSslConnection", "", "passphrase", "", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "<init>", "(Lcom/intellij/httpClient/execution/ssl/SslCertificate;Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;ZLjava/lang/String;Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;)V", "getCertificate", "()Lcom/intellij/httpClient/execution/ssl/SslCertificate;", "getKey", "()Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;", "getInsecureSslConnection", "()Z", "getPassphrase", "()Ljava/lang/String;", "createKeyStore", "Ljava/security/KeyStore;", "applyTo", "T", "configurator", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;", "(Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;)Ljava/lang/Object;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nsslConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sslConfiguration.kt\ncom/intellij/httpClient/execution/ssl/SslConfiguration$Configured\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 sslErrors.kt\ncom/intellij/httpClient/execution/ssl/SslErrorsKt\n*L\n1#1,213:1\n1#2:214\n24#3,4:215\n24#3,4:219\n*S KotlinDebug\n*F\n+ 1 sslConfiguration.kt\ncom/intellij/httpClient/execution/ssl/SslConfiguration$Configured\n*L\n105#1:215,4\n123#1:219,4\n*E\n"})
    public static final class Configured
    implements SslConfiguration {
        @Nullable
        private final SslCertificate certificate;
        @Nullable
        private final SslCertificatePrivateKey key;
        private final boolean insecureSslConnection;
        @Nullable
        private final String passphrase;
        @NotNull
        private final SslConfigurationContext context;

        public Configured(@Nullable SslCertificate certificate, @Nullable SslCertificatePrivateKey key, boolean insecureSslConnection, @Nullable String passphrase, @NotNull SslConfigurationContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.certificate = certificate;
            this.key = key;
            this.insecureSslConnection = insecureSslConnection;
            this.passphrase = passphrase;
            this.context = context;
        }

        public /* synthetic */ Configured(SslCertificate sslCertificate, SslCertificatePrivateKey sslCertificatePrivateKey, boolean bl, String string, SslConfigurationContext sslConfigurationContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            if ((n & 0x10) != 0) {
                sslConfigurationContext = SslConfigurationContext.Default.INSTANCE;
            }
            this(sslCertificate, sslCertificatePrivateKey, bl, string, sslConfigurationContext);
        }

        @Nullable
        public final SslCertificate getCertificate() {
            return this.certificate;
        }

        @Nullable
        public final SslCertificatePrivateKey getKey() {
            return this.key;
        }

        public final boolean getInsecureSslConnection() {
            return this.insecureSslConnection;
        }

        @Nullable
        public final String getPassphrase() {
            return this.passphrase;
        }

        private final KeyStore createKeyStore() throws HttpRequestSslConfigurationException {
            KeyStore keyStore;
            SslCertificate sslCertificate = this.certificate;
            if (sslCertificate != null) {
                Object $this$createKeyStore_u24lambda_u241;
                SslCertificate sslCertificate2 = sslCertificate;
                try {
                    $this$createKeyStore_u24lambda_u241 = sslCertificate2;
                    boolean bl = false;
                    SslCertStore keyStore2 = ((SslCertificate)$this$createKeyStore_u24lambda_u241).readCertificateToKeyStore$intellij_httpClient_executor(this.context, this.passphrase);
                    if (this.key == null && !keyStore2.getContainsKey()) {
                        throw new HttpRequestSslConfigurationException(this.context.getErrorMessage(SslErrorDescriptor.CONFIGURATION, HttpClientExecutorBundle.message("http.request.ssl.cannot.determine.key.for.cert.error", new Object[0])), null, 2, null);
                    }
                    if (this.key != null && keyStore2.getContainsKey()) {
                        throw new HttpRequestSslConfigurationException(this.context.getErrorMessage(SslErrorDescriptor.KEY, HttpClientExecutorBundle.message("http.request.ssl.cert.file.already.contains.key.error", new Object[0])), null, 2, null);
                    }
                    if (this.key != null && keyStore2 instanceof SslCertStore.Raw) {
                        PrivateKey privateKey = this.key.convertToJavaPrivateKey$intellij_httpClient_executor(this.context, this.passphrase);
                        if (privateKey != null) {
                            PrivateKey it = privateKey;
                            boolean bl2 = false;
                            ((SslCertStore.Raw)keyStore2).addPrivateKey(it, this.passphrase);
                        }
                    }
                    $this$createKeyStore_u24lambda_u241 = Result.constructor-impl((Object)keyStore2.getKeyStore());
                }
                catch (Throwable throwable) {
                    $this$createKeyStore_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object $this$getOrRethrowSslException$iv = $this$createKeyStore_u24lambda_u241;
                boolean $i$f$getOrRethrowSslException = false;
                Object object = $this$getOrRethrowSslException$iv;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                    Throwable it$iv = throwable;
                    boolean bl = false;
                    if (it$iv instanceof HttpRequestSslConfigurationException) {
                        httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                    } else {
                        Throwable it = it$iv;
                        boolean bl3 = false;
                        Object[] objectArray = new Object[]{it.getLocalizedMessage()};
                        Throwable throwable2 = it$iv;
                        String string = this.context.getErrorMessage(SslErrorDescriptor.KEY, HttpClientExecutorBundle.message("http.request.ssl.cannot.add.key.to.key.store.error", objectArray));
                        httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string, throwable2);
                    }
                    HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                    throw exception$iv;
                }
                keyStore = (KeyStore)object;
            } else {
                keyStore = null;
            }
            KeyStore keyStore3 = keyStore;
            return keyStore3;
        }

        @Override
        public <T> T applyTo(@NotNull SslConfigurationTarget<T> configurator) throws HttpRequestSslConfigurationException {
            Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
            KeyStore keyStore = this.createKeyStore();
            configurator.configureTrustManager(this.insecureSslConnection);
            if (keyStore != null) {
                Object $this$applyTo_u24lambda_u243;
                Configured configured = this;
                try {
                    $this$applyTo_u24lambda_u243 = configured;
                    boolean bl = false;
                    configurator.configureKeyStore(keyStore, ((Configured)$this$applyTo_u24lambda_u243).passphrase);
                    $this$applyTo_u24lambda_u243 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    $this$applyTo_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object $this$getOrRethrowSslException$iv = $this$applyTo_u24lambda_u243;
                boolean $i$f$getOrRethrowSslException = false;
                Object object = $this$getOrRethrowSslException$iv;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    HttpRequestSslConfigurationException httpRequestSslConfigurationException;
                    Throwable it$iv = throwable;
                    boolean bl = false;
                    if (it$iv instanceof HttpRequestSslConfigurationException) {
                        httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
                    } else {
                        Throwable it = it$iv;
                        boolean bl2 = false;
                        Object[] objectArray = new Object[]{it.getLocalizedMessage()};
                        Throwable throwable2 = it$iv;
                        String string = this.context.getErrorMessage(SslErrorDescriptor.CONFIGURATION, HttpClientExecutorBundle.message("http.request.ssl.cannot.add.key.store.to.ssl.context.error", objectArray));
                        httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string, throwable2);
                    }
                    HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
                    throw exception$iv;
                }
            }
            return configurator.finish();
        }

        @Nullable
        public final SslCertificate component1() {
            return this.certificate;
        }

        @Nullable
        public final SslCertificatePrivateKey component2() {
            return this.key;
        }

        public final boolean component3() {
            return this.insecureSslConnection;
        }

        @Nullable
        public final String component4() {
            return this.passphrase;
        }

        private final SslConfigurationContext component5() {
            return this.context;
        }

        @NotNull
        public final Configured copy(@Nullable SslCertificate certificate, @Nullable SslCertificatePrivateKey key, boolean insecureSslConnection, @Nullable String passphrase, @NotNull SslConfigurationContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new Configured(certificate, key, insecureSslConnection, passphrase, context);
        }

        public static /* synthetic */ Configured copy$default(Configured configured, SslCertificate sslCertificate, SslCertificatePrivateKey sslCertificatePrivateKey, boolean bl, String string, SslConfigurationContext sslConfigurationContext, int n, Object object) {
            if ((n & 1) != 0) {
                sslCertificate = configured.certificate;
            }
            if ((n & 2) != 0) {
                sslCertificatePrivateKey = configured.key;
            }
            if ((n & 4) != 0) {
                bl = configured.insecureSslConnection;
            }
            if ((n & 8) != 0) {
                string = configured.passphrase;
            }
            if ((n & 0x10) != 0) {
                sslConfigurationContext = configured.context;
            }
            return configured.copy(sslCertificate, sslCertificatePrivateKey, bl, string, sslConfigurationContext);
        }

        @NotNull
        public String toString() {
            return "Configured(certificate=" + this.certificate + ", key=" + this.key + ", insecureSslConnection=" + this.insecureSslConnection + ", passphrase=" + this.passphrase + ", context=" + this.context + ")";
        }

        public int hashCode() {
            int result2 = this.certificate == null ? 0 : this.certificate.hashCode();
            result2 = result2 * 31 + (this.key == null ? 0 : this.key.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.insecureSslConnection);
            result2 = result2 * 31 + (this.passphrase == null ? 0 : this.passphrase.hashCode());
            result2 = result2 * 31 + this.context.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configured)) {
                return false;
            }
            Configured configured = (Configured)other;
            if (!Intrinsics.areEqual((Object)this.certificate, (Object)configured.certificate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.key, (Object)configured.key)) {
                return false;
            }
            if (this.insecureSslConnection != configured.insecureSslConnection) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.passphrase, (Object)configured.passphrase)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.context, (Object)configured.context);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Error;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "error", "", "<init>", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "applyTo", "T", "configurator", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;", "(Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;)Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.httpClient.executor"})
    public static final class Error
    implements SslConfiguration {
        @NotNull
        private final String error;

        public Error(@Nls @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.error = error;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        @Override
        public <T> T applyTo(@NotNull SslConfigurationTarget<T> configurator) throws HttpRequestSslConfigurationException {
            Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
            throw new HttpRequestSslConfigurationException(this.error, null, 2, null);
        }

        @NotNull
        public final String component1() {
            return this.error;
        }

        @NotNull
        public final Error copy(@Nls @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new Error(error);
        }

        public static /* synthetic */ Error copy$default(Error error, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = error.error;
            }
            return error.copy(string);
        }

        @NotNull
        public String toString() {
            return "Error(error=" + this.error + ")";
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error = (Error)other;
            return Intrinsics.areEqual((Object)this.error, (Object)error.error);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u001e\u0010\n\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010!J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J&\u0010&\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bH\u00c2\u0003\u00a2\u0006\u0002\u0010'J\\\u0010(\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2 \b\u0002\u0010\n\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020\u00072\b\u0010+\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\rH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R(\u0010\n\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006/"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslConfiguration$NotYetConfigured;", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "certificate", "Lcom/intellij/httpClient/execution/ssl/SslCertificate;", "key", "Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;", "insecureSslConnection", "", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "passphraseProvider", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "", "<init>", "(Lcom/intellij/httpClient/execution/ssl/SslCertificate;Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;ZLcom/intellij/httpClient/execution/ssl/SslConfigurationContext;Lkotlin/jvm/functions/Function1;)V", "getCertificate", "()Lcom/intellij/httpClient/execution/ssl/SslCertificate;", "getKey", "()Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;", "getInsecureSslConnection", "()Z", "getContext", "()Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "Lkotlin/jvm/functions/Function1;", "applyTo", "T", "configurator", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;", "(Lcom/intellij/httpClient/execution/ssl/SslConfigurationTarget;)Ljava/lang/Object;", "toConfigured", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration$Configured;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "component1", "component2", "component3", "component4", "component5", "()Lkotlin/jvm/functions/Function1;", "copy", "(Lcom/intellij/httpClient/execution/ssl/SslCertificate;Lcom/intellij/httpClient/execution/ssl/SslCertificatePrivateKey;ZLcom/intellij/httpClient/execution/ssl/SslConfigurationContext;Lkotlin/jvm/functions/Function1;)Lcom/intellij/httpClient/execution/ssl/SslConfiguration$NotYetConfigured;", "equals", "other", "hashCode", "", "toString", "intellij.httpClient.executor"})
    public static final class NotYetConfigured
    implements SslConfiguration {
        @Nullable
        private final SslCertificate certificate;
        @Nullable
        private final SslCertificatePrivateKey key;
        private final boolean insecureSslConnection;
        @NotNull
        private final SslConfigurationContext context;
        @NotNull
        private final Function1<Continuation<? super String>, Object> passphraseProvider;

        public NotYetConfigured(@Nullable SslCertificate certificate, @Nullable SslCertificatePrivateKey key, boolean insecureSslConnection, @NotNull SslConfigurationContext context, @NotNull Function1<? super Continuation<? super String>, ? extends Object> passphraseProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(passphraseProvider, (String)"passphraseProvider");
            this.certificate = certificate;
            this.key = key;
            this.insecureSslConnection = insecureSslConnection;
            this.context = context;
            this.passphraseProvider = passphraseProvider;
        }

        public /* synthetic */ NotYetConfigured(SslCertificate sslCertificate, SslCertificatePrivateKey sslCertificatePrivateKey, boolean bl, SslConfigurationContext sslConfigurationContext, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                sslConfigurationContext = SslConfigurationContext.Default.INSTANCE;
            }
            this(sslCertificate, sslCertificatePrivateKey, bl, sslConfigurationContext, (Function1<? super Continuation<? super String>, ? extends Object>)function1);
        }

        @Nullable
        public final SslCertificate getCertificate() {
            return this.certificate;
        }

        @Nullable
        public final SslCertificatePrivateKey getKey() {
            return this.key;
        }

        public final boolean getInsecureSslConnection() {
            return this.insecureSslConnection;
        }

        @NotNull
        public final SslConfigurationContext getContext() {
            return this.context;
        }

        @Override
        public <T> T applyTo(@NotNull SslConfigurationTarget<T> configurator) {
            Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
            throw new IllegalStateException("Cannot get SSLContext from `NotYetConfigured`. Extract final configuration from `toConfigured`".toString());
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object toConfigured(@NotNull Continuation<? super Configured> $completion) {
            if (!($completion instanceof toConfigured.1)) ** GOTO lbl-1000
            var4_2 = $completion;
            if ((var4_2.label & -2147483648) != 0) {
                var4_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ NotYetConfigured this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.toConfigured((Continuation<? super Configured>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = this.passphraseProvider.invoke((Object)$continuation);
                    if (v0 == var5_4) {
                        return var5_4;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    this = (NotYetConfigured)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    passphrase = (String)v0;
                    return new Configured(this.certificate, this.key, this.insecureSslConnection, passphrase, this.context);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Nullable
        public final SslCertificate component1() {
            return this.certificate;
        }

        @Nullable
        public final SslCertificatePrivateKey component2() {
            return this.key;
        }

        public final boolean component3() {
            return this.insecureSslConnection;
        }

        @NotNull
        public final SslConfigurationContext component4() {
            return this.context;
        }

        private final Function1<Continuation<? super String>, Object> component5() {
            return this.passphraseProvider;
        }

        @NotNull
        public final NotYetConfigured copy(@Nullable SslCertificate certificate, @Nullable SslCertificatePrivateKey key, boolean insecureSslConnection, @NotNull SslConfigurationContext context, @NotNull Function1<? super Continuation<? super String>, ? extends Object> passphraseProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(passphraseProvider, (String)"passphraseProvider");
            return new NotYetConfigured(certificate, key, insecureSslConnection, context, passphraseProvider);
        }

        public static /* synthetic */ NotYetConfigured copy$default(NotYetConfigured notYetConfigured, SslCertificate sslCertificate, SslCertificatePrivateKey sslCertificatePrivateKey, boolean bl, SslConfigurationContext sslConfigurationContext, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                sslCertificate = notYetConfigured.certificate;
            }
            if ((n & 2) != 0) {
                sslCertificatePrivateKey = notYetConfigured.key;
            }
            if ((n & 4) != 0) {
                bl = notYetConfigured.insecureSslConnection;
            }
            if ((n & 8) != 0) {
                sslConfigurationContext = notYetConfigured.context;
            }
            if ((n & 0x10) != 0) {
                function1 = notYetConfigured.passphraseProvider;
            }
            return notYetConfigured.copy(sslCertificate, sslCertificatePrivateKey, bl, sslConfigurationContext, function1);
        }

        @NotNull
        public String toString() {
            return "NotYetConfigured(certificate=" + this.certificate + ", key=" + this.key + ", insecureSslConnection=" + this.insecureSslConnection + ", context=" + this.context + ", passphraseProvider=" + this.passphraseProvider + ")";
        }

        public int hashCode() {
            int result2 = this.certificate == null ? 0 : this.certificate.hashCode();
            result2 = result2 * 31 + (this.key == null ? 0 : this.key.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.insecureSslConnection);
            result2 = result2 * 31 + this.context.hashCode();
            result2 = result2 * 31 + this.passphraseProvider.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotYetConfigured)) {
                return false;
            }
            NotYetConfigured notYetConfigured = (NotYetConfigured)other;
            if (!Intrinsics.areEqual((Object)this.certificate, (Object)notYetConfigured.certificate)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.key, (Object)notYetConfigured.key)) {
                return false;
            }
            if (this.insecureSslConnection != notYetConfigured.insecureSslConnection) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.context, (Object)notYetConfigured.context)) {
                return false;
            }
            return Intrinsics.areEqual(this.passphraseProvider, notYetConfigured.passphraseProvider);
        }
    }
}

