/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.graphql.notification;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.graphql.notification.HttpClientGraphQLPluginAdvertisementKt;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/httpClient/graphql/notification/HttpClientGraphQLPluginAdvertisement;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "InstallGraphQLNotification", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientGraphQLPluginAdvertisement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientGraphQLPluginAdvertisement.kt\ncom/intellij/httpClient/graphql/notification/HttpClientGraphQLPluginAdvertisement\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n12574#2,2:93\n*S KotlinDebug\n*F\n+ 1 HttpClientGraphQLPluginAdvertisement.kt\ncom/intellij/httpClient/graphql/notification/HttpClientGraphQLPluginAdvertisement\n*L\n38#1:93,2\n*E\n"})
public final class HttpClientGraphQLPluginAdvertisement
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        IdeaPluginDescriptor descriptor;
        boolean hasGraphQL;
        block8: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!HttpClientGraphQLPluginAdvertisementKt.access$getPromoteGraphQLPlugin()) {
                return null;
            }
            if (HttpClientGraphQLPluginAdvertisementKt.access$getDoNotShowAgain()) {
                return null;
            }
            if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)HttpRequestFileType.INSTANCE)) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            if (!(psiFile2 instanceof HttpRequestPsiFile)) {
                return null;
            }
            HttpRequestBlock[] httpRequestBlockArray = HttpRequestPsiUtils.getRequestBlocks(psiFile2);
            Intrinsics.checkNotNullExpressionValue((Object)httpRequestBlockArray, (String)"getRequestBlocks(...)");
            Object[] $this$any$iv = httpRequestBlockArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                HttpRequestBlock it = (HttpRequestBlock)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getRequest().getHttpMethod(), (Object)"GRAPHQL")) continue;
                bl = true;
                break block8;
            }
            bl = hasGraphQL = false;
        }
        if (!hasGraphQL) {
            return null;
        }
        PluginId pluginId = PluginId.getId((String)"com.intellij.lang.jsgraphql");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        PluginId pluginId2 = pluginId;
        IdeaPluginDescriptor ideaPluginDescriptor = descriptor = PluginManagerCore.getPlugin((PluginId)pluginId2);
        boolean bl = ideaPluginDescriptor != null ? ideaPluginDescriptor.isEnabled() : false;
        if (bl) {
            return null;
        }
        return arg_0 -> HttpClientGraphQLPluginAdvertisement.collectNotificationData$lambda$1(project, descriptor, pluginId2, arg_0);
    }

    private static final InstallGraphQLNotification collectNotificationData$lambda$1(Project $project, IdeaPluginDescriptor $descriptor, PluginId $pluginId, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new InstallGraphQLNotification(it, $project, $descriptor, $pluginId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/graphql/notification/HttpClientGraphQLPluginAdvertisement$InstallGraphQLNotification;", "Lcom/intellij/ui/EditorNotificationPanel;", "Lcom/intellij/openapi/util/Weighted;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Lcom/intellij/openapi/extensions/PluginId;)V", "getWeight", "", "intellij.restClient"})
    private static final class InstallGraphQLNotification
    extends EditorNotificationPanel
    implements Weighted {
        public InstallGraphQLNotification(@NotNull FileEditor fileEditor, @NotNull Project project, @Nullable IdeaPluginDescriptor descriptor, @NotNull PluginId pluginId) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            super(fileEditor, EditorNotificationPanel.Status.Info);
            if (descriptor == null) {
                this.setText(RestClientBundle.message("http.client.graphql.plugin.promote.install.label.text", new Object[0]));
                v0 = this.createActionLabel(RestClientBundle.message("http.client.graphql.plugin.promote.install.action.text", new Object[0]), () -> InstallGraphQLNotification._init_$lambda$1(project, pluginId));
            } else {
                this.setText(RestClientBundle.message("http.client.graphql.plugin.promote.enable.label.text", new Object[0]));
                v0 = this.createActionLabel(RestClientBundle.message("http.client.graphql.plugin.promote.enable.action.text", new Object[0]), () -> InstallGraphQLNotification._init_$lambda$2(project, descriptor));
            }
            this.createActionLabel(IdeBundle.message((String)"action.Anonymous.text.do.not.show.again", (Object[])new Object[0]), () -> InstallGraphQLNotification._init_$lambda$3(project));
        }

        public double getWeight() {
            return 10.0;
        }

        private static final void lambda$1$lambda$0(Project $project) {
            EditorNotifications.getInstance((Project)$project).updateAllNotifications();
        }

        private static final void _init_$lambda$1(Project $project, PluginId $pluginId) {
            PluginsAdvertiser.installAndEnable$default((Project)$project, (Set)SetsKt.setOf((Object)$pluginId), (boolean)false, (boolean)false, null, () -> InstallGraphQLNotification.lambda$1$lambda$0($project), (int)28, null);
        }

        private static final void _init_$lambda$2(Project $project, IdeaPluginDescriptor $descriptor) {
            PluginManagerConfigurable.showPluginConfigurableAndEnable((Project)$project, (Set)SetsKt.setOf((Object)$descriptor));
        }

        private static final void _init_$lambda$3(Project $project) {
            HttpClientGraphQLPluginAdvertisementKt.access$setDoNotShowAgain(true);
            EditorNotifications.getInstance((Project)$project).updateAllNotifications();
        }
    }
}

