/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestCollectionProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.net.URL;
import org.jetbrains.annotations.Nullable;

@Service
final class HttpRequestCollectionHolder
implements Disposable {
    private final Pair<VirtualFilePointer, VirtualFile> myCollectionFileOrPointer = this.findCollectionFile();

    HttpRequestCollectionHolder() {
    }

    @Nullable
    static VirtualFile getCollectionFile() {
        return HttpRequestCollectionHolder.getInstance().getCollectionFileImpl();
    }

    static HttpRequestCollectionHolder getInstance() {
        return (HttpRequestCollectionHolder)ApplicationManager.getApplication().getService(HttpRequestCollectionHolder.class);
    }

    @Nullable
    private VirtualFile getCollectionFileImpl() {
        Pair<VirtualFilePointer, VirtualFile> pair = this.myCollectionFileOrPointer;
        VirtualFilePointer pointer = (VirtualFilePointer)pair.getFirst();
        if (pointer != null) {
            return pointer.getFile();
        }
        VirtualFile file = (VirtualFile)pair.getSecond();
        return file != null && file.isValid() ? file : null;
    }

    public void dispose() {
    }

    private Pair<VirtualFilePointer, VirtualFile> findCollectionFile() {
        URL libFileUrl = HttpRequestCollectionProvider.class.getClassLoader().getResource("com/intellij/ws/rest/client/requests/collection/get-requests.http");
        assert (libFileUrl != null) : "Can not find requests collection directory, the installation is possibly broken.";
        String vfsUrl = VfsUtilCore.convertFromUrl((URL)libFileUrl);
        VirtualFile file = VirtualFileManager.getInstance().refreshAndFindFileByUrl(vfsUrl.substring(0, vfsUrl.lastIndexOf(47)));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Pair.create(null, (Object)file);
        }
        return Pair.create(file == null ? null : VirtualFilePointerManager.getInstance().create(file, (Disposable)this, null), null);
    }
}

