/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices.endpoints;

import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.http.request.microservices.endpoints.HttpClientEndpointsTabState;
import com.intellij.httpClient.http.request.microservices.endpoints.HttpClientTabEvent;
import com.intellij.httpClient.http.request.microservices.endpoints.HttpClientTabState;
import com.intellij.httpClient.http.request.microservices.endpoints.HttpRequestIdentity;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="HttpClientEndpointsTabState", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0015J\b\u0010!\u001a\u00020\u0002H\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lcom/intellij/httpClient/http/request/microservices/endpoints/HttpClientEndpointsTabStatePreserver;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/httpClient/http/request/microservices/endpoints/HttpClientEndpointsTabState;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "cachedEndpointTabsState", "currentRequest", "Lcom/intellij/httpClient/http/request/microservices/endpoints/HttpRequestIdentity;", "_httpClientTabUpdates", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/httpClient/http/request/microservices/endpoints/HttpClientTabEvent;", "httpClientTabUpdates", "Lkotlinx/coroutines/flow/Flow;", "getHttpClientTabUpdates", "()Lkotlinx/coroutines/flow/Flow;", "fireCurrentGenerationRequestChanged", "", "newRequests", "", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlsGenerationRequest;", "fireTextForCurrentRequestChanged", "newText", "", "documentModificationStamp", "", "fireConsoleVisibilityForCurrentRequestChanged", "newConsoleVisibility", "", "getCachedHttpTabState", "Lcom/intellij/httpClient/http/request/microservices/endpoints/HttpClientTabState;", "generationRequest", "getState", "loadState", "state", "Companion", "intellij.restClient"})
public final class HttpClientEndpointsTabStatePreserver
implements PersistentStateComponent<HttpClientEndpointsTabState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HttpClientEndpointsTabState cachedEndpointTabsState;
    @Nullable
    private volatile HttpRequestIdentity currentRequest;
    @NotNull
    private final MutableSharedFlow<HttpClientTabEvent> _httpClientTabUpdates;
    @NotNull
    private final Flow<HttpClientTabEvent> httpClientTabUpdates;

    public HttpClientEndpointsTabStatePreserver(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.cachedEndpointTabsState = new HttpClientEndpointsTabState(null, 1, null);
        this._httpClientTabUpdates = SharedFlowKt.MutableSharedFlow((int)1, (int)100, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        this.httpClientTabUpdates = (Flow)FlowKt.asSharedFlow(this._httpClientTabUpdates);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ HttpClientEndpointsTabStatePreserver this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0._httpClientTabUpdates.collect(new FlowCollector(){

                            public final Object emit(HttpClientTabEvent updateEvent, Continuation<? super Unit> $completion) {
                                HttpClientTabEvent httpClientTabEvent;
                                HttpClientTabState existingState;
                                HttpClientTabState httpClientTabState = this$0.cachedEndpointTabsState.getCachedRequestData().get(updateEvent.getRequestIdentity());
                                if (httpClientTabState == null) {
                                    httpClientTabState = existingState = new HttpClientTabState(null, 0L, false, 7, null);
                                }
                                if ((httpClientTabEvent = updateEvent) instanceof HttpClientTabEvent.TextChanged) {
                                    if (((HttpClientTabEvent.TextChanged)updateEvent).getChangeTimeStamp() > existingState.getCacheTimeStamp()) {
                                        this$0.cachedEndpointTabsState.getCachedRequestData().put(((HttpClientTabEvent.TextChanged)updateEvent).getRequestIdentity(), HttpClientTabState.copy$default(existingState, ((HttpClientTabEvent.TextChanged)updateEvent).getNewText(), ((HttpClientTabEvent.TextChanged)updateEvent).getChangeTimeStamp(), false, 4, null));
                                    }
                                } else if (httpClientTabEvent instanceof HttpClientTabEvent.ConsoleVisibilityChanged) {
                                    this$0.cachedEndpointTabsState.getCachedRequestData().put(((HttpClientTabEvent.ConsoleVisibilityChanged)updateEvent).getRequestIdentity(), HttpClientTabState.copy$default(existingState, null, 0L, ((HttpClientTabEvent.ConsoleVisibilityChanged)updateEvent).getNewVisibility(), 3, null));
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Flow<HttpClientTabEvent> getHttpClientTabUpdates() {
        return this.httpClientTabUpdates;
    }

    public final void fireCurrentGenerationRequestChanged(@NotNull List<HttpRequestUrlsGenerationRequest> newRequests) {
        HttpRequestUrlsGenerationRequest singleRequest;
        Intrinsics.checkNotNullParameter(newRequests, (String)"newRequests");
        HttpRequestUrlsGenerationRequest httpRequestUrlsGenerationRequest = singleRequest = (HttpRequestUrlsGenerationRequest)CollectionsKt.singleOrNull(newRequests);
        this.currentRequest = httpRequestUrlsGenerationRequest == null ? null : HttpRequestIdentity.Companion.from(httpRequestUrlsGenerationRequest);
    }

    public final void fireTextForCurrentRequestChanged(@NotNull String newText, long documentModificationStamp) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        HttpRequestIdentity httpRequestIdentity = this.currentRequest;
        if (httpRequestIdentity == null) {
            return;
        }
        HttpRequestIdentity currentRequestIdentity = httpRequestIdentity;
        if (StringsKt.isBlank((CharSequence)newText)) {
            return;
        }
        this._httpClientTabUpdates.tryEmit((Object)new HttpClientTabEvent.TextChanged(currentRequestIdentity, newText, documentModificationStamp));
    }

    public final void fireConsoleVisibilityForCurrentRequestChanged(boolean newConsoleVisibility) {
        HttpRequestIdentity httpRequestIdentity = this.currentRequest;
        if (httpRequestIdentity == null) {
            return;
        }
        HttpRequestIdentity currentRequestIdentity = httpRequestIdentity;
        this._httpClientTabUpdates.tryEmit((Object)new HttpClientTabEvent.ConsoleVisibilityChanged(currentRequestIdentity, newConsoleVisibility));
    }

    @Nullable
    public final HttpClientTabState getCachedHttpTabState(@Nullable HttpRequestUrlsGenerationRequest generationRequest) {
        return generationRequest == null ? null : this.cachedEndpointTabsState.getCachedRequestData().get(HttpRequestIdentity.Companion.from(generationRequest));
    }

    @NotNull
    public HttpClientEndpointsTabState getState() {
        return this.cachedEndpointTabsState;
    }

    public void loadState(@NotNull HttpClientEndpointsTabState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.cachedEndpointTabsState = state;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/httpClient/http/request/microservices/endpoints/HttpClientEndpointsTabStatePreserver$Companion;", "", "<init>", "()V", "getInstanceAsync", "Lcom/intellij/httpClient/http/request/microservices/endpoints/HttpClientEndpointsTabStatePreserver;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getInstance", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nHttpClientEndpointsTabStatePreserver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientEndpointsTabStatePreserver.kt\ncom/intellij/httpClient/http/request/microservices/endpoints/HttpClientEndpointsTabStatePreserver$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,114:1\n72#2:115\n31#2,2:116\n*S KotlinDebug\n*F\n+ 1 HttpClientEndpointsTabStatePreserver.kt\ncom/intellij/httpClient/http/request/microservices/endpoints/HttpClientEndpointsTabStatePreserver$Companion\n*L\n19#1:115\n23#1:116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super HttpClientEndpointsTabStatePreserver> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(HttpClientEndpointsTabStatePreserver.class, $completion);
        }

        @NotNull
        public final HttpClientEndpointsTabStatePreserver getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<HttpClientEndpointsTabStatePreserver> serviceClass$iv = HttpClientEndpointsTabStatePreserver.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (HttpClientEndpointsTabStatePreserver)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

