/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToLimitedTemporalDurationNode
extends JavaScriptBaseNode {
    protected ToLimitedTemporalDurationNode() {
    }

    public abstract JSTemporalDurationRecord execute(Object var1, List<TruffleString> var2);

    @Specialization
    protected JSTemporalDurationRecord toLimitedTemporalDuration(Object temporalDurationLike, List<TruffleString> disallowedFields, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile hasDisallowedFields, @Cached InlinedBranchProfile errorBranch) {
        JSTemporalDurationRecord d;
        if (isObjectProfile.profile(this, !isObjectNode.executeBoolean(temporalDurationLike))) {
            TruffleString str = toStringNode.executeString(temporalDurationLike);
            d = JSTemporalDuration.parseTemporalDurationString(str);
        } else {
            d = JSTemporalDuration.toTemporalDurationRecord((JSDynamicObject)temporalDurationLike);
        }
        if (hasDisallowedFields.profile(this, disallowedFields != TemporalUtil.listEmpty)) {
            for (TemporalUtil.UnitPlural unit : TemporalUtil.DURATION_PROPERTIES) {
                double value2 = TemporalUtil.getPropertyFromRecord(d, unit);
                if (value2 == 0.0 || !Boundaries.listContains(disallowedFields, unit.toTruffleString())) continue;
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorDisallowedField(unit.toTruffleString());
            }
        }
        return d;
    }
}

