/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalInstantNode
extends JavaScriptBaseNode {
    protected final JSContext ctx;

    protected ToTemporalInstantNode(JSContext context) {
        this.ctx = context;
    }

    public abstract JSTemporalInstantObject execute(Object var1);

    @Specialization
    public JSTemporalInstantObject toTemporalDateTime(Object item, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached InlinedConditionProfile isObjectProfile) {
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            if (TemporalUtil.isTemporalInstant(item)) {
                return (JSTemporalInstantObject)item;
            }
            if (TemporalUtil.isTemporalZonedDateTime(item)) {
                return JSTemporalInstant.create(this.ctx, this.getRealm(), ((JSTemporalZonedDateTimeObject)item).getNanoseconds());
            }
        }
        TruffleString string = toStringNode.executeString(item);
        BigInt epochNanoseconds = TemporalUtil.parseTemporalInstant(string);
        return JSTemporalInstant.create(this.ctx, this.getRealm(), epochNanoseconds);
    }
}

