/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferViewBase;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.TypedArrayAccess;
import com.oracle.truffle.js.runtime.interop.InteropArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTypedArrayObject
extends JSArrayBufferViewBase {
    TypedArray arrayType;

    protected JSTypedArrayObject(Shape shape, TypedArray arrayType, JSArrayBufferObject arrayBuffer, int length2, int offset) {
        super(shape, arrayBuffer, length2, offset);
        this.arrayType = arrayType;
    }

    public TypedArrayAccess typedArrayAccess() {
        return TypedArrayAccess.SINGLETON;
    }

    public TypedArray getArrayType() {
        return this.arrayType;
    }

    public static JSTypedArrayObject create(Shape shape, TypedArray arrayType, JSArrayBufferObject arrayBuffer, int length2, int offset) {
        return new JSTypedArrayObject(shape, arrayType, arrayBuffer, length2, offset);
    }

    @Override
    public TruffleString getClassName() {
        return this.typedArrayAccess().getTypedArrayName(this);
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return Strings.UC_OBJECT;
    }

    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        assert (JSObject.getJSClass(this) == JSArrayBufferView.INSTANCE);
        return InteropArray.create(JSTypedArrayObject.filterEnumerableNames(this, JSNonProxy.ordinaryOwnPropertyKeys(this), JSArrayBufferView.INSTANCE));
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return JSArrayBufferView.typedArrayGetLength(this);
    }

    @ExportMessage
    public Object readArrayElement(long index, @CachedLibrary(value="this") InteropLibrary self, @Cached(value="create(language(self).getJSContext())", uncached="getUncachedRead()") ReadElementNode readNode, @Cached ExportValueNode exportNode) throws InvalidArrayIndexException, UnsupportedMessageException {
        JSTypedArrayObject target = this;
        if (index < 0L || index >= self.getArraySize(this)) {
            throw InvalidArrayIndexException.create(index);
        }
        Object result2 = readNode == null ? JSObject.getOrDefault((JSDynamicObject)target, index, (Object)target, (Object)Undefined.instance) : readNode.executeWithTargetAndIndexOrDefault(target, index, Undefined.instance);
        return exportNode.execute(result2);
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable")})
    public boolean isArrayElementReadable(long index, @CachedLibrary(value="this") InteropLibrary thisLibrary) {
        try {
            return index >= 0L && index < thisLibrary.getArraySize(this);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    public void writeArrayElement(long index, Object value2, @Cached ImportValueNode castValueNode, @Cached(value="createCachedInterop()", uncached="getUncachedWrite()") WriteElementNode writeNode, @CachedLibrary(value="this") InteropLibrary thisLibrary) throws InvalidArrayIndexException, UnsupportedMessageException {
        JSTypedArrayObject target = this;
        if (index < 0L || index >= thisLibrary.getArraySize(this)) {
            throw InvalidArrayIndexException.create(index);
        }
        Object importedValue = castValueNode.executeWithTarget(value2);
        if (writeNode == null) {
            JSObject.set((JSDynamicObject)target, index, importedValue, true, null);
        } else {
            writeNode.executeWithTargetAndIndexAndValue((Object)target, index, importedValue);
        }
    }

    @ExportMessage
    public boolean isArrayElementInsertable(long index) {
        return false;
    }
}

