/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.charset.SortedListOfRanges;
import java.util.function.BiPredicate;

public class CaseFoldTable {
    private static final int INTEGER_OFFSET = 1;
    private static final int DIRECT_MAPPING = 2;
    private static final int ALTERNATING_UL = 3;
    private static final int ALTERNATING_AL = 4;
    private static final CodePointSet[] CHARACTER_SET_TABLE = new CodePointSet[]{CaseFoldTable.rangeSet(181, 181, 924, 924, 956, 956), CaseFoldTable.rangeSet(452, 454), CaseFoldTable.rangeSet(455, 457), CaseFoldTable.rangeSet(458, 460), CaseFoldTable.rangeSet(497, 499), CaseFoldTable.rangeSet(837, 837, 921, 921, 953, 953, 8126, 8126), CaseFoldTable.rangeSet(914, 914, 946, 946, 976, 976), CaseFoldTable.rangeSet(917, 917, 949, 949, 1013, 1013), CaseFoldTable.rangeSet(920, 920, 952, 952, 977, 977), CaseFoldTable.rangeSet(922, 922, 954, 954, 1008, 1008), CaseFoldTable.rangeSet(928, 928, 960, 960, 982, 982), CaseFoldTable.rangeSet(929, 929, 961, 961, 1009, 1009), CaseFoldTable.rangeSet(931, 931, 962, 963), CaseFoldTable.rangeSet(934, 934, 966, 966, 981, 981), CaseFoldTable.rangeSet(1042, 1042, 1074, 1074, 7296, 7296), CaseFoldTable.rangeSet(1044, 1044, 1076, 1076, 7297, 7297), CaseFoldTable.rangeSet(1054, 1054, 1086, 1086, 7298, 7298), CaseFoldTable.rangeSet(1057, 1057, 1089, 1089, 7299, 7299), CaseFoldTable.rangeSet(1058, 1058, 1090, 1090, 7300, 7301), CaseFoldTable.rangeSet(1066, 1066, 1098, 1098, 7302, 7302), CaseFoldTable.rangeSet(1122, 1123, 7303, 7303), CaseFoldTable.rangeSet(7304, 7304, 42570, 42571), CaseFoldTable.rangeSet(7776, 7777, 7835, 7835), CaseFoldTable.rangeSet(75, 75, 107, 107, 8490, 8490), CaseFoldTable.rangeSet(83, 83, 115, 115, 383, 383), CaseFoldTable.rangeSet(197, 197, 229, 229, 8491, 8491), CaseFoldTable.rangeSet(920, 920, 952, 952, 977, 977, 1012, 1012), CaseFoldTable.rangeSet(937, 937, 969, 969, 8486, 8486), CaseFoldTable.rangeSet(73, 73, 105, 105, 304, 305)};
    private static final CaseFoldTableImpl NON_UNICODE_TABLE_ENTRIES = new CaseFoldTableImpl(new int[]{65, 90, 1, 32, 97, 122, 1, -32, 181, 181, 2, 0, 192, 214, 1, 32, 216, 222, 1, 32, 224, 246, 1, -32, 248, 254, 1, -32, 255, 255, 1, 121, 256, 303, 4, 0, 306, 311, 4, 0, 313, 328, 3, 0, 330, 375, 4, 0, 376, 376, 1, -121, 377, 382, 3, 0, 384, 384, 1, 195, 385, 385, 1, 210, 386, 389, 4, 0, 390, 390, 1, 206, 391, 392, 3, 0, 393, 394, 1, 205, 395, 396, 3, 0, 398, 398, 1, 79, 399, 399, 1, 202, 400, 400, 1, 203, 401, 402, 3, 0, 403, 403, 1, 205, 404, 404, 1, 207, 405, 405, 1, 97, 406, 406, 1, 211, 407, 407, 1, 209, 408, 409, 4, 0, 410, 410, 1, 163, 412, 412, 1, 211, 413, 413, 1, 213, 414, 414, 1, 130, 415, 415, 1, 214, 416, 421, 4, 0, 422, 422, 1, 218, 423, 424, 3, 0, 425, 425, 1, 218, 428, 429, 4, 0, 430, 430, 1, 218, 431, 432, 3, 0, 433, 434, 1, 217, 435, 438, 3, 0, 439, 439, 1, 219, 440, 441, 4, 0, 444, 445, 4, 0, 447, 447, 1, 56, 452, 454, 2, 1, 455, 457, 2, 2, 458, 460, 2, 3, 461, 476, 3, 0, 477, 477, 1, -79, 478, 495, 4, 0, 497, 499, 2, 4, 500, 501, 4, 0, 502, 502, 1, -97, 503, 503, 1, -56, 504, 543, 4, 0, 544, 544, 1, -130, 546, 563, 4, 0, 570, 570, 1, 10795, 571, 572, 3, 0, 573, 573, 1, -163, 574, 574, 1, 10792, 575, 576, 1, 10815, 577, 578, 3, 0, 579, 579, 1, -195, 580, 580, 1, 69, 581, 581, 1, 71, 582, 591, 4, 0, 592, 592, 1, 10783, 593, 593, 1, 10780, 594, 594, 1, 10782, 595, 595, 1, -210, 596, 596, 1, -206, 598, 599, 1, -205, 601, 601, 1, -202, 603, 603, 1, -203, 604, 604, 1, 42319, 608, 608, 1, -205, 609, 609, 1, 42315, 611, 611, 1, -207, 613, 613, 1, 42280, 614, 614, 1, 42308, 616, 616, 1, -209, 617, 617, 1, -211, 618, 618, 1, 42308, 619, 619, 1, 10743, 620, 620, 1, 42305, 623, 623, 1, -211, 625, 625, 1, 10749, 626, 626, 1, -213, 629, 629, 1, -214, 637, 637, 1, 10727, 640, 640, 1, -218, 642, 642, 1, 42307, 643, 643, 1, -218, 647, 647, 1, 42282, 648, 648, 1, -218, 649, 649, 1, -69, 650, 651, 1, -217, 652, 652, 1, -71, 658, 658, 1, -219, 669, 669, 1, 42261, 670, 670, 1, 42258, 837, 837, 2, 5, 880, 883, 4, 0, 886, 887, 4, 0, 891, 893, 1, 130, 895, 895, 1, 116, 902, 902, 1, 38, 904, 906, 1, 37, 908, 908, 1, 64, 910, 911, 1, 63, 913, 913, 1, 32, 914, 914, 2, 6, 915, 916, 1, 32, 917, 917, 2, 7, 918, 919, 1, 32, 920, 920, 2, 8, 921, 921, 2, 5, 922, 922, 2, 9, 923, 923, 1, 32, 924, 924, 2, 0, 925, 927, 1, 32, 928, 928, 2, 10, 929, 929, 2, 11, 931, 931, 2, 12, 932, 933, 1, 32, 934, 934, 2, 13, 935, 939, 1, 32, 940, 940, 1, -38, 941, 943, 1, -37, 945, 945, 1, -32, 946, 946, 2, 6, 947, 948, 1, -32, 949, 949, 2, 7, 950, 951, 1, -32, 952, 952, 2, 8, 953, 953, 2, 5, 954, 954, 2, 9, 955, 955, 1, -32, 956, 956, 2, 0, 957, 959, 1, -32, 960, 960, 2, 10, 961, 961, 2, 11, 962, 963, 2, 12, 964, 965, 1, -32, 966, 966, 2, 13, 967, 971, 1, -32, 972, 972, 1, -64, 973, 974, 1, -63, 975, 975, 1, 8, 976, 976, 2, 6, 977, 977, 2, 8, 981, 981, 2, 13, 982, 982, 2, 10, 983, 983, 1, -8, 984, 1007, 4, 0, 1008, 1008, 2, 9, 1009, 1009, 2, 11, 1010, 1010, 1, 7, 1011, 1011, 1, -116, 1013, 1013, 2, 7, 1015, 1016, 3, 0, 1017, 1017, 1, -7, 1018, 1019, 4, 0, 1021, 1023, 1, -130, 1024, 1039, 1, 80, 1040, 1041, 1, 32, 1042, 1042, 2, 14, 1043, 1043, 1, 32, 1044, 1044, 2, 15, 1045, 1053, 1, 32, 1054, 1054, 2, 16, 1055, 1056, 1, 32, 1057, 1057, 2, 17, 1058, 1058, 2, 18, 1059, 1065, 1, 32, 1066, 1066, 2, 19, 1067, 1071, 1, 32, 1072, 1073, 1, -32, 1074, 1074, 2, 14, 1075, 1075, 1, -32, 1076, 1076, 2, 15, 1077, 1085, 1, -32, 1086, 1086, 2, 16, 1087, 1088, 1, -32, 1089, 1089, 2, 17, 1090, 1090, 2, 18, 1091, 1097, 1, -32, 1098, 1098, 2, 19, 1099, 1103, 1, -32, 1104, 1119, 1, -80, 1120, 1121, 4, 0, 1122, 1123, 2, 20, 1124, 1153, 4, 0, 1162, 1215, 4, 0, 1216, 1216, 1, 15, 1217, 1230, 3, 0, 1231, 1231, 1, -15, 1232, 1327, 4, 0, 1329, 1366, 1, 48, 1377, 1414, 1, -48, 4256, 4293, 1, 7264, 4295, 4295, 1, 7264, 4301, 4301, 1, 7264, 4304, 4346, 1, 3008, 4349, 4351, 1, 3008, 5024, 5103, 1, 38864, 5104, 5109, 1, 8, 5112, 5117, 1, -8, 7296, 7296, 2, 14, 7297, 7297, 2, 15, 7298, 7298, 2, 16, 7299, 7299, 2, 17, 7300, 7301, 2, 18, 7302, 7302, 2, 19, 7303, 7303, 2, 20, 7304, 7304, 2, 21, 7312, 7354, 1, -3008, 7357, 7359, 1, -3008, 7545, 7545, 1, 35332, 7549, 7549, 1, 3814, 7566, 7566, 1, 35384, 7680, 7775, 4, 0, 7776, 7777, 2, 22, 7778, 7829, 4, 0, 7835, 7835, 2, 22, 7840, 7935, 4, 0, 7936, 7943, 1, 8, 7944, 7951, 1, -8, 7952, 7957, 1, 8, 7960, 7965, 1, -8, 7968, 7975, 1, 8, 7976, 7983, 1, -8, 7984, 7991, 1, 8, 7992, 7999, 1, -8, 8000, 8005, 1, 8, 8008, 8013, 1, -8, 8017, 8017, 1, 8, 8019, 8019, 1, 8, 8021, 8021, 1, 8, 8023, 8023, 1, 8, 8025, 8025, 1, -8, 8027, 8027, 1, -8, 8029, 8029, 1, -8, 8031, 8031, 1, -8, 8032, 8039, 1, 8, 8040, 8047, 1, -8, 8048, 8049, 1, 74, 8050, 8053, 1, 86, 8054, 8055, 1, 100, 8056, 8057, 1, 128, 8058, 8059, 1, 112, 8060, 8061, 1, 126, 8112, 8113, 1, 8, 8120, 8121, 1, -8, 8122, 8123, 1, -74, 8126, 8126, 2, 5, 8136, 8139, 1, -86, 8144, 8145, 1, 8, 8152, 8153, 1, -8, 8154, 8155, 1, -100, 8160, 8161, 1, 8, 8165, 8165, 1, 7, 8168, 8169, 1, -8, 8170, 8171, 1, -112, 8172, 8172, 1, -7, 8184, 8185, 1, -128, 8186, 8187, 1, -126, 8498, 8498, 1, 28, 8526, 8526, 1, -28, 8544, 8559, 1, 16, 8560, 8575, 1, -16, 8579, 8580, 3, 0, 9398, 9423, 1, 26, 9424, 9449, 1, -26, 11264, 11311, 1, 48, 11312, 11359, 1, -48, 11360, 11361, 4, 0, 11362, 11362, 1, -10743, 11363, 11363, 1, -3814, 11364, 11364, 1, -10727, 11365, 11365, 1, -10795, 11366, 11366, 1, -10792, 11367, 11372, 3, 0, 11373, 11373, 1, -10780, 11374, 11374, 1, -10749, 11375, 11375, 1, -10783, 11376, 11376, 1, -10782, 11378, 11379, 4, 0, 11381, 11382, 3, 0, 11390, 11391, 1, -10815, 11392, 11491, 4, 0, 11499, 11502, 3, 0, 11506, 11507, 4, 0, 11520, 11557, 1, -7264, 11559, 11559, 1, -7264, 11565, 11565, 1, -7264, 42560, 42569, 4, 0, 42570, 42571, 2, 21, 42572, 42605, 4, 0, 42624, 42651, 4, 0, 42786, 42799, 4, 0, 42802, 42863, 4, 0, 42873, 42876, 3, 0, 42877, 42877, 1, -35332, 42878, 42887, 4, 0, 42891, 42892, 3, 0, 42893, 42893, 1, -42280, 42896, 42899, 4, 0, 42900, 42900, 1, 48, 42902, 42921, 4, 0, 42922, 42922, 1, -42308, 42923, 42923, 1, -42319, 42924, 42924, 1, -42315, 42925, 42925, 1, -42305, 42926, 42926, 1, -42308, 42928, 42928, 1, -42258, 42929, 42929, 1, -42282, 42930, 42930, 1, -42261, 42931, 42931, 1, 928, 42932, 42947, 4, 0, 42948, 42948, 1, -48, 42949, 42949, 1, -42307, 42950, 42950, 1, -35384, 42951, 42954, 3, 0, 42960, 42961, 4, 0, 42966, 42969, 4, 0, 42997, 42998, 3, 0, 43859, 43859, 1, -928, 43888, 43967, 1, -38864, 65313, 65338, 1, 32, 65345, 65370, 1, -32});
    private static final CaseFoldTableImpl UNICODE_TABLE_ENTRIES = new CaseFoldTableImpl(new int[]{65, 74, 1, 32, 75, 75, 2, 23, 76, 82, 1, 32, 83, 83, 2, 24, 84, 90, 1, 32, 97, 106, 1, -32, 107, 107, 2, 23, 108, 114, 1, -32, 115, 115, 2, 24, 116, 122, 1, -32, 181, 181, 2, 0, 192, 196, 1, 32, 197, 197, 2, 25, 198, 214, 1, 32, 216, 222, 1, 32, 223, 223, 1, 7615, 224, 228, 1, -32, 229, 229, 2, 25, 230, 246, 1, -32, 248, 254, 1, -32, 255, 255, 1, 121, 256, 303, 4, 0, 306, 311, 4, 0, 313, 328, 3, 0, 330, 375, 4, 0, 376, 376, 1, -121, 377, 382, 3, 0, 383, 383, 2, 24, 384, 384, 1, 195, 385, 385, 1, 210, 386, 389, 4, 0, 390, 390, 1, 206, 391, 392, 3, 0, 393, 394, 1, 205, 395, 396, 3, 0, 398, 398, 1, 79, 399, 399, 1, 202, 400, 400, 1, 203, 401, 402, 3, 0, 403, 403, 1, 205, 404, 404, 1, 207, 405, 405, 1, 97, 406, 406, 1, 211, 407, 407, 1, 209, 408, 409, 4, 0, 410, 410, 1, 163, 412, 412, 1, 211, 413, 413, 1, 213, 414, 414, 1, 130, 415, 415, 1, 214, 416, 421, 4, 0, 422, 422, 1, 218, 423, 424, 3, 0, 425, 425, 1, 218, 428, 429, 4, 0, 430, 430, 1, 218, 431, 432, 3, 0, 433, 434, 1, 217, 435, 438, 3, 0, 439, 439, 1, 219, 440, 441, 4, 0, 444, 445, 4, 0, 447, 447, 1, 56, 452, 454, 2, 1, 455, 457, 2, 2, 458, 460, 2, 3, 461, 476, 3, 0, 477, 477, 1, -79, 478, 495, 4, 0, 497, 499, 2, 4, 500, 501, 4, 0, 502, 502, 1, -97, 503, 503, 1, -56, 504, 543, 4, 0, 544, 544, 1, -130, 546, 563, 4, 0, 570, 570, 1, 10795, 571, 572, 3, 0, 573, 573, 1, -163, 574, 574, 1, 10792, 575, 576, 1, 10815, 577, 578, 3, 0, 579, 579, 1, -195, 580, 580, 1, 69, 581, 581, 1, 71, 582, 591, 4, 0, 592, 592, 1, 10783, 593, 593, 1, 10780, 594, 594, 1, 10782, 595, 595, 1, -210, 596, 596, 1, -206, 598, 599, 1, -205, 601, 601, 1, -202, 603, 603, 1, -203, 604, 604, 1, 42319, 608, 608, 1, -205, 609, 609, 1, 42315, 611, 611, 1, -207, 613, 613, 1, 42280, 614, 614, 1, 42308, 616, 616, 1, -209, 617, 617, 1, -211, 618, 618, 1, 42308, 619, 619, 1, 10743, 620, 620, 1, 42305, 623, 623, 1, -211, 625, 625, 1, 10749, 626, 626, 1, -213, 629, 629, 1, -214, 637, 637, 1, 10727, 640, 640, 1, -218, 642, 642, 1, 42307, 643, 643, 1, -218, 647, 647, 1, 42282, 648, 648, 1, -218, 649, 649, 1, -69, 650, 651, 1, -217, 652, 652, 1, -71, 658, 658, 1, -219, 669, 669, 1, 42261, 670, 670, 1, 42258, 837, 837, 2, 5, 880, 883, 4, 0, 886, 887, 4, 0, 891, 893, 1, 130, 895, 895, 1, 116, 902, 902, 1, 38, 904, 906, 1, 37, 908, 908, 1, 64, 910, 911, 1, 63, 913, 913, 1, 32, 914, 914, 2, 6, 915, 916, 1, 32, 917, 917, 2, 7, 918, 919, 1, 32, 920, 920, 2, 26, 921, 921, 2, 5, 922, 922, 2, 9, 923, 923, 1, 32, 924, 924, 2, 0, 925, 927, 1, 32, 928, 928, 2, 10, 929, 929, 2, 11, 931, 931, 2, 12, 932, 933, 1, 32, 934, 934, 2, 13, 935, 936, 1, 32, 937, 937, 2, 27, 938, 939, 1, 32, 940, 940, 1, -38, 941, 943, 1, -37, 945, 945, 1, -32, 946, 946, 2, 6, 947, 948, 1, -32, 949, 949, 2, 7, 950, 951, 1, -32, 952, 952, 2, 26, 953, 953, 2, 5, 954, 954, 2, 9, 955, 955, 1, -32, 956, 956, 2, 0, 957, 959, 1, -32, 960, 960, 2, 10, 961, 961, 2, 11, 962, 963, 2, 12, 964, 965, 1, -32, 966, 966, 2, 13, 967, 968, 1, -32, 969, 969, 2, 27, 970, 971, 1, -32, 972, 972, 1, -64, 973, 974, 1, -63, 975, 975, 1, 8, 976, 976, 2, 6, 977, 977, 2, 26, 981, 981, 2, 13, 982, 982, 2, 10, 983, 983, 1, -8, 984, 1007, 4, 0, 1008, 1008, 2, 9, 1009, 1009, 2, 11, 1010, 1010, 1, 7, 1011, 1011, 1, -116, 1012, 1012, 2, 26, 1013, 1013, 2, 7, 1015, 1016, 3, 0, 1017, 1017, 1, -7, 1018, 1019, 4, 0, 1021, 1023, 1, -130, 1024, 1039, 1, 80, 1040, 1041, 1, 32, 1042, 1042, 2, 14, 1043, 1043, 1, 32, 1044, 1044, 2, 15, 1045, 1053, 1, 32, 1054, 1054, 2, 16, 1055, 1056, 1, 32, 1057, 1057, 2, 17, 1058, 1058, 2, 18, 1059, 1065, 1, 32, 1066, 1066, 2, 19, 1067, 1071, 1, 32, 1072, 1073, 1, -32, 1074, 1074, 2, 14, 1075, 1075, 1, -32, 1076, 1076, 2, 15, 1077, 1085, 1, -32, 1086, 1086, 2, 16, 1087, 1088, 1, -32, 1089, 1089, 2, 17, 1090, 1090, 2, 18, 1091, 1097, 1, -32, 1098, 1098, 2, 19, 1099, 1103, 1, -32, 1104, 1119, 1, -80, 1120, 1121, 4, 0, 1122, 1123, 2, 20, 1124, 1153, 4, 0, 1162, 1215, 4, 0, 1216, 1216, 1, 15, 1217, 1230, 3, 0, 1231, 1231, 1, -15, 1232, 1327, 4, 0, 1329, 1366, 1, 48, 1377, 1414, 1, -48, 4256, 4293, 1, 7264, 4295, 4295, 1, 7264, 4301, 4301, 1, 7264, 4304, 4346, 1, 3008, 4349, 4351, 1, 3008, 5024, 5103, 1, 38864, 5104, 5109, 1, 8, 5112, 5117, 1, -8, 7296, 7296, 2, 14, 7297, 7297, 2, 15, 7298, 7298, 2, 16, 7299, 7299, 2, 17, 7300, 7301, 2, 18, 7302, 7302, 2, 19, 7303, 7303, 2, 20, 7304, 7304, 2, 21, 7312, 7354, 1, -3008, 7357, 7359, 1, -3008, 7545, 7545, 1, 35332, 7549, 7549, 1, 3814, 7566, 7566, 1, 35384, 7680, 7775, 4, 0, 7776, 7777, 2, 22, 7778, 7829, 4, 0, 7835, 7835, 2, 22, 7838, 7838, 1, -7615, 7840, 7935, 4, 0, 7936, 7943, 1, 8, 7944, 7951, 1, -8, 7952, 7957, 1, 8, 7960, 7965, 1, -8, 7968, 7975, 1, 8, 7976, 7983, 1, -8, 7984, 7991, 1, 8, 7992, 7999, 1, -8, 8000, 8005, 1, 8, 8008, 8013, 1, -8, 8017, 8017, 1, 8, 8019, 8019, 1, 8, 8021, 8021, 1, 8, 8023, 8023, 1, 8, 8025, 8025, 1, -8, 8027, 8027, 1, -8, 8029, 8029, 1, -8, 8031, 8031, 1, -8, 8032, 8039, 1, 8, 8040, 8047, 1, -8, 8048, 8049, 1, 74, 8050, 8053, 1, 86, 8054, 8055, 1, 100, 8056, 8057, 1, 128, 8058, 8059, 1, 112, 8060, 8061, 1, 126, 8064, 8071, 1, 8, 8072, 8079, 1, -8, 8080, 8087, 1, 8, 8088, 8095, 1, -8, 8096, 8103, 1, 8, 8104, 8111, 1, -8, 8112, 8113, 1, 8, 8115, 8115, 1, 9, 8120, 8121, 1, -8, 8122, 8123, 1, -74, 8124, 8124, 1, -9, 8126, 8126, 2, 5, 8131, 8131, 1, 9, 8136, 8139, 1, -86, 8140, 8140, 1, -9, 8144, 8145, 1, 8, 8152, 8153, 1, -8, 8154, 8155, 1, -100, 8160, 8161, 1, 8, 8165, 8165, 1, 7, 8168, 8169, 1, -8, 8170, 8171, 1, -112, 8172, 8172, 1, -7, 8179, 8179, 1, 9, 8184, 8185, 1, -128, 8186, 8187, 1, -126, 8188, 8188, 1, -9, 8486, 8486, 2, 27, 8490, 8490, 2, 23, 8491, 8491, 2, 25, 8498, 8498, 1, 28, 8526, 8526, 1, -28, 8544, 8559, 1, 16, 8560, 8575, 1, -16, 8579, 8580, 3, 0, 9398, 9423, 1, 26, 9424, 9449, 1, -26, 11264, 11311, 1, 48, 11312, 11359, 1, -48, 11360, 11361, 4, 0, 11362, 11362, 1, -10743, 11363, 11363, 1, -3814, 11364, 11364, 1, -10727, 11365, 11365, 1, -10795, 11366, 11366, 1, -10792, 11367, 11372, 3, 0, 11373, 11373, 1, -10780, 11374, 11374, 1, -10749, 11375, 11375, 1, -10783, 11376, 11376, 1, -10782, 11378, 11379, 4, 0, 11381, 11382, 3, 0, 11390, 11391, 1, -10815, 11392, 11491, 4, 0, 11499, 11502, 3, 0, 11506, 11507, 4, 0, 11520, 11557, 1, -7264, 11559, 11559, 1, -7264, 11565, 11565, 1, -7264, 42560, 42569, 4, 0, 42570, 42571, 2, 21, 42572, 42605, 4, 0, 42624, 42651, 4, 0, 42786, 42799, 4, 0, 42802, 42863, 4, 0, 42873, 42876, 3, 0, 42877, 42877, 1, -35332, 42878, 42887, 4, 0, 42891, 42892, 3, 0, 42893, 42893, 1, -42280, 42896, 42899, 4, 0, 42900, 42900, 1, 48, 42902, 42921, 4, 0, 42922, 42922, 1, -42308, 42923, 42923, 1, -42319, 42924, 42924, 1, -42315, 42925, 42925, 1, -42305, 42926, 42926, 1, -42308, 42928, 42928, 1, -42258, 42929, 42929, 1, -42282, 42930, 42930, 1, -42261, 42931, 42931, 1, 928, 42932, 42947, 4, 0, 42948, 42948, 1, -48, 42949, 42949, 1, -42307, 42950, 42950, 1, -35384, 42951, 42954, 3, 0, 42960, 42961, 4, 0, 42966, 42969, 4, 0, 42997, 42998, 3, 0, 43859, 43859, 1, -928, 43888, 43967, 1, -38864, 65313, 65338, 1, 32, 65345, 65370, 1, -32, 66560, 66599, 1, 40, 66600, 66639, 1, -40, 66736, 66771, 1, 40, 66776, 66811, 1, -40, 66928, 66938, 1, 39, 66940, 66954, 1, 39, 66956, 66962, 1, 39, 66964, 66965, 1, 39, 66967, 66977, 1, -39, 66979, 66993, 1, -39, 66995, 67001, 1, -39, 67003, 67004, 1, -39, 68736, 68786, 1, 64, 68800, 68850, 1, -64, 71840, 71871, 1, 32, 71872, 71903, 1, -32, 93760, 93791, 1, 32, 93792, 93823, 1, -32, 125184, 125217, 1, 34, 125218, 125251, 1, -34});
    private static final CaseFoldTableImpl PYTHON_ASCII_TABLE_ENTRIES = new CaseFoldTableImpl(new int[]{65, 90, 1, 32, 97, 122, 1, -32});
    private static final CaseFoldTableImpl PYTHON_UNICODE_TABLE_ENTRIES = new CaseFoldTableImpl(new int[]{65, 72, 1, 32, 73, 73, 2, 28, 74, 74, 1, 32, 75, 75, 2, 23, 76, 82, 1, 32, 83, 83, 2, 24, 84, 90, 1, 32, 97, 104, 1, -32, 105, 105, 2, 28, 106, 106, 1, -32, 107, 107, 2, 23, 108, 114, 1, -32, 115, 115, 2, 24, 116, 122, 1, -32, 181, 181, 2, 0, 192, 196, 1, 32, 197, 197, 2, 25, 198, 214, 1, 32, 216, 222, 1, 32, 223, 223, 1, 7615, 224, 228, 1, -32, 229, 229, 2, 25, 230, 246, 1, -32, 248, 254, 1, -32, 255, 255, 1, 121, 256, 303, 4, 0, 304, 305, 2, 28, 306, 311, 4, 0, 313, 328, 3, 0, 330, 375, 4, 0, 376, 376, 1, -121, 377, 382, 3, 0, 383, 383, 2, 24, 384, 384, 1, 195, 385, 385, 1, 210, 386, 389, 4, 0, 390, 390, 1, 206, 391, 392, 3, 0, 393, 394, 1, 205, 395, 396, 3, 0, 398, 398, 1, 79, 399, 399, 1, 202, 400, 400, 1, 203, 401, 402, 3, 0, 403, 403, 1, 205, 404, 404, 1, 207, 405, 405, 1, 97, 406, 406, 1, 211, 407, 407, 1, 209, 408, 409, 4, 0, 410, 410, 1, 163, 412, 412, 1, 211, 413, 413, 1, 213, 414, 414, 1, 130, 415, 415, 1, 214, 416, 421, 4, 0, 422, 422, 1, 218, 423, 424, 3, 0, 425, 425, 1, 218, 428, 429, 4, 0, 430, 430, 1, 218, 431, 432, 3, 0, 433, 434, 1, 217, 435, 438, 3, 0, 439, 439, 1, 219, 440, 441, 4, 0, 444, 445, 4, 0, 447, 447, 1, 56, 452, 454, 2, 1, 455, 457, 2, 2, 458, 460, 2, 3, 461, 476, 3, 0, 477, 477, 1, -79, 478, 495, 4, 0, 497, 499, 2, 4, 500, 501, 4, 0, 502, 502, 1, -97, 503, 503, 1, -56, 504, 543, 4, 0, 544, 544, 1, -130, 546, 563, 4, 0, 570, 570, 1, 10795, 571, 572, 3, 0, 573, 573, 1, -163, 574, 574, 1, 10792, 575, 576, 1, 10815, 577, 578, 3, 0, 579, 579, 1, -195, 580, 580, 1, 69, 581, 581, 1, 71, 582, 591, 4, 0, 592, 592, 1, 10783, 593, 593, 1, 10780, 594, 594, 1, 10782, 595, 595, 1, -210, 596, 596, 1, -206, 598, 599, 1, -205, 601, 601, 1, -202, 603, 603, 1, -203, 604, 604, 1, 42319, 608, 608, 1, -205, 609, 609, 1, 42315, 611, 611, 1, -207, 613, 613, 1, 42280, 614, 614, 1, 42308, 616, 616, 1, -209, 617, 617, 1, -211, 618, 618, 1, 42308, 619, 619, 1, 10743, 620, 620, 1, 42305, 623, 623, 1, -211, 625, 625, 1, 10749, 626, 626, 1, -213, 629, 629, 1, -214, 637, 637, 1, 10727, 640, 640, 1, -218, 642, 642, 1, 42307, 643, 643, 1, -218, 647, 647, 1, 42282, 648, 648, 1, -218, 649, 649, 1, -69, 650, 651, 1, -217, 652, 652, 1, -71, 658, 658, 1, -219, 669, 669, 1, 42261, 670, 670, 1, 42258, 837, 837, 2, 5, 880, 883, 4, 0, 886, 887, 4, 0, 891, 893, 1, 130, 895, 895, 1, 116, 902, 902, 1, 38, 904, 906, 1, 37, 908, 908, 1, 64, 910, 911, 1, 63, 912, 912, 1, 7235, 913, 913, 1, 32, 914, 914, 2, 6, 915, 916, 1, 32, 917, 917, 2, 7, 918, 919, 1, 32, 920, 920, 2, 26, 921, 921, 2, 5, 922, 922, 2, 9, 923, 923, 1, 32, 924, 924, 2, 0, 925, 927, 1, 32, 928, 928, 2, 10, 929, 929, 2, 11, 931, 931, 2, 12, 932, 933, 1, 32, 934, 934, 2, 13, 935, 936, 1, 32, 937, 937, 2, 27, 938, 939, 1, 32, 940, 940, 1, -38, 941, 943, 1, -37, 944, 944, 1, 7219, 945, 945, 1, -32, 946, 946, 2, 6, 947, 948, 1, -32, 949, 949, 2, 7, 950, 951, 1, -32, 952, 952, 2, 26, 953, 953, 2, 5, 954, 954, 2, 9, 955, 955, 1, -32, 956, 956, 2, 0, 957, 959, 1, -32, 960, 960, 2, 10, 961, 961, 2, 11, 962, 963, 2, 12, 964, 965, 1, -32, 966, 966, 2, 13, 967, 968, 1, -32, 969, 969, 2, 27, 970, 971, 1, -32, 972, 972, 1, -64, 973, 974, 1, -63, 975, 975, 1, 8, 976, 976, 2, 6, 977, 977, 2, 26, 981, 981, 2, 13, 982, 982, 2, 10, 983, 983, 1, -8, 984, 1007, 4, 0, 1008, 1008, 2, 9, 1009, 1009, 2, 11, 1010, 1010, 1, 7, 1011, 1011, 1, -116, 1012, 1012, 2, 26, 1013, 1013, 2, 7, 1015, 1016, 3, 0, 1017, 1017, 1, -7, 1018, 1019, 4, 0, 1021, 1023, 1, -130, 1024, 1039, 1, 80, 1040, 1041, 1, 32, 1042, 1042, 2, 14, 1043, 1043, 1, 32, 1044, 1044, 2, 15, 1045, 1053, 1, 32, 1054, 1054, 2, 16, 1055, 1056, 1, 32, 1057, 1057, 2, 17, 1058, 1058, 2, 18, 1059, 1065, 1, 32, 1066, 1066, 2, 19, 1067, 1071, 1, 32, 1072, 1073, 1, -32, 1074, 1074, 2, 14, 1075, 1075, 1, -32, 1076, 1076, 2, 15, 1077, 1085, 1, -32, 1086, 1086, 2, 16, 1087, 1088, 1, -32, 1089, 1089, 2, 17, 1090, 1090, 2, 18, 1091, 1097, 1, -32, 1098, 1098, 2, 19, 1099, 1103, 1, -32, 1104, 1119, 1, -80, 1120, 1121, 4, 0, 1122, 1123, 2, 20, 1124, 1153, 4, 0, 1162, 1215, 4, 0, 1216, 1216, 1, 15, 1217, 1230, 3, 0, 1231, 1231, 1, -15, 1232, 1327, 4, 0, 1329, 1366, 1, 48, 1377, 1414, 1, -48, 4256, 4293, 1, 7264, 4295, 4295, 1, 7264, 4301, 4301, 1, 7264, 4304, 4346, 1, 3008, 4349, 4351, 1, 3008, 5024, 5103, 1, 38864, 5104, 5109, 1, 8, 5112, 5117, 1, -8, 7296, 7296, 2, 14, 7297, 7297, 2, 15, 7298, 7298, 2, 16, 7299, 7299, 2, 17, 7300, 7301, 2, 18, 7302, 7302, 2, 19, 7303, 7303, 2, 20, 7304, 7304, 2, 21, 7312, 7354, 1, -3008, 7357, 7359, 1, -3008, 7545, 7545, 1, 35332, 7549, 7549, 1, 3814, 7566, 7566, 1, 35384, 7680, 7775, 4, 0, 7776, 7777, 2, 22, 7778, 7829, 4, 0, 7835, 7835, 2, 22, 7838, 7838, 1, -7615, 7840, 7935, 4, 0, 7936, 7943, 1, 8, 7944, 7951, 1, -8, 7952, 7957, 1, 8, 7960, 7965, 1, -8, 7968, 7975, 1, 8, 7976, 7983, 1, -8, 7984, 7991, 1, 8, 7992, 7999, 1, -8, 8000, 8005, 1, 8, 8008, 8013, 1, -8, 8017, 8017, 1, 8, 8019, 8019, 1, 8, 8021, 8021, 1, 8, 8023, 8023, 1, 8, 8025, 8025, 1, -8, 8027, 8027, 1, -8, 8029, 8029, 1, -8, 8031, 8031, 1, -8, 8032, 8039, 1, 8, 8040, 8047, 1, -8, 8048, 8049, 1, 74, 8050, 8053, 1, 86, 8054, 8055, 1, 100, 8056, 8057, 1, 128, 8058, 8059, 1, 112, 8060, 8061, 1, 126, 8064, 8071, 1, 8, 8072, 8079, 1, -8, 8080, 8087, 1, 8, 8088, 8095, 1, -8, 8096, 8103, 1, 8, 8104, 8111, 1, -8, 8112, 8113, 1, 8, 8115, 8115, 1, 9, 8120, 8121, 1, -8, 8122, 8123, 1, -74, 8124, 8124, 1, -9, 8126, 8126, 2, 5, 8131, 8131, 1, 9, 8136, 8139, 1, -86, 8140, 8140, 1, -9, 8144, 8145, 1, 8, 8147, 8147, 1, -7235, 8152, 8153, 1, -8, 8154, 8155, 1, -100, 8160, 8161, 1, 8, 8163, 8163, 1, -7219, 8165, 8165, 1, 7, 8168, 8169, 1, -8, 8170, 8171, 1, -112, 8172, 8172, 1, -7, 8179, 8179, 1, 9, 8184, 8185, 1, -128, 8186, 8187, 1, -126, 8188, 8188, 1, -9, 8486, 8486, 2, 27, 8490, 8490, 2, 23, 8491, 8491, 2, 25, 8498, 8498, 1, 28, 8526, 8526, 1, -28, 8544, 8559, 1, 16, 8560, 8575, 1, -16, 8579, 8580, 3, 0, 9398, 9423, 1, 26, 9424, 9449, 1, -26, 11264, 11311, 1, 48, 11312, 11359, 1, -48, 11360, 11361, 4, 0, 11362, 11362, 1, -10743, 11363, 11363, 1, -3814, 11364, 11364, 1, -10727, 11365, 11365, 1, -10795, 11366, 11366, 1, -10792, 11367, 11372, 3, 0, 11373, 11373, 1, -10780, 11374, 11374, 1, -10749, 11375, 11375, 1, -10783, 11376, 11376, 1, -10782, 11378, 11379, 4, 0, 11381, 11382, 3, 0, 11390, 11391, 1, -10815, 11392, 11491, 4, 0, 11499, 11502, 3, 0, 11506, 11507, 4, 0, 11520, 11557, 1, -7264, 11559, 11559, 1, -7264, 11565, 11565, 1, -7264, 42560, 42569, 4, 0, 42570, 42571, 2, 21, 42572, 42605, 4, 0, 42624, 42651, 4, 0, 42786, 42799, 4, 0, 42802, 42863, 4, 0, 42873, 42876, 3, 0, 42877, 42877, 1, -35332, 42878, 42887, 4, 0, 42891, 42892, 3, 0, 42893, 42893, 1, -42280, 42896, 42899, 4, 0, 42900, 42900, 1, 48, 42902, 42921, 4, 0, 42922, 42922, 1, -42308, 42923, 42923, 1, -42319, 42924, 42924, 1, -42315, 42925, 42925, 1, -42305, 42926, 42926, 1, -42308, 42928, 42928, 1, -42258, 42929, 42929, 1, -42282, 42930, 42930, 1, -42261, 42931, 42931, 1, 928, 42932, 42947, 4, 0, 42948, 42948, 1, -48, 42949, 42949, 1, -42307, 42950, 42950, 1, -35384, 42951, 42954, 3, 0, 42960, 42961, 4, 0, 42966, 42969, 4, 0, 42997, 42998, 3, 0, 43859, 43859, 1, -928, 43888, 43967, 1, -38864, 64261, 64262, 3, 0, 65313, 65338, 1, 32, 65345, 65370, 1, -32, 66560, 66599, 1, 40, 66600, 66639, 1, -40, 66736, 66771, 1, 40, 66776, 66811, 1, -40, 66928, 66938, 1, 39, 66940, 66954, 1, 39, 66956, 66962, 1, 39, 66964, 66965, 1, 39, 66967, 66977, 1, -39, 66979, 66993, 1, -39, 66995, 67001, 1, -39, 67003, 67004, 1, -39, 68736, 68786, 1, 64, 68800, 68850, 1, -64, 71840, 71871, 1, 32, 71872, 71903, 1, -32, 93760, 93791, 1, 32, 93792, 93823, 1, -32, 125184, 125217, 1, 34, 125218, 125251, 1, -34});

    private static CaseFoldTableImpl getTable(CaseFoldingAlgorithm algorithm) {
        switch (algorithm) {
            case ECMAScriptNonUnicode: {
                return NON_UNICODE_TABLE_ENTRIES;
            }
            case ECMAScriptUnicode: {
                return UNICODE_TABLE_ENTRIES;
            }
            case PythonAscii: {
                return PYTHON_ASCII_TABLE_ENTRIES;
            }
            case PythonUnicode: {
                return PYTHON_UNICODE_TABLE_ENTRIES;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public static void applyCaseFold(CodePointSetAccumulator codePointSet, CodePointSetAccumulator tmp, CaseFoldingAlgorithm algorithm) {
        CaseFoldTable.getTable(algorithm).applyCaseFold(codePointSet, tmp);
    }

    private static CodePointSet rangeSet(int ... ranges) {
        return CodePointSet.createNoDedup(ranges);
    }

    public static enum CaseFoldingAlgorithm {
        ECMAScriptNonUnicode,
        ECMAScriptUnicode,
        PythonAscii,
        PythonUnicode;


        public BiPredicate<Integer, Integer> getEqualsPredicate() {
            return (codePointA, codePointB) -> CaseFoldTable.getTable(this).equalsIgnoreCase((int)codePointA, (int)codePointB);
        }
    }

    private static final class CaseFoldTableImpl
    implements SortedListOfRanges {
        private final int[] ranges;

        CaseFoldTableImpl(int[] ranges) {
            this.ranges = ranges;
        }

        void applyCaseFold(CodePointSetAccumulator acc, CodePointSetAccumulator copy) {
            acc.copyTo(copy);
            for (Range r : copy) {
                int search = this.binarySearch(r.lo);
                if (this.binarySearchExactMatch(search, r.lo, r.hi)) {
                    this.apply(acc, search, r.lo, r.hi);
                    continue;
                }
                int firstIntersection = this.binarySearchGetFirstIntersecting(search, r.lo, r.hi);
                if (this.binarySearchNoIntersectingFound(firstIntersection)) continue;
                for (int j = firstIntersection; j < this.size() && !this.rightOf(j, r.lo, r.hi); ++j) {
                    assert (this.intersects(j, r.lo, r.hi));
                    int intersectionLo = Math.max(this.getLo(j), r.lo);
                    int intersectionHi = Math.min(this.getHi(j), r.hi);
                    this.apply(acc, j, intersectionLo, intersectionHi);
                }
            }
        }

        private void apply(CodePointSetAccumulator codePointSet, int tblEntryIndex, int intersectionLo, int intersectionHi) {
            switch (this.ranges[tblEntryIndex * 4 + 2]) {
                case 1: {
                    int delta = this.ranges[tblEntryIndex * 4 + 3];
                    codePointSet.addRange(intersectionLo + delta, intersectionHi + delta);
                    break;
                }
                case 2: {
                    CodePointSet set2 = CHARACTER_SET_TABLE[this.ranges[tblEntryIndex * 4 + 3]];
                    codePointSet.addSet(set2);
                    break;
                }
                case 3: {
                    int loUL = Math.min((intersectionLo - 1 ^ 1) + 1, (intersectionHi - 1 ^ 1) + 1);
                    int hiUL = Math.max((intersectionLo - 1 ^ 1) + 1, (intersectionHi - 1 ^ 1) + 1);
                    if (SortedListOfRanges.contains(intersectionLo, intersectionHi, loUL, hiUL)) break;
                    codePointSet.addRange(loUL, hiUL);
                    break;
                }
                case 4: {
                    int loAL = Math.min(intersectionLo ^ 1, intersectionHi ^ 1);
                    int hiAL = Math.max(intersectionLo ^ 1, intersectionHi ^ 1);
                    if (SortedListOfRanges.contains(intersectionLo, intersectionHi, loAL, hiAL)) break;
                    codePointSet.addRange(loAL, hiAL);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
        }

        boolean equalsIgnoreCase(int codePointA, int codePointB) {
            if (codePointA == codePointB) {
                return true;
            }
            int search = this.binarySearch(codePointA);
            if (this.binarySearchExactMatch(search, codePointA, codePointA)) {
                return this.equalsIgnoreCase(search, codePointA, codePointB);
            }
            int firstIntersection = this.binarySearchGetFirstIntersecting(search, codePointA, codePointA);
            if (this.binarySearchNoIntersectingFound(firstIntersection) || this.rightOf(firstIntersection, codePointA, codePointA)) {
                return false;
            }
            assert (this.intersects(firstIntersection, codePointA, codePointA));
            return this.equalsIgnoreCase(firstIntersection, codePointA, codePointB);
        }

        private boolean equalsIgnoreCase(int tblEntryIndex, int codePointA, int codePointB) {
            switch (this.ranges[tblEntryIndex * 4 + 2]) {
                case 1: {
                    int delta = this.ranges[tblEntryIndex * 4 + 3];
                    return codePointA + delta == codePointB;
                }
                case 2: {
                    CodePointSet set2 = CHARACTER_SET_TABLE[this.ranges[tblEntryIndex * 4 + 3]];
                    return set2.contains(codePointB);
                }
                case 3: {
                    return (codePointA - 1 ^ 1) + 1 == codePointB;
                }
                case 4: {
                    return (codePointA ^ 1) == codePointB;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public int getLo(int i) {
            return this.ranges[i * 4];
        }

        @Override
        public int getHi(int i) {
            return this.ranges[i * 4 + 1];
        }

        @Override
        public int size() {
            return this.ranges.length / 4;
        }

        @Override
        public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

