/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.flavors;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.parser.RegexASTBuilder;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyCaseFoldingData;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyCaseUnfoldingTrie;
import com.oracle.truffle.regex.tregex.parser.flavors.RubyRegexParser;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RubyCaseFolding {
    public static void caseFoldUnfoldString(int[] codepoints, CodePointSet encodingRange, RegexASTBuilder astBuilder) {
        RubyCaseFolding.caseFoldUnfoldString(codepoints, encodingRange, false, astBuilder);
    }

    public static void caseFoldUnfoldString(int[] codepoints, CodePointSet encodingRange, boolean dropAsciiOnStart, RegexASTBuilder astBuilder) {
        List<Integer> caseFolded = RubyCaseFolding.caseFold(codepoints);
        List<RubyCaseUnfoldingTrie.Unfolding> unfoldings = RubyCaseUnfoldingTrie.findUnfoldings(caseFolded);
        unfoldings = unfoldings.stream().filter(u -> encodingRange.contains(u.getCodepoint())).collect(Collectors.toList());
        astBuilder.pushGroup();
        int start2 = 0;
        int end = 0;
        int unfoldingsStartIndex = 0;
        int unfoldingsEndIndex = 0;
        for (int i = 0; i < unfoldings.size(); ++i) {
            RubyCaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(i);
            if (unfolding.getStart() >= end) {
                RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start2, end, 0, dropAsciiOnStart);
                if (unfolding.getStart() > end) {
                    if (dropAsciiOnStart && end == 0 && RubyRegexParser.isAscii(caseFolded.get(end))) {
                        astBuilder.popGroup();
                        astBuilder.replaceCurTermWithDeadNode();
                        return;
                    }
                    RubyCaseFolding.addString(astBuilder, caseFolded.subList(end, unfolding.getStart()));
                }
                start2 = unfolding.getStart();
                unfoldingsStartIndex = i;
            }
            end = Math.max(end, unfolding.getEnd());
            unfoldingsEndIndex = i + 1;
        }
        RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsStartIndex, unfoldingsEndIndex), start2, end, 0, dropAsciiOnStart);
        if (end < caseFolded.size()) {
            if (dropAsciiOnStart && end == 0 && RubyRegexParser.isAscii(caseFolded.get(end))) {
                astBuilder.popGroup();
                astBuilder.replaceCurTermWithDeadNode();
                return;
            }
            RubyCaseFolding.addString(astBuilder, caseFolded.subList(end, caseFolded.size()));
        }
        astBuilder.popGroup();
    }

    public static int[] caseFold(int codePoint) {
        return (int[])RubyCaseFoldingData.CASE_FOLD.get(codePoint);
    }

    private static List<Integer> caseFold(int[] codepoints) {
        ArrayList<Integer> caseFolded = new ArrayList<Integer>();
        for (int codepoint : codepoints) {
            int[] folded = RubyCaseFolding.caseFold(codepoint);
            if (folded == null) {
                caseFolded.add(codepoint);
                continue;
            }
            for (int foldedElem : folded) {
                caseFolded.add(foldedElem);
            }
        }
        return caseFolded;
    }

    private static void addChar(RegexASTBuilder astBuilder, int codepoint) {
        astBuilder.addCharClass(CodePointSet.create(codepoint), true);
    }

    private static void addString(RegexASTBuilder astBuilder, List<Integer> codepoints) {
        for (int codepoint : codepoints) {
            RubyCaseFolding.addChar(astBuilder, codepoint);
        }
    }

    private static void unfoldSegment(RegexASTBuilder astBuilder, List<Integer> caseFolded, List<RubyCaseUnfoldingTrie.Unfolding> unfoldings, int start2, int end, int backtrackingDepth, boolean dropAsciiOnStart) {
        int unfoldingsNextIndex;
        if (backtrackingDepth > 8) {
            throw new UnsupportedRegexException("case-unfolding of case-insensitive string is too complex");
        }
        if (start2 == end) {
            return;
        }
        if (unfoldings.isEmpty()) {
            RubyCaseFolding.addString(astBuilder, caseFolded.subList(start2, end));
            return;
        }
        RubyCaseUnfoldingTrie.Unfolding unfolding = unfoldings.get(0);
        if (unfolding.getStart() > start2) {
            RubyCaseFolding.addString(astBuilder, caseFolded.subList(start2, unfolding.getStart()));
            RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings, unfolding.getStart(), end, backtrackingDepth, dropAsciiOnStart);
            return;
        }
        if (unfolding.getLength() > 1) {
            int unfoldingsNextIndex2;
            for (unfoldingsNextIndex2 = 1; unfoldingsNextIndex2 < unfoldings.size() && unfoldings.get(unfoldingsNextIndex2).getStart() < unfolding.getEnd(); ++unfoldingsNextIndex2) {
            }
            astBuilder.pushGroup();
            RubyCaseFolding.addChar(astBuilder, unfolding.getCodepoint());
            RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsNextIndex2, unfoldings.size()), unfolding.getEnd(), end, backtrackingDepth + 1, dropAsciiOnStart);
            astBuilder.nextSequence();
            RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(1, unfoldings.size()), start2, end, backtrackingDepth + 1, dropAsciiOnStart);
            astBuilder.popGroup();
            return;
        }
        CodePointSetAccumulator acc = new CodePointSetAccumulator();
        if (!dropAsciiOnStart || start2 != 0 || !RubyRegexParser.isAscii(caseFolded.get(start2))) {
            acc.addCodePoint(caseFolded.get(start2));
        }
        for (unfoldingsNextIndex = 0; unfoldingsNextIndex < unfoldings.size() && unfoldings.get(unfoldingsNextIndex).getStart() == start2; ++unfoldingsNextIndex) {
            assert (unfoldings.get(unfoldingsNextIndex).getLength() == 1);
            int codepoint = unfoldings.get(unfoldingsNextIndex).getCodepoint();
            if (dropAsciiOnStart && start2 == 0 && RubyRegexParser.isAscii(codepoint)) continue;
            acc.addCodePoint(codepoint);
        }
        astBuilder.addCharClass(acc.toCodePointSet(), false);
        RubyCaseFolding.unfoldSegment(astBuilder, caseFolded, unfoldings.subList(unfoldingsNextIndex, unfoldings.size()), start2 + 1, end, backtrackingDepth, dropAsciiOnStart);
    }
}

