import React, { useState } from 'react';
import useResizeObserver from 'use-resize-observer';
import { Sidebar } from '../Sidebar/Sidebar';
import { Info } from '../Info/Info';
import { Servers } from '../Servers/Servers';
import { Operations } from '../Operations/Operations';
import { Messages } from '../Messages/Messages';
import { Schemas } from '../Schemas/Schemas';
import { Error } from '../Error/Error';
import { SpecificationContext, ConfigContext } from '../../contexts';
var AsyncApiLayout = function (_a) {
    var asyncapi = _a.asyncapi, config = _a.config, _b = _a.error, error = _b === void 0 ? null : _b;
    var _c = useState('container:xl'), observerClassName = _c[0], setObserverClassName = _c[1];
    var ref = useResizeObserver({
        onResize: function (_a) {
            var width = _a.width;
            requestAnimationFrame(function () {
                if (width === undefined) {
                    return;
                }
                var possibleClassName = width <= 1280 ? 'container:xl' : 'container:base';
                if (possibleClassName !== observerClassName) {
                    setObserverClassName(possibleClassName);
                }
            });
        },
    }).ref;
    var configShow = config.show || {};
    return (React.createElement(ConfigContext.Provider, { value: config },
        React.createElement(SpecificationContext.Provider, { value: asyncapi },
            React.createElement("section", { className: "aui-root" },
                React.createElement("div", { className: "".concat(observerClassName, " relative md:flex bg-white leading-normal"), id: config.schemaID || undefined, ref: ref },
                    configShow.sidebar && React.createElement(Sidebar, null),
                    React.createElement("div", { className: "panel--center relative py-8 flex-1" },
                        React.createElement("div", { className: "relative z-10" },
                            configShow.errors && error && React.createElement(Error, { error: error }),
                            configShow.info && React.createElement(Info, null),
                            configShow.servers && React.createElement(Servers, null),
                            configShow.operations && React.createElement(Operations, null),
                            configShow.messages && React.createElement(Messages, null),
                            configShow.schemas && React.createElement(Schemas, null)),
                        React.createElement("div", { className: "panel--right absolute top-0 right-0 h-full bg-gray-800" })))))));
};
export default AsyncApiLayout;
//# sourceMappingURL=Layout.js.map